--' ************************************ Click Fix Event ************************************ '--
ClickFixEvent = deriveLuaClass("ClickFixEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="ClickFixEvent",
	items = {
		{ obj="my_object", fixAmount=24 },
	},
}
--]]

function ClickFixEvent:init(desc)
	ClickFixEvent.superInit(self, desc)

	--' Configuration variables
	self.fixAmount = self.fixAmount or 20
	self.trackProgressPerItem = self.trackProgressPerItem ~= false --' Default true

	--' Status variables
	self.clicksDone = 0

	--' Override
	self.matchingItemType = "FixableObject"
end

function ClickFixEvent:onInitialized()
	ClickFixEvent.super.onInitialized(self)

	self.clicksTodo = 0
	for _,item in ipairs(self.items) do
		item.clicksDone = 0
		item.fixAmount = item.fixAmount or item.obj.fixAmount or self.fixAmount
		self.clicksTodo = self.clicksTodo + item.fixAmount
		self:createProgressBar(item)
	end

	if (self.trackProgress) then
		eventBar.targetValue = self.clicksTodo
	end
	eventBar.showValue = true
	eventBar.showTarget = true

	if (isString(self.tagetObject)) then
		self.tagetObject = level:getSpriteExt(self.tagetObject)
	end
end

function ClickFixEvent:showItem(item)
	ClickFixEvent.super.showItem(self, item)

	item.obj.onClick = clickFixOnClick
end

function ClickFixEvent:onProgress()
	ClickFixEvent.super.onProgress(self)

	if (not self.trackProgressPerItem and isTable(self.tagetObject)) then
		local fc = self.tagetObject.frameCount
		self.tagetObject.frame = math.min(fc-1, fc * self.clicksDone / self.clicksTodo)
	end
end

function ClickFixEvent:onItemDone(item)
	ClickFixEvent.super.onItemDone(self, item)

	if (self.trackProgressPerItem and isTable(self.tagetObject)) then
		local fc = self.tagetObject.frameCount
		self.tagetObject.frame = math.min(fc-1, fc * self.itemsDone / self:getNumItemsTodo())
	end
end

function ClickFixEvent:getProgress()
	if (self.trackProgress) then
		return self.clicksDone / self.clicksTodo
	end
	return ClickFixEvent.super.getProgress(self)
end

--' ************************************ Click Fix Object ************************************ '--
FixableObject = deriveLuaClass("FixableObject", "EventObject")

function clickFixOnClick(self)
	if (self.item.done) then
		return
	end

	event:hideHintArrow()
	event.clicksDone = event.clicksDone + 1
	self.item.clicksDone = self.item.clicksDone + 1
	event:showProgressBar(self.item)
	local p = ghf.getMouseCursorPos()
	self:newChild({class="ParticleEffect", library="CLICKFIX:particles", x=p.x-self.x, y=p.y-self.y, start=true})
	if (event.clickSoundId) then
		self:playSample(event.clickSoundId)
	end

	local frac = 1
	if (self.item.clicksDone < self.item.fixAmount) then
		frac = self.item.clicksDone / self.item.fixAmount
		self.frame = frac * (self.frameCount-1)
		event:onProgress()
	else
		self:showLastFrame()
		event:itemDone(self.item)
	end

	if (self.item.bar) then
		self.item.bar:setProgress(frac)
	end
	return true
end
