levelDesc = levelDesc or {}

--' Default values in levelDesc
levelDesc.defaultPoductSettings = {
	orderable = true,
	edible = true,
	lo_cal = 100,
	hi_cal = 100,
	chance = 100,
	veg = true,
	regular = 100,
	big = 100,
	elderly = 100,
	kid = 100,
	designer = 100,
	yup = 100,
	easy = false,
}

levelDesc.counterOrderSize = 2
levelDesc.tableOrderSize  = 4
levelDesc.orderSteps = 1
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values =
{
	moneyFloaterDelay = 1000,
	moneyFullOrderAtOncePerProduct = 5,
	moneyCustomerChain = 11,
	moneySameCustomerType = 11,
	comboCheckout2 = 10,
	comboCheckout3 = 20,
	comboCheckout4 = 0,
	closeDelay = 4000,
	cleanDuration = 4000,
	entertainDuration = 4000,
	moodDropWarning = 5000,
	idleAnimTimeoutMin = 6000,
	idleAnimTimeoutMax = 12000,
	thinkIconFrameTime = 200,
	maxBalloonSize = 6,
	maxTraySize = 3,
	startMood = 3,
	moodDropTime = 10000,
	tipNormal = 10,
	tipHappy = 20,
	tipExstatic = 30,
	moneyPerProduct = 10,
	drinkFrameTime = 200,
	eatFrameTime = 200,
	readFrameTime = 200,
	orderFrameTime = 200,
	moneyAngryCustomerLeaves = -50,
	danceFrameTime = 110,
	danceTime = 6000,
	danceTipNormal = 10,
	danceTipHappy = 25,
	danceTipExstatic = 50,
}
levelDesc.valueMultipliers =
{
	queueMoodDurationMultiplier = 1.5,
	tableMoodDurationMultiplier = 1,
	counterMoodDurationMultiplier = 1,
	tableTipMultiplier = 1.2,
	entertainDuration = {1.2, 1, 0.8}, --' easy, normal, hard
	moodDropTime = {
		{1.4, 1.1, 1.0}, --' easy
		{1.4, 1.1, 1.0}, --' normal
		{1.4, 1.1, 1.0}, --' hard
	},
	spawnDelay = {
		{ 1.4*1.1, 1.4, 1.4*0.9 }, --' easy
		{ 1.1*1.1, 1.1, 1.1*0.9 }, --' normal
		{ 1.0*1.1, 1.0, 1.0*0.9 }, --' hard
	},
}
levelDesc.valueAdders =
{
	startMood = {1, 0, 0,}, --' easy, normal, hard
}
levelDesc.targetScores =
{
	{ --' Room 1
		{target=440, expert=640}, 	--' Shift 1
		{target=600, expert=800},	--' Shift 2 
		{target=1550, expert=1750}, --' Shift 3 
		{target=790, expert=990}, 	--' Shift 4  
		{target=1630, expert=1830}, --' Shift 5 
		{target=1380, expert=1590}, --' Shift 6 
		{target=1620, expert=1820}, --' Shift 7
		{target=1360, expert=1560}, --' Shift 8
		{target=1390, expert=1590}, --' Shift 9
		{target=1690, expert=1890}, --' Shift 10
	},
	{ --' Room 2
		{target=1340, expert=1520}, --' Shift 1
		{target=1460, expert=1640}, --' Shift 2
		{target=1880, expert=2060}, --' Shift 3
		{target=1620, expert=1820}, --' Shift 4
		{target=2200, expert=2420}, --' Shift 5
		{target=2150, expert=2330}, --' Shift 6
		{target=1870, expert=2080}, --' Shift 7
		{target=1560, expert=1740}, --' Shift 8
		{target=2200, expert=2390}, --' Shift 9
		{target=2300, expert=2490}, --' Shift 10
	},
	{ --' Room 3
		{target=1390, expert=1610}, --' Shift 1
		{target=1430, expert=1590}, --' Shift 2  
		{target=1630, expert=1800}, --' Shift 3    
		{target=1600, expert=1780}, --' Shift 4
		{target=1960, expert=2130}, --' Shift 5
		{target=1670, expert=1870}, --' Shift 6
		{target=1900, expert=2250}, --' Shift 7
		{target=2300, expert=2480}, --' Shift 8   
		{target=1910, expert=2170}, --' Shift 9  
		{target=2350, expert=2570}, --' Shift 10
	},
	{ --' Room 4
		{target=1480, expert=1660}, --' Shift 1
		{target=1300, expert=1440}, --' Shift 2
		{target=1950, expert=2090}, --' Shift 3
		{target=1580, expert=1760}, --' Shift 4
		{target=1630, expert=1950}, --' Shift 5
		{target=1340, expert=1490}, --' Shift 6
		{target=1730, expert=1880}, --' Shift 7
		{target=2230, expert=2380}, --' Shift 8
		{target=2440, expert=2590}, --' Shift 9
		{target=1810, expert=2010}, --' Shift 10
	},
	{ --' Room 5
		{target=1220, expert=1450}, 	--' Shift 1
		{target=1270, expert=1430}, --' Shift 2
		{target=1800, expert=2010}, --' Shift 3
		{target=2170, expert=2280}, --' Shift 4
		{target=1970, expert=2130}, --' Shift 5
		{target=1780, expert=1920}, --' Shift 6
		{target=2200, expert=2370}, --' Shift 7
		{target=2390, expert=2610}, --' Shift 8
		{target=2210, expert=2340}, --' Shift 9
		{target=2560, expert=2670}, --' Shift 10
	},
}
levelDesc.gameHouseObjects =
{
	{room=1, shift=4}, --' 1
	{room=1, shift=8}, --' 2
	{room=2, shift=2}, --' 3
	{room=2, shift=8}, --' 4
	{room=3, shift=4}, --' 5
	{room=3, shift=8}, --' 6
	{room=4, shift=2}, --' 7
	{room=4, shift=6}, --' 8
	{room=5, shift=4}, --' 9
	{room=5, shift=8}, --' 10
}
levelDesc.animationDescs = 
{
	READ = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 800}, },
	EAT = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 800}, },
	DRINK = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 800}, },
	ORDER = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 800}, },	
	DANCE = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 0}, },	
}

levelDesc.characterTypes =
{
	default = {
		x=-500, y=500,
		class						= "DelCharacter",		--' E.g. "Customer"
		baseAnimation				= "CUSTOMER-REGULAR",	--' Dummy
		defaultSection				= "characters",			--'
		defaultAnimation			= "IDLE",				--'
		walkSpeed					= 292,					--' Pixels / sec
		animationWalkSpeed			= 160,					--' Pixels / sec
		verticalWalkMultiplier		= 0.666,				--' Modifies vertical speed
		walkFrameDistanceHor		= 1,					--' Pixels to travel for next walk frame (horizontal)
		walkFrameDistanceVer		= 1,					--' Pixels to travel for next walk frame (vertical)
		minAge						= 30,					--'
		maxAge						= 30,					--'
		valueMultipliers			= {},					--'
		valueAdders					= {},					--'
		playIdleAnimations			= true,
		isCustomer					= false,
		allowAutoHorizontalFlip		= true,
		floor						= -10,
		moodPos						= {45, -145},
		moodPosSit					= {-55, -125},
		anchor						= "bottom",
		tableClipHeight				= 62,
		waitAtDirtyTableTime		= 1000,
		shadowResource				= "CHARACTER_SHADOW",
		idleAnimations = {
			{a="IDLE_WWW", f=150, c=1},
			{a="IDLE_XXX", f=150, c=1},
			{a="IDLE_YYY", f=150, c=1},
			{a="IDLE_ZZZ", f=150, c=1},
		},
	},

	-- Customers
	big = {
		baseAnimation = "CUSTOMER-BIG",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 6000,
		eatTime = 25000, --large
		big = true,
		valueMultipliers = { moodDropTime = 1.4, }, -- large
	},
	child = {
		baseAnimation = "CUSTOMER-CHILD",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 6000, --small
		eatTime = 20000,
		tableClipHeight = 40,
		kid = true,
		sitOffset = {x=5, y=-10},
		valueMultipliers = { moodDropTime = 0.8, }, -- small
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},
	designer = {
		baseAnimation = "CUSTOMER-DESIGNER",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 10000, --large
		eatTime = 25000, -- large
		veg = true,
		designer = true,
		valueMultipliers = { moodDropTime = 0.8, }, -- small
	},
	elderly = {
		baseAnimation = "CUSTOMER-ELDERLY",
		floor = -10,
		walkSpeed = 230,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 10000, --large
		eatTime = 25000, --large
		elderly = true,
		valueMultipliers = { moodDropTime = 1.4, }, -- large
	},
	farmer = {
		baseAnimation = "CUSTOMER-FARMER",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 15000, -- small
		farmer = true,
	},
	regular = {
		baseAnimation = "CUSTOMER-REGULAR",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = 103/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 20000,
		regular = true,
		danceFrameTime = 90,
	},
	yup = {
		baseAnimation = "CUSTOMER-YUP",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 15000, -- small
		yup = true,
		valueMultipliers = { moodDropTime = 0.8, }, -- small
	},

	emily = {
		baseAnimation = "EMILY",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},

	francois = {
		baseAnimation = "FRANCOIS",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
			
	bunny = {
		baseAnimation = "BUNNY",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(2*3),
		walkFrameDistanceVer = 12,
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},
	
	puppy = {
		baseAnimation = "PUPPY",
		floor = -11,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(2*3),
		walkFrameDistanceVer = 12,
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},

	chicken = {
		baseAnimation = "CHICKEN",
		floor = -9,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*80/(4*2),
		walkFrameDistanceVer = 12,
		idleAnimTimeoutMin = 1000,
		idleAnimTimeoutMax = 3000,
		idleAnimations = {
			{a="IDLE_XXX", f=150, c=2},
			{a="IDLE_YYY", f=150, c=2},
			{a="IDLE_ZZZ", f=150, c=2},
		},
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},

	ostrich = {
		baseAnimation = "OSTRICH",
		floor = -14,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(4*2),
		walkFrameDistanceVer = 12,
		idleAnimTimeoutMin = 3000,
		idleAnimTimeoutMax = 6000,
		idleAnimations = {
			{a="IDLE_XXX", f=150, c=1},
			{a="IDLE_YYY", f=150, c=1},
			{a="IDLE_ZZZ", f=150, c=1},
		},
	},
	
	sheep = {
		baseAnimation = "SHEEP-STATE_1",
		idleAnimTimeoutMin = 3000,
		idleAnimTimeoutMax = 6000,
		idleAnimations = {
			{a="IDLE_XXX", f=150, c=1},
		},
	},

	grandma = {
		baseAnimation = "GRANDMA",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	grandpa = {
		baseAnimation = "GRANDPA",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	edward = {
		baseAnimation = "EDWARD",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	evelyn = {
		baseAnimation = "EVELYN",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	hunter = {
		baseAnimation = "HUNTER",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	antonio = {
		baseAnimation = "ANTONIO",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,		
	},
	angela = {
		baseAnimation = "ANGELA",
		floor = -10,
		walkSpeed = 600,
		tableClipHeight = 50,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	
	bigPie = {
		baseAnimation = "CUSTOMER-BIG_MALE",
		floor = -10,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		hi_cal = true,
		thinkTime = 8000,
		eatTime = 20000,
	},
	farmerPie = {
		baseAnimation = "CUSTOMER-FARMER_MALE",
		floor = -10,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 20000,
	},
	hunterFriend = {
		baseAnimation = "HUNTER-FRIEND",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	mayorMale = {
		baseAnimation = "MAYOR-MALE",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	stacy = {
		baseAnimation = "STACY",
		floor = -10,
		walkSpeed = 700,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small				
	},
	teenMale = {
		baseAnimation = "TEEN-MALE",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	teenFemale = {
		baseAnimation = "TEEN-FEMALE",
		floor = -10,
		walkSpeed = 600,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	littleGirl = {
		baseAnimation = "LITTLE-GIRL",
		floor = -10,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},
	dj = {
		baseAnimation = "DJ",
		floor = -10,
		walkSpeed = 350,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	fixerMale = {
		baseAnimation = "FIXER-MALE",
		floor = -10,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
	},
	farmerBeehive = {
		baseAnimation = "CUSTOMER-FARMER_MALE",
		floor = -10,
		walkSpeed = 200,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 20000,
	},

	cameo_betty = {
		baseAnimation = "CAMEO-BETTY",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},

	cameo_bully = {
		baseAnimation = "CAMEO-BULLY",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},

	cameo_charles = {
		baseAnimation = "CAMEO-CHARLES",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},

	cameo_elvis = {
		baseAnimation = "CAMEO-ELVIS",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},

	cameo_mailman = {
		baseAnimation = "CAMEO-MAILMAN",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},
	
	cameo_matthew = {
		baseAnimation = "CAMEO-MATTHEW",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},
	
	cameo_mayor = {
		baseAnimation = "CAMEO-MAYOR",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},
	
	cameo_mo = {
		baseAnimation = "CAMEO-MO",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},

	cameo_tashi = {
		baseAnimation = "CAMEO-TASHI",
		floor = -10,
		animationWalkSpeed = 300,
		walkFrameDistanceHor = tbd*120/(3*2),
		walkFrameDistanceVer = 12,
		
		--' Special friend
		specialFriend = true,
		thinkTime = 8000,
		eatTime = 15000, -- small					
	},
}

--' So we can access this table more easily from the editor:
_G.chs = levelDesc.characterTypes
