scenes = scenes or {}
dialogs = dialogs or {}
blueprints = blueprints or {}

blueprints.default_painter = {
	class = "DelPainter",
	section = "default",
	centerColor = 0xffffff,
	centeralpha = 1.0,
	sides_offset_x = 50,
	sides_offset_y = 50,
	images = {		
		"BORDER_TOP_LEFT","BORDER_TOP_CENTER", "BORDER_TOP_RIGHT",
		"BORDER_CENTER_LEFT","CENTER_BACKGROUND","BORDER_CENTER_RIGHT",
		"BORDER_BOTTOM_LEFT", "BORDER_BOTTOM_CENTER", "BORDER_BOTTOM_RIGHT",
	},
}

blueprints.progressbar_big = {
	class = "ProgressBar",
	back = {class="Sprite", image="PROGRESSBAR:gamescene", anchor="center"},
	front = {class="Sprite", image="PROGRESSBAR_FILL:gamescene", anchor="center", x=-1, y=-2},
}

blueprints.progressbar_click_fix = {
	class = "ProgressBar",
	back = {class="Sprite", image="PROGRESSBAR_CLICK_FIX:gamescene", anchor="center"},
	front = {class="Sprite", image="PROGRESSBAR_CLICK_FIX_FILL:gamescene", anchor="center", x=-1, y=-2},
	label = {class="Label", name="EVENT_VALUE", font="FONT_GUI_SCORE", x=0, y=0, anchor="center", pivot="center" }
}

blueprints.label_floater = {
	class="Label",
	font="FONT_FLOATERS:default",
	anchor="center",
	align="center",
	lineHeight=25,
	roundPos=false,
}

blueprints.sprite_label_floater = {
	class="LabelLetters",
	font="FONT_FLOATERS:default",
	anchor="center",
	align="center",
	lineHeight=25,
	maxWidth=300,
	wrapStyle="wordwrap",
	roundPos=false,
}

scenes.gameTransition = {
	class = "AlphaTransition",
	time = 1000,
}

scenes.defaultTransition = {
	class = "FadeBlackTransition",
	time = 500,
	sceneComponents = {
		{class="Label", name="LOADING_LABEL", x=512, y=384, anchor="center", font="FONT_DAY_END_SCORE_MONEY_HEADING:interstitial", textId="CTEXT_LOADING"},
	},
}

scenes.introTransition = {
	class = "IntroTransition",
	startDuration = 1600, transitionDuration = 3200, endDuration = 1600,
	start = { waveHeight = 0, waveLength = 300, waveOffset = 384, moveFrequency = 2000, },
	trans_start = { waveHeight = 18, waveLength = 200, waveOffset = 384, moveFrequency = 2000, },
	trans_end = { waveHeight = 18, waveLength = 200, waveOffset = 384, moveFrequency = 2000, },
	finish = { waveHeight = 0, waveLength = 200, waveOffset = 384, moveFrequency = 2000, },
}

scenes.endGameTransition = {
	class = "EndGameTransition",
	time = 500,
	showTime = 8000,
	showDelay = 700,
	sceneComponents = {
		{class="Label", name="LABEL_END", x=512, y=400, anchor="center", font="FONT_DIALOG_HEADER:default", textId="END_GAME_THANKS", align="center", wrapStyle="wordwrap", maxWidth=900,}, 
	},
}

scenes.splashTransition = {
	class = "FadeBlackTransition",
	time = 500,
	sceneComponents = {
		{class="Sprite", name="LOADING_TEXT", x=512, y=715, image="LOADING_PLEASE_WAIT:preloadSection", anchor="top"},
	},
}

scenes.splash = {
	class = "SceneSplash",
	background = "SPLASH_BACKGROUND:splash",
}

scenes.load = {
	class = "SceneLoad",
	sceneComponents = {
		{class="TheoraVideo", name="video", file="movies/intro.ogv", autoSize=false, width=1024, height=768},
		{class="Button", name="LOADING_TEXT", x=512, y=715, image="LOADING_PLEASE_WAIT:preloadSection", anchor="top"},
	},
	playVideo = function(self)
		self:getChild("video"):sendToBack()
		self:getChild("video"):play()
		self:getChild("video").onEndReached = function()
			self.videoEnded = true
		end

		local black = self:newChild({class="Sprite", color="black", draw="color", width=1024, height=768})
		black:sendToBack()
	end
}

scenes.selection = {
	class = "SceneSelection",
	background = "BACKGROUND:sceneselection",
	sceneComponents = {
		{class="TheoraVideo", name="video", file="movies/selection_scene.ogv", autoSize=false, width=1024, height=768},
		{class="Sprite", name="LOGO", x=512, y=40, image="LOGO:sceneselection", anchor="top"},		
		{class="Label", name="PLAYER_NAME", x=512, y=329, anchor="center", font="FONT_SELECTION_WELCOME:sceneselection", },
		{class="Button", name="BUTTON_PLAY", x=512, y=376, image="BUTTON_PLAY:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},

		{class="Sprite", name="GUIBAR", x=0, y=768, image="GUI_BAR:sceneselection", anchor="bottomleft",
			children={
				{class="Sprite", x=512, y=0, image="GUI_BAR:sceneselection", anchor="bottomleft", currentFrame=1},
			}
		},
		{class="Button", x=100, y=744, name="BUTTON_HELP", image="BUTTON_HOWTOPLAY:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},
		{class="Button", x=307, y=744, name="BUTTON_SETTINGS", image="BUTTON_SETTINGS:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},
		{class="Button", x=512, y=744, name="BUTTON_CHANGEPLAYER", image="BUTTON_CHANGEPLAYER:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},
		{class="Button", x=717, y=741, name="BUTTON_EXTRA", image="BUTTON_EXTRA:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},
		{class="Button", x=925, y=744, name="BUTTON_EXIT", image="BUTTON_EXIT:sceneselection", clickSound="SOUND_BUTTON", soundSection="default", anchor="center"},	
	},
}

scenes.shop = {
	class = "SceneShop",
	background = "BACKGROUND_REST:sceneshop",
	sceneComponents = {
		prices = {
			class = "GameNode",
			name = "NODE_PRICES",
			children = {
				{class="Sprite", name="PRICE_UPGRADE_0", x=130, y=320, image="PRICE_100:sceneshop", anchor="topleft"},
				{class="Sprite", name="PRICE_UPGRADE_1", x=350, y=525, image="PRICE_200:sceneshop", anchor="topleft"},
				{class="Sprite", name="PRICE_UPGRADE_2", x=820, y=215, image="PRICE_300:sceneshop", anchor="topleft"},
				{class="Sprite", name="PRICE_UPGRADE_3", x=334, y=320, image="PRICE_400:sceneshop", anchor="topleft"},
				{class="Sprite", name="PRICE_UPGRADE_4", x=820, y=585, image="PRICE_500:sceneshop", anchor="topleft"},
				{class="Sprite", name="PRICE_UPGRADE_5", x=615, y=585, image="PRICE_600:sceneshop", anchor="topleft"},
				{class="Button", name="BUTTON_UPGRADE_0", x=130+80, y=320+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", name="BUTTON_UPGRADE_1", x=350+80, y=525+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", name="BUTTON_UPGRADE_2", x=820+80, y=215+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", name="BUTTON_UPGRADE_3", x=334+80, y=320+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", name="BUTTON_UPGRADE_4", x=820+80, y=585+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", name="BUTTON_UPGRADE_5", x=615+80, y=585+67, image="BUTTON_BUY:sceneshop", anchor="center", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Label", name="LABEL_CREDITS_DESCRIPTION", x=340, y=692, rotation=-5, anchor="center", align="center", font="FONT_BALLOON_DIALOG:default"},
				{class="Label", name="LABEL_CREDITS_VALUE", x=250, y=730, rotation=-5, anchor="topleft", align="center", font="FONT_BALLOON_DIALOG:default"},
				{class="Button", name="BUTTON_MAP", x=7, y=768-40, image="BUTTON_BACK:scenetrophy", clickSound="SOUND_BUTTON", soundSection="default"},
			},
		},
	},
}

scenes.trophy = {
	class = "SceneTrophy",
	background = "TROPHY_BACKGROUND:scenetrophy",
	sceneComponents = {
		{class="Button", name="BUTTON_BACK", x=5, y=719, image="BUTTON_BACK:scenetrophy", clickSound="SOUND_BUTTON", soundSection="default"},
		{class="Button", name="BUTTON_SHOW", x=911, y=719, image="BUTTON_SHOW:scenetrophy", clickSound="SOUND_BUTTON", soundSection="default"},
		box = {
			class = "GameNode",
			name = "NODE_BOX_HIGHLIGHT",
			children = {
				{class="Sprite", name="TROPHY_ROCKET_1", x=609, y=10, image="TROPHY_ROCKET_1_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_2", x=418, y=40, image="TROPHY_ROCKET_2_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_3", x=660, y=34, image="TROPHY_ROCKET_3_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_4", x=720, y=70, image="TROPHY_ROCKET_4_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_5", x=523, y=95, image="TROPHY_ROCKET_5_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_10", x=268, y=96, image="TROPHY_ROCKET_10_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_15", x=348, y=6, image="TROPHY_ROCKET_15_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_18", x=125, y=25, image="TROPHY_ROCKET_18_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_6", x=302, y=244, image="TROPHY_ROCKET_6_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_7", x=433, y=234, image="TROPHY_ROCKET_7_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_11", x=117, y=203, image="TROPHY_ROCKET_11_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_12", x=520, y=239, image="TROPHY_ROCKET_12_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_14", x=745, y=151, image="TROPHY_ROCKET_14_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_8", x=302, y=392, image="TROPHY_ROCKET_8_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_ROCKET_9", x=39, y=276, image="TROPHY_ROCKET_9_REST:scenetrophy", visible="false"},			
				{class="Sprite", name="TROPHY_ROCKET_13", x=758, y=280, image="TROPHY_ROCKET_13_REST:scenetrophy", visible="false"},				
				{class="Sprite", name="TROPHY_ROCKET_17", x=603, y=220, image="TROPHY_ROCKET_17_REST:scenetrophy", visible="false"},			
				{class="Sprite", name="TROPHY_ROCKET_16", x=527, y=376, image="TROPHY_ROCKET_16_REST:scenetrophy", visible="false"},
				{class="Sprite", name="TROPHY_PLATE_HOVER", x=211, y=635, image="TROPHY_PLATE_HOVER:scenetrophy", visible="false"},
				{class="Label", name="LABEL_TROPHY_TITLE", x=494, y=576, anchor="center", align="center", font="FONT_TROPHY_BOX:default"},
				{class="Label", name="LABEL_TROPHY_DESCRIPTION", x=494, y=680, anchor="center", align="center", font="FONT_TROPHY_PLATE:default"},
				{class="Label", name="LABEL_TROPHY_COUNTER", x=494, y=713, anchor="center", align="center", font="FONT_TROPHY_PLATE:default"},
			},
		},
	},
}

scenes.game = {
	class = "SceneGame",
	gui = {
		class = "GameNode",
		name = "NODE_GUI",
		children = {
			{class="Sprite", image="GUI_BAR:gamescene", x=0, y=768, anchor="bottomleft" },
			{class="Button", name="BUTTON_MENU", command="menu", image="BUTTON_MENU:gamescene", clickSound="SOUND_BUTTON", soundSection="default", x=24, y=726, anchor="topleft"},
			{class="Sprite", name="SCORE_BAR", image="SCORE_BAR:gamescene", x=649, y=747 },
			{class="EventBar", name="EVENTBAR",
				labelX1 = 176, labelX2 = 246,
				labelY1 = 732, labelY2 = 722,
				valuesX1 = 317, valuesX2 = 246,
				children = {
					{class="Sprite", name="CLOSED_BAR", image="EVENTBAR_CLOSED:gamescene", x=164, y=768, anchor="bottomleft" },
					{class="Sprite", name="EVENT_BAR", image="EVENT_BAR:gamescene", x=177, y=747 },
					{class="Sprite", name="EVENT_ICON", x=355, y=732, anchor="center" },
					{class="Sprite", name="EVENT_CURTAIN", image="CURTAIN:gamescene", x=330, y=704 },
					{class="Label", name="EVENT_TEXT", font="FONT_SCORE_TEXT", x=176, y=722, textId="TEXT_EVENT" },
					{class="Label", name="EVENT_VALUE", font="FONT_GUI_SCORE", x=317, y=722, anchor="topright", pivot="center", text="0/0" },
				},
			},
			{class="Sprite", image="CLOCK_FRAME_RED:gamescene", x=438, y=732, anchor="center"},
			{class="ThresholdSprite", name="CLOCK_RING", image="CLOCK_RING:gamescene", thresholdMask="CLOCK_THRESHOLD:gamescene", x=438, y=732, anchor="center", canShowBlack=true },
			{class="Sprite", name="CLOCK_FRAME", image="CLOCK_FRAME:gamescene", x=438, y=732, anchor="center"},
			{class="Sprite", name="CLOCK_POINTER", image="CLOCK_POINTER:gamescene", x=438, y=732, anchor="center" },
			{class="Label", name="SCORE_TEXT", font="FONT_SCORE_TEXT", x=647, y=721, textId="TEXT_SCORE" },
			{class="Label", name="SCORE_VALUE", font="FONT_GUI_SCORE", x=695, y=721, text="0", anchor="topleft", pivot="center" },

			{class="Sprite", name="TARGET_INDICATOR", image="TARGET_NORMAL:gamescene", y=743, anchor="bottom", },
			{class="Label", name="TARGET_SCORE", font="FONT_GUI_SCORE", y=720 },
			{class="Sprite", name="EXPERT_INDICATOR", image="TARGET_EXPERT:gamescene", y=743, anchor="bottom", },
			{class="Label", name="EXPERT_SCORE", font="FONT_GUI_SCORE", y=720 },
			{class="Tray", name="TRAY", x=4, y=643, children={{class="Sprite", name="ICONS", x=47, y=33}}, },

			{class="Label", name="SHIFT_INDICATOR", font="FONT_DAY", x=539, y=741, anchor="center" },
		},
	},
}

scenes.interstitial = {
	class = "InterstitialScene",
	calendarPos = {x=638, y=289},
	buttonsY = 20,
	sceneComponents = {
		{class="Background", name="BACKGROUND"},
		{class="EndLevelOverlay", name="LEVEL_END_OVERLAY"},
		{class="RestaurantSelection", name="RESTAURANT_SELECTION", image="top:interstitial", x=0, y=-120,
			children={
				{class="Sprite", x=512, y=0, image="top:interstitial", currentFrame=1},
				{class="Switch", name="REST1", image="button_rest1:interstitial", hitMask="button_rest1_hit", x=100, y=0, group=40},
				{class="Switch", name="REST2", image="button_rest2:interstitial", hitMask="button_rest2_hit", x=200, y=0, group=40},
				{class="Switch", name="REST3", image="button_rest3:interstitial", hitMask="button_rest3_hit", x=300, y=0, group=40},
				{class="Switch", name="REST4", image="button_rest4:interstitial", hitMask="button_rest4_hit", x=400, y=0, group=40},
				{class="Switch", name="REST5", image="button_rest5:interstitial", hitMask="button_rest5_hit", x=500, y=0, group=40},
				{class="Label", name="LABEL_PROGRESS", x=1024/2, y=100, font="FONT_TEXT:default", anchor="center"},
			},
		},
		{class="Sprite", name="GUIBAR", x=0, y=1024, image="gui_bar:interstitial",
			children={
				{class="Sprite", x=512, y=0, image="gui_bar:interstitial", currentFrame=1},
				{class="Button", x=850, name="BUTTON_START", image="button_start:interstitial", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", x=76, name="BUTTON_SHOP", image="button_shop:interstitial", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", x=334, name="BUTTON_TROPHY", image="button_trophy:interstitial", clickSound="SOUND_BUTTON", soundSection="default"},
				{class="Button", x=592, name="BUTTON_MEMORIES", image="button_memories:interstitial", clickSound="SOUND_BUTTON", soundSection="default"},
			},
		},
		{class="Calender", name="CALENDAR",x=1024, y=289, image="calendar:interstitial",
			children={
				{class="Sprite", x=114, y=-2, name="MOUSE", image="mouse_appear:interstitial"},
				{class="Button", name="BG1", image="day_1_blue:interstitial", x=66, y=122, hitMaskThreshold=0.1},
				{class="Button", name="BG2", image="day_2_blue:interstitial", x=130, y=130, hitMaskThreshold=0.1},
				{class="Button", name="BG3", image="day_3_blue:interstitial", x=193, y=137, hitMaskThreshold=0.1},
				{class="Button", name="BG4", image="day_4_blue:interstitial", x=57, y=161, hitMaskThreshold=0.1},
				{class="Button", name="BG5", image="day_5_blue:interstitial", x=117, y=170, hitMaskThreshold=0.1},
				{class="Button", name="BG6", image="day_6_blue:interstitial", x=183, y=178, hitMaskThreshold=0.1},
				{class="Button", name="BG7", image="day_7_blue:interstitial", x=46, y=201, hitMaskThreshold=0.1},
				{class="Button", name="BG8", image="day_8_blue:interstitial", x=106, y=207, hitMaskThreshold=0.1},
				{class="Button", name="BG9", image="day_9_blue:interstitial", x=171, y=216, hitMaskThreshold=0.1},
				{class="Button", name="BG10", image="day_10_blue:interstitial", x=30, y=238, hitMaskThreshold=0.1},

				{class="SpecialSwitch", name="DAY1", image="day_1:interstitial", x=71, y=106, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY2", image="day_2:interstitial", x=136, y=115, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY3", image="day_3:interstitial", x=197, y=123, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY4", image="day_4:interstitial", x=62, y=147, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY5", image="day_5:interstitial", x=123, y=151, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY6", image="day_6:interstitial", x=186, y=161, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY7", image="day_7:interstitial", x=47, y=185, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY8", image="day_8:interstitial", x=111, y=193, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY9", image="day_9:interstitial", x=170, y=201, group=42, hitMaskThreshold=0.9},
				{class="SpecialSwitch", name="DAY10", image="day_10:interstitial", x=38, y=222, group=42, hitMaskThreshold=0.9},
			},
		},
	},
}

blueprints.day_won = {
	class = "DayWon", id="DAY_WON", width=1024, height=768, color="black",
	children = {	
		{ class="Sprite", name="SPRITE_WON_TEXT", x=501, y=78, image="day_completed:interstitial", anchor="top"},
		{ class="Label", name="LABEL_REST_HEADER", x=500, y=239, rotation=-7, wrapStyle="wordwrap", maxWidth=295, font="FONT_DAY_END_GREEN:interstitial", anchor="top", roundPos=false},

		{ class="Sprite", name="INFO_BG", x=0, y=0, alpha=0, children = {
			{ class="Sprite", name="SPRITE_INFO_BG", x=44, y=385, image="info_space:interstitial"},
			{ class="Sprite", name="SPRITE_SCOREBAR", x=71, y=389, image="score_bar_full:interstitial"},
			
			{ class="Sprite", name="SPRITE_STAR_TARGET", x=347, y=375, image="star_target_score:interstitial", anchor="center"},
			{ class="Sprite", name="SPRITE_STAR_EXPERT", x=466, y=375, image="star_expert_score:interstitial", anchor="center"},
					
			{ class="Label", name="LABEL_SCORE_TARGET_TEXT", x=67, y=360, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_SCORE_MONEY_HEADING:interstitial", textId="TEXT_SCORE_TARGET", anchor="left"},
			{ class="Label", name="LABEL_SCORE_TODAY_TEXT", x=67, y=438, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_TODAY_TEXT:interstitial", textId="TEXT_DAY_SCORE", anchor="left"},
			{ class="Label", name="LABEL_MONEY_EARNED", x=546, y=438, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_SCORE_NUMBERS:interstitial", anchor="right"},

			{ class="Label", name="LABEL_DECORATION_CREDITS_HEADER", x=67, y=495, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_SCORE_MONEY_HEADING:interstitial", anchor="left", textId="TEXT_DAY_DECORATION"},
			{ class="Label", name="LABEL_DECORATION_CREDITS_TEXT", x=69, y=535, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_TODAY_TEXT:interstitial", anchor="left", textId="TEXT_DAY_DECORATION_TODAY"},
			{ class="Label", name="LABEL_DECORATION_CREDITS", x=535, y=535, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_TODAY_TEXT:interstitial", anchor="right"},

			{ class="Label", name="LABEL_DECORATION_CREDITS_TOTAL_TEXT", x=68, y=579, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_TOTAL_MONEY_TEXT:interstitial", anchor="left", textId="TEXT_DAY_DECORATION_CREDITS"},
			{ class="Label", name="LABEL_DECORATION_CREDITS_TOTAL", x=541, y=578, setup="TEXT_LABEL_WHITE", font="FONT_DAY_END_TOTAL_MONEY_NUMBERS:interstitial", anchor="right"},}
		},
		{ class="Sprite", name="SPRITE_DECORATIONS_STAR", x=307, y=549, image="decoratons_unlocked_animation:interstitial", alpha=0},
		{ class="Sprite", name="SPRITE_DECORATIONS", x=125, y=581, image="decorations_unlocked:interstitial", alpha=0},
	},
}

dialogs.yes_no = {
	class = "DialogYesNo",
	minWidth = 500, minHeight = 300,
	autoCenter = true,
	doDarkenBackground = true,
	painter = blueprints.default_painter,
	components = {
		{ class="Label", name="HEADER", x=246, y=100, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Label", name="MESSAGE", x=250, y=143, maxWidth=340, anchor="top", align="center", wrapStyle="wordwrap", font="FONT_TEXT:default"},
		{ class="Button", name="BUTTON_YES", x=240, y=170, image="BUTTON_YES:default", anchor="topright", clickSound="SOUND_BUTTON", soundSection="default"},
		{ class="Button", name="BUTTON_NO", x=260, y=170, image="BUTTON_NO:default", anchor="topleft", clickSound="SOUND_BUTTON", soundSection="default"},
	},
}

dialogs.hint = {
	class = "DialogHint",
	name = "DIALOG_HINT",
	minWidth = 424, minHeight = 200,
	lty1 = 158, lty2 = 168,
	autoCenter = false,
	painter = {
		class = "DialogPainter",
		section = "default",
		images = {
			"BORDER_HINT_TOP_LEFT", "BORDER_HINT_TOP_CENTER", "BORDER_HINT_TOP_RIGHT",
			"BORDER_HINT_CENTER_LEFT", "BORDER_HINT_CENTER", "BORDER_HINT_CENTER_RIGHT",
			"BORDER_HINT_BOTTOM_LEFT", "BORDER_HINT_BOTTOM_CENTER", "BORDER_HINT_BOTTOM_RIGHT",
		},
	},
	components = {
		{ class="Label", name="TIP_HEADER", x=212, y=65, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Label", name="TIP_TEXT", x=212, y=100, maxWidth=300, align="center", wrapStyle="wordwrap", anchor="top", lineHeight=18, font="FONT_TEXT:default"},
		{ class="Button", name="BUTTON_OK", x=212, y=105, image="BALLOON_OK:gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default"},
	},
}

dialogs.help = {
	class="DialogHelp", name="DIALOG_HELP", autoCenter=true, width=1024, height=768, movable=false, doDarkenBackground=false,
	components = {
		{ class="Sprite", name="BACK_1", x=0, y=0, image="HELP1", section="gamescene", },
		{ class="Sprite", name="BACK_2", x=0, y=0, image="HELP2", section="gamescene", alpha=0, },
		{ class="Button", name="BUTTON_PREV", x=166, y=650,image="BUTTON_PREV", section="gamescene", anchor="topright", clickSound="SOUND_BUTTON", soundSection="default"},
		{ class="Button", name="BUTTON_OK", x=512, y=675, image="BUTTON_OK", section="default", anchor="top", },
		{ class="Button", name="BUTTON_NEXT", x=854, y=650, image="BUTTON_NEXT", section="gamescene", anchor="topleft", clickSound="SOUND_BUTTON", soundSection="default"},
	},
}

dialogs.player_select = {
	class="DialogPlayerSelect", minWidth=690, minHeight=630, autoCenter=true, doDarkenBackground=true, painter=blueprints.default_painter,
	buttonSpacing = 50,
	nameButton = { class="Button", y=160, image="NAME_SELECT_BUTTON", anchor="top", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
	nameLabel = { class="Label", y=12, anchor="top", font="FONT_TEXT:default", },
	components = {
		{ class="Sprite", x=88, y=121, image="PLAYER_SELECT_BACK", section="default", },
		{ class="Label", x=345, y=108, anchor="top", textId="PLAYER_SELECT", font="FONT_DIALOG_HEADER", section="default", },
		{ class="Sprite", name="BORDER", x=0, y=0, anchor="top", image="PLAYER_BORDER", section="default", },
		{ class="Button", name="BUTTON_ADD", x=180, y=503, image="BUTTON_ADD", anchor="top", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
		{ class="Button", name="BUTTON_REMOVE", x=345, y=503, image="BUTTON_REMOVE", anchor="top", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
		{ class="Button", name="BUTTON_OK", x=515, y=503, image="BUTTON_OK", anchor="top", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
	},
}

dialogs.new_player = {
	class="DialogNameInput", minWidth=690, minHeight=630, autoCenter=true, doDarkenBackground=true, painter=blueprints.default_painter,
	components = {
		{ class="Sprite", x=89, y=122, image="NAME_INPUT_BACK", section="default", },
		{ class="Label", x=345, y=107, anchor="top", textId="PLAYER_SELECT", font="FONT_DIALOG_HEADER:default", },
		{ class="LabelInput", name="INPUT_NAME", x=345, y=151, anchor="top", image="INPUTLABEL:default",
			cursorImage="CARET", cursorX=4, cursorY=-5, maxWidth=340,
			durationOn=500, durationOff=500,
			selectionColor=0x0099ee, borderColor=0x000044,
			label = { class="Label", x=0, y=13, anchor="top", font="FONT_TEXT:default", },
		},

		{ class="Label", x=345, y=237, anchor="top", textId="DIFFICULTY", font="FONT_DIALOG_HEADER:default", },
		{ class="Switch", name="D0", x=122, y=264, image="RADIO:default", group=781, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D0", x=181, y=289, textId="EASY", font="FONT_DIALOG_SUB:default", },
		{ class="Switch", name="D1", x=271, y=264, image="RADIO:default", group=781, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D1", x=325, y=289, textId="MEDIUM", font="FONT_DIALOG_SUB:default", },
		{ class="Switch", name="D2", x=425, y=264, image="RADIO:default", group=781, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D2", x=485, y=289, textId="HARD", font="FONT_DIALOG_SUB:default", },

		{ class="Label", textId="AUDIO", x=345, y=359, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Sprite", name="AUDIO_BIRDS", x=347, y=406, image="AUDIO_BIRDS:default", anchor="center"},
		{ class="Sprite", name="NOTE1", x=210, y=347, image="AUDIO_NOTE:default", anchor="center"},
		{ class="Sprite", name="NOTE2", x=229, y=347, image="AUDIO_NOTE2:default", anchor="center"},
		{ class="Sprite", name="NOTE3", x=440, y=353, image="AUDIO_NOTE:default", anchor="center"},
		{ class="Sprite", name="NOTE4", x=456, y=353, image="AUDIO_NOTE2:default", anchor="center"},
		{ class="Label", textId="TURN_ON_AUDIO", x=354, y=407, maxWidth=340, anchor="top", align="center", wrapStyle="wordwrap", font="FONT_TEXT:default"},

		{ class="Button", name="BUTTON_CANCEL", x=180, y=503, image="BUTTON_CANCEL", anchor="topleft", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
		{ class="Button", name="BUTTON_OK", x=488, y=502, image="BUTTON_OK", anchor="topright", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
	},
}

dialogs.settings = {
	class="DialogSettings", minWidth=690, minHeight=630, autoCenter=true, doDarkenBackground=true, painter=blueprints.default_painter,
	components = {
		{ class="Sprite", x=89, y=122, image="SETTINGS_BACK", section="default", },
		{ class="Label", x=345, y=113, textId="CTEXT_SETTINGS_HEADER", anchor="top", font="FONT_DIALOG_HEADER", section="default", },

		{ class="Label", x=135, y=162, textId="CTEXT_SETTINGS_MUSIC", font="FONT_DIALOG_SUB", section="default", },
		{ class="Slider", name="SLIDER_MUSICVOL", x=220, y=167, image="SLIDER_BACK", section="default", minX=20, minY=14, maxX=337, maxY=14,
			button = { class="Button", y=-7, image="SLIDER_BUTTON", section="default", anchor="center", },
		},
		{ class="Sprite", name="YELLOW_BACK_1", image="SLIDER_BACK_FILLED", section="default", },

		{ class="Label", x=135, y=206, textId="CTEXT_SETTINGS_SOUND", font="FONT_DIALOG_SUB", section="default", },
		{ class="Slider", name="SLIDER_FXVOL", x=220, y=212, image="SLIDER_BACK", section="default", minX=20, minY=14, maxX=337, maxY=14,
			button = { class="Button", y=-7, image="SLIDER_BUTTON", section="default", anchor="center", },
		},
		{ class="Sprite", name="YELLOW_BACK_2", image="SLIDER_BACK_FILLED", section="default", },

		{ class="Switch", name="SWITCH_FULLSCREEN", x=120, y=234, image="CHECKBOX", offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", section="default", soundSection="default", },
		{ class="Label", name="LABEL_FULLSCREEN", x=185, y=257, textId="FULLSCREEN", font="FONT_DIALOG_SUB", section="default", },
		{ class="Switch", name="SWITCH_SHOWHINTS", x=120, y=284, image="CHECKBOX", offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", section="default", soundSection="default", },
		{ class="Label", name="LABEL_SHOWHINTS", x=185, y=307, textId="SHOW_HINTS", font="FONT_DIALOG_SUB", section="default", },

		{ class="Label", x=345, y=371, textId="DIFFICULTY", anchor="top", font="FONT_DIALOG_HEADER:default", },
		{ class="Switch", name="D0", x=122, y=400, image="RADIO:default", group=783, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D0", x=181, y=425, textId="EASY", font="FONT_DIALOG_SUB:default", },
		{ class="Switch", name="D1", x=271, y=400, image="RADIO:default", group=783, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D1", x=325, y=425, textId="MEDIUM", font="FONT_DIALOG_SUB:default", },
		{ class="Switch", name="D2", x=425, y=400, image="RADIO:default", group=783, offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", },
		{ class="Label", name="LABEL_D2", x=485, y=425, textId="HARD", font="FONT_DIALOG_SUB:default", },

		{ class="Button", name="BUTTON_CREDITS", x=258, y=502, image="BUTTON_CREDITS", anchor="topright", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
		{ class="Button", name="BUTTON_OK", x=354, y=502, image="BUTTON_OK", anchor="top", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
		{ class="Button", name="BUTTON_CANCEL",	x=460, y=502, image="BUTTON_CANCEL", clickSound="SOUND_BUTTON", section="default", soundSection="default", },
	},
}

dialogs.credits = {
	class="DialogCredits", name="credits", doDarkenBackground=false,
	background="BACKGROUND:fireworks",
	clipHeight=250, clipY=60,
	startDelay=2000, endDelay=2000, scrollDuration=60000,
	startSpacing=400,
	preNameSpacing=28,
	nameSpacing=32,
	postNameSpacing=60,
	postHeadSpacing=60,
	noClickDelay=4000,
	labelsX=680,
	labelMaxWidth=(1024-680)*2,
	slope=0,
	kidPhotoWidth=300,
	numKidPhotos=12,
	kidPhotoDelay=7500,
	timePerKidPhoto=8100,
	kidPhotoFadeTime=1200,
	kidPhotoPos={x=0, y=10},
	kidPhotoOffset={x=680*2 - 1024 - 0 - 300, y=380},
	components = {
		{ class="Sprite", name="BACK" },
		{ class="Sprite", name="LABELS", y=768/2,
			children={
				{ class="Sprite", x=512, y=0, anchor="center", image="GAME_LOGO", section="default", },
			},
		},
		{ class="Label", name="VERSION", x=336, y=366, },
	},
}

dialogs.ingame_menu = {
	class="DialogMenu", name="ingame_menu", autoCenter=true, minWidth=320, minHeight=535, doDarkenBackground=true, painter=blueprints.default_painter,
	components = {
		{ class="Label", x=162, y=96, anchor="top", textId="CTEXT_MAKE_CHOICE", font="FONT_DIALOG_HEADER", section="default", },
		{ class="Button", name="BUTTON_SETTINGS", x=160, y=150, image="MENU_SETTINGS", section="gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_HELP", x=160, y=210, image="MENU_HELP", section="gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },		
		{ class="Button", name="BUTTON_CALENDAR", x=160, y=270, image="MENU_CALENDAR", section="gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_MENU", x=160, y=330, image="MENU_MENU", section="gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_RESUME", x=160, y=390, image="MENU_RESUME", section="gamescene", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
	},
}

dialogs.premium_menu = {
	class="DialogPremium", name="premium_menu", width=1024, height=768, doDarkenBackground=false, background="BACKGROUND:prem",
	children = {
		{ class="Sprite", name="MAIN", x=184, y=101, image="INTRO", section="prem", },
		{ class="Sprite", name="FRAME", x=25, y=17, image="FRAME_1", section="prem", },
		{ class="Button", name="BUTTON_GUIDE", x=100, y=200, image="BUTTON_GUIDE", section="prem", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_SCREEN", x=100, y=256, image="BUTTON_SCREEN", section="prem", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },		
		{ class="Button", name="BUTTON_CONCEPT", x=100, y=312, image="BUTTON_CONCEPT", section="prem", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_BLOG", x=100, y=368, image="BUTTON_BLOG", section="prem", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
		{ class="Button", name="BUTTON_BACK", x=100, y=424, image="BUTTON_BACK", section="prem", anchor="top", clickSound="SOUND_BUTTON", soundSection="default", },
	},
}

dialogs.shift_start = {
	class="DialogShiftStart", autoCenter=true, width=1024, height=768, doDarkenBackground=true,
	components = {
		{ class="Sprite", name="BACK", image="SHIFT_STARTS", section="gamescene", anchor="center", x=512, y=340, },
		{ class="Sprite", name="TEXT", image="SHIFT_STARTS_TEXT", section="gamescene", anchor="center", x=512, y=340, },
		{ class="Label", name="DAY_TEXT", rotation=-7, font="FONT_DAY_END_GREEN:default", anchor="center", x=512, y=394, },
	},
}

dialogs.shift_close = {
	class="DialogShiftClose", name="DIALOG_SHIFT_CLOSE", autoCenter=true, width=1024, height=768, doDarkenBackground=true, modal=false,
	components = {
		{ class="Sprite", name="BACK", image="SHIFT_CLOSED", section="gamescene", anchor="center", x=512, y=340, },
		{ class="Sprite", name="TEXT", image="SHIFT_CLOSED_TEXT", section="gamescene", anchor="center", x=512, y=340, },
	},
}
