--' ************************************ Memory Task ************************************ '--
MemoryTask = deriveLuaClass("MemoryTask", "LuaTask")
function MemoryTask:start()
	self.memoryIdx = player:getMemoryIdx(player.room, player.shift)
	if (self.dummy) then
		player:missedMemory(self.memoryIdx)
		return false
	end

	if (isString(self.circleTarget)) then
		self.circleTarget = level:getChild(self.circleTarget)
	end

	self.startDuration = self.startDuration or 500
	self.memoryDuration = self.memoryDuration or 4000
	self.endDuration = self.endDuration or 1000
	if (self.duration == 0) then
		self.duration = self.startDuration + self.memoryDuration + self.endDuration
	end

	if (self.memoryIdx >= 1 and not player:hasMemory(self.memoryIdx)) then
		self.memory = scene:newChild({
			class = "Memory",

			memoryIdx = self.memoryIdx,
			memoryDuration = self.memoryDuration,

			circleTarget = self.circleTarget,
			circleOffset = self.circleOffset,
			cameraOffset = self.cameraOffset,

			numStars = self.numStars or 5,
			circleRadius = self.circleRadius or 200,

			startDuration = self.startDuration,
			circleDuration = self.circleDuration or 2000,
			endDuration = self.endDuration,
		})
	end

	return self.memory ~= nil
end

function MemoryTask:update(time)
	return
		not self.memory or
		self.memory.finished or
		self.memory.__deleted
end

function MemoryTask:skip()
	if (self.dummy or not isTable(self.memory) or not self.memory.hasBeenClicked) then
		player:missedMemory(self.memoryIdx)
	end
	if (isTable(self.memory) and self.memory.remove and not self.memory.__deleted) then
		self.memory:remove()
	end
end

--' Memor
Memory = getClass("Memory")

function Memory:initCamera(camera)
	camera:doEvery(0, function()
		camera:newChild({class="ParticleEffect", x=0, y=-30, particle="flash_effect:memories_ingame", scale=0.2})
		return 1000
	end)
end

--' ************************************ Memory Dialog ************************************ '--
dialogs = dialogs or {}
dialogs.memories = {
	class="DialogMemories", background="background_5:memories",
	onShow=function(self)
		self:doEvery(0, function()
			--' TODO: background animation (butterfly etc)
			return math.Random(100, 300)
		end)
	end,
	components={
		{ class="Label", name="page", font="FONT_TEXT:default", x=393, y=735},
		{ class="Button", name="prev", image="button_prev:memories", x=19, y=681, anchor="topleft"},
		{ class="Button", name="back", image="button_back:memories", x=496, y=728, anchor="top"},
		{ class="Button", name="next", image="button_next:memories", x=1012, y=681, anchor="topright"},
		{ class="Sprite", image="grass:memories", x=0, y=768, anchor="bottomleft"},
	},

	flipDuration=200,
}

memoriesConfig={
	--' Room 1
	{ shift=1, x=0, y=-11 },
	{ shift=3, x=0, y=266 },
	{ shift=5, x=447, y=0 },
	{ shift=6, x=735, y=0 },
	{ shift=9, x=480, y=291 },

	--' Room 2
	{ shift=1, x=0, y=2 },
	{ shift=3, x=0, y=322 },
	{ shift=6, x=456, y=0 },
	{ shift=7, x=458, y=261 },
	{ shift=10, x=235, y=279 },

	--' Room 3
	{ shift=1, x=0, y=15 },
	{ shift=2, x=0, y=337 },
	{ shift=5, x=445, y=0 },
	{ shift=9, x=481, y=317 },
	{ shift=10, x=761, y=150 },

	--' Room 4
	{ shift=3, x=0, y=0 },
	{ shift=5, x=175, y=281 },
	{ shift=6, x=439, y=0 },
	{ shift=7, x=737, y=0 },
	{ shift=10, x=545, y=336 },

	--' Room 5
	{ shift=0, x=0, y=11 },
	{ shift=4, x=0, y=351 },
	{ shift=6, x=223, y=62 },
	{ shift=9, x=443, y=0 },
	{ shift=10, x=739, y=0 },
}
