ghf.GameNode.remove = ghf.GameNode.removeFromParent

pppp, pppn, doPr = "", 0, false --' State vars
function ts(x) return tostring(x) end --' Lazy tostring
function pf()
	if (doPr and pppp ~= "") then
	--''print(string.rep("\t", pppn)..pppp) pppp = ""
	end
end
function pr(...) for _,v in ipairs(arg) do pppp = pppp.." "..ts(v) end end	--' Append
function pi(...) pf() pppn = pppn + 1 pr(unpack(arg)) end					--' Inc Append
function pb(...) pi(unpack(arg)) pd() end									--' Inc Append Flush Dec
function pe(...) pr(unpack(arg)) pf() end									--' Append Flush
function pd(...) pe(unpack(arg)) pppn = pppn - 1 end						--' Append Flush Dec
function pn(...) pf() pr(unpack(arg)) end									--' Flush Append
function pl(...) pf() pe(unpack(arg)) end									--' Flush Append Flush

--doPr = true --' <-- Change this to turn the 'px' debug output off

function randomFromWeightedTable(t)
	assert(isTable(t))
	assert(table.count(t) > 0)
	local shortNotation
	for _,v in pairs(t) do
		assert(isTable(v) or isNumber(v))
		if (shortNotation == nil) then
			shortNotation = isNumber(v)
		else
			assert(shortNotation == isNumber(v))
		end
		if (not shortNotation) then
			assert(isNumber(v.weight))
		end
	end

	--' Calculate the sum of the weights
	local sum = 0
	for _,v in pairs(t) do
		sum = sum + ((shortNotation and v) or v.weight)
	end
	assert(sum > 0)

	--' Get a random index
	local idx = math.Random(sum)
	assert(idx >= 1)
	assert(idx <= sum)

	--' Calculate the value
	local counter = 0
	local result
	for k,v in pairs(t) do
		if (shortNotation) then
			result = k
		else
			--'result = (table.count(v) == 2 and v[1]) or v
			result = v
		end
		result = (shortNotation and k) or v
		counter = counter + ((shortNotation and v) or v.weight)
		if (counter > idx) then
			break
		end
	end
	return result
end

function toPoint(v, w)
	if (isTable(v)) then
		return {x = v.x or v[1] or 0, y = v.y or v[2] or 0}
	end
	return {x = v or 0, y = w or 0}
end

function switchNeverShowHintClick(object, hintId)
	assert(object)
	if (object.oldShowHintClick) then
		object.onClick = object.oldShowHintClick
	end
	object.oldShowHintClick = object.onClick
	object.onClick = function()
		local r = object.oldShowHintClick(object)
		player:setNeverShowHint(hintId)
		object.onClick = object.oldShowHintClick
		return r
	end
end

function switchHintArrowClick(object, arrowId)
	assert(object)
	if (object.oldHintArrowClick) then
		object.onClick = object.oldHintArrowClick
	end

	object.oldHintArrowClick = object.onClick
	object.oldOnAvailable = object.onBecomeAvailable
	object.onClick = function()
		local doOnArrowRemoved = hintManager:hasArrow(arrowId)
		hintManager:removeArrows(arrowId)
		local r = object:oldHintArrowClick()
		object.onClick = object.oldHintArrowClick
		if (level and level.onArrowRemoved and doOnArrowRemoved) then
			level:onArrowRemoved(arrowId, object)
		end
		return r
	end
end

function switchCustomerGroupLeave(group, hintId)
	if (isCallable(group.oldGroupLeave)) then
		return
	end

	group.oldGroupLeave = group.groupLeave or function() end
	group.groupLeave = function()
		if (group.oldGroupLeave) then
			group:oldGroupLeave()
		end
		group.groupLeave = group.oldGroupLeave
		if (hintId == "CompoundOrdered") then
			local removedHint =
				hintManager:removeArrows("CompoundOrdered") or
				hintManager:removeArrows("compound_ordered_2") or
				hintManager:removeArrows("compound_ordered_3")
			if (removedHint) then
				player:removeNeverShowHint("CompoundOrdered")
			end
		end
		if (hintId == "JamEmpty") then
			local removedHint =
				hintManager:removeArrows("JamEmpty") or
				hintManager:removeArrows("jam_empty_2")
			if (removedHint) then
				player:removeNeverShowHint("JamEmpty")
			end
		end
		if (hintId == "PieReady") then
			local removedHint =
				hintManager:removeArrows("PieReady") or
				hintManager:removeArrows("pie_2")
			if (removedHint) then
				player:removeNeverShowHint("PieReady")
			end
		end
		if (hintId == "Pizza") then
			local removedHint =
				hintManager:removeArrows("Pizza") or
				hintManager:removeArrows("pizza_2")
			if (removedHint) then
				player:removeNeverShowHint("Pizza")
			end
		end
	end
end

dofile("script/Constants.lua");
dofile("script/Tasks.lua");
dofile("script/Character.lua")
dofile("script/TaskSystem.lua")
dofile("script/Trophies.lua")
dofile("script/Level.lua")
dofile("script/Values.lua")
dofile("script/Scenes.lua")
dofile("script/Interstitial.lua")

dofile("script/shifts/all_shifts.lua")

dofile("script/objects/View.lua")
dofile("script/objects/Object.lua")
dofile("script/objects/GameHouseObject.lua")
dofile("script/objects/Mouse.lua")
dofile("script/objects/Station.lua")
dofile("script/objects/CashRegister.lua")
dofile("script/objects/IngredientButton.lua")
dofile("script/objects/Clock.lua")
dofile("script/objects/StatusObject.lua")
dofile("script/objects/Cooker.lua")
dofile("script/objects/Tap.lua")
dofile("script/objects/Shelf.lua")
dofile("script/objects/Animal.lua")
dofile("script/objects/Firefly.lua")
dofile("script/objects/Grow.lua")
dofile("script/objects/Changer.lua")
dofile("script/objects/Tree.lua")
dofile("script/objects/Stack.lua")
dofile("script/objects/Dispenser.lua")
dofile("script/objects/Operator.lua")
dofile("script/objects/Disco.lua")
dofile("script/objects/ProgressBar.lua")
dofile("script/objects/MemoryEgg.lua")

dofile("script/events/Event.lua")
dofile("script/events/ClickFixEvent.lua")
dofile("script/events/FixEvent.lua")
dofile("script/events/LearnToRideEvent.lua")
dofile("script/events/HiddenObjectEvent.lua")
dofile("script/events/PopupEvent.lua")
dofile("script/events/SearchSpotsEvent.lua")
dofile("script/events/ShoutAndMakeEvent.lua")
dofile("script/events/SpecialTreatEvent.lua")
dofile("script/events/WhereIsMyEvent.lua")
dofile("script/events/KeepItUpEvent.lua")

dofile("script/Fireworks.lua")
dofile("script/Memories.lua")
