--' ************************************ Interstitial Scene ************************************ '--
InterstitialScene = getClass("InterstitialScene")

function InterstitialScene:moveCalendar(onScreen)
	local calendar = self:child("CALENDAR")
	if (onScreen) then
		calendar:animate({x=scenes.interstitial.calendarPos.x, duration=500})
	else
		calendar:animate({x=ghf.screenWidth + 30, duration=500})
	end
	calendar.enabled = onScreen
end

function InterstitialScene:moveRestSelectionAndButtons(onScreen)
	local restSelection = self:child("RESTAURANT_SELECTION")
	if (restSelection) then
		local h = 0
		if (not onScreen) then h = -restSelection.height end
		restSelection:animate({y=h, duration=500})
	end
	local guibar = self:child("GUIBAR")
	if (guibar) then
		local h = ghf.screenHeight - guibar.height
		if (not onScreen) then h = ghf.screenHeight+20 end
		guibar:animate({y=h, duration=500})
	end
	restSelection.enabled = onScreen
end

function InterstitialScene:simpleAnimationRestaurant()
	local background = self:child("BACKGROUND")
	local black = self:newChild({x=0, y=0, image="rest1_background:interstitial"})
	black.color = "black"
	black.alpha = 0

	self:moveCalendar(false)
	self:moveRestSelectionAndButtons(false)

	black:animate(
		{alpha=1, duration=1000},
		{command="update", target=self},
		{command="update", target=background},
		{alpha=0, duration=1000},
		{call=function()
			self:moveCalendar(true)
			self:moveRestSelectionAndButtons(true)
		end},
		{remove=true}
	)
end

function InterstitialScene:initializeRestaurant1()
	local background = self:child("BACKGROUND")

	local geese = background:newChild({x=-160, y=105, image="rest1_geese:interstitial"})
	geese:animate({frameTime=100})
	geese:doEvery(0, function()
		local duration = math.Random(14000, 20000)
		geese.x = -geese.width
		geese.y = 180
		geese.scale = 0.6
		geese:animate({x=ghf.screenWidth, y=100, scale=1.3, duration=7000})
		return duration
	end)

	background:newChild({x=0, y=123, image="rest1_front:interstitial"})

	local chickens = background:newChild({x=286, y=518, image="rest1_chickens:interstitial"})
	chickens:animate({frameTime = 300, startframe = 0, loop = "infinite"})
end

function InterstitialScene:initializeRestaurant2()
	local background = self:child("BACKGROUND")
	background:newChild({x=21, y=543, image="rest2_front:interstitial"})
	butterfly = background:newChild({x=300, y=408, image="rest2_butterfly:interstitial", anchor="center"})
	butterfly:animate({frameTime = 100, startframe = 0, loop = "infinite"})
	rooster = background:newChild({x=220, y=260, image="rest2_rooster:interstitial", anchor="center"})
	rooster:doEvery(1000, function()
		local loops = math.Random(3)
		rooster:animate({frameTime = 100, startFrame = 0, loop=loops}, {frame=0})
		SpriteExt.playSample(nil, "SOUND_ROOSTER:sound")
		return loops * 100 * rooster.frameCount + math.Random(1000, 5000)
	end)

	catterpillar = background:newChild({x=400, y=710, image="rest2_catterpillar:interstitial", anchor="center"})
	catterpillar:animate({delay = 0}, {{frameTime = 200, startframe = 0, loop = "infinite"}, {x = 1024, duration = 40000}})
	background:newChild({x=21, y=543, image="rest2_front:interstitial"})

end

function InterstitialScene:initializeRestaurant3()
	local background = self:child("BACKGROUND")

	background:newChild({x=0, y=0, image="rest3_background:interstitial"})

	campfire_shadow1 = background:newChild({x=450, y=665, skewX=-0.5, image="rest3_campfire_shadow:interstitial", anchor="center", alpha=1.0})
	campfire_shadow2 = background:newChild({x=450, y=665, skewX=0.5, image="rest3_campfire_shadow:interstitial", anchor="center", alpha=1.0})
	campfire_back = background:newChild({x=435, y=565, image="rest3_campfire_back:interstitial", anchor="center"})
	campfire_fire = background:newChild({x=470, y=600, image="rest3_fire:interstitial", anchor="center"})
	campfire_front = background:newChild({x=450, y=565, image="rest3_campfire_front:interstitial", anchor="center"})
	campfire_fire:animate({frameTime = 100, startframe = 0, loop = "infinite"})
	background:newChild({class="ParticleEffect", library="PARTICLE_THEAPOT:interstitial", x=525, y=540, start=true})
	campfire_shadow1:doEvery(0, function()
		local duration = math.Random(80, 300)
		campfire_shadow1:animate({alpha=math.Random(0.4, 0.8), duration=duration})
		return duration
	end)
	campfire_shadow2:doEvery(0, function()
		local duration = math.Random(50, 600)
		campfire_shadow2:animate({alpha=math.Random(0.4, 0.7), duration=duration})
		return duration
	end)
	background:newChild({x=0, y=0, image="rest3_front:interstitial"})
end

function InterstitialScene:initializeRestaurant4()
	local background = self:child("BACKGROUND")

	background:newChild({x=290, y=120, image="rest3_fire:interstitial"})
	local gondolla1 = background:newChild({x=372, y=222, image="rest3_fire:interstitial", pivotPoint={x=47,y=12}})
	local gondolla2 = background:newChild({x=372, y=222, image="rest3_fire:interstitial", pivotPoint={x=47,y=12}})
	background:newChild({x=290, y=120, image="rest3_fire:interstitial"})
	background:newChild({x=0, y=0, image="rest4_background:interstitial"})

	local path = {
		{186, 248},
		{286, 233},
		{321, 228},
		{356, 223},
		{386, 218},
		{416, 213},
		{456, 204},
		{506, 191},
		{546, 180},
		{586, 167},
		{616, 158},
		{656, 145},
		{696, 132},
		{756, 115},
	}

	local anims = {}
	local totalDur = 0

	local tX = path[1][1]
	local tY = path[1][2]
	for i = 2, #path do
		local x = path[i][1]
		local y = path[i][2]
		local dur = 20 * math.sqrt((x-tX)*(x-tX) + (y-tY)*(y-tY))
		anims[#anims+1] = {x=x, y=y, duration=dur}
		tX = x
		tY = y
		totalDur = totalDur + dur
	end

	gondolla1:doEvery(0, function()
		gondolla1:setX(path[1][1])
		gondolla1:setY(path[1][2])
		gondolla1:animate(unpack(anims))
		return totalDur
	end)

	local firstTime = true
	gondolla2:doEvery(0, function()
		gondolla2:setX(path[1][1])
		gondolla2:setY(path[1][2])
		if (firstTime) then
			firstTime = false
			gondolla2:animate({delay=totalDur/2}, unpack(anims))
			return totalDur + totalDur/2
		else
			gondolla2:animate(unpack(anims))
			return totalDur
		end
	end)

	gondolla1:doEvery(0, function()
		local dur = 900 + math.Random(200)
		gondolla1:animate({rotation=4, style="easeInOut", duration=dur}, {rotation=0, style="easeInOut", duration=dur})
		return 2*dur
	end)

	gondolla2:doEvery(0, function()
		local dur = 900 + math.Random(200)
		gondolla2:animate({rotation=4, style="easeInOut", duration=dur}, {rotation=0, style="easeInOut", duration=dur})
		return 2*dur
	end)
end

function InterstitialScene:initializeRestaurant5()
	local background = self:child("BACKGROUND")
	local geese = background:newChild({x=1024, y=105, image="rest5_geese:interstitial"})
	
	geese:animate({frameTime=100})
	geese:doEvery(0, function()
		local duration = math.Random(14000, 20000)
		geese.x = 1024
		geese.y = 100
		geese.scale = 1.3
		geese:animate({x=-ghf.screenWidth, y=180, scale=0.6, duration=9000})
		return duration
	end)

	background:newChild({x=541, y=430, image="rest5_sign:interstitial"})
	background:newChild({x=563, y=355, image="rest5_bird:interstitial"})
	background:newChild({x=542, y=370, image="rest5_baby_birds:interstitial"})
	background:newChild({x=512, y=377, image="rest5_nest:interstitial"})
end
