dialogs = dialogs or {}

--[[ TROPHY FIREWORKS EXAMPLE

		-- ALL VARIABLES (+ defaults):
		{ -- TROPHY 1
			duration = 8000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK1",
				rocketDuration = 2000,				-- Duration of the tail sparkle
				startMinX = 0,						-- Min/max for random start X
				startMaxX = 1024,
				--startX = 300,						-- Overrides min/max X
				startOffset = {x = 0,y = -600},		-- Tail start curve setting
				endOffset = {x = 0,y = 0},			-- Tail end curve setting
				target = {x = 1024/2,y = 768/2},	-- Rocket target position
				blastDelay = 2000,					-- Delay before blast (defaults to rocketDuration)
				flashDelay = 2000,					-- Delay before flash (defaults to rocketDuration)
				shape = "SHAPE_MASK",				-- The shape mask resource id
				shapeOffset = {x = w/2,y = h/2},	-- Position of the shape relative to the target (default center)
				initialSubDelay = 2000,				-- Initial before subs (defaults to rocketDuration)
				subDelay = 20,						-- Delay between subs
			},
		},

		-- MINIMAL VARIABLES:
		{ -- TROPHY 2
			duration = 8000,
			{ -- ROCKET 1
			},
		},
--]]

dialogs.firework = {
	class="DialogFirework", name="DIALOG_FIREWORK", background="BACKGROUND:fireworks", alpha=0, color="black",
	onShow=function(self)
		self.numStars = 0
		self:doEvery(0, function()
			if (self.numStars < 30) then
				self.numStars = self.numStars + 1
				local star = self:newChild({
					x=math.Random(1024), y=math.Random(768),
					image="small_star:fireworks", anchor="center", alpha=0})
				star:animate(
					{alpha=1, duration=1500 + math.Random(1000)},
					{alpha=0, duration=1500 + math.Random(1000)},
					{call=function()
						star:remove()
						self.numStars = self.numStars - 1
					end}
				)
			end
			return math.Random(100, 300)
		end)
	end,
	fireworks =
	{
		{ -- TROPHY 1
			duration = 3000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK1",
				rocketDuration = 800,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 100,
				startMaxX = 300,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=400},
				blastDelay = 1200,
				blastSound = "BLAST_SOUND1",
				shapeOffset = {x=9,y=9},
				subSound1 = "SUB_SOUND2",
				subSound2 = "SUB_SOUND2",
				initialSubDelay = 800,
			},
		},
		{ -- TROPHY 2
			duration = 3000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK2",
				rocketDuration = 800,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 0,
				startMaxX = 300,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=350},
				blastDelay = 800,
				shape = "SHAPE_MASK2",
				blastSound = "BLAST_SOUND1",
				shapeOffset = {x=511,y=280},
				initialSubDelay = 900,
				subDelay = 10,
			},
		},
		{ -- TROPHY 3
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK3",
				rocketDuration = 800,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 0,
				startMaxX = 300,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=400},
				blastDelay = 800,
				shape = "SHAPE_MASK3",
				blastSound = "BLAST_SOUND1",
				shapeOffset = {x=511,y=377},
				initialSubDelay = 900,
				subDelay = 10,
			},
        },
		{ -- TROPHY 4
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK4",
				rocketDuration = 800,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 0,
				startMaxX = 512,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=300},
				blastDelay = 800,
				blastSound = "BLAST_SOUND1",
				initialSubDelay = 1500,
			},
        },
		{ -- TROPHY 5
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK5",
				rocketDuration = 650,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 512,
				startMaxX = 512,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=600},
				blastDelay = 650,
				blastSound = "BLAST_SOUND1",
				shapeOffset = {x=310,y=500},
				initialSubDelay = 1500,
				shape = "SHAPE_MASK5",
				subDelay = 20,
				subSound1 = "SUB_SOUND1",
			},
		},
		{ -- TROPHY 6
			duration = 3000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK6",
				rocketDuration = 1000,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 100,
				startMaxX = 100,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=555,y=320},
				blastDelay = 1100,
				blastSound = "BLAST_SOUND1",
				shapeOffset = {x=350,y=50},
				initialSubDelay = 300,
				shape = "SHAPE_MASK6",
				subDelay = 11,
			},
		},
		{ -- TROPHY 7
			duration = 5000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK7",
				rocketDuration = 1000,
				startMinX = 600,
				startMaxX = 700,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=510},
				blastDelay = 1000,
				shapeOffset = {x=518,y=370},
				initialSubDelay = 1500,
				shape = "SHAPE_MASK7",
				subDelay = 40,
				blastSound = "SUB_SOUND2",
				subSound1 = "BLAST_SOUND1",
				subSound2 = "SUB_SOUND1",
				subSound3 = "SUB_SOUND1",
				rocketSound = "ROCKET_SOUND1",
			},
        },
		{ -- TROPHY 8
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK8",
				rocketDuration = 1000,
				startMinX = 600,
				startMaxX = 700,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=350},
				blastDelay = 1000,
				shapeOffset = {x=402,y=270},
				initialSubDelay = 1000,
				shape = "SHAPE_MASK8",
				subDelay = 20,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
		},
		{ -- TROPHY 9
			duration = 5000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK9",
				rocketDuration = 1000,
				startMinX = 600,
				startMaxX = 700,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=400},
				blastDelay = 1000,
				shapeOffset = {x=402,y=311},
				initialSubDelay = 1400,
				shape = "SHAPE_MASK9",
				subDelay = 40,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 10
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK10",
				rocketDuration = 1200,
				startMinX = 512,
				startMaxX = 512,
				startOffset = {x=0,y=-0},
				endOffset = {x=0,y=0},
				target = {x=512,y=370},
				blastDelay = 1200,
				shapeOffset = {x=512,y=390},
				initialSubDelay = 1200,
				shape = "SHAPE_MASK10",
				subDelay = 35,
				subSound2 = "SUB_SOUND1",
				subSound3 = "SUB_SOUND1",
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 11
			duration = 3000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK11",
				rocketDuration = 1200,
				startMinX = 512,
				startMaxX = 512,
				startOffset = {x=0,y=-0},
				endOffset = {x=0,y=0},
				target = {x=512,y=270},
				blastDelay = 1200,
				shapeOffset = {x=500,y=300},
				initialSubDelay = 1200,
				shape = "SHAPE_MASK11",
				subDelay = 20,
				rocketSound = "ROCKET_SOUND1",
				subSound1 = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 12
			duration = 3500,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK12",
				rocketDuration = 1200,
				startMinX = 512,
				startMaxX = 512,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=270},
				blastDelay = 1100,
				shapeOffset = {x=402,y=130},
				initialSubDelay = 200,
				shape = "SHAPE_MASK12",
				subDelay = 20,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 13
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK13",
				rocketDuration = 1000,
				startMinX = 100,
				startMaxX = 100,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=360},
				blastDelay = 1100,
				shapeOffset = {x=402,y=311},
				initialSubDelay = 1500,
				shape = "SHAPE_MASK13",
				subDelay = 40,
				rocketSound = "ROCKET_SOUND1",
				subSound4 = "SUB_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 14
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK14",
				rocketDuration = 1000,
				startMinX = 512,
				startMaxX = 400,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=290},
				blastDelay = 1100,
				shapeOffset = {x=288,y=50},
				initialSubDelay = 300,
				shape = "SHAPE_MASK14",
				subDelay = 18,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 15
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK15",
				rocketDuration = 1500,
				startMinX = 512,
				startMaxX = 400,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=290},
				blastDelay = 1500,
				shapeOffset = {x=288,y=50},
				initialSubDelay = 300,
				shape = "SHAPE_MASK15",
				subDelay = 18,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
			},
        },
		{ -- TROPHY 16
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK16",
				rocketDuration = 1000,
				startMinX = 512,
				startMaxX = 400,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=390},
				blastDelay = 1000,
				shapeOffset = {x=512,y=403},
				initialSubDelay = 1100,
				shape = "SHAPE_MASK16",
				subDelay = 14,
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
				subSound2 = "SUB_SOUND1",
			},
        },
		{ -- TROPHY 17
			duration = 4000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK17",
				rocketDuration = 1000,
				startMinX = 512,
				startMaxX = 400,
				startOffset = {x=0,y=-300},
				endOffset = {x=0,y=0},
				target = {x=512,y=550},
				blastDelay = 1100,
				shapeOffset = {x=235,y=350},
				initialSubDelay = 1200,
				shape = "SHAPE_MASK17",
				rocketSound = "ROCKET_SOUND1",
				blastSound = "BLAST_SOUND1",
				subSound4 = "SUB_SOUND1",
				subDelay = 40,
			},
        },
		{ -- TROPHY 18
			duration = 7000,
			{ -- ROCKET 1
				library = "PARTICLE_FIREWORK18",
				rocketDuration = 1600,
				rocketSound = "ROCKET_SOUND1",
				startMinX = 512,
				startMaxX = 512,
				startOffset = {x=0,y=-100},
				endOffset = {x=0,y=0},
				target = {x=512,y=380},
				blastDelay = 1600,
				shapeOffset = {x=512,y=384},
				initialSubDelay = 1600,
				blastSound = "BLAST_SOUND1",
				subSound4 = "BLAST_SOUND2",
				subSound3 = "SUB_SOUND1",
				shape = "SHAPE_MASK18",
				subDelay = 50,
			},
        },
	},
}


