--' ************************************ Character ************************************ '--
Character = getClass("Character")

function Character:isWorkActive()
	return self.workActive ~= false --' Actually false, allow nil
end

--' ************************************ Delicious Character ************************************ '--
DelCharacter = getClass("DelCharacter")

function DelCharacter:canPlayIdleAnimations()
	if (self.playIdleAnimations and
		isTable(self.idleAnimations) and
		not taskSystem:hasAnimationFor(self))
	then
		if (not self.validIdleAnimations or self.baseAnimation ~= self.previousIdleBaseAnimation) then
			self.previousIdleAnimationIndex = -1
			self.previousIdleBaseAnimation = self.baseAnimation
			self.validIdleAnimations = {}
			for k,v in ipairs(self.idleAnimations) do
				if (isTable(v) and isString(v.a) and self:canPlayAnimation(v.a)) then
					table.push_back(self.validIdleAnimations, v)
				end
			end
		end
		return not table.empty(self.validIdleAnimations)
	end
	return false
end

function DelCharacter:playIdleAnimation()
	if (self:canPlayIdleAnimations()) then
		self.previousIdleAnimationIndex = self.previousIdleAnimationIndex or -1
		local paramIdx = self.previousIdleAnimationIndex
		local numAnims = #self.validIdleAnimations
		if (numAnims <= 2) then
			paramIdx = math.Random(numAnims)
		elseif (numAnims > 0) then
			while (paramIdx == self.previousIdleAnimationIndex) do
				paramIdx = math.Random(numAnims)
			end
		end
		self.previousIdleAnimationIndex = paramIdx
		local params = self.validIdleAnimations[paramIdx]
		if (isTable(params)) then
			local animationName = params.a
			local frameTime = params.f
			local cycles = params.c or 1
			local sound = params.s or ""
			self:playSample(sound)
			self:addTask({class="PlayAnimationTask", animation=animationName, cycles=cycles, frameTime=frameTime, whenFinished="default", wait=true, affectsGameplay=false})
		end
	end
end

--' ************************************ Stationary Character ************************************ '--
StationaryCharacter = getClass("StationaryCharacter")

function StationaryCharacter:backToWaitPosition()
	local wp = self.waitPosition
	if (self.x ~= wp.x or self.y ~= wp.y) then
		self:addTask({class="WalkToTask", target=self.waitPosition, playDefaultOnFinish=true})
	end
end

function StationaryCharacter:isWorkActive()
	return self.stationaryActive and StationaryCharacter.super.isWorkActive(self)
end

--' ************************************ Entertainer ************************************ '--
Entertainer = deriveLuaClass("Entertainer", "StationaryCharacter")

function Entertainer:init(desc)
	self.introductionTextId = "UNLOCKED_ENTERTAINER"
	Entertainer.superInit(self, desc)
	self.clickable = true
end

function Entertainer:allowWork(actor)
	return false
end

function Entertainer:onClick()
	Entertainer.super.onClick(self)
	self.selected = not self.selected
	return true
end

function Entertainer:onActorWorkStart(task)
end

function Entertainer:onActorWorkFinish(task)
end

--' ************************************ Customer ************************************ '--
Customer = getClass("Customer")

function Customer:enterRoom(idx, groupSize, queuePos)
	self:addTask({class="Task", duration=idx*500})
	self:addTask({class="QueueTask"})
	if (self.group.main == self) then
		self:addTask({class="Task", duration=500*groupSize + 1000})
		self:addTask({class="CallTask", func=function() 
			self.group:leave()
		end })
	end
end

function Customer:leaveRoom(idx, exitIdx)
	taskSystem:cancelAllTasksFor(self)
	self:addTask({class="PlayAnimationTask", animation="IDLE"})
	self:addTask({class="Task", duration=idx*500 + 300})
	self:addTask({class="ExitTask", exit=exitIdx or math.Random(#level.currentRoom.exits)-1})
end
