-- start of an animation

--[[
-- Possible parameters:
ghf.anim.run()
ghf.anim.run(client)
ghf.anim.run(client, scene)
ghf.anim.run(nil, scene)
ghf.anim.run(client, "name", scene)
ghf.anim.run("name", scene) --> ghf.anim.run("", scene)
ghf.anim.run("name")
--]]

ghf = ghf or {}
ghf.anim = ghf.anim or {}

ghf.Modifier = getClass("Modifier")
ghf.ModifierRoot = getClass("ModifierRoot")
ghf.ModifierGroup = getClass("ModifierGroup")
ghf.ModifierFraction = getClass("ModifierFraction")
ghf.ModifierAlpha = getClass("ModifierAlpha")
ghf.ModifierDelay = getClass("ModifierDelay")

ghf.Modifier.kInitialized = ghf.bit1
ghf.Modifier.kIsDone = ghf.bit2

function ghf.anim.run(...)
	local argc = 1

	local lClient = nil
	local lName = ""
	local lScene = scene

    if type(arg[argc]) == "table" then
		lClient = arg[argc]
		argc = argc + 1
    end

    if isString(arg[argc]) then
		lName = arg[argc]
		argc = argc + 1
    end

    if isTable(arg[argc]) then
		lScene = arg[argc]
    end

    local group = ghf.anim.animation(lScene, lName)
    if (lClient) then
		group.client = lClient
    end

	return group
end

-- setup for the shortcut functions
function ghf.anim.setup(t, modClass)
    local t = table.copy(t)
    t.class = modClass
    return t
end

-- alpha shortcut
function ghf.anim.alpha(t)
    return ghf.anim.setup(t, "ModifierAlpha")
end
