--local BAD_CONNECT = 219000 -- 
--SEED = 372000 -- Force roads test level 3
if SEED == nil then
	SEED = getrealtime()
end

print ("SEED = ", SEED)
math.randomseed(SEED)

--print ("worldgen_main.lua MAIN = 1")

MAIN = 1

--install our crazy loader! MUST BE HERE FOR NACL
local loadfn = function(modulename)
    local errmsg = ""
    local modulepath = string.gsub(modulename, "%.", "/")
    for path in string.gmatch(package.path, "([^;]+)") do
        local filename = string.gsub(path, "%?", modulepath)
        filename = string.gsub(filename, "\\", "/")
        local result = kleiloadlua(filename)
        if result then
            return result
        end
        errmsg = errmsg.."\n\tno file '"..filename.."' (checked with custom loader)"
    end
  return errmsg    
end
table.insert(package.loaders, 1, loadfn)

local basedir = "./"
--patch this function because NACL has no fopen
if TheSim then
    basedir = "data/scripts/"
    function loadfile(filename)
        return kleiloadlua(filename)
    end
end


require("mods")
require("simutil")
require("strict")
require("json")
require("vector3")
require("tuning")
require("languages/language")
require("strings")
require("constants")
require("class")
require("debugtools")
require("util")
require("prefabs")
require("profiler")
require("dumper")
require("map/tasks")

print ("running worldgen_main.lua\n")


local basedir = "./"

local last_tick_seen = -1


local PendingUpdateFns = {}
function CallOnNextUpdate(fn)
    PendingUpdateFns[fn] = true
end



------TIME FUNCTIONS

function GetTickTime()
    return 0
end

local ticktime = GetTickTime()
function GetTime()
    return 0
end

function GetTick()
    return 0
end

function GetTimeReal()
    return getrealtime()
end

---SCRIPTING
local Scripts = {}

function LoadScript(filename)
    if not Scripts[filename] then
        local scriptfn = loadfile("data/scripts/" .. filename)
        Scripts[filename] = scriptfn()
    end
    return Scripts[filename]
end


function RunScript(filename)
    local fn = LoadScript(filename)
    if fn then
        fn()
    end
end

function GetDebugString()
    return tostring(scheduler)
end
------------------------------

--- non-user-facing Tracking stats  ---
TrackingEventsStats = {}
TrackingTimingStats = {}
function IncTrackingStat(stat, subtable)

    local t = TrackingEventsStats
    if subtable then
        t = TrackingEventsStats[subtable]

        if not t then
            t = {}
            TrackingEventsStats[subtable] = t
        end
    end

    t[stat] = 1 + (t[stat] or 0)
end

function SetTimingStat(subtable, stat, value)

    local t = TrackingTimingStats
    if subtable then
        t = TrackingTimingStats[subtable]

        if not t then
            t = {}
            TrackingTimingStats[subtable] = t
        end
    end

    t[stat] = math.floor(value/1000)
end

--- GAME Stats and details to be sent to server on game complete ---
ProfileStats = {}

function GetProfileStats()
	if GetTableSize(ProfileStats) then
    	return json.encode({
    						stats = ProfileStats
    						})
    else
    	return json.encode({})
    end
end

function ProfileStatsSet(item, value)
    ProfileStats[item] = value
end

function ProfileStatsAdd(item)
    --print ("ProfileStatsAdd", item)
    if ProfileStats[item] then
    	ProfileStats[item] = ProfileStats[item] +1
    else
    	ProfileStats[item] = 1
    end
end

function ProfileStatsAddItemChunk(item, chunk)
    if ProfileStats[item] == nil then
    	ProfileStats[item] = {}
    end

    if ProfileStats[item][chunk] then
    	ProfileStats[item][chunk] =ProfileStats[item][chunk] +1
    else
    	ProfileStats[item][chunk] = 1
    end
end




function PROFILE_world_gen(debug)
	require("profiler")
	local profiler = newProfiler("time", 100000)
	profiler:start()    
        
	local strdata = LoadParametersAndGenerate(debug)
	
	profiler:stop()
	local outfile = io.open( "profile.txt", "w+" )
	profiler:report(outfile)
	outfile:close()
	local tmp = {}
	
	profiler:lua_report(tmp)
	require("debugtools")
	dumptable(profiler)
	
	return strdata
end

function ShowDebug(savedata)
	local item_table = { }
	
	for id, locs in pairs(savedata.ents) do		
		for i, pos in ipairs(locs) do
			local misc = -1
			if string.find(id, "wormhole") ~= nil then
				if pos.data and pos.data.teleporter and pos.data.teleporter.target then
					misc = pos.data.teleporter.target - 2300000
				end
			end
			table.insert(item_table, {id, pos.x/TILE_SCALE + savedata.map.width/2.0, pos.z/TILE_SCALE + savedata.map.height/2.0, misc})
		end
	end

	WorldSim:ShowDebugItems(item_table)			
end

function CheckMapSaveData(savedata)
	print("Checking map...")
        
    assert(savedata.map, "Map missing from savedata on generate")
    assert(savedata.map.prefab, "Map prefab missing from savedata on generate")
    assert(savedata.map.tiles, "Map tiles missing from savedata on generate")
    assert(savedata.map.width, "Map width missing from savedata on generate")
    assert(savedata.map.height, "Map height missing from savedata on generate")
	assert(savedata.map.topology, "Map topology missing from savedata on generate")
        
	assert(savedata.playerinfo, "Playerinfo missing from savedata on generate")
	assert(savedata.playerinfo.x, "Playerinfo.x missing from savedata on generate")
	assert(savedata.playerinfo.y, "Playerinfo.y missing from savedata on generate")
	assert(savedata.playerinfo.z, "Playerinfo.z missing from savedata on generate")
	assert(savedata.playerinfo.day, "Playerinfo day missing from savedata on generate")

	assert(savedata.ents, "Entites missing from savedata on generate")
end

local function OverrideTweeks(level, world_gen_choices)
	local customise = require("map/customise")
	for i,v in ipairs(level.overrides) do
		local name = v[1]
		local value = v[2]
		
		if type(name) == type({}) then
			name = name[math.random(#name)]
		end
		if type(value) == type({}) then
			value = value[math.random(#value)]
		end

		local area = customise.GetGroupForItem(name)
		-- Modify world now
		if world_gen_choices["tweak"] == nil then
			world_gen_choices["tweak"] = {}
		end
		if world_gen_choices["tweak"][area] == nil then
			world_gen_choices["tweak"][area] = {}
		end
		world_gen_choices["tweak"][area][name] = value
	end
end

local function GetRandomFromLayouts( layouts )
	local area_keys = {}
	for k,v in pairs(layouts) do
		table.insert(area_keys, k)
	end
	local area_idx =  math.random(#area_keys)
	local area = area_keys[area_idx]
	local target = nil
	if (area == "Rare" and math.random()<0.98) or GetTableSize(layouts[area]) <1 then
		table.remove(area_keys, area_idx)
		area = area_keys[math.random(#area_keys)]
	end

	if GetTableSize(layouts[area]) <1 then
		return nil
	end

	target = {target_area=area, choice=GetRandomKey(layouts[area])} 	

	return target
end

local function GetAreasForChoice(area, level)
	local areas = {}

	for i, task_name in ipairs(level.tasks) do
		local task = tasks.GetTaskByName(task_name, tasks.sampletasks)
		if area == "Any" or area == "Rare" or  area == INV_GROUND_VALUES[task.room_bg] then
			table.insert(areas, task_name)
		end
	end
	if #areas ==0 then
		return nil
	end
	return areas
end

local function AddSingleSetPeice(level, choicefile)
	local choices = require(choicefile)
	assert(choices.Sandbox)
	local chosen = GetRandomFromLayouts(choices.Sandbox)
	if chosen ~= nil then
		if level.set_pieces == nil then
			level.set_pieces = {}
		end

		local areas = GetAreasForChoice(chosen.target_area, level)
		if areas then
			local num_peices = 1
			if level.set_pieces[chosen.choice] ~= nil then
				num_peices = level.set_pieces[chosen.choice].count + 1
			end
			level.set_pieces[chosen.choice] = {count = num_peices, tasks=areas}
		end
	end
end

local function AddSetPeices(level, world_gen_choices)
	AddSingleSetPeice(level, "map/traps")
	AddSingleSetPeice(level, "map/pointsofinterest")
	AddSingleSetPeice(level, "map/protected_resources")

	local boons_override = "default"
	local touchstone_override = "default"
	if world_gen_choices["tweak"] ~=nil and 
		world_gen_choices["tweak"]["misc"] ~= nil then

		if world_gen_choices["tweak"]["misc"]["boons"] ~= nil then
			boons_override = world_gen_choices["tweak"]["misc"]["boons"]
		end
		if world_gen_choices["tweak"]["misc"]["touchstone"] ~= nil then
			touchstone_override = world_gen_choices["tweak"]["misc"]["touchstone"]
		end
	end
	
	local multiply = {
		["rare"] = 0.5,
		["default"] = 1,
		["often"] = 1.5,
		["mostly"] = 2.2,
		["always"] = 3,		
	}

	if touchstone_override ~= "default" and level.set_pieces ~= nil and 
								level.set_pieces["ResurrectionStone"] ~= nil then

		if touchstone_override == "never" then
			level.set_pieces["ResurrectionStone"] = nil
		else
			level.set_pieces["ResurrectionStone"].count = math.ceil(level.set_pieces["ResurrectionStone"].count*multiply[touchstone_override])
		end
	end

	if boons_override ~= "never" then

		-- Quick hack to get the boons in
		for idx=1, math.random(math.floor(3*multiply[boons_override]), math.ceil(8*multiply[boons_override])) do
			AddSingleSetPeice(level, "map/boons")
		end
	end

end

local function FixWesUnlock(level, progress, profile)
	local should_wes = profile and profile.unlocked_characters["wes"] ~= true and progress == 3
	if not should_wes then
		print("No wes allowed on this level!")
		level.set_pieces["WesUnlock"] = nil
	else
		print("Wes setpiece allowed in this level.")
	end
end

function GenerateNew(debug, parameters)
    
    --print("Generate New map",debug, parameters.gen_type, parameters.level_type, parameters.current_level, parameters.world_gen_choices)
	local Gen = require "map/forest_map"
	require("map/map")
	
	require("map/levels")

	local choose_tasks = nil
	local level_area_triggers = nil
	local id = nil
	local override_level_string = false
	local name = nil
	local hideminimap = false
	local teleportaction = false
	local teleportmaxwell = nil
	local nomaxwell = false
	if parameters.level_type and string.upper(parameters.level_type) == "ADVENTURE" then
		local level = levels.story_levels[parameters.current_level]

		-- makes the levels loop when we are pushing testing branches
		--if parameters.adventure_progress == levels.CAMPAIGN_LENGTH then
		--	level.teleportaction = "restart"
		--end

		name = level.name
		hideminimap = level.hideminimap
		teleportaction = level.teleportaction
		teleportmaxwell = level.teleportmaxwell
		nomaxwell = level.nomaxwell
		OverrideTweeks(level, parameters.world_gen_choices)
		AddSetPeices(level, parameters.world_gen_choices)
		FixWesUnlock(level, parameters.adventure_progress, parameters.profiledata)
		print("\n#######\n#\n# Generating "..level.name.."("..parameters.current_level..")".."\n#\n#######\n")
		choose_tasks = level:GetTasksForLevel(tasks.sampletasks)
		level_area_triggers = level.override_triggers
		id = level.id
		override_level_string = level.override_level_string
	elseif parameters.level_type and string.upper(parameters.level_type) == "TEST" then
		print("\n#######\n#\n# Generating TEST Mode Level\n#\n#######\n")
		OverrideTweeks(levels.test_level, parameters.world_gen_choices)
		AddSetPeices(levels.test_level, parameters.world_gen_choices)
		choose_tasks = levels.test_level:GetTasksForLevel(tasks.sampletasks)
		level_area_triggers = levels.test_level.override_triggers
		id = level.id
		override_level_string = level.override_level_string
	else
		if parameters.world_gen_choices.level_id == nil or parameters.world_gen_choices.level_id > #levels.sandbox_levels then
			parameters.world_gen_choices.level_id = 1
		end
		
		local level = levels.sandbox_levels[parameters.world_gen_choices.level_id]
		print("\n#######\n#\n# Generating Normal Mode "..level.name.." Level\n#\n#######\n")
		OverrideTweeks(level, parameters.world_gen_choices)
		level_area_triggers = level.override_triggers
		AddSetPeices(level, parameters.world_gen_choices)
		hideminimap = level.hideminimap
		choose_tasks = level:GetTasksForLevel(tasks.sampletasks)
		id = level.id
		override_level_string = level.override_level_string
	end
	
	
	if debug == true then
	 	 choose_tasks = tasks.oneofeverything
	end
    --print ("Generating new world","forest", max_map_width, max_map_height, choose_tasks)
        
	local savedata = nil

	local max_map_width = 1024 -- 1024--256 
	local max_map_height = 1024 -- 1024--256 
	
	local try = 1
	local maxtries = 25
	
	while savedata == nil do
		savedata = Gen.Generate("forest", max_map_width, max_map_height, choose_tasks, parameters.world_gen_choices, parameters.level_type)	
		
		if savedata == nil then
			print("An error occured during world gen we will retry! [",try," of ",maxtries,"]")
			try = try + 1
			
			assert(try <= maxtries, "Maximum world gen retries reached!")
			collectgarbage("collect")
			WorldSim:ResetAll()
		elseif GEN_PARAMETERS == "" or parameters.show_debug == true then			
			ShowDebug(savedata)
		end
	end
	
	savedata.map.topology.level_type = parameters.level_type
	savedata.map.topology.level_number = parameters.current_level
	savedata.map.level_id = id or "survival"
	savedata.map.override_level_string = override_level_string
	savedata.map.name = name
	savedata.map.nomaxwell = nomaxwell
	savedata.map.hideminimap = hideminimap
	savedata.map.teleportaction = teleportaction
	savedata.map.teleportmaxwell = teleportmaxwell
	
	savedata.map.topology.override_triggers = level_area_triggers
	CheckMapSaveData(savedata)
		
	-- Clear out scaffolding :)
	for i=#savedata.map.topology.ids,1, -1 do
		local name = savedata.map.topology.ids[i]
		if string.find(name, "LOOP_BLANK_SUB") ~= nil  then
			table.remove(savedata.map.topology.ids, i)
			table.remove(savedata.map.topology.nodes, i)
			for eid=#savedata.map.topology.edges,1,-1 do
				if savedata.map.topology.edges[eid].n1 == i or savedata.map.topology.edges[eid].n2 == i then
					table.remove(savedata.map.topology.edges, eid)
				end
			end
		end
	end		
	
	print("Generation complete")

	local strdata = DataDumper(savedata, nil, PLATFORM == "NACL")
	return strdata
end

local function LoadParametersAndGenerate(debug)

	local parameters = nil
	if GEN_PARAMETERS == "" then
		print("WARNING: No parameters found, using defaults. This should only happen from the test harness!")
		parameters = { level_type="adventure", current_level=5, adventure_progress=3, profiledata={unlocked_characters={wes=true}} }
	else
		parameters = json.decode(GEN_PARAMETERS)
	end
    
    if 	parameters.world_gen_choices == nil then
		parameters.world_gen_choices = {}
    end
	return GenerateNew(debug, parameters)-- parameters.worldgen_type, parameters.level_type, parameters.current_level, parameters.world_gen_choices)
end

return LoadParametersAndGenerate(false)
