--[[

***************************************************************    
*** NOTICE TO TRANSLATORS: DO NOT EDIT THIS FILE DIRECTLY! ***

We have provided a standard PO file to translation in /scripts/languages/strings.po
To add a new language:
- User a PO editor such as POEdit (http://www.poedit.net/) to translate strings.po
- Load your own PO file under /scripts/languages/language.lua

***************************************************************
]]

STRINGS=
{
	CHARACTER_NAMES =
	{
		wilson = "Wilson P. Higgsbury",
		willow = "Willow",
		wendy = "Wendy",
		wolfgang = "Wolfgang",
		woodie = "Woodie",
		wickerbottom = "Ms Wickerbottom",
		wx78 = "WX-78",
		wes = "Wes",
		waxwell = "Maxwell",
		unknown = "The Unknown",
	},

	CHARACTER_QUOTES =
	{
		wilson = "\"I will conquer it all with the power of my MIND!\"",
		willow = "\"Things are so much prettier when they burn.\"",
		wendy ="\"Abigail? Come back! I'm not done playing with you.\"",
		wolfgang = "\"I am mighty! No one is mightier!\"",
		wx78 = "\"EMPATHY MODULE NOT RESPONDING\"",
		wickerbottom = "\"Shhhh! No talking!\"",
		waxwell = "\"Freedom!\"",
		wes = "...",
	},

	CHARACTER_TITLES =
	{
		wilson = "The Gentleman Scientist",
		willow = "The Firestarter",
		wendy = "The Bereaved",
		wolfgang = "The Strongman",
		wx78 = "The Soulless Automaton",
		wickerbottom = "The Librarian",
		wes = "The Silent",
		waxwell = "The Puppet Master",
	},

	CHARACTER_DESCRIPTIONS =
	{
		wilson = "*Grows a magnificent beard",
		willow = "*Immune to fire damage\n*Starts fires in the dark",
		wendy = "*Has visitors at night",
		wolfgang = "*Higher health, bigger stomach\n*Hits harder",
		wx78 = "*Can eat spoiling food with no penalty",
		wickerbottom = "*Gets a bonus tech level",
		wes = "*Can't talk\n*Has trouble staying alive",
		waxwell = "*Is dapper\n*Is frail\n*Brings his own sword",
	},


    --ACTION MOUSEOVER TEXT
    ACTIONS=
    {
		SEW = "Sew",
        GIVE = "Give",
        DROP = 
        {
            GENERIC = "Drop",
            SETTRAP = "Set Trap",
            SETMINE = "Set Mine",
        },
        BUILD = "Build",
        PICK = "Pick",
        REPAIR = "Repair",
        PICKUP = "Pick up",
        CHOP = "Chop",
        FERTILIZE = "Fertilize",
        EAT = "Eat",
        BAIT = "Bait",
        COOK = "Cook",
        ADDFUEL = "Add Fuel",
        LIGHT = "Light",
        EXTINGUISH = "Extinguish",
        LOOKAT = "Examine",
        TALKTO = "Talk to",
        MINE = "Mine",
        ATTACK = "Attack",
        WALKTO = "Walk To",
        CHECKTRAP = "Check",
        BUILD = "Build",
        CRAFT = "Craft",
        PLANT = "Plant",
        HARVEST = "Harvest",
        GOHOME = "Go Home",
        DIG = "Dig",
        SLEEPIN = "Sleep",
        EQUIP = "Equip",
        TERRAFORM = "Dig",
        UNEQUIP = "Unequip",
        RESEARCH = "Research",
        SHAVE = "Shave",
        DRY = "Dry",
        STORE = 
        {
            GENERIC = "Store",
            COOK = "Cook",
            IMPRISON = "Imprison",
        },
        RUMMAGE =
        {
            GENERIC = "Open",
            CLOSE = "Close",
        },
        DEPLOY = 
        {
			GENERIC = "Plant",
			GROUNDTILE = "Place Ground",
			WALL = "Build Wall"
		},
		
        PLAY = "Play",
        NET = "Catch",
        CATCH = "Catch",
        FISH = "Fish",
        REEL =
        {
            GENERIC = "Hook",
            REEL = "Reel In",
            CANCEL = "Stop Fishing",
        },
        POLLINATE = "Pollinate",
        HAMMER = "Hammer",
        RESETMINE = "Reset",
        ACTIVATE = {
            GENERIC = "Activate",
            INVESTIGATE = "Investigate",
        },
		JUMPIN = "Jump In",
        MURDER = "Murder",
        HEAL = "Heal",
        UNLOCK = 
        {
            GENERIC = "Unlock",
            LOCK = "Lock",
        },
        TEACH = "Learn",
        TURNON = "Turn On",
        TURNOFF = "Turn Off",
    },

	LMB = "\255",--"",
	RMB = "\254",--"",

	SELECT = "Select",
    DROPALL = "Drop All",

    NAMES =
    {
		DEFAULT = "INVENTORY ITEM",
		
		SEWING_KIT = "Sewing Kit",
        RED_MUSHROOM = "Red Mushroom",
        RED_CAP = "Red Cap",
        RED_CAP_COOKED = "Cooked Red Cap",
        GREEN_MUSHROOM = "Green Mushroom",
        GREEN_CAP = "Green Cap",
        GREEN_CAP_COOKED = "Cooked Green Cap",
        BLUE_MUSHROOM = "Blue Mushroom",
        BLUE_CAP_COOKED = "Cooked Blue Cap",
        BLUE_CAP = "Blue Cap",

		CARROT = "Carrot",
		PUMPKIN = "Pumpkin",
		DRAGONFRUIT = "Dragon Fruit",
		POMEGRANATE = "Pomegranate",
		CORN = "Corn",
		DURIAN = "Durian",
		EGGPLANT = "Eggplant",
		ICEBOX = "Ice Box",
		CARROT_SEEDS = "Carrot Seeds",
		PUMPKIN_SEEDS = "Pumpkin Seeds",
		DRAGONFRUIT_SEEDS = "Dragon Fruit Seeds",
		POMEGRANATE_SEEDS = "Pomegranate Seeds",
		CORN_SEEDS = "Corn Seeds",
		DURIAN_SEEDS = "Durian Seeds",
		EGGPLANT_SEEDS = "Eggplant Seeds",
		
		NITRE = "Nitre",
		GUNPOWDER = "Gunpowder",
		BIRD_EGG = "Egg",
		BIRD_EGG_COOKED = "Cooked Egg",
		ROTTENEGG = "Rotten Egg",
		
		WINTEROMETER = "Winterometer",
        RAINOMETER = "Rainometer",
		SPOILED_FOOD = "Rot",
		BERRIES = "Berries",
		BACKPACK = "Backpack",
		PIGGYBACK = "Piggyback",
		REDGEM ="Red Gem",
        PURPLEGEM = "Purple Gem",
		HOUNDSTOOTH = "Hound's Tooth",
		SWEATERVEST = "Dapper Vest",
		CARROT_COOKED = "Roasted Carrot",
		PUMPKIN_COOKED = "Hot Pumpkin",
		DRAGONFRUIT_COOKED = "Prepared Dragon Fruit",
		POMEGRANATE_COOKED = "Sliced Pomegranate",
		CORN_COOKED = "Popcorn",
		DURIAN_COOKED = "Extra Smelly Durian",
		EGGPLANT_COOKED = "Braised Eggplant",
		BERRIES_COOKED = "Roasted Berries",
		
        UMBRELLA = "Umbrella",
		KRAMPUS_SACK = "Krampus Sack",

		TURF_WOODFLOOR = "Wooden Flooring",
		TURF_CARPETFLOOR = "Carpeted Flooring",
		TURF_CHECKERFLOOR = "Checkerboard Flooring",
		TURF_SAVANNA = "Savanna Turf",
		TURF_GRASS = "Grass Turf",
		TURF_FOREST = "Forest Turf",
		TURF_MARSH = "Marsh Turf",
		TURF_DIRT = "Dirt Turf",
		TURF_ROCKY = "Rocky Turf",
		TURF_ROAD = "Cobblestones",
		TURF_WEBBING = "Sticky Webbing",
		
		COOKPOT = "Crock Pot",
		DUG_GRASS = "Grass Tuft",
		DUG_SAPLING = "Sapling",
		DUG_BERRYBUSH = "Berry Bush",
        DUG_BERRYBUSH2 = "Berry Bush",
        DUG_MARSH_BUSH = "Spiky Bush",
		
		FOOTBALLHAT="Football Helmet",
		PIGSKIN = "Pig Skin",
		AXE = "Axe",
		HAMMER = "Hammer",
		GOLDENAXE = "Luxury Axe",
		MEAT = "Meat",
		COOKEDMEAT = "Cooked Meat",
		MEAT_DRIED = "Jerky",
        SMALLMEAT = "Morsel",
        COOKEDSMALLMEAT = "Cooked Morsel",
        SMALLMEAT_DRIED = "Small Jerky",
		MONSTERMEAT = "Monster Meat",
		COOKEDMONSTERMEAT = "Cooked Monster Meat",
		MONSTERMEAT_DRIED = "Monster Jerky",
		TRAP = "Trap",
		LOG = "Log",
		HAMBAT = "Ham Bat",
        LIVINGLOG = "Living Log",
		TWIGS = "Twigs",
		CUTGRASS = "Cut Grass",
		PETALS = "Petals",
        PETALS_EVIL = "Dark Petals",
        ADVENTURE_PORTAL = "Maxwell's Door",
        POOP = "Manure",
		TORCH = "Torch",
        SEEDS = "Seeds",
        HOUND = "Hound",
        FIREHOUND = "Red Hound",
		SEEDS_COOKED = "Toasted Seeds",
		SILK = "Silk",
		SPIDERGLAND = "Spider Gland",
		TRAP_TEETH = "Tooth Trap",
		TRAP_TEETH_MAXWELL = "Maxwell's Tooth Trap",
		KRAMPUS = "Krampus",
		ROCKS = "Rocks",
        FLINT = "Flint",
		AMULET = "Amulet",
		PICKAXE = "Pickaxe",
		GOLDENPICKAXE = "Opulent Pickaxe",
		SHOVEL = "Shovel",
		GOLDENSHOVEL = "Regal Shovel",
		PITCHFORK = "Pitchfork",
		GOLDENPITCHFORK = "Snazzy Pitchfork",
		BEEFALO = "Beefalo",
		BABYBEEFALO = "Baby Beefalo",
		BERRYBUSH = "Berry Bush",
        BERRYBUSH2 = "Berry Bush",
		SUNKBOAT = "Boat",
		BONFIRE = "Bonfire",
		CAMPFIRE = "Campfire",
		CROW = "Crow",
		ROBIN = "Redbird",
		ROBIN_WINTER = "Snowbird",
		EVERGREEN = "Evergreen",
		EVERGREEN_SPARSE = "Lumpy Evergreen",
		SLOW_FARMPLOT = "Basic Farm",
		FAST_FARMPLOT = "Improved Farm",
		FIRE = "Fire",
		FIREPIT = "Fire Pit",
		HEATROCK = "Heat Stone",
		FLOWER = "Flower",
        FLOWER_EVIL = "Evil Flower",
        FIREFLIES = "Fireflies",
		GHOST = "Ghost",
        GRASS = "Grass",
        DEPLETED_GRASS = "Grass",
		GRAVESTONE = "Headstone",
		HOMESIGN = "Sign",
		MAXWELL = "Maxwell",
		MOUND = "Grave",
		PIGHOUSE = "Pig House",
		PIGMAN = "Pig Man",
		CROP = "Crop",
		POND = "Pond",
        POND_MOS = "Pond",
		RABBIT = "Rabbit",
		RABBITHOLE = "Rabbit Hole",
		ROCK1 = "Boulder",
		ROCK2 = "Boulder",
		ROCK_FLINTLESS = "Boulder",
        INSANITYROCK = "Obelisk",
        SANITYROCK = "Obelisk",
        SKELETON = "Skeleton",
        PIGHEAD = "Pig Head",
        MERMHEAD = "Merm Head",

		SAPLING = "Sapling",
		SPIDER = "Spider",
		SPIDERDEN = "Spider Den",
		SPIDER_WARRIOR = "Spider Warrior",
		TENT = "Tent",
        PIGTORCH = "Pig Torch",
		
		WILSON = "Wilson",
        WILLOW = "Willow",
        WENDY = "Wendy",
        WOLFGANG = "Wolfgang",
        WOODIE = "Woodie",
        WICKERBOTTOM = "Wickerbottom",
        WX78 = "Wx78",
        WES = "Wes",
        
        PIGKING = "Pig King",
        STRAWHAT = "Straw Hat",
        TOPHAT = "Top Hat",
        FLOWERHAT = "Garland",
        BEEFALOHAT = "Beefalo Hat",
		FEATHERHAT = "Feather Hat",
        ARMORWOOD = "Log Suit",
        ARMORGRASS = "Grass Suit",
        ARMORMARBLE = "Marble Suit",
        ARMOR_SANITY = "Night Armour",
        SPEAR = "Spear",
        TENTACLESPIKE = "Tentacle spike",
        TENTACLE = "Tentacle",
        ROPE = "Rope",
        RESURRECTIONSTATUE = "Meat Effigy",
        RESURRECTIONSTONE = "Touch Stone",
        BOARDS = "Boards",
        CUTSTONE = "Cut Stone",
        GOLDNUGGET = "Gold Nugget",
        RESEARCHLAB = "Science Machine",
        RESEARCHLAB2 = "Alchemy Engine",
        RESEARCHLAB3 = "Shadow Manipulator",
        PLANT_NORMAL = "Crop",
        RAZOR = "Razor",
        BEARDHAIR = "Beard Hair",
        TREASURECHEST = "Chest",
        SKULLCHEST = "Skullchest",
        PANDORASCHEST = "Ornate Chest",
        CHESTER = "Chester",
        CHESTER_EYEBONE = "Eye Bone",
        BEDROLL_STRAW = "Straw Roll",
        BEEFALOWOOL = "Beefalo Wool",
        PINECONE = "Pine Cone",
        SPIDEREGGSACK = "Spider Eggs",
        CHARCOAL = "Charcoal",
		ASH = "Ashes",
		ASH_REMAINS = "Ashes of %s",
        MANDRAKE = "Mandrake",
        COOKEDMANDRAKE = "Cooked Mandrake",
        REEDS = "Reeds",
        CUTREEDS = "Cut Reeds",
        MARSH_PLANT = "Plant",
        MARSH_BUSH = "Spiky Bush",
        PAPYRUS = "Papyrus",
        MARSH_TREE = "Spiky Tree",
        PANFLUTE = "Pan Flute",
        BUGNET = "Bug Net",
        FROG = "Frog",
        FISHINGROD = "Fishing Rod",
        FISH = "Fish",
        FISH_COOKED = "Cooked Fish",
        HONEY = "Honey",
        HONEYCOMB = "Honeycomb",
        BEEHIVE = "Beehive",
        BEEBOX = "Bee box",
        BEE = "Bee",
        KILLERBEE = "Killer Bee",
        WASPHIVE = "Killer Bee Hive",
		MOSQUITO = "Mosquito",
        BEEHAT = "Beekeeper Hat",
        STINGER = "Stinger",
        BUTTERFLY = "Butterfly",
        BUTTERFLYWINGS = "Butterfly Wings",
        BUTTER = "Butter",
        FROGLEGS = "Frog Legs",
        FROGLEGS_COOKED = "Cooked Frog Legs",
        TALLBIRD = "Tallbird",
        SMALLBIRD = "Smallbird",
        TEENBIRD = "Smallish Tallbird",
        WALRUS = "MacTusk",
        WALRUS_CAMP = "Walrus Camp",
        WALRUS_TUSK = "Walrus Tusk",
        WALRUSHAT = "Tam o' Shanter",
        LITTLE_WALRUS = "Wee MacTusk",
        PUMPKIN_LANTERN = "Pumpkin Lantern",
        TALLBIRDNEST = "Tallbird Nest",
        TALLBIRDEGG = "Tallbird Egg",
        TALLBIRDEGG_CRACKED = "Hatching Tallbird Egg",
        TALLBIRDEGG_COOKED = "Fried Tallbird Egg",
        FEATHER_CROW = "Crow Feather",
        FEATHER_ROBIN = "Redbird Feather",
        FEATHER_ROBIN_WINTER = "Snowbird Feather",
        BIRDTRAP = "Bird Trap",
        BLOWDART_SLEEP = "Sleep Dart",
        BLOWDART_FIRE = "Fire Dart",
        BLOWDART_PIPE = "Blow Dart",
        BEEMINE = "Bee Mine",
        BEEMINE_MAXWELL = "Maxwell's Mosquito Trap",
        BIRDCAGE = "Birdcage",
        SPIDERQUEEN = "Spider Queen",
		EARMUFFSHAT = "Rabbit Earmuffs",
        WINTERHAT = "Winter Hat",
        HORN = "Beefalo Horn",
        ONEMANBAND = "One-man Band",
        STATUEHARP = "Harp Statue",
        STATUEMAXWELL = "Maxwell Statue",
        MAXWELLLIGHT = "Maxwell's Light",
        MAXWELLKEY = "Shadow Key",
        
		TELEPORTATO_RING = "Ring thing",
		TELEPORTATO_BOX = "Box thing",
		TELEPORTATO_CRANK = "Crank thing",
		TELEPORTATO_POTATO = "Metal potato thing",
		TELEPORTATO_BASE = "Wooden thing",
        TELEPORTATO_CHECKMATE = "Wooden thing",

		
        TRINKET_1 = "Melty Marbles",
        TRINKET_2 = "Fake Kazoo",
        TRINKET_3 = "Gord's Knot",
        TRINKET_4 = "Gnome",
        TRINKET_5 = "Tiny Rocketship",
        TRINKET_6 = "Frazzled Wires",
        TRINKET_7 = "Ball and Cup",
        TRINKET_8 = "Hardened Rubber Bung",
        TRINKET_9 = "Mismatched Buttons",
        TRINKET_10 = "Second-hand Dentures",
        TRINKET_11 = "Lying Robot",
        TRINKET_12 = "Dessicated Tentacle",

        CARROT_PLANTED = "Carrot",
        LEIF = "Treeguard",
        LEIF_SPARSE = "Treeguard",

		BUTTERFLYMUFFIN = "Butter Muffin",
		FROGGLEBUNWICH = "Froggle Bunwich",
		HONEYHAM = "Honey Ham",
		DRAGONPIE = "Dragonpie",
		TAFFY = "Taffy",
		PUMPKINCOOKIE = "Pumpkin Cookies",
		KABOBS = "Kabobs",
		MANDRAKESOUP = "Mandrake Soup",
		BACONEGGS = "Bacon and Eggs",
		BONESTEW = "Meaty Stew",
		PEROGIES = "Pierogi",
		WETGOOP = "Wet Goop",
		RATATOUILLE = "Ratatouille",
		FRUITMEDLEY = "Fruit Medley",
		FISHTACOS ="Fish Tacos",
		WAFFLES ="Waffles",
		TURKEYDINNER = "Turkey Dinner",
		DRUMSTICK = "Drumstick",
		DRUMSTICK_COOKED = "Fried Drumstick",
		TENTACLESPOTS = "Tentacle Spots",
		PERD = "Gobbler",
		ABIGAIL = "Abigail",
		MINERHAT = "Miner Hat",
		FISHSTICKS = "Fishsticks",
		STUFFEDEGGPLANT = "Stuffed Eggplant",
		HONEYNUGGETS = "Honey Nuggets",
		MEATBALLS = "Meatballs",
		JAMMYPRESERVES = "Fist Full of Jam",
		MONSTERLASAGNA = "Monster Lasagna",
		SPIDERHAT = "Spiderhat",
		WORMHOLE = "Worm Hole",
        WORMHOLE_LIMITED_1 = "Sick Worm Hole",
		
		WALL_WOOD_ITEM = "Wood Wall",
		WALL_STONE_ITEM = "Stone Wall",
		WALL_HAY_ITEM = "Hay Wall",

		WALL_WOOD = "Wood Wall",
		WALL_STONE = "Stone Wall",
		WALL_HAY = "Hay Wall",
        ANIMAL_TRACK = "Animal Track",
        DIRTPILE = "Suspicious Dirt Pile",
        KOALEFANT_SUMMER = "Koalefant",
        KOALEFANT_WINTER = "Koalefant",
        TRUNK_SUMMER = "Koalefant Trunk",
		TRUNK_WINTER = "Winter Koalefant Trunk",
        TRUNK_COOKED = "Koalefant Trunk Steak",
        TRUNKVEST_SUMMER = "Breezy Vest",
		TRUNKVEST_WINTER = "Puffy Vest",
        BOOMERANG = "Boomerang",
        BUSHHAT = "Bush Hat",
        
        CRAWLINGHORROR = "Crawling Horror",
        TERRORBEAK = "Terrorbeak",
        NIGHTMAREFUEL = "Nightmare Fuel",
        NIGHTLIGHT = "Night Light",
        NIGHTSWORD = "Dark Sword",
        
        DEERCLOPS = "Deerclops",
        BLUEGEM = "Blue Gem",
        ICESTAFF = "Ice Staff",
        FIRESTAFF = "Fire Staff",
        ICEHOUND = "Blue Hound",
        PENGUIN = "Penguin",
        DEERCLOPS_EYEBALL = "Deerclops Eyeball",
        GEARS = "Gears",
        NITRE = "Nitre",
        MAXWELLHEAD = "Maxwell's Head",
        DEADLYFEAST = "Deadly Feast",
       
        
        SINKHOLE = "Basalt",
        BASALT = "Basalt",
        BASALT_PILLAR = "Basalt Pillar",
        HOUNDMOUND = "Hound Mound",
        HOUNDBONE = "Bones",
        MERM = "Merm",
        MERMHOUSE = "Rundown House",

        MARBLEPILLAR = "Marble Pillar",
        MARBLETREE = "Marble Tree",
        MARBLE = "Marble",
        KNIGHT = "Clockwork Knight",
        BISHOP = "Clockwork Bishop",
        SUNKBOAT = "Sunken Boat",
        MAXWELLPHONOGRAPH = "Maxwell's Phonograph",
        MAXWELLTHRONE = "Nightmare Throne",
        MAXWELLLOCK = "Nightmare Lock",

        LOCKEDWES = "Wes",
        TREASURECHEST_TRAP = "Treasure Chest",
        MEATRACK = "Drying Rack",
        BANDAGE = "Honey Poultice",
		HEALINGSALVE = "Healing Salve",
		CANE = "Walking Cane",
		LIGHTNING_ROD = "Lightning Rod",
		DIVININGROD = "Divining Rod",
		DIVININGRODBASE = "Divining Rod Holder",
		DIVININGRODSTART = "Divining Rod Holder",
	},

    RECIPE_DESC=
    {
		GUNPOWDER = "A handful of gunpowder",
        TORCH = "Portable light source",
        TRAP = "Capture small creatures",
        BIRDTRAP = "Capture winged beasts",
        PIGHOUSE = "Shelters one pig",
        CAMPFIRE = "Provides light while burning",
        FIREPIT = "A safer, more efficient campfire",
		HEATROCK = "Stores heat for travel.",
        SLOW_FARMPLOT = "Grows seeds",
        FAST_FARMPLOT = "Grows seeds a bit faster",
        TENT = "Restores sanity, but costs time and hunger",
        ROPE = "Tightly woven coils of usefulness",
        ARMORWOOD = "Protects you from some damage",
        ARMORGRASS = "Provides a small amount of protection.",
        ARMORMARBLE = "It's heavy, but it will protect you.",
        ARMOR_SANITY = "Protects your body, but not your mind",
        SPEAR="Use the pointy end",
        STRAWHAT = "How fashionable!",
        TOPHAT = "The classiest hat of all.",
		FLOWERHAT = "Something to soothe the nerves.",
        BEEFALOHAT = "And you thought they smelled bad on the outside.",
        AXE = "Chop down trees!",
        PICKAXE = "Break down rocks",
		HAMMER = "Deconstruct structures",
        SHOVEL = "Move plants around",
        PITCHFORK = "Move the ground around",
        GOLDENAXE = "Chop down trees with STYLE!",
        GOLDENPICKAXE = "Break down rocks like a boss.",
        GOLDENSHOVEL = "Lasts longer, digs the same stuff",
		GOLDENPITCHFORK = "Rearrange the whole world",
        CUTSTONE = "Nicely squared rocks",
		WINTEROMETER = "Measure ambient air temperature",
        RAINOMETER = "Indicates the probability of precipitation",
        RESURRECTIONSTATUE = "Resurrect yourself with the power of meat.",
        BOARDS = "Like logs but flatter",
        RESEARCHLAB = "Unlock new crafting recipes",
		BACKPACK = "Carry more stuff.",
		PIGGYBACK = "Carries a lot, but slows you down.",
        UMBRELLA = "Mitigate the effects of atmospheric moisture.",
        RESEARCHLAB2 = "Unlock even more crafting recipes",
        RESEARCHLAB3 = "Is this even science anymore?",
        RAZOR = "Shave off your dirty beatnick beard.",
        PAPYRUS = "For writing things",
        PANFLUTE = "Music to soothe savage beasts",
        COOKPOT = "Make better food",
        BUGNET = "Catch bugs",
        BEEBOX = "Store your own bees",
        BEEHAT = "Protection against angry bees",
        TREASURECHEST = "A sturdy container",
        BEDROLL_STRAW = "Sleep through the night ",
        PUMPKIN_LANTERN = "Spooky illumination",
        FISHINGROD = "Go fishing. For fish.",
        FEATHERHAT = "Dress for your head.",
        MINERHAT = "Light up the night with your noggin.",
        FOOTBALLHAT = "Protect your braincase.",
        BLOWDART_SLEEP = "Spit sleepiness at your enemies.",
        BLOWDART_FIRE = "Spit fire at your enemies",
        BLOWDART_PIPE = "Spit teeth at your enemies.",
        BEEMINE = "Weaponized bees. What could go wrong?",
        AMULET = "Protects you from death.",
        SWEATERVEST = "Rugged, yet stylish.",
        TRUNKVEST_SUMMER = "Warm, but light enough for summer.",
		TRUNKVEST_WINTER = "Warm enough for winter storms.",
        BIRDCAGE = "A happy home for your avian friends.",
        SPIDERHAT = "Spiders will call you 'mom'.",
        TRAP_TEETH = "Pops up and bites whoever steps on it",
        TRAP_TEETH_MAXWELL = "Pops up and bites whoever steps on it",
		EARMUFFSHAT = "A fuzzy little bit of warmth",
        WINTERHAT = "There must be some magic in it...",
        BUSHHAT = "Good for hiding!",
        BOOMERANG = "It comes from a land down under.",
        ICEBOX = "Slows food spoilage.",
        ONEMANBAND = "Even a crazed musician can amass quite a following.",
        NIGHTMAREFUEL = "An evil residue used by the foolish and the crazy.",
        PURPLEGEM = "By your colours combined!",
        HAMBAT = "It takes food to make food.",
        HOMESIGN = "Make your mark upon the world.",
		WALL_WOOD_ITEM = "Wooden wall segments.",
		WALL_STONE_ITEM = "Stone wall segments.",
		WALL_HAY_ITEM = "Hay wall segments. Not very sturdy.",
        TURF_WOODFLOOR = "High-quality laminate floorboards.",
        TURF_CHECKERFLOOR = "Nicely checkered marble tiles.",
        TURF_CARPETFLOOR = "The smell is best described as 'Beefalesque'.",
        TURF_ROAD = "Build your own road to nowhere.",
        SEWING_KIT = "Fix up degraded clothing items.",
        NIGHTLIGHT = "Light the night with your dreams.",
        NIGHTSWORD = "Lucid dreaming damage.",
        ICESTAFF = "Freeze enemies in their tracks.",
        FIRESTAFF = "Harness the power of combustion!",
        MEATRACK = "The jerkiest of racks.",
        BANDAGE = "Heal your minor wounds.",
		HEALINGSALVE = "Disinfectant for cuts and abrasions.",
		LIGHTNING_ROD = "Protection from strikes.",
		CANE = "Help with walking.",
    },

    MAXWELL_TEST = {"Say pal, you don't look so good.", "You better find something to eat before night comes!"},

    MAXWELL_QUEST_SURVIVE = {
    	{"Say pal, you don't look so good.", "You better find something to eat before night comes!"},
    	{"Say pal, you don't look so good.", "You have some space to explore methinks."},
    	{"This may take some time...", "Don't get lost now!"},
    	{"The dew has fallen with a particularly sickening thud this morning...", "I'm off to find Zem..."},
    	{"Lucky nothing uses water eh?", "Its going to be a long day"},
    	{"Don't forget your booties cause its cold out there!", "Its cold out there every day."},
    	{"Safe and secure area?", "Its just a skip, hop and a jump away from here."},
    	{"Say pal, keep your chin up.", "You will probably find it hard to stay dapper."},
    	{"I left you a little something...","I don't think it will help you though.", "You know what I like about nighttime?", "All the spiders."},
    	},
    	

    MAXWELL_SANDBOXINTROS =
    {
        ONE = "Say pal, you don't look so good.",
        TWO = "You'd better find something to eat before night comes!",       
    },

    MAXWELL_ADVENTUREINTROS =
    {
        LEVEL_1 =
        {
            ONE = "Oh, you found my portal did you?",
            TWO = "You'd think you would have learned your lesson by now.",
            --THREE = "Strange machinery hasn't exactly been kind to you in the past.",
            THREE = "Hmm. Let's try something a little more challenging, shall we?",
            --FIVE = "Let's see if you're so enthusastic when it's fourty below.",
        },
        LEVEL_2 =
        {
            ONE = "Well would you look at that, you survived.",
            TWO = "One down, four to go!",
            --TWO = "Now don't get a big head, you aren't the first.",
            --THREE = "Let's see what you're really made of.",
            --FOUR = "And by that I mean to say,",
            --FIVE = "I will enjoy inspecting your entrails once the Deerclops is done with you.",
        },
        LEVEL_3 =
        {
            ONE = "What? You're still here?",
            TWO = "Impressive. But you should probably stop while you're ahead.",
            --TWO = "Must I do everything myself?",
            --THREE = "HOUNDS! DISPOSE OF THIS PEST!",
        },
        LEVEL_4 =
        {
            ONE = "Say, pal.",
            TWO = "You're really pushing your luck.",
            THREE = "Turn back now, or I may have to resort to drastic mesaures.",
        },
        TWOLANDS =
        {
            ONE = "Say, pal.",
            TWO = "Let's make a deal. You can stay here. Settle down, even.",
            THREE = "I'll give you food, gold, pigs, whatever you need.",
            FOUR = "All I want in return is a truce.",
        },
        LEVEL_5 =
        {
            ONE = "You insolent, pitiful, insignificant ant!",
            TWO = "Do not arouse the wrath of the Great Maxwell!",
            THREE = "You will regret coming any further...",
        },
        LEVEL_6 =
        {
            ONE = "Well, this is it.",
            TWO = "You found me. Now, what are you going to do?",
            TELEPORTFAIL = "Don't you think I've tried that?",
            TELEPORTFAIL2 = "This is the end of the line. We have no escape.",
            COMBATFAIL = 
            {
                "Where would be the sport in that?",
                "Who do you think allowed you to make that?",
            },
            CONVERSATION = 
            {
                "Is this what you were expecting?",
                "Forgive me if I don't get up.",
                "You've been an interesting plaything, but I've grown tired of this game.",
                "Or maybe They've grown tired of me.",
                "Heh. Took them long enough.",
                "They'll show you terrible, beautiful things.",
                "It will change you, like it did me.",
                "It's best not to fight it.",
                "There wasn't much here when I showed up.",
                "Just dust. And the void. And Them.",
                "I've learned so much since then. I've built so much.",
				"But even a King is bound to the board.",                
				"You can't change the rules of the game.",
                "I don't know what they want. They... they just watch.",
                "Unless you get too close. Then...",
                "Well, there's a reason I stay so dapper.",
                "What year is it out there? Time moves differently here.",
                "Go on, stay a while. Keep us company.",
                "Or put the key in the box. It's your decision.",
                "Either way, you're just delaying the inevitable.",
                "Reality is like that, sometimes.",
                "I think I've said enough.",
                "..."
            }
        },

    },

    MAXWELL_ADVENTURE_HEAD =
    {
        LEVEL_4 =
        {
            ONE = "Fine. Just remember that you chose this.",
        },
        LEVEL_6 =
        {
            ONE = "We're not so different, you and I.",
            TWO = 
            {
                ONE = "That's why I brought you here.",
                TWO = "That's why I brought all of them here.",
            },
            THREE =   
            {
                ONE = "Oh, did you think you were the first?",
                TWO = "HA!",
            },
            FOUR = 
            {
                ONE = "It's just that...",
                TWO = "I've become accustomed to winning.",
            },
        },
    },

    MAXWELL_ADVENTURETHRONE =
    {
        LEVEL_6 =
        {
            INTRO =
            {
                ONE = "Is this how it ends?",
            },
            HIT =
            {
                ONE = "The throne won't allow that. I've tried.",
            },
            NOUNLOCK =
            {
                ONE = "Ah, I am a fool. I had dared to hope.",
            },
            PHONOGRAPHON =
            {
                ONE = "I guess I deserve that.",
            },
            PHONOGRAPHOFF =
            {
                ONE = "Thank you. I have been listening to that song for an eternity.",
            },
        },
    },
	
    --ITEM DESCRIPTIONS
    DESCRIBE_NULL = "MISSING DESCRIPTION STRING",


    PIG_TALK_FOLLOWWILSON = {"YOU FRIEND", "I LOVE FRIEND", "YOU IS GOOD", "I FOLLOW!"},
    PIG_TALK_FIND_LIGHT = {"SCARY", "NO LIKE DARK", "WHERE IS SUN?", "STAY NEAR FIRE", "FIRE IS GOOD"},
    PIG_TALK_LOOKATWILSON = {"WHO ARE YOU?", "YOU NOT PIG", "UGLY MONKEY MAN", "YOU HAS MEAT?"},
    PIG_TALK_RUNAWAY_WILSON = {"TOO CLOSE!", "STAY AWAY!", "YOU BACK OFF!", "THAT MY SPACE."},
    PIG_TALK_FIGHT = {"I KILL NOW!", "YOU GO SMASH!", "RAAAWR!"},
    PIG_TALK_RUN_FROM_SPIDER = {"SPIDER BAD!", "NO LIKE SPIDER!", "SCARY SPIDER!"},
    PIG_TALK_HELP_CHOP_WOOD = {"KILL TREE!", "SMASH MEAN TREE!", "I PUNCH TREE!"},
    PIG_TALK_ATTEMPT_TRADE = {"WHAT YOU GOT?", "BETTER BE GOOD."},
    PIG_TALK_PANIC = {"NOOOOO!", "TOO DARK! TOO DARK!", "AAAAAAAAAH!!"},
    PIG_TALK_PANICFIRE = {"HOT HOT HOT!", "OWWWWW!", "IT BURNS!"},
    PIG_TALK_FIND_MEAT = {"ME HUNGRY!", "YUM!", "I EAT FOOD!", "TIME FOR FOOD!"},
    PIG_TALK_EAT_MEAT = {"NOM NOM NOM", "YUM!"},
    PIG_TALK_GO_HOME = {"HOME TIME!", "HOME! HOME!"},
    PIG_GUARD_TALK_TORCH = {"TORCH GET LOW", "MAKE TORCH BRIGHT", "MORE BURNING"},
    PIG_GUARD_TALK_FIGHT = {"FOR KING!", "DEFEND!", "SAVE KING!"},
    PIG_GUARD_TALK_GOHOME = {"MUST DEFEND!", "I PROTECT", "KING! KING!"},
    PIG_GUARD_TALK_LOOKATWILSON = {"YOU LEAVE NOW", "YOU GO AWAY", "YOU NO STAY"},
    


    EPITAPHS =
    {
        "Here lies some guy. Blah blah blah.",
        "This headstone is blank",
        "It says: 'Milk. Eggs. Bacon.'",
        "Hey that's my name!",
    },

    TABS =
    {
        TOOLS = "Tools",
        LIGHT = "Light",
        FARM = "Food",
        SURVIVAL = "Survival",
        SCIENCE = "Science",
        WAR = "Fight",
        TOWN = "Structures",
        REFINE = "Refine",
        DRESS = "Dress",
        MAGIC = "Magic",
    },
}

STRINGS.PIGNAMES=
{
	--emperors
	"Augustus",
	"Tiberius",
	"Caligula",
	"Claudius",
	"Nero",
	"Galba",
	"Otho",
	"Vitellius",
	"Vespasian",
	"Titus",
	"Domitian",
	"Nerva",
	"Trajan",
	"Hadrian",
	"Antonius",
	"Lucius",
	"Marcus",
	"Commodus",
	"Pertinax",
	"Didius",
	"Septmius",
	"Caracalla",
	"Geta",
	"Marcrinus",
	"Elagabalus",
	"Severus",
	"Maximinus",
	"Gordian",
	"Pupienus",
	"Balbinus",
	"Philip",
	"Hostilian",
	"Trebonianus",
	"Aemilian",
	"Valerian",
	"Gallienus",
	"Quintillus",
	"Aurelian",
	"Tacitus",
	"Florian",
	"Probus",
	"Carus",
	"Numerian",
	"Carinus",
	"Diocletian",
	"Maximian",
	"Constantius",
	"Galerius",
	"Constantine",
	"Maxentius",
	"Licinius",
	"Constans",
	"Vetriano",
	"Julian",
	"Jovian",
	"Valentinian",
	"Valens",
	"Gratian",
	"Theodosius",
	"Arcadius",
	"Honorius",
	"Joannes",
	"Marcian",
	"Petronius",
	"Avitus",
	"Majorian",
	"Libius",
	"Anthemius",
	"Olybrius",
	"Glycerius",
	"Julius",
	"Romulus",
	"Leo",
	"Zeno",
	"Basiliscus",
	"Anatasius",
	"Justin",
	"Justinian",
	"Maurice",

	--forum fun
	"Mickey",

	--dev team
	"Kevin",
	"Ju-lian",
	"Alia",
	"Tatham",
	"Brook",
	"Matt",
	"Alex",
	"Kelly",
	"Eugene",
	"Graham",
	"Jamie",
	"Jeff",
	"Joe",
	"Corey",
	"Bryce",
	"Bug", --Joe's kid

	--food that Soth likes
	"Moon Pie",
	"Bagel",
	"Biscuit",
	"Bacon",
	"Hamilton",
	"Hamms",
	"Mr.P",
	"Brownie",
	"Butters",
	"Tuna",
	"Clover",
	"Coco",
	"Custard",
	"Dumpling",
	"Eggy",
	"Kiwi",
	"Weiner",
	"Waffle",
	"Twinkie",
	"Truffle",
	"Tater",
	"Cheddar",
	"Pumpkin",
	"Oatey",
	"Oinkey",
	"Nacho",
	"Puffin",
	"Doughnut",
	"Cabbage",
	"Porky",
	"Porkins",
	"Porkbun",
	"Pepper",
	"Gouda",
	"Eggbert",
	"Chip",
	"Berry",
	"Crabby",
	"Reuben",
	"Barley",
	"Olive",
	"Pickles",
	"Wiggles",
	"Jerky",
	"Smelly",
	"Salty",
}

STRINGS.UI =
{
	
	CHARACTERSELECT=
	{
		APPLY = "Apply",
		CANCEL = "Cancel",
	},
	
	CRAFTING=
	{	
		PLACE = "Place",
		BUILD = "Build",
		PROTOTYPE = "Prototype",
		BUILD = "Build",
		RESEARCH = "Research",
		NEEDSCIENCEMACHINE = "Use a science machine to build a prototype!",
		NEEDALCHEMYENGINE = "Use an alchemy engine to build a prototype!",
        NEEDSHADOWMANIPULATOR = "Use a shadow manipulator to build a prototype!",
		CANTRESEARCH = "Some things are unknowable",
	},
	
	DEATHSCREEN=
	{
		MAINMENU = "Main Menu",
		RETRY = "Retry",
		CONTINUE = "Continue",
		YOUAREDEAD = "YOU ARE DEAD!",
		YOUESCAPED = "You escaped!",
		DAYS = "days",
		DAY = "day",
		SURVIVEDDAYS = "You survived",
		NEXTREWARD = "Next Reward...",
		LEVEL = "Level ",
		ATCAP = "At Cap!",
	},
	
    CREDITS=
    {
        TITLE = "CREDITS",
        NAMES=
        {
            "Kevin Forbes",
            "Ju-Lian Kwan",
            "Jamie Cheng",
            "Alia McCutcheon",
            "Tatham Johnson",
            "Graham Jans",
            "Brook Miles",
            "Bryce Doig",
            "Charles Bostik",
            "Wade Lindley",
            "Joe Wreggelsworth",
            "Corey Rollins",
            "Matthew Marteinsson",
            "Jason Garner",
            "Vince de Vera",
            "Jeff Agala",
            "Alex Savin",
            "Sloth Trakhtenberg",
            "Kelly Graham",
            "Allan Cortez",
            "Aaron Bouthillier",
        },

        ALTGAMES = 
        {
            TITLE = "Linux and OSX ports by Alternative Games",
            NAMES = 
            {
                "Turo Lamminen",
                "Tuomas Narvainen", 
                "Tapio Honkonen",
            },
        },

        THANKYOU = "Thank you!",
        EXTRA_THANKS = "Ophir Lupu\nKo Kim\nColt McAnlis",
        THANKS = "And a very special thanks to all our supporters who braved the challenge of the \"Early-Access Beta\".\nYou are too numerous to name - our amazing moderators, the wonderful artists, musicians, live streamers,\nto all who made a Let's Play video and everybody who chimed in to let us know exactly what you think.\nYour encouragement, passion and support has been amazing.\n\nDon't Starve is truly a better game because of all of you.",

        FMOD = "FMOD Sound System,\nCopyright Firelight Technologies",

        FACEBOOK = "The Facebooks",
        TWITTER = "The Twitters",
    },
	
	WORLDGEN=
	{
		TITLE = "GENERATING WORLD",
		VERBS = 
		{
			"Wrangling",
			"Generating",
			"Herding",
			"Embiggening",
			"Iterating upon",
			"Insinuating",
			"Reticulating",
			"Inserting",
			"Framing",
		},
		NOUNS=
		{
			"trees",
			"pathos",
			"pines",
			"spiders",
			"monsters",
			"a keen sense of despair",
			"Wilson's beard",
			"buckets and buckets of loot",
			"game theory",
			"food",		
		}
	},
	EMAILSCREEN=
	{
		SIGNUPSUCCESSTITLE="Subscribe Complete",
		SIGNUPSUCCESS="Thanks for signing up! You should receive a confirmation email in your inbox.",
		INVALIDEMAILTITLE= "Invalid Email", 
		INVALIDEMAIL= "We aren't psychic! If you don't enter your email address, we won't be able to tell you about new stuff!",
		INVALIDDATETITLE= "Invalid Date", 
		INVALIDDATE= "We need to know your birthdate, otherwise ratings people will get mad at us for emailing you content that might not be appropriate for all ages.",
		OK = "Ok",
		SUBSCRIBE = "Subscribe",
		CANCEL = "Cancel",
		TITLE = "Keep me updated with Don't Starve news",
		EMAIL = "Email:",
		BIRTHDAY = "Birthdate:",
		BIRTHDAYREASON = "We need to know your birthdate in order to send you age appropriate updates!\r\nDon't worry, we won't spam you or sell your information.",
		JAN="Jan",
		FEB="Feb",
		MAR="Mar",
		APR="Apr",
		MAY="May",
		JUN="Jun",
		JUL="Jul",
		AUG="Aug",
		SEP="Sep",
		OCT="Oct",
		NOV="Nov",
		DEC="Dec",
		MONTH = "M",
		DAY = "D",
		YEAR = "YYYY",
	},
	
	MAINSCREEN =
	{
		NOTIFY = "Notify Me!",
		FORUM = "Forum",
		BUYNOW = "Buy Now",
		GIFT = "Send Gift",
        MODTITLE = "Mods Installed!",
        MODDETAIL = "Installed mods:",
        MODDETAIL2 = "Klei is not able to help you should issues arise while using mods. Use with caution!",
        MODFAILTITLE = "WARNING!",
        MODFAILDETAIL = "The following mod(s) have caused a failure:",
        MODFAILDETAIL2 = "You can disable the mod(s) in /mod/modsettings.lua",
        MODQUIT = "No way!",
        MODFORUMS = "Mod Forums",
        SCRIPTERRORQUIT = "Exit Game",
        SCRIPTERRORMODWARNING = "This error may have occurred due to a mod you have installed!\nYou have the following mods installed:\n",
        TESTING = "This is the testing branch!", 
		TESTINGDETAIL = "You may encounter bugs or broken features, and you may lose your save game when we update. Please report all problems in the forum.",
		TESTINGNO = "No thank you!",
		TESTINGYES = "I understand",
		CONTINUE = "Continue",
		DELETE = "Delete",
		RESTART = "Restart",
		NEWADVENTURE_WARN = "The new adventure system is currently in active development and is provided for testing purposes. It will probably contain bugs.",
		NEWADVENTURE = "Adventure (TEST)",
		NEWFREEPLAY = "Sandbox",
		NEWFREEPLAYCUSTOM = "Sandbox (Custom)",
		NEWGAMESHORT = "Empty",
		UNKNOWNGAME = "Unknown",
		NEWGAMETYPE = "What kind of game would you like to play?",
		SLOTACTION = "What would you like to do?",
		ADVENTURE = "Adventure",
		FREEPLAY = "Sandbox",
		SLOT = "Game Slot",
		SLOT_1 = "1",
		SLOT_2 = "2",
		SLOT_3 = "3",
		SLOT_4 = "4",
		IMPORT = "Import",
		CANCEL = "Cancel",
		SETTINGS = "Settings",
		OPTIONS = "Options",
		PLAYDEMO = "Play Demo",
		ENTERPRODUCTKEY = "Enter Key",
		ENTERKEY = "Enter New Key",
		RESETPROFILE = "Reset profile!",
		UNLOCKEVERYTHING = "Unlock Everything",
		SURE = "Are you sure?",
		YES = "Yes",
		NO = "No",
		CHEATS = "Cheats",
		PLAY = "Play!",
		RATE = "Rate This Game",
		ACCOUNTINFO = "Account Info",
		VISITFORUM = "Visit Forum",
		MOREGAMES = "More Games",
		CHOOSEDIR = "Don't Starve Game Data",
		IMPORTSUCCESS = "Success",
		IMPORTSUCCESSDESC = "Data was imported successfully.",
		OK = "OK",
		IMPORTFAIL = "Failed to load",
		GREETING = "Hi ",
		NEWWORLD = "Create a new world!",
		NEWWORLDDESC = "This will erase your current world and any saved games in it. Continue?",
		RESETGAMEDESC = "This will reset your current world. Continue?",
		NEWGAMEDESC = "This will erase your current save. Continue?",
		ADVGAMEDESC = "NOTE: This mode is still under development.\n\nFor experienced players only!\n\nYou've decided to bring the fight to Maxwell.\nCan you survive the increasingly harsh conditions he's created for you, and beat him at his own game?",
		NEWGAME = "Start a new game!",
		NEWGO = "Lets Go!",
		ASKQUIT = "Do you really want to quit?",
		ASKQUITDESC = "Wilson will miss you!",

		FRESHBUILD = "Fresh Build!",
		LASTBUILDDAYS = "Last build %d days ago",
		NEXTBUILDIMMINENT = "Next build imminent!",
		NEXTUPDATEDAYS = "Next Update: %d days",
		
		MOTDTITLE = "Don't Starve News",
		MOTD = "Thank you to everyone who participated in the beta!\nJoin the community today in our forum.",
		EXIT = "Exit",
        LOGOUT = "Log Out",
        CREDITS = "Credits",
	},
	
	HUD=
	{
		MAP = "Show Map\n(tab)",
		BUYNOW = "Buy Now",
		READYTITLE = "Ready to play!",
		READY = "How long will you survive?",
		START = "Start",
		CLOCKDAY = "Day",
		SAVING = "SAVING...",
		WORLD = "World",
		BUILD = "Build",
		HERE = "here",
		STALE = "Stale",
		SPOILED = "Spoiled",
		ROTLEFT = "Rotate Left\n(Q)",
		ROTRIGHT = "Rotate Right\n(E)",
		PAUSE = "Pause\n(ESC)",
	},
	
	OPTIONS=
	{
		ACCEPTTITLE = "Accept Changes",
		ACCEPTBODY = "Do you wish to accept these changes?",
		ACCEPT = "Accept",
		CANCEL = "Cancel",
		REVERT = "Revert Changes",
		APPLY = "Apply",
		CLOSE = "Close",
		BLOOM = "Bloom:",
		DISTORTION = "Distortion:",
		FULLSCREEN = "Fullscreen:",
		DISPLAY = "Display:",
		RESOLUTION = "Resolution:",
		REFRESHRATE = "Refresh Rate:",
		ENABLED = "Enabled",
		DISABLED = "Disabled",
	},
	
	PAUSEMENU =
	{
		TITLE = "Paused",
		SAVEANDQUITTITLE = "Save and return to main menu?",
		SAVEANDQUITBODY = "Don't worry - we'll be waiting for you.",
		SAVEANDQUITYES = "I said quit!",
		SAVEANDQUITNO = "Never mind...",
		QUITTITLE = "Return to main menu?",
		QUITBODY = "Leaving so soon?",
		QUITYES = "I said quit!",
		QUITNO = "Never mind...",
		OPTIONS = "Options",
        SAVEANDQUIT = "Save and Quit",
        QUIT = "Quit",
		CONTINUE = "Continue",
	},
	
	CUSTOMIZATIONSCREEN =
	{
		APPLY = "Apply",
		CANCEL = "Cancel",
		PRESETTITLE = "Preset",
		DEFAULT_PRESET_DESC = "Lots of pigs and spiders and a tallbird nest.",
		LOSECHANGESTITLE = "Lose Changes?",
		LOSECHANGESBODY = "Apply a new preset and lose custom changes?",
		YES = "Yes",
		NO = "No",
		CUSTOMDESC = "Your world, your rules!",
		CUSTOM = "(Custom)",
		
		PRESETLEVELS = {
				"Default", 
				"Default Medium", 
				"Default Large", 	
				"Soggy", 					-- Too much water - swamp etc
				"Eternal Summer", 			-- Less water, no swamp etc
				"Winter you'll do next?", 	-- Winter focus
				"Island you an axe", 		-- Island hopping
				"Crazy Eddie",   			-- Focus on sanity play
				"Nighttime Antics",  		-- Focus on nighttime play
				},		
		PRESETLEVELDESC = {
			"The standard Don't Starve Experience",
			"The standard Don't Starve Experience 2",
			"The standard Don't Starve Experience 3",
			"The standard Don't Starve Experience 4",
			"The standard Don't Starve Experience 5",
			"The standard Don't Starve Experience 6",
			"The standard Don't Starve Experience 7",
			"The standard Don't Starve Experience 8",
			"The standard Don't Starve Experience 9",
			"The standard Don't Starve Experience 10",
		}
				
	},
	
    NEWGAMESCREEN =
    {
        TITLE = "New Game",
        CANCEL = "Cancel",
        CHANGECHARACTER = "Change Character",
        CUSTOMIZE = "Customize World",
        START = "Start",
    },

	SLOTDETAILSSCREEN =
	{
		TITLE = "Slot",
		CANCEL = "Cancel",
		CONTINUE = "Continue",
        PLAY = "Play",
		RESTART = "Restart",
		DELETE = "Delete",
        CHANGECHARACTER = "Change Character",
	},
	LOADGAMESCREEN=
	{
		CANCEL = "Cancel",
		TITLE = "Choose A Slot",
		NEWGAME = "New Game",
		ADVENTURE = "Adventure",
		SURVIVAL = "Survival",
		RESTART = "Restart",		
	},

    UNLOCKMAXWELL=
    {
        TITLE = "Take pity?",
        BODY1 = "The key looks like it will fit. You can free ",
        BODY2 =", but I doubt %s captors will be pleased...",
        YES = "Yes",
        NO = "No",
    },

    STARTADVENTURE=
    {
        TITLE="Doorway to Adventure!",
        BODY="You're about to step into a long, arduous journey to find Maxwell. You will need to survive 5 worlds, each randomly generated to present a new challenge.\n\nShould you die, you will start back at this portal, but lose all your progress on the journey.\n\nAre you ready?",
        YES="Yes",
        NO="No",
    },

    ENDGAME=
    {
        TITLE="The End.",
        BODY1 = "And so the cycle continues. Will ",
        BODY2 = " ever escape?\n Perhaps %s too will tire of this wretched place, and use %s new powers to tempt the unsuspecting.\n\nThe mysterious beings that control this place still lurk in the shadows, and new challenges will soon be revealed.\n\nUntil then,\n- The Don't Starve Team -",
        YES= "For Science!",
    },

    GENDERSTRINGS =
    {
        MALE = 
        {
            ONE = "he",
            TWO = "his",
        },
        FEMALE = 
        {
            ONE = "she",
            TWO = "her",
        },
        ROBOT =
        {
            ONE = "it",
            TWO = "its",
        },
    },

	SANDBOXMENU =
	{
		TITLE = "World Customisation",
		TITLEDETAIL = "",
		
		EASY = "Not Easy",
		MEDIUM = "Quite Difficult",
		HARD = "Overly Taxing",

		GENERATE = "OK",
		MAINMENU = "Cancel",
		
		CHOICEMONSTERS = "Monsters",
		CHOICEANIMALS = "Animals",
		CHOICERESOURCES = "Resources",
		CHOICEFOOD = 	"Food",
		CHOICECOOKED = "Prepared Food",		
		CHOICEAMTDAY = "Amount of Day",	
		CHOICEMISC = "World",	
				
		DAY = "Day",
		NIGHT = "Night",
		DUSK = "Dusk",
		
		SLIDESHORT = "Short",
		SLIDELONG = "Long",
		SLIDEALL = "Only",
		
		SLIDEDEFAULT = "Default",
		
		SLIDENEVER = "None",
		SLIDERARE = "Less",
		SLIDEOFTEN = "More",
		SLIDEALWAYS = "Lots",
		
		SLIDEVERYSLOW = "Very Slow",
		SLIDESLOW = "Slow",
		SLIDEFAST = "Fast",
		SLIDEVERYFAST = "Very Fast",
		
		SUMMER = "Summer",
		WINTER = "Winter",
		BOTH = "Both",
		
		SLIDESMALL = "Default",
		SLIDESMEDIUM = "Medium",
		SLIDESLARGE = "Large",
		SLIDESHUGE = "Huge",
		
		SLIDEVERYSIMPLE = "Very Simple",
		SLIDESIMPLE = "Simple",
		SLIDECOMPLEX = "Complex",
		SLIDEVERYCOMPLEX = "Very Complex",

		BRANCHINGMOST = "Most",
		BRANCHINGANY = "Default",
		BRANCHINGLEAST = "Least",
		BRANCHINGNEVER = "Never",

		LOOPNEVER = "Never",
		LOOPRANDOM = "Default",
		LOOPALWAYS = "Always",
		
		USEPRESET = "Preset",
		CHAPTERS = {
                "Chapter 1 of 5",
                "Chapter 2 of 5",
                "Chapter 3 of 5",
                "Chapter 4 of 5",
                "Chapter 5 of 5",
                "Epilogue",
        },
        ADVENTURELEVELS = {
                "A Cold Reception", 
                "The King of Winter", 
                "The Game is Afoot", 
                "Archipelago",
                "Two Worlds", 
                "Darkness", 

				"Checkmate",
				},
		NONE = "None",
		NONEAVAILABLE = "None Available",
		MODIFYTASKS = "Modify Tasks",
		
		YES ="Yes",
		NO = "No",
	},
	
	QUITTINGTITLE = "Quitting!",
	QUITTING = "Packing up the science.",
	
	TELEPORTTITLE = "Journey onwards?",
	TELEPORTBODY_SURVIVAL = "This will destroy your current world but you will retain your inventory contents.",
	TELEPORTBODY_ADVENTURE = "This will REMOVE ALL YOUR ITEMS and destroy your current world. Only items placed in the machine will appear in the next world.",
	TELEPORTYES = "Lets Go!",
	TELEPORTNO = "Stay here.",
}

--these are broken out into their own files for ease of editing
STRINGS.CHARACTERS =
{
	GENERIC = require "speech_wilson",
	WAXWELL = require "speech_maxwell",
	WOLFGANG = require "speech_wolfgang",
	WX78 = require "speech_wx78",
	WILLOW = require "speech_willow",
	WENDY = require "speech_wendy",
	WICKERBOTTOM = require "speech_wickerbottom",
}



if TranslateStringTable ~= nil then
	TranslateStringTable( STRINGS )
end
