require "util"

local ParseNestedKey -- must define it first so we can recurse
ParseNestedKey = function(obj, key, value)
	if #key == 1 then
		obj[key[1]] = value
		return
	else
		local key_head = key[1]
		if key_head == nil then
			return
		end
		
		local key_tail = {}
		for i,k in ipairs(key) do
			if i > 1 then table.insert(key_tail, k) end
		end
		if obj[key_head] == nil then
			obj[key_head] = {}
		end
		ParseNestedKey(obj[key_head], key_tail, value)
	end
end



local function ConvertStaticLayoutToLayout(layoutsrc, additionalProps)
	local staticlayout = require(layoutsrc)
	
	local layout = additionalProps or {}
		
	-- add stuff
	layout.type = LAYOUT.STATIC	
	layout.scale = 1	
	
	-- See \tools\tiled\dont_starve\tiles.png for tiles
	layout.ground_types = {GROUND.IMPASSABLE, GROUND.ROAD, GROUND.ROCKY, GROUND.DIRT, 
							GROUND.SAVANNA, GROUND.GRASS, GROUND.FOREST, GROUND.MARSH, 
							GROUND.WOODFLOOR, GROUND.CARPET, GROUND.CHECKER}
	layout.ground = {}
	
	-- See \tools\tiled\dont_starve\objecttypes.xml for objects
	layout.layout = {}
	
	for layer_idx, layer in ipairs(staticlayout.layers) do
		if layer.type == "tilelayer" and layer.name == "BG_TILES" then 
			local val_per_row = layer.width * 3				
			local i = val_per_row

			while i < #layer.data do		
				local data = {}	
				local j = 1
				while j < layer.width and i+j < #layer.data do
					table.insert(data, layer.data[i+j])
					j = j + 4
				end
				table.insert(layout.ground, data)	
				i = i + val_per_row + layer.width
			end
		elseif layer.type == "objectgroup" and layer.name == "FG_OBJECTS" then 
			for obj_idx, obj in ipairs(layer.objects) do
				if layout.layout[obj.type] == nil then
					layout.layout[obj.type] = {}
				end
				
				-- TODO: Check the object properties for other options to substitute here
				local x = obj.x+obj.width/2
				x = x/64.0-(staticlayout.width/4)/2
				local y = obj.y+obj.height/2
				y = y/64.0-(staticlayout.height/4)/2

				local width = obj.width/64.0
				local height = obj.height/64.0

				local properties = {}
				if obj.properties then
					for k,v in pairs(obj.properties) do
						local keys = k:split(".")
						local number_v = tonumber(v)
						if v == "true" or v == "false" then
							ParseNestedKey(properties,keys, v == "true")
						else
							ParseNestedKey(properties,keys,number_v or v)
						end
					end
					
					--print("Static Layout Properties for ", layoutsrc)
					--dumptable(properties,1,10)

				end

				table.insert(layout.layout[obj.type], {x=x, y=y, properties=properties, width=width, height=height})				
			end
		end
	end
	
	return layout
end

return {Get = ConvertStaticLayoutToLayout}
