0035:debugsounds.lua:0180A:1:14=515226D9:16=47d21313:require("class")
require("util")



--tweakable parameters
local maxRecentSounds = 10  --max number of recent sounds to list in the debug output
local maxDistance = 100     --max distance to show 

local playsound = SoundEmitter.PlaySound
local killsound = SoundEmitter.KillSound
local killallsounds = SoundEmitter.KillAllSounds
local setparameter = SoundEmitter.SetParameter
local setvolume = SoundEmitter.SetVolume
local setlistener = Sim.SetListener

local nearbySounds = {}
local loopingSounds = {}
local soundCount = 0
local listenerPos = nil
 
TheSim:LoadPrefabs({"sounddebugicon"})

SoundEmitter.PlaySound = function(emitter, event, name, volume, ...)
    local ent = emitter:GetEntity()
    if ent and ent.Transform and listenerPos then
        local pos = Vector3(ent.Transform:GetWorldPosition() )
        local dist = math.sqrt(distsq(pos, listenerPos) )
        if dist < maxDistance or name then
            local soundIcon = nil
            if name and loopingSounds[ent] and loopingSounds[ent][name] then
                soundIcon = loopingSounds[ent][name].icon
            else
                soundIcon = SpawnPrefab("sounddebugicon")
            end
            if soundIcon then
                soundIcon.Transform:SetPosition(pos:Get() )
            end
            local soundInfo = {event=event, owner=ent, guid=ent.GUID, prefab=ent.prefab or "", position=pos, dist=dist, volume=volume or 1, icon=soundIcon}
            if name then
                --add to looping sounds list
                soundInfo.params = {}
                if not loopingSounds[ent] then
                    loopingSounds[ent] = {}
                end
                loopingSounds[ent][name] = soundInfo
                if soundIcon then
                    if soundIcon.autokilltask then
                        soundIcon.autokilltask:Cancel()
                        soundIcon.autokilltask = nil
                    end
                    soundIcon.Label:SetText(name)
                end
            else
                --add to oneshot sound list
                soundCount = soundCount + 1
                local index = (soundCount % maxRecentSounds)+1
                soundInfo.count = soundCount
                nearbySounds[index] = soundInfo
                if soundIcon then
                    soundIcon.Label:SetText(tostring(soundCount) )
                end
            end
        end
    end
    
    playsound(emitter, event, name, volume, ...)
end

SoundEmitter.KillSound = function(emitter, name, ...)
    local ent = emitter:GetEntity()
    if loopingSounds[ent] then
        if loopingSounds[ent][name] and loopingSounds[ent][name].icon then
            loopingSounds[ent][name].icon:Remove()
        end
        loopingSounds[ent][name] = nil
    end
    killsound(emitter, name, ...)
end

SoundEmitter.KillAllSounds = function(emitter, ...)
    local sounds = loopingSounds[emitter:GetEntity()]
    if sounds then
        for k,v in pairs(sounds) do
            if v.icon then
                v.icon:Remove()
            end
            sounds[v] = nil
        end
        sounds = nil
    end
    killallsounds(emitter, ...)
end

SoundEmitter.SetParameter = function(emitter, name, parameter, value, ...)
    local ent = emitter:GetEntity()
    if loopingSounds[ent] and loopingSounds[ent][name] then
        loopingSounds[ent][name].params[name] = value
    end
    setparameter(emitter, name, parameter, value, ...)
end

SoundEmitter.SetVolume = function(emitter, name, volume, ...)
    local ent = emitter:GetEntity()
    if loopingSounds[ent] and loopingSounds[ent][name] then
        loopingSounds[ent][name].volume = volume
    end
    setvolume(emitter, name, volume, ...)
end

Sim.SetListener = function(sim, x, y, z, ...)
    listenerPos = Vector3(x, y, z)
    setlistener(sim, x, y, z, ...)
end

local function DoUpdate()
    for ent,sounds in pairs(loopingSounds) do
        if not next(sounds) then
            loopingSounds[ent] = nil
        else
            for name,info in pairs(sounds) do
                if not ent:IsValid() or not ent.SoundEmitter or not ent.SoundEmitter:PlayingSound(name) then
                    if info.icon then
                        info.icon:Remove()
                    end
                    sounds[name] = nil
                else
                    local pos = Vector3(ent.Transform:GetWorldPosition() )
                    local dist = math.sqrt(distsq(pos, listenerPos) )
                    info.dist = dist
                    info.pos = pos
                    if info.icon then
                        info.icon.Transform:SetPosition(pos:Get() )
                    end
                end
            end
        end
    end
end
scheduler:ExecutePeriodic(1, DoUpdate)

function GetSoundDebugString()
    local lines = {}
    table.insert(lines, "-------SOUND DEBUG-------")
    table.insert(lines, "Looping Sounds")
    for ent,sounds in pairs(loopingSounds) do
        for name,info in pairs(sounds) do
            if info.dist < maxDistance then
                local params = ""
                for k,v in pairs(info.params) do
                    params = params.." "..k.."="..v
                end
                table.insert(lines, string.format("[%s] %s owner:%d %s pos:%s dist:%2.2f volume:%d params:{%s}",
                        name, info.event, info.guid, info.prefab, tostring(info.pos), info.dist, info.volume, params) )
            end
        end
    end
    table.insert(lines, "Recent Sounds")
    for i = soundCount-maxRecentSounds+1, soundCount do
        local index = (i % maxRecentSounds)+1
        if nearbySounds[index] then
            local soundInfo = nearbySounds[index]
            table.insert(lines, string.format("[%d] %s owner:%d %s pos:%s dist:%2.2f volume:%d",
                soundInfo.count, soundInfo.event, soundInfo.guid, soundInfo.prefab, tostring(soundInfo.pos), soundInfo.dist, soundInfo.volume) )
        end
    end
    return table.concat(lines, "\n")
end0033:debugtools.lua:0C12:1:14=5171DA80:16=47d21313:local getinfo = debug.getinfo
local max = math.max
local concat = table.concat

local function filtersource(src)
        if not src then return "[?]" end
        if src:sub(1, 1) == "@" then
                src = src:sub(2)
        end
        return src
end

local function formatinfo(info)
        if not info then return "**error**" end
        local source = filtersource(info.source)
        if info.currentline then
                source = source..":"..info.currentline
        end
        return ("\t%s in (%s) %s (%s) <%d-%d>"):format(source, info.namewhat, info.name or "?", info.what, info.linedefined, info.lastlinedefined)
end

function debugstack(start, top, bottom)
        if not bottom then bottom = 10 end
        if not top then top = 12 end
        start = (start or 1) + 1

        local count = max(2, start)
        while getinfo(count) do
                count = count + 1
        end

        count = count - start

        if top + bottom >= count then
                top = count
                bottom = nil
        end

        local s = {"stack traceback:"}
        for i = 1, top, 1 do
                s[#s + 1] = formatinfo(getinfo(start + i - 1))
        end
        if bottom then
                s[#s + 1] = "\t..."
                for i = bottom , 1, -1 do
                        s[#s + 1] = formatinfo(getinfo(count - i + 1))
                end
        end

        return concat(s, "\n")
end

function debuglocals (level)
        local t = {}
        local index = 1
        while true do
                local name, value = debug.getlocal(level + 1, index)
                if not name then break end
                t[index] = string.format("%s = %s", name, tostring(value))
                index = index + 1
        end
        return table.concat(t, "\n")
end

function dumptable(obj, indent, recurse_levels)
	indent = indent or 1
	recurse_levels = recurse_levels or 10
    if obj then
		local dent = ""
		if indent then
			for i=1,indent do dent = dent.."\t" end
		end
    	if type(obj)==type("") then
    		print(obj)
    		return
    	end
        for k,v in pairs(obj) do
            if type(v) == "table" and recurse_levels>0 then
                print(dent.."K: ",k)
                dumptable(v, indent+1, recurse_levels-1)
            else
                print(dent.."K: ",k," V: ",v)
            end
        end
    end
end

function tabletodictstring(obj, fn)
	if obj == nil then
		return "{ }"
	end
	local s = "{ "
	local first = true
	for k,v in pairs(obj) do
		if not first then 
			s = s..", "
		else
			first = false
		end
		if fn then k,v = fn(k,v) end
		s = s..tostring(k).."="..tostring(v)
	end
	s = s.." }"
	return s
end
function tabletoliststring(obj, fn)
	if obj == nil then
		return "[ ]"
	end
	local s = "[ "
	local first = true
	for i,v in ipairs(obj) do
		if not first then 
			s = s..", "
		else
			first = false
		end
		if fn then v = fn(v) end
		s = s..tostring(v)
	end
	s = s.." ]"
	return s
end
0030:dumper.lua:01CEA:1:14=511C60C2:16=47d21313:--[[ DataDumper.lua
Copyright (c) 2007 Olivetti-Engineering SA

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and a