local Machine = Class(function(self, inst)
	self.inst = inst
	self.turnonfn = nil
	self.turnofffn = nil
	self.ison = false
	self.cooldowntime = 3
	self.caninteract = true
end)

function Machine:TurnOn()
	self.caninteract = false
	self.inst:DoTaskInTime(self.cooldowntime, function() self.caninteract = true end)
	if self.turnonfn then
		self.turnonfn(self.inst)
	end
	self.ison = true
end

function Machine:TurnOff()
	self.caninteract = false
	self.inst:DoTaskInTime(self.cooldowntime, function() self.caninteract = true end)	
	if self.turnofffn then
		self.turnofffn(self.inst)
	end
	self.ison = false
end

function Machine:IsOn()
	return self.ison
end

function Machine:CollectSceneActions(doer, actions)
	if self.caninteract then
		if self:IsOn() then
			table.insert(actions, ACTIONS.TURNOFF)
		else
			table.insert(actions, ACTIONS.TURNON)
		end	
	end
end

return Machine