local LootDropper = Class(function(self, inst)
    self.inst = inst
    self.numrandomloot = nil
    self.randomloot = nil
    self.totalrandomweight = nil
    self.chanceloot = nil
    self.loot = nil
    
end)

function LootDropper:SetLoot( loots )
    self.loot = loots
    self.chanceloot = nil
    self.randomloot = nil
    self.numrandomloot = nil
end

function LootDropper:AddRandomLoot( prefab, weight)
    if not self.randomloot then
		self.randomloot = {}
		self.totalrandomweight = 0
	end
	
    table.insert(self.randomloot, {prefab=prefab,weight=weight} )
    self.totalrandomweight = self.totalrandomweight + weight
end

function LootDropper:AddChanceLoot( prefab, chance)
    if not self.chanceloot then
		self.chanceloot = {}
	end
    table.insert(self.chanceloot, {prefab=prefab,chance=chance} )
end

function LootDropper:PickRandomLoot()
    if self.totalrandomweight and self.totalrandomweight > 0 and self.randomloot then
        local rnd = math.random()*self.totalrandomweight
        for k,v in pairs(self.randomloot) do
            rnd = rnd - v.weight
            if rnd <= 0 then
                return v.prefab
            end
        end
    end
end

function LootDropper:GenerateLoot()
    local loots = {}
    
    if self.numrandomloot then
		for k = 1, self.numrandomloot do
		    local loot = self:PickRandomLoot()
		    if loot then
			    table.insert(loots, loot)
			end
		end
	end
    
    if self.chanceloot then
		for k,v in pairs(self.chanceloot) do
			if math.random() < v.chance then
				table.insert(loots, v.prefab)
			end
		end
	end
    
    if self.loot then
		for k,v in ipairs(self.loot) do
			table.insert(loots, v)
		end
	end
	
	local recipe = GetRecipe(self.inst.prefab)
	if recipe then
		for k,v in ipairs(recipe.ingredients) do
			local amt = math.ceil( v.amount * TUNING.HAMMER_LOOT_PERCENT)
			for n = 1, amt do
				table.insert(loots, v.type)
			end
		end
	end
    
    return loots
end


function LootDropper:SpawnLootPrefab(lootprefab, pt)
    if lootprefab then
        local loot = SpawnPrefab(lootprefab)
        if loot then
			if not pt then
				pt = Point(self.inst.Transform:GetWorldPosition())
			end
	        
			loot.Transform:SetPosition(pt.x,pt.y,pt.z)
	        
			if loot.Physics then
	        
				local angle = math.random()*2*PI
				loot.Physics:SetVel(2*math.cos(angle), 10, 2*math.sin(angle))

				if loot.Physics and self.inst.Physics then
					pt = pt + Vector3(math.cos(angle), 0, math.sin(angle))*(loot.Physics:GetRadius() + self.inst.Physics:GetRadius())
					loot.Transform:SetPosition(pt.x,pt.y,pt.z)
				end
				
				loot:DoTaskInTime(1, 
					function() 
						if not (loot.components.inventoryitem and loot.components.inventoryitem:IsHeld()) then
							if not loot:IsOnValidGround() then
						        PlayFX(loot:GetPosition(), "splash", "splash_ocean", "idle")
								loot:Remove()
							end
						end
					end)
			end
	        
			return loot
		end
    end
end

function LootDropper:DropLoot(pt)
    local prefabs = self:GenerateLoot()
    if not self.inst.components.fueled and self.inst.components.burnable and self.inst.components.burnable:IsBurning() then
        for k,v in pairs(prefabs) do
            local cookedAfter = v.."_cooked"
            local cookedBefore = "cooked"..v
            if PrefabExists(cookedAfter) then
                prefabs[k] = cookedAfter
            elseif PrefabExists(cookedBefore) then
                prefabs[k] = cookedBefore 
            else             
                prefabs[k] = "ash"               
            end
        end
    end
    for k,v in pairs(prefabs) do
        self:SpawnLootPrefab(v, pt)
    end
end

return LootDropper
