class 'mailmanspecial'

mailmanspecial.doMailmanEvent = true
mailmanspecial.mailmanTimer = getRandomRange(25000, 40000)
mailmanspecial.getMailTimer = mailmanspecial.mailmanTimer + getRandomRange(500, 1200)
mailmanspecial.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
mailmanspecial.mailman = nil
mailmanspecial.getMailPerson = nil
mailmanspecial.getMailscore = 50
mailmanspecial.loseMailScore = 50
mailmanspecial.mailDeliverTrigger = false
mailmanspecial.mailGetTrigger = false
mailmanspecial.numDeliverMail = 0
mailmanspecial.numGetMail = 0
mailmanspecial.appliance = "rest0_reception"
mailmanspecial.entryNode = nil
mailmanspecial.exitNode = nil
mailmanspecial.active = true

function mailmanspecial:__init()
end

function mailmanspecial:onLevelInited()
	getProduct("ENVELOP"):setVisible(false)
	getProduct("MAIL"):setVisible(false)
	self.mailDeliverTrigger = pm:hasNotification("trigger mail deliver")
	self.mailGetTrigger = pm:hasNotification("trigger mail get")
end

function mailmanspecial:onNotify(notification)
	if (self.doMailmanEvent == false or scene:isClosed()) then
		return
	end

	if (notification == "trigger mail deliver" and self.mailman == nil) then
		self:doMailMan()
	elseif (notification == "trigger mail get" and self.getMailPerson == nil) then
		self:doGetMailPerson()
	elseif (notification == "trigger mailGetHint" and self.getMailPerson ~= nil) then
		if (hm ~= nil) then
			hm:placeArrow(getArrowIndex("ARROW_HINT_MAIL_QUERY"), self.getMailPerson, 0, -35)
		end
	end	
end

function mailmanspecial:onTick(time)

	if (scene:isStartingMovie() or scene:isPlayingMovie() or scene:isClosed()) then
		return
	end

	if (self.doMailmanEvent == false or self.mailman ~= nil or self.getMailPerson) then
		return
	end

	if (self.mailDeliverTrigger == false) then
		self.mailmanTimer = self.mailmanTimer - time	
		if (self.mailmanTimer <= 0) then
			self:doMailMan()
			self.numDeliverMail = self.numDeliverMail + 1
			self.mailmanTimer = getRandomRange(25000, 70000)
		end
	end

	if (self.mailGetTrigger == false) then
		self.getMailTimer = self.getMailTimer  - time	
		if (self.getMailTimer  <= 0) then
			
			if (self.numGetMail < self.numDeliverMail) then		 
				self:doGetMailPerson()
				self.numGetMail = self.numGetMail + 1
			end
			self.getMailTimer  = getRandomRange(25000, 70000)
		end
	end
end

function mailmanspecial:doMailMan()

	if (self.mailman ~= nil or self:needsMail() == false or self.active == false) then
		return
	end

  	-- create the specialmailman
	self.mailman = pm:createPerson("specialmailman")
	self.mailman:setPosition(grid:getNode(49, 2))

end

function mailmanspecial:needsMail()
	return (getProduct("ENVELOP"):isVisible() == false or getProduct("MAIL"):isVisible() == false)
end

function mailmanspecial:getRandomMailId(checkForVisible)
	local availableMail = {}
	local availableIndex = 0

	if (getProduct("ENVELOP"):isVisible() == checkForVisible or (checkForVisible and tray:hasProduct("ENVELOP"))) then
		availableIndex = availableIndex + 1
		availableMail[availableIndex] = "ENVELOP"
	end
	if (getProduct("MAIL"):isVisible() == checkForVisible or (checkForVisible and tray:hasProduct("MAIL"))) then
		availableIndex = availableIndex + 1
		availableMail[availableIndex] = "MAIL"
	end

	if (availableIndex > 0) then
		local mailIndex = getRandom(availableIndex) + 1
		return availableMail[mailIndex]			
	elseif (checkForVisible == true) then
		local r = getRandom(2)
		if (r == 0) then
			return "ENVELOP"
		elseif (r == 1) then
			return "MAIL"
		end	
	end	

	return ""
end

function mailmanspecial:clearGetMailPerson()
	self.getMailPerson = nil
end

function mailmanspecial:doGetMailPerson()

	if (self.getMailPerson ~= nil or grid:getNode(49, 3):isBlocked() or grid:getNode(19, 28):isBlocked()) then
		return
	end

	local person = pm:createPerson("luacustomer")
	self.getMailPerson = person
	person.score = self.getMailscore
	person:setBaseName(getSpecialRandomCustomerName())
	person.enterNode = self.entryNode
	person.exitNode = self.exitNode
	person:initCustomer(self, self.clearGetMailPerson)
	
	person:qWalkToXY(19, 28)
	person:qWait(300)
	person:qCallback(person, function(p) 
	-- add an order for a room
		local mailId = self:getRandomMailId(true)
		p:createOrder(mailId)
		p:showOrder()
				
		-- no room available
		local mailProduct = getProduct(mailId)
		if (mailProduct:isVisible() == false and not tray:hasProduct(mailId)) then
			p:qRemoveHighlight()
			emily:qWait(200)
			emily:qWalkToAppliance(getAppliance(restaurant.mailSpecial.appliance))
			emily:qSayTimed("TEXT_RESTAURANT_0_NO_MAIL", 2000)
			emily:qCallback(p, function(p)
				p:removeOrder()
				p:qWait(50)
				p:qSetAppearance("ANGRY")
				p:qWait(400)
				p:qWalkToNode(self.exitNode)
				p:qDestroy()
				restaurant.mailSpecial.getMailPerson = nil
				addScore(-restaurant.mailSpecial.loseMailScore)
			end)
		else
			-- hint
			hm:placeArrow(getArrowIndex("ARROW_HINT_MAIL_PICKUP"), mailProduct, (mailProduct:getWidth() / 2), 0)
		end
	end)
end

---------- a specialmailman -------------
class 'specialmailman' (npc)

-- internal variables
-- don't change unless you know what you're doing
specialmailman.timer = 0
specialmailman.counter = 0
specialmailman.handed = 0
specialmailman.state = "wait to enter"
specialmailman.carry = true
specialmailman.order = nil
specialmailman.product = ""

specialmailman.baseSection = "characters"
specialmailman.angryAnimFPS = 4
specialmailman.soundEventBad = "SOUND_EVENT_BAD"
specialmailman.timeUntilAngry = 6000
specialmailman.timeUntilLeave = 3000
specialmailman.targetX = 26
specialmailman.targetY = 20
specialmailman.angryAnim = "IDLE_WAITING"
specialmailman.workAnim = "GIVE_LEFT"
specialmailman.workAnimEmily = "WORK_RIGHT"

function specialmailman:__init(baseName) super(baseName)
end

function specialmailman:onCreate()

	self:setDefaultSection(self.baseSection)
	D2Person.onCreate(self)	
	self:setPosition(grid:getNode(49, 2))
		
	-- walk to our 'wait' position
	self:qWalkToXY(self.targetX, self.targetY)      
	self:qWait(300)
	self:qCallback(self, function(p) 
	-- add an order for mail
		p:createHighlight()
		p.order = createOrder()
		x = -p:getAnchorX() + p:getWidth() / 2
		y = -p:getAnchorY()
		p.order:setX(x)
		p.order:setY(y)
		p.order:setAnchorPointType(BOTTOMCENTER)		
		p:addChild(p.order)
		
		local mail = restaurant.mailSpecial:getRandomMailId(false)
		p.order:addProduct(mail)
		p.product = mail
		p.key = key	
		p.order:popIn()
		
		p.state = "wait to angry"
		-- wait time until we get angry
		p.timer = self.timeUntilAngry	      
		-- get attention
		p:playSound("SOUND_EVENT_ATTENTION")
		
		-- hint
		hm:placeArrow(getArrowIndex("ARROW_HINT_POSTMAN"), self, 0, -35)
	
	end)
	
	-- do it with a package
	self.carry = true
	self:setAppearance("")
		
	self.timer = 0
	
end

function specialmailman:onTick(time)
	
	if (scene:isPlayingMovie()) then
		return
	end
   
	if (self.state == "wait to angry") then
    
    	-- wait until we get annoyed
    	self.timer = self.timer - time
		if (self.timer < 0) then
      
			self.state = "wait to leave"
			-- wait time until we leave
			self.timer = self.timeUntilLeave
			-- animate specialmailman
			self:setAppearance("ANNOYED")
			self:animate(self.angryAnim, 1, self.angryAnimFPS)
      
    	end
    
	elseif (self.state == "wait to leave") then
  
		-- wait until we leave pissed
		self.timer = self.timer - time
		if (self.timer < 0) then
	  
			self.state = "walking out"
			-- disable highlight so we can't click the specialmailman anymore
			self:getHighlight():clear()    
			self:getHighlight():setActive(false)	    
			self:removeOverhead()
			-- walk to exit
			self:playSound(self.soundEventBad)
			self:setAppearance("")
			self:qWalkToXY(49, 3)
			self:qCallback(self, function(p) 
				restaurant.mailSpecial.mailman = nil
			end)
			self:qDestroy()
			
		end   
	end

end

function specialmailman:onClick()

	-- if the specialmailman is already selected then the player already
	-- clicked on him. in that case we ignore the click.
	if (self:isSelected() == false) then
  
		-- change the specialmailman state. this makes sure
    	-- he doesn't run away while emily is trying to retrieve
		-- the package
		self.state = "handing over"
    
		-- make emily get the package
		emily:qWorkOn(self)
    
		-- select the specialmailman
		-- this makes sure that we can't receive multiple packages
		-- from him at once
		self:setSelected(true)
    
	end
	
end

function specialmailman:onWorkStart(task)

	-- disable selection
	self:setSelected(false)
	-- disable highlight so we can't click the specialmailman anymore
	self:getHighlight():clear()    
	self:getHighlight():setActive(false)	 

	-- animate emily
	emily:animate(self.workAnimEmily, 1)
	emily:playSound("SOUND_PICKUP_POST_CARD")
  
	-- animate specialmailman
	self:animate(self.workAnim, 1)
  		
	-- time it takes to transfer the package
	task:setDuration(500)
	
	return true
	
end

function specialmailman:onWorkComplete(task)

	self:animate("IDLE", 0)
	emily:animate("IDLE", 0)

	-- the specialmailman leaves after handing over the package
	self.state = "walking out"
	self.carry = false
	self.order:popOut()
	
	getProduct(self.product):setVisible(true)

	-- walk to exit
	self:qWalkToXY(49, 3)
	self:qCallback(self, function(p) 
		restaurant.mailSpecial.mailman = nil
	end)
	self:qDestroy()

	-- trophy check
	tm:checkDeliveriesAccepted()

end

function specialmailman:getWorkNode()
  
	return grid:getNode(self.targetX - 3, self.targetY)
  
end

function specialmailman:calcImageName(input)

	res = D2Person.calcImageName(self, input)
  
	if (self.carry) then
		res = res .. "_CARRY"
	end

	return res
  
end
