class 'keyspecial'

keyspecial.doKeyCustomers = true
keyspecial.deliverKeyTimer = getRandomRange(3000, 6000)
keyspecial.getKeyTimer = keyspecial.deliverKeyTimer + getRandomRange(10000, 40000)
keyspecial.getKeyPerson = nil
keyspecial.activeKeyCustomer = false
keyspecial.score = 50
keyspecial.keyDeliverTrigger = false
keyspecial.keyGetTrigger = false
keyspecial.numDeliverKeys = 0
keyspecial.numGetKeys = 0

function keyspecial:__init()
end

function keyspecial:onLevelInited()
	self.keyDeliverTrigger = pm:hasNotification("trigger key deliver")
	self.keyGetTrigger = pm:hasNotification("trigger key get")
end

function keyspecial:onNotify(notification)

	if (notification == "trigger keyGetHint") then
		if (hm ~= nil and self.getKeyPerson ~= nil) then
			hm:placeArrow(getArrowIndex("ARROW_HINT_ROOM_REQUESTED"), self.getKeyPerson, 0, -35)			
		end
	end

	if (self.doKeyCustomers == false or self.activeKeyCustomer == true or self:checkKeyActive() or scene:isClosed()) then
		return
	end

	if (notification == "trigger key deliver") then
		self:doKeyPerson()

	elseif (notification == "trigger key get") then
		self:doGetKeyPerson()	
		
	end
	
end

function keyspecial:onTick(time)

	if (scene:isStartingMovie() or scene:isPlayingMovie() or scene:isClosed()) then
		return
	end

	if (self.doKeyCustomers == false or self.activeKeyCustomer == true or self:checkKeyActive()) then
		return
	end

	if (self.keyDeliverTrigger == false) then
		self.deliverKeyTimer = self.deliverKeyTimer - time	
		if (self.deliverKeyTimer <= 0) then
			self:doKeyPerson()
			self.deliverKeyTimer = getRandomRange(25000, 70000)
		end
	end
	
	if (self.activeKeyCustomer == true) then
		return
	end

	if (self.keyGetTrigger == false) then
		self.getKeyTimer = self.getKeyTimer - time
		if (self.getKeyTimer <= 0) then
			if (self.numGetKeys < self.numDeliverKeys) then		 
				self:doGetKeyPerson()
			end
			self.getKeyTimer = getRandomRange(25000, 70000)
		end	
	end	
end

function keyspecial:doKeyPerson()

	if (grid:getNode(0, 1):isBlocked() or grid:getNode(15, 28):isBlocked()) then
		return
	end

	local person = pm:createPerson("fakecustomer")
	person:setBaseName(getSpecialRandomCustomerName())
	person:setPosition(grid:getNode(0, 1))
	person:qWalkToXY(15, 28)
	person:qAnimateWait("IDLE", 1)
	person:qCallback(self, self.onArrive)
	person:qWait(300)
	person:qWalkToXY(49, 3)
	person:qDestroy()

	self.activeKeyCustomer = true
	
end

function keyspecial:checkKeyActive()

	return  getProduct("KEY_1_DROP"):isVisible() or
		getProduct("KEY_2_DROP"):isVisible() or
		getProduct("KEY_3_DROP"):isVisible()	
		
end

function keyspecial:onArrive()
		
		local r = getRandomRange(0, 3)
		local p = nil
		
		if (r == 0) then
			p = getProduct("KEY_1_DROP")
		elseif (r == 1) then
			p = getProduct("KEY_2_DROP")
		else
			p = getProduct("KEY_3_DROP")
		end	
	
		p:playSound("SOUND_PLACE_KEY")
		p:setVisible(true)
		p:setClickable(true)
		
		self.activeKeyCustomer = false
		
		hm:openHint(getHintIndex("HINT_KEY_DROPED"), p:getScreenX() + (p:getWidth() / 2), p:getScreenY())
		--hm:placeArrow(getArrowIndex("ARROW_HINT_KEY_RETURNED"), p, 12, 15);
end

function keyspecial:getKeyId()

	local availableKeys = {}
	local availableIndex = 0

	if (getProduct("KEY_1"):getStock() >= 1 or tray:hasProduct("KEY_1")) then
		availableIndex = availableIndex + 1
		availableKeys[availableIndex] = "KEY_1"
	end
	if (getProduct("KEY_2"):getStock() >= 1 or tray:hasProduct("KEY_2")) then
		availableIndex = availableIndex + 1
		availableKeys[availableIndex] = "KEY_2"
	end
	if (getProduct("KEY_3"):getStock() >= 1 or tray:hasProduct("KEY_3")) then
		availableIndex = availableIndex + 1
		availableKeys[availableIndex] = "KEY_3"
	end	

	if (availableIndex > 0) then
		local keyIndex = getRandom(availableIndex) + 1
		return availableKeys[keyIndex]			
	else
		local r = getRandom(3)
		if (r == 0) then
			return "KEY_1"
		elseif (r == 1) then
			return "KEY_2"
		else
			return "KEY_3"
		end	
	end	
end

function keyspecial:clearGetKeyPerson()
	self.activeKeyCustomer = false
	self.getKeyPerson = nil
end

function keyspecial:doGetKeyPerson()

	if (grid:getNode(49, 3):isBlocked() or grid:getNode(15, 28):isBlocked()) then
		return
	end

	self.numGetKeys = self.numGetKeys + 1

    local s = self.score
	if (um:hasUpgrade("DECO_SLINGERS_L_UPGRADE") ~= 1) then
		s = s + getInteger("0_UPGRADE_HOTEL_GUEST_EXTRA_POINTS")
	end

	local person = pm:createPerson("luacustomer")
	self.getKeyPerson = person
	person.score = s
	person:setBaseName(getSpecialRandomCustomerName())
	person.enterNode = grid:getNode(49, 3)
	person.exitNode = grid:getNode(0, 0)
	person:initCustomer(self, self.clearGetKeyPerson)

	person:qWalkToXY(15, 28)
	person:qWait(300)
	person:qCallback(person, function(p) 
	    -- add an order for a room
		local keyId = self:getKeyId()
		p:createOrder(keyId)
		p:showOrder()
		
		local keyProduct = getProduct(keyId)
		
		-- no room available
		if (keyProduct:getStock() == 0 and not tray:hasProduct(keyId)) then
			p:qRemoveHighlight()
			emily:qWait(200)
			emily:qWalkToAppliance(getAppliance("rest0_reception"))
			emily:qSayTimed("RESTAURANT_0_HOTEL_FULL", 2500)
			emily:qCallback(p, function(p)
				p:removeOrder()
				p:qWait(300)
				p:qWalkToXY(49, 3)
				p:qDestroy()
				restaurant.keySpecial.activeKeyCustomer = false
				restaurant.keySpecial.getKeyPerson = nil
			end)
		else
			-- add a hint arrow
			hm:placeArrow(getArrowIndex("ARROW_HINT_KEY_ORDERED"), keyProduct, (keyProduct:getWidth() / 2), 0)
		end
		
	end)

	self.activeKeyCustomer = true
	
end

