-- set event

-- day class
class 'day0' (interface)

day0.sequenceStart1 = nil
day0.sequenceStart2 = nil
day0.sequenceStart3 = nil
day0.sequenceEnd = nil
day0.roofAnim = nil
day0.doorLeft = nil
day0.registeredObjectIds = 
{ 
"intro_snow_0",
"intro_snow_1",
"intro_snow_2",
"intro_snow_3",
"intro_snow_4",
}
day0.snowObjects = {}
day0.snowIndex = 1

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	francois = pm:createPerson("francois")
	francois:setPosition(grid:getNode(15,30))
	francois:setBaseName("INGAME_PERSON_FRANCOIS_WINTER")
	francois:setName("FRANCOIS")
	francois:setAppearance("CHEERING")
	
	sleigh = pm:createPerson("npc")
	sleigh:setPosition(grid:getNode(49,32))
	sleigh:setBaseName("INGAME_PERSON_SLEIGH")	
	sleigh:setVisible(false)
	sleigh:setWalkTimePerNode(150)
	sleigh:setShadowVisible(false)
	
	self.roofAnim = om:getObject("ANIM_ROOF")
	self.roofAnim:setAcceptingTasks(true)
	
	self.doorLeft = om:getObject("OBJECT_DOOR_L")
	self.doorLeft:setAcceptingTasks(true)
	
	emily:setPosition(grid:getNode(32,30))
	emily:setAppearance("SNOW_OFFENDED")
	
	local particle = level:getLayer(2):addParticleEffectAfter("PARTICLE_SNOW_LEVEL_INTRO")
	particle:play()
	
	self.sequenceStart1 = 
	{
		{ "scene",			"qStartMovie",			false, 1							},
		{ "emily",			"qWait",				1000								},
		{ "emily",			"qSay",					"TEXT_RESTAURANT99_DAY0_0"			},
		{ "francois",		"qAnimateWait",			"CHEERING_STOP", 1					},
		{ "francois",		"qAnimate",				"IDLE_STOP", 0						},
		{ "emily",			"qSay",					"TEXT_RESTAURANT99_DAY0_1"			},		
		{ "francois",		"qSay",					"TEXT_RESTAURANT99_DAY0_2"			},
		{ "emily",			"qSay",					"TEXT_RESTAURANT99_DAY0_3"			},		
		
		{ "emily",			"qSetAppearance",		"SNOW"								},
	}
	
	self.sequenceStart2 = 
	{
		{ "emily",			"qSay",					"TEXT_RESTAURANT99_DAY0_4"			},	
		{ "emily",			"qSayAskName",			"TEXT_RESTAURANT99_DAY0_5"			},
		{ "emily",			"qSayAskDifficulty",	"TEXT_RESTAURANT99_DAY0_6"			},
	}		
	
	self.sequenceStart3 = 
	{
		{ "scene",			"qNotify",				"show bar"							},
		{ "emily",			"qWalkToNode",			self.snowObjects[1]:getWorkNode()	},	
		{ "scene",			"qCallback",	self,	function(self) self.snowObjects[self.snowIndex]:getHighlight():setColor(0xff00ff00) self.snowObjects[self.snowIndex]:setSelected(true) end },		
		{ "scene", 			"qFinishMovie" 												},
		{ "scene", 			"qStartGame" 												},		
	}

	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",			false, 1							},

		{ "",				"parallel"													},		
		{ "francois",		"qSetAppearance",		""									},
		{ "francois",		"qWalkToXY",			27, 11								},
		{ "emily",			"qWait",				1400								},
		{ "emily",			"qWalkToXY",			23, 10								},	

		{ "",				"sequential"												},		
		{ "doorLeft",		"qAnimate",				"OBJECT_DOOR_OPEN",	0				},
		{ "emily",			"qWait",				100									},
		{ "emily",			"qWalkToXY",			23, 0								},	
		{ "emily",			"qDestroy"													},	
		{ "francois",		"qWalkToXY",			23, 0								},	
		{ "doorLeft",		"qWait",				300									},
		{ "doorLeft",		"qAnimate",				"OBJECT_DOOR_L",	0				},
		{ "francois",		"qDestroy"													},	
		{ "scene",			"qCallback",	self,	function(self) level:shakeScreen(true) end	},
		{ "scene",			"qWait",				80									},
		{ "scene",			"qCallback",	self,	function(self) level:shakeScreen(false) end	},
		{ "scene",			"qWait",				30									},
		{ "roofAnim",		"qAnimateWait",			"ANIM_ROOF", 1, false, 12, true		},
		{ "doorLeft",		"qWait",				1000								},
		{ "doorLeft",		"qCallback",			self, function(s) player:setSeenIntro(true) end },	
		{ "scene", 			"qFinishMovie" 												},
		{ "scene", 			"qFinishGame" 												},
	}

	--create a highlight for the first showObject
	self.snowObjects[self.snowIndex]:createHighlight()
	self.snowObjects[self.snowIndex]:getHighlight():setHighlighted(false)
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(5)
	eventBar:setProgress(0)
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("SNOW_BAR", player:getCurrentResourceSection())
end

function day0:onLevelInited()
	qSequence(self.sequenceStart1)
	if (isNewPlayer() == true) then	
		qSequence(self.sequenceStart2)
	end
	qSequence(self.sequenceStart3)

end

function day0:onDayBegin()
end

function day0:onNotify(notification)
	if (notification == "show bar") then
		eventBar:animateToActive()
		eventBar:raiseCurtain()		
	end
end

function day0:createObject(desc)
  	result = nil
  
	for index, value in ipairs(self.registeredObjectIds) do
		if (value == desc:getObjectId()) then
			result = snowObject()
			result:setType(desc:getType())
			self.snowObjects[index] = result
			self.snowObjects[index].clickedOn = false
		end
	end
	
  	return result
end

-- set day
day = day0()

-- a hidden object
class 'snowObject' (D2Object)

-- internal variables

function snowObject:__init() super()
end

function snowObject:onCreate()
	self:setDefaultSection(player:getCurrentResourceSection())
	self:animate(self:getBaseName(), 0)
end

function snowObject:onClick()
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
	
		if (self.clickedOn == false) then
			-- make emily go to person to talk
			emily:qWorkOn(self)   
			self.clickedOn = true
			self:clearOverhead()    
		end
	end
end

function snowObject:onWorkStart(task)
	-- disable highlight so we can't click the attentionPerson anymore
	self:removeHighlight()
		
	-- time it takes to transfer the package
	task:setDuration(2000)

	-- let emily animate
	emily:animate("SNOW_DOWN", 4)
	emily:setShadowVisible(false)

	-- play sound
	self:playSound("SOUND_USE_SNOW_SHOVEL")		

	return true
end

function snowObject:onWorkComplete(task)
	emily:animate("IDLE", 0)	
	emily:setShadowVisible(true)
	emily:setLocation(0, 0, 0)

	-- hide the item
	self:setVisible(false)

	-- update the event bar
	eventBar:setProgress(day.snowIndex)

	if (day.snowIndex == 2) then
		sleigh:playSound("SOUND_SLED_OVER_SNOW")
		sleigh:qSetVisible(true)
		sleigh:qWalkToXY(0, 32)
		sleigh:qDestroy()
	end

	if (day.snowIndex == 5) then
		-- lower curtain
		eventBar:animateToDeactive()
		
		qSequence(day.sequenceEnd)
	else
		day.snowIndex = day.snowIndex + 1
		emily:qWalkToNode(day.snowObjects[day.snowIndex]:getWorkNode())
		
		day.snowObjects[day.snowIndex]:createHighlight()
		day.snowObjects[day.snowIndex]:getHighlight():setColor(0xff00ff00)
		day.snowObjects[day.snowIndex]:setSelected(true)
	end
end
