-- day class
class 'day9' (interface)

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- Mom and Dad
	mom = pm:createPerson("npc")
    mom:setBaseName("INGAME_PERSON_EVELYN")
    mom:setPosition(entryNode)
    mom:setVisible(false)
    mom:setType("mom")
	dad = pm:createPerson("npc")
    dad:setBaseName("INGAME_PERSON_EDWARD")
    dad:setPosition(entryNode)
    dad:setVisible(false)    
    dad:setType("dad")

	momAndDadEntered = false
    	
	-- Angela
	angela = pm:createPerson("story_character")
    angela:setBaseName("INGAME_PERSON_ANGELA")
    angela:setPosition(entryNode)
    angela:initTimer(30000, 50000)
	angela.destX = 34
	angela.destY = 26
	angela.talkPositionX = 31
	angela.talkPositionY = 26
    angela.sequence =
	{	
		{ "scene",			"qStartMovie",		1								},	
		{ "angela",			"qSetAppearance",	"ENTHOUSIASTIC"					},
		{ "angela",			"qSay",				"RESTAURANT4_DAY9_0"			},
		{ "dad",			"qSetAppearance",	"HAPPY"							},
		{ "dad",			"qSay",				"RESTAURANT4_DAY9_1"			},
		{ "mom",			"qSetAppearance",	"HAPPY"							},		
		{ "mom",			"qSay",				"RESTAURANT4_DAY9_2"			},
		{ "emily",			"qSetAppearance",	"LAUGH"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_3"			},
		{ "angela",			"qSay",				"RESTAURANT4_DAY9_4"			},
		{ "scene", 			"qFinishMovie" 										},
	}
    angela.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "angela",			"qSetAppearance",	""								},					
		{ "dad",			"qSetAppearance",	""								},					
		{ "mom",			"qSetAppearance",	""								},					
		{ "",				"parallel"											},
		{ "dad",			"qWalkToNode",		entryNode						},
		{ "dad",			"qSetVisible",		false							},
		{ "mom",			"qWalkToNode",		entryNode						},
		{ "mom",			"qSetVisible",		false							},				
		{ "angela",			"qWait",			500								},
		{ "angela",			"qWalkToNode",		entryNode						},
		{ "angela",			"qSetVisible",		false							},
		{ "",				"parallel"											},
	}	
	angela.entered = false

	-- Elvis
	elvis = pm:createPerson("story_character")
    elvis:setBaseName("INGAME_PERSON_ELVIS")
    elvis:setPosition(entryNode)
    elvis:initTimer(40000, 60000)
	elvis.destX = 34
	elvis.destY = 26
	elvis.talkPositionX = 31
	elvis.talkPositionY = 26
    elvis.sequence =
	{	
		{ "scene",			"qStartMovie",		3								},	
		{ "emily",			"qSetAppearance",	"HAPPY"							},					
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_20"			},
		{ "elvis",			"qSay",				"RESTAURANT4_DAY9_21"			},
		{ "emily",			"qSetAppearance",	"NEUTRAL"						},					
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_22"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_220"			},		
		{ "elvis",			"qSetAppearance",	"SAD"							},					
		{ "elvis",			"qSay",				"RESTAURANT4_DAY9_221"			},
		{ "elvis",			"qSetAppearance",	"SAD_HANDS"						},					
		{ "elvis",			"qSay",				"RESTAURANT4_DAY9_222"			},	
		{ "scene", 			"qFinishMovie" 										},
	}
    elvis.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "elvis",			"qSetAppearance",	""								},					
		{ "elvis",			"qWalkToNode",		entryNode						},
		{ "elvis",			"qSetVisible",		false							},
		{ "",				"parallel"											},
	}			

	-- Antonio
	antonio = pm:createPerson("story_character")
    antonio:setBaseName("INGAME_PERSON_ANTONIO")
    antonio:setPosition(grid:getNode(33, 0))
    antonio:initTimer(40000, 60000)
	antonio.destX = 34
	antonio.destY = 26
	antonio.talkPositionX = 31
	antonio.talkPositionY = 26
    antonio.sequence =
	{	
		{ "scene",			"qStartMovie",		1								},	
		{ "emily",			"qSetAppearance",	"HAPPY"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_38"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY9_39"			},				
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_40"			},				
		{ "antonio",		"qSetAppearance",	"PROUD"							},
		{ "antonio",		"qSay",				"RESTAURANT4_DAY9_41"			},				
		{ "scene", 			"qFinishMovie" 										},
	}
    antonio.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},
		{ "antonio",		"qSetAppearance",	""								},					
		{ "antonio",		"qWalkToNode",		entryNode						},
		{ "antonio",		"qSetVisible",		false							},
		{ "",				"parallel"											},
	}
	
	-- Francois (dummy for cleaner)
	francois = pm:createPerson("story_character")
    francois:setBaseName("INGAME_PERSON_FRANCOIS_WINTER")
    francois:setPosition(grid:getNode(33, 0))
    francois:initTimer(40000, 60000)
    francois:setAlpha(0)
	francois.destX = 34
	francois.destY = 26
	francois.talkPositionX = 31
	francois.talkPositionY = 26
	francois.optional = false
    francois.sequence =
	{	
		{ "scene",			"qStartMovie",		1								},	
		{ "cleaner",		"qWalkToXY",		34, 26							},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_45"			},
		{ "emily",			"qSetAppearance",	"HAPPY"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_46"			},
		{ "cleaner",		"qSetAppearance",	"LAUGH"							},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_47"			},
		{ "emily",			"qAnimateWait",		"LAUGH", 2	                	},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_48"			},
		{ "scene", 			"qFinishMovie" 										},
	}
    francois.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},
		{ "emily",			"qAnimate",			"IDLE", 0						},
		{ "",				"parallel"											},
		{ "francois",		"qWalkToNode",		entryNode						},
		{ "francois",		"qSetVisible",		false							},
		{ "cleaner",		"qSetAppearance",	""								},					
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()			},
		{ "",				"parallel"											},
	}		
	
	-- Maggie
	maggie = pm:createPerson("story_character")
    maggie:setBaseName("INGAME_PERSON_MAGGIE")
    maggie:setPosition(grid:getNode(33, 0))
    maggie:initTimer(40000, 60000)
	maggie.destX = 34
	maggie.destY = 26
	maggie.talkPositionX = 31
	maggie.talkPositionY = 26
    maggie.sequence =
	{	
		{ "scene",			"qStartMovie",		2								},	
		{ "maggie",			"qSetAppearance",	"HAPPY"							},
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_55"			},
		{ "emily",			"qSetAppearance",	"LAUGH"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_56"			},
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_57"			},
		{ "scene", 			"qFinishMovie" 										},
	}
    maggie.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "maggie",			"qSetAppearance",	""								},					
		{ "maggie",			"qWalkToNode",		entryNode						},
		{ "maggie",			"qSetVisible",		false							},
		{ "",				"parallel"											},
	}	
	
	angela:setActive()
	angela:setNextCharacter(elvis)
	elvis:setNextCharacter(antonio)	
	antonio:setNextCharacter(francois)	
	francois:setNextCharacter(maggie)	

	paul = pm:createPerson("npc")
	paul:setBaseName("INGAME_PERSON_PAUL_WINTER")
	paul:setDefaultSection("characters")
	paul:setPosition(grid:getNode(27, 0))

	richard = pm:createPerson("npc")
	richard:setBaseName("INGAME_PERSON_RICHARD_WINTER")
	richard:setDefaultSection("characters")
	richard:setPosition(grid:getNode(27, 0))

	child = pm:createPerson("npc")
	child:setBaseName("INGAME_CUSTOMER_MALE_WINTER_CHILD")
	child:setDefaultSection("customers")
	child:setPosition(grid:getNode(33, 0))

	customer1 = pm:createPerson("fakecustomer")
	customer1:setBaseName("INGAME_CUSTOMER_MALE_WINTER_REGULAR")
	customer1:setDefaultSection("customers")
	customer1:setPosition(grid:getNode(33, 0))

	customer2 = pm:createPerson("fakecustomer")
	customer2:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_DESIGNER")
	customer2:setDefaultSection("customers")
	customer2:setPosition(grid:getNode(33, 0))

	customer3 = pm:createPerson("fakecustomer")
	customer3:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_YUPPIES")
	customer3:setDefaultSection("customers")
	customer3:setPosition(grid:getNode(33, 0))
	
	mo = pm:createPerson("npc")
	mo:setBaseName("INGAME_PERSON_MO_BROKEN")
	mo:setDefaultSection("characters")
	mo:setPosition(grid:getNode(33, 0))

	tashi = pm:createPerson("npc")
    tashi:setBaseName("INGAME_PERSON_TASHI")
	tashi:setDefaultSection("characters")
	tashi:setPosition(grid:getNode(33, 0))
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",		3								},
	
		{ "emily",			"qWalkToXY",		21, 25							},	
		{ "emily",			"qSetAppearance",	"THINKING"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_000"			},		
		{ "cleaner",		"qWalkToXY",		24, 25							},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_001"			},		
		{ "emily",			"qSetAppearance",	""								},				
		{ "cleaner",		"qSetAppearance",	"THINK"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_002"			},	
	
		{ "",				"parallel"											},				
		{ "mo",				"qWalkToXY",		17, 25							},
		{ "tashi",			"qWait",			1000							},
		{ "tashi",			"qWalkToXY",		14, 25							},
		{ "",				"sequential"										},				
		{ "emily",			"qSetAppearance",	"HAPPY"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_003"			},		
		{ "cleaner",		"qSetAppearance",	""								},				
		{ "mo",				"qSetAppearance",	"HAPPY"							},				
		{ "mo",				"qSay",				"RESTAURANT4_DAY9_004"			},		
		{ "tashi",			"qSetAppearance",	"HAPPY"							},				
		{ "tashi",			"qSay",				"RESTAURANT4_DAY9_005"			},				
		{ "maggie",			"qSetVisible",		true							},
		
		{ "",				"parallel"											},				
		{ "maggie",			"qWalkToXY",		19, 23							},
		{ "customer1",		"qWait",			1000							},
		{ "customer1",		"qWalkToXY",		17, 16							},
		{ "customer2",		"qWait",			2000							},
		{ "customer2",		"qWalkToXY",		21, 19							},
		{ "customer3",		"qWait",			3000							},
		{ "customer3",		"qWalkToXY",		25, 18							},
						
		{ "",				"sequential"										},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_006"			},		
		{ "maggie",			"qSetAppearance",	"NERVOUS"						},				
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_007"			},		
		{ "maggie",			"qWalkToXY",		6, 26							},
		{ "maggie",			"qSetAppearance",	"HAPPY"							},				
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_008"			},		
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_009"			},		
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_010"			},		
		{ "maggie",			"qSay",				"RESTAURANT4_DAY9_011"			},		
		
		{ "maggie",			"qWait",			2000							},		
		
		{ "",				"parallel"											},				
		{ "mo",				"qWalkToXY",		33, 0							},
		{ "mo",				"qSetVisible",		false							},
		{ "tashi",			"qWait",			1000							},
		{ "tashi",			"qWalkToXY",		33, 0							},
		{ "tashi",			"qSetVisible",		false							},
		{ "customer1",		"qWait",			2000							},
		{ "customer1",		"qWalkToXY",		33, 0							},
		{ "customer1",		"qSetVisible",		false							},
		{ "customer2",		"qWait",			3000							},
		{ "customer2",		"qWalkToXY",		33, 0							},
		{ "customer2",		"qSetVisible",		false							},
		{ "customer3",		"qWait",			4000							},
		{ "customer3",		"qWalkToXY",		33, 0							},
		{ "customer3",		"qSetVisible",		false							},
		{ "maggie",			"qWait",			5000							},
		{ "maggie",			"qWalkToXY",		33, 0							},
		{ "maggie",			"qSetVisible",		false							},
		{ "",				"sequential"										},				
				
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										},
	}	
	
	-- End sequence
	self.sequenceFinish = 
	{	
		{ "scene",			"qStartMovie",		true, 1							},
		{ "",				"sequential"										},

		{ "cleaner",		"qWalkToXY",		14, 24							},

		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_600"			},	
		{ "emily",			"qWalkToXY",		22, 24							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_601"			},	
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_602"			},	
		{ "cleaner",		"qSetAppearance",	"THINK"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_603"			},	
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_604"			},	
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_605"			},			
		
		{ "",				"parallel"											},
		{ "customer1",		"qSetVisible",		true							},
		{ "customer1",		"qSitAt",			om:getTable(0), 0				},
		{ "customer2",		"qSetVisible",		true							},
		{ "customer2",		"qSitAt",			om:getTable(0), 1				},
		{ "customer3",		"qSetVisible",		true							},
		{ "customer3",		"qSitAt",			om:getTable(0), 2				},		
		
		{ "child",			"qWait",			500								},
		{ "child",			"qSetVisible",		true							},
		{ "child",			"qWalkToXY",		16, 18							},

		{ "mo",				"qWait",			1200							},
		{ "mo",				"qWalkToXY",		38, 14							},
		{ "mo",				"qSetVisible",		true							},

		{ "tashi",			"qWait",			2000							},
		{ "tashi",			"qSetVisible",		true							},
		{ "tashi",			"qWalkToXY",		41, 14							},

		{ "maggie",			"qSetVisible",		true							},
		{ "maggie",			"qWalkToXY",		26, 17							},		

		{ "",				"sequential"										},		
		{ "paul",			"qSetVisible",		true							},
		{ "paul",			"qWalkToXY",		19, 24							},
		{ "paul",			"qSetAppearance",	"TIRED"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_6061"			},	
		{ "emily",			"qSetAppearance",	"SURPRISED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_606"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_607"			},	
		{ "paul",			"qSetAppearance",	"SERIOUS"						},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_608"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_609"			},	
		{ "cleaner",		"qSetAppearance",	"ROLLEYES"						},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_610"			},	
		{ "paul",			"qSetAppearance",	"ROLLEYES"						},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_611"			},	
		{ "cleaner",		"qSetAppearance",	""								},				
		{ "paul",			"qSetAppearance",	"SERIOUS"						},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_612"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_613"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_614"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_615"			},	
		{ "emily",			"qSetAppearance",	"SURPRISED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_616"			},	
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_617"			},	
		{ "richard",		"qSetVisible",		true							},
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_618"			},			
		{ "richard",		"qWalkToXY",		25, 24							},		
		{ "emily",			"qSetAppearance",	"SURPRISED"						},				
		{ "paul",			"qSetAppearance",	"SURPRISED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_619"			},			
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_620"			},			
		{ "richard",		"qSetAppearance",	"SORRY"							},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_621"			},			
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_622"			},			
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_623"			},			
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_624"			},			
		{ "richard",		"qSetAppearance",	"SORRY"							},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_625"			},			
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_626"			},			
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_627"			},			
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_628"			},			
		{ "emily",			"qSetAppearance",	"SURPRISED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_629"			},			
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_630"			},			
		{ "cleaner",		"qSetAppearance",	"THINK"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_631"			},	
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_632"			},	
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_633"			},	
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_634"			},	
				
		{ "emily",			"qSayChoice",		"RESTAURANT4_DAY9_67", "FRANCOIS", "RICHARD", "PAUL", "", "" },
	}	
	
	-- Choices
	self.sequenceChoseFrancois = 
	{
		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_900"			},
		{ "cleaner",		"qSetAppearance",	"SHOCKED"						},				
		{ "paul",			"qSetAppearance",	"SHOCK"							},				
		{ "richard",		"qSetAppearance",	"SHOCK"							},				
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_901"			},	

		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_902"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_903"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_904"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_905"			},
		{ "paul",			"qSetAppearance",	"SAD"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_906"			},
		{ "richard",		"qSetAppearance",	"SERIOUS"						},				
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_907"			},

		{ "",				"parallel"											},
		{ "richard",		"qWalkToXY",		27, 12							},
		{ "richard",		"qSetAppearance",	"SMUG"							},				
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_908"			},
		{ "richard",		"qWalkToXY",		33, 0							},
		{ "richard",		"qSetVisible",		false							},
		{ "paul",			"qWait",			1000							},
		{ "paul",			"qWalkToXY",		33, 0							},
		{ "paul",			"qSetVisible",		false							},

		{ "",				"sequential"										},		
		{ "cleaner",		"qSetAppearance",	"SHOCKED"						},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY9_909"			},
		{ "emily",			"qSetAppearance",	"LAUGH"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_910"			},

		{ "cleaner",		"qSetAppearance",	""								},				
		{ "cleaner",		"qWalkToXY",		20, 24							},
		{ "cleaner",		"qWait",			500								},				
		{ "cleaner",		"qSetVisible",		false							},
		{ "emily",			"qSetAppearance",	"HUG_FRANCOIS"					},				
		{ "emily",			"qWait",			3000							},				
		{ "cleaner",		"qSetVisible",		true							},
		{ "emily",			"qSetAppearance",	""								},				
		
		-- little kid
		{ "child",			"qSay",				"RESTAURANT4_DAY9_911"			},	
		{ "child",			"qSetAppearance",	"POINT"							},				
		{ "child",			"qSay",				"RESTAURANT4_DAY9_912"			},	

		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},		
	}	

	self.sequenceChoseRichard = 
	{
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_800"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_801"			},
		{ "emily",			"qSetAppearance",	"DISAPPROVE"					},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_802"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_803"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_804"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_805"			},
		{ "richard",		"qSetAppearance",	"SHOCK"							},				
		{ "emily",			"qSetAppearance",	"CRYING"						},						
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_806"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_807"			},
		{ "emily",			"qSetAppearance",	"DISAPPROVE"					},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_808"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_809"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_810"			},
		{ "paul",			"qSetAppearance",	"sad"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_811"			},
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_812"			},
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_813"			},
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_814"			},
		{ "paul",			"qWalkToXY",		33, 0							},
		{ "paul",			"qSetVisible",		false							},
		{ "richard",		"qSay",				"RESTAURANT0_DAY5_21"			},
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT0_DAY5_21"			},
		{ "richard",		"qSetAppearance",	"SMUG"							},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_815"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_816"			},
		{ "richard",		"qWalkToXY",		20, 24							},
		{ "richard",		"qSetVisible",		false							},
		{ "emily",			"qAnimate",			"KISS_RICHARD", 0				},				
		{ "emily",			"qWait",			3000							},				
		{ "emily",			"qAnimate",			"IDLE", 0						},				
		{ "richard",		"qSetVisible",		true							},

		-- little kid
		{ "child",			"qSay",				"RESTAURANT4_DAY9_911"			},	
		{ "child",			"qSetAppearance",	"POINT"							},				
		{ "child",			"qSay",				"RESTAURANT4_DAY9_912"			},	

		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},		
	}	

	self.sequenceChosePaul = 
	{
		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_700"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_701"			},

		{ "paul",			"qSetAppearance",	"SAD"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_811"			},
		{ "paul",			"qWalkToXY",		26, 12							},
		{ "emily",			"qSetAppearance",	"CONFUSED"						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_702"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_703"			},
		{ "paul",			"qWalkToXY",		20, 24							},
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_704"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_705"			},

		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_706"			},
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_707"			},
		{ "richard",		"qSetAppearance",	"THINKING"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_708"			},
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_709"			},
		{ "paul",			"qSetAppearance",	"SHOCK"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_710"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_711"			},
		{ "paul",			"qSetAppearance",	"BLUSH"							},				
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_712"			},
		{ "paul",			"qSay",				"RESTAURANT4_DAY9_713"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY9_714"			},

		{ "paul",			"qSetVisible",		false							},
		{ "emily",			"qAnimate",			"KISS_PAUL", 0					},				
		{ "emily",			"qWait",			3000							},				
		{ "emily",			"qAnimate",			"IDLE", 0						},				
		{ "paul",			"qSetVisible",		true							},
		
		{ "richard",		"qSetAppearance",	"ROLL_EYES"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_715"			},
		{ "richard",		"qSetAppearance",	"SERIOUS"						},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_716"			},
		
		{ "richard",		"qWalkToXY",		26, 12							},
		{ "richard",		"qSetAppearance",	"SMUG"							},		
		{ "richard",		"qSay",				"RESTAURANT4_DAY9_717"			},
		{ "richard",		"qWalkToXY",		33, 0							},	
		{ "richard",		"qSetVisible",		false							},
		
		-- little kid
		{ "child",			"qSay",				"RESTAURANT4_DAY9_911"			},	
		{ "child",			"qSetAppearance",	"POINT"							},				
		{ "child",			"qSay",				"RESTAURANT4_DAY9_912"			},	

		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}
	
	
end

function day9:onLevelInited()
	qSequence(self.sequenceStart)
end

function day9:onDayEnd()
	if (getScore() >= level:getTargetScore()) then
		autoAllPeopleWalkOut = false
		qSequence(self.sequenceFinish)
	end
end

function day9:onNotify(notification)
end

function day9:onClickMessage(text, result)

	if (text == "RESTAURANT4_DAY9_67") then
		if (result == "PAUL") then
		
			qSequence(self.sequenceChosePaul)
			choose("man", "paul")
			tm:checkChosenPartner(1) -- trophy
			
		elseif (result == "RICHARD") then
		
			qSequence(self.sequenceChoseRichard)
			choose("man", "richard")
			tm:checkChosenPartner(2) -- trophy
			
		elseif (result == "FRANCOIS") then
		
			qSequence(self.sequenceChoseFrancois)
			choose("man", "francois")
			tm:checkChosenPartner(3) -- trophy

		else
			assert(nil)
		end
	end

end

function day9:onTaskStart(actorType, taskType, p0, p1)

	if (actorType == "story_character") then
		if (taskType == "WalkToTask") then
			if (angela:isVisible()) then
				if (not momAndDadEntered) then
					-- enter mom/dad
					mom:qWait(200)
					mom:qSetVisible(true)
					mom:qWalkToXY(39, 25)
					mom:qCreateHighlight()
					dad:qWait(400)
					dad:qSetVisible(true)
					dad:qWalkToXY(36, 25)
					dad:qCreateHighlight()
					
					momAndDadEntered = true
				end
			end
			
			if (francois:isVisible()) then
				francois:setVisible(false)
			end
		end	
	end

end

function day9:onClickPerson(person)
	
	if (person:getType() == "mom") then
		angela:onClick()
		mom:removeHighlight()
		dad:removeHighlight()
	end
	
	if (person:getType() == "dad") then
		angela:onClick()
		mom:removeHighlight()
		dad:removeHighlight()		
	end	
	
end
-- set day
day = day9()
