include("scripts/events/decorateevent.lua")

-- set event
event = decorateEvent()
event.decorateObjectId = "rest4_tree"
event.decorationObjects = {"rest4_tree_lights_off", "rest4_tree_balls_blue", "rest4_tree_balls_green", "rest4_tree_balls_gold"}
event.pbY = 0

-- day class
class 'day8' (interface)

function day8:__init() super()
end

function day8:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false

	event.targetWorkX = 32
	event.targetWorkY = 25
	event.timeUntilFixed = 50000
	event.scoreGotAll = 100
	event.animFix = "FIX"
	event.soundFix = "SOUND_DECORATE"

	cleaner:setPosition(grid:getNode(49, 17))
	cleaner:setAppearance("TREE")
	cleaner:createTree()
	cleaner:setVisible(false)
	
	emily:setPosition(grid:getCounterNode())
	
	grid:getNode(11, 17):setGridNodeType(0)
	
	framerate = cleaner:getDefaultFrameRate()
	cleaner:setDefaultFrameRate(22)
	shadowX = cleaner:getShadowX()
	cleaner:setShadowX(25)
	
	getObject("rest4_tree"):setVisible(false)
	getObject("rest4_tree_glow"):setVisible(false)
	getObject("rest4_tree_lights_on"):setVisible(false)
	getObject("rest4_tree_lights_off"):setVisible(false)
	getObject("rest4_tree_balls_blue"):setVisible(false)
	getObject("rest4_tree_balls_green"):setVisible(false)
	getObject("rest4_tree_balls_gold"):setVisible(false)
	getObject("rest4_tree_top"):setVisible(false)
	getObject("rest4_tree_flat"):setVisible(false)
	getObject("rest4_ladder"):setVisible(false)	
	getObject("rest4_tree_glow"):setAlpha(0)
	getObject("rest4_tree_top"):animate("EVENT_TREE_PIEK_OFF", 0)
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			2								},	
			
		{ "cleaner",		"qSetWalkTimePerNode",		200							},
		{ "cleaner",		"qSetVisible",		true								},
		
		{ "cleaner",		"qWalkToXY",		47, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		45, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		43, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		41, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		39, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		37, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		35, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		33, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		31, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		29, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		27, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		25, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		23, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		21, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		19, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		17, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		15, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		13, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		11, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		9, 17								},
		{ "cleaner",		"qAnimateWait",		"DRAG", 1							},
		{ "cleaner",		"qWalkToXY",		7, 17								},
		
		{ "scene",			"qCallback",		self, function(c) cleaner:setShadowX(shadowX) cleaner:setDefaultFrameRate(framerate) grid:getNode(11, 17):setGridNodeType(1) cleaner:removeTree() getObject("rest4_tree_flat"):setVisible(true) end },
		{ "cleaner",		"qSetAppearance",	""									},
		{ "cleaner",		"qWait",			1000								},
		
		{ "emily",			"qSetAppearance",	"SHOCK"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_0"				},
		{ "emily",			"qSetAppearance",	"CURIOUS"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_1"				},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_2"				},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_3"				},
		{ "emily",			"qSetAppearance",	""									},

		{ "cleaner",		"qSetWalkTimePerNode",	35								},
		{ "cleaner",		"qSetAppearance",	""									},
		{ "cleaner",		"qWalkToXY",		38, 22								},				
		{ "cleaner",		"qWalkToXY",		22, 16								},				
		{ "emily",			"qWalkToXY",		38, 22								},				
		{ "emily",			"qWalkToXY",		25, 16								},

		{ "cleaner",		"qAnimate",			"LIFT_TREE", 1						},				
		{ "emily",			"qAnimateWait",		"LIFT_TREE", 1						},				
		{ "cleaner",		"qAnimate",			"IDLE", 0							},				
		{ "emily",			"qAnimate",			"IDLE", 0							},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_flat"):setVisible(false) getObject("rest4_tree"):setVisible(true) end },
		{ "cleaner",		"qAnimate",			"LIFTED_TREE", 0					},				
		{ "emily",			"qAnimateWait",		"LIFTED_TREE", 0					},				
		{ "emily",			"qWait",			1000								},				
		{ "cleaner",		"qAnimate",			"IDLE", 0							},				
		{ "emily",			"qAnimate",			"IDLE", 0							},
		{ "emily",			"qWait",			1000								},				

		{ "emily",			"qSetAppearance",	"FLIRT"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_4"				},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_5"				},
		{ "emily",			"qSetAppearance",	""									},
		{ "cleaner",		"qSetAppearance",	""									},
		
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},		
	}

	self.dayEnd = 
	{		
		{ "cleaner",		"qWalkToXY",		22, 22								},
		{ "emily",			"qWalkToXY",		18, 22								},

		{ "emily",			"qSetAppearance",	"HAPPY"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_6"				},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_7"				},
		{ "cleaner",		"qSetAppearance",	"THINK"								},
		{ "cleaner",		"qSayTimed",		"RESTAURANT0_DAY1_16", 2000			},
		{ "cleaner",		"qSetAppearance",	""									},
		{ "emily",			"qSetAppearance",	""									},
		{ "cleaner",		"qWalkToXY",		49, 13								},
		{ "cleaner",		"qSetVisible",		false								},
		{ "cleaner",		"qSetPosition",		grid:getNode(49, 17)				},
		{ "cleaner",		"qWait",			800									},
		{ "scene",			"qCallback",		cleaner, function(c) c:createLadder() end },
		{ "cleaner",		"qSetAppearance",	"LADDER"							},
		{ "cleaner",		"qSetVisible",		true								},
		{ "cleaner",		"qWalkToXY",		32, 17								},
		{ "scene",			"qCallback",		cleaner, function(c) c:removeLadder() 	getObject("rest4_ladder"):setVisible(true) end },
		{ "cleaner",		"qWait",			1500								},
		{ "cleaner",		"qWalkToXY",		31, 8								},
		{ "cleaner",		"qSetAppearance",	""									},
		{ "cleaner",		"qAnimateWait",		"PIEK_PLACE", 1, false, 10, true	},
		{ "scene",			"qCallback",		cleaner, function(c) getObject("rest4_tree_top"):setVisible(true) end },
		{ "cleaner",		"qAnimate",			"IDLE", 0							},
		{ "cleaner",		"qSetAppearance",	"LADDER"							},
		{ "cleaner",		"qWait",			500									},
		{ "cleaner",		"qWalkToXY",		32, 17								},
		{ "cleaner",		"qWait",			1000								},
		{ "cleaner",		"qSetAppearance",	""									},
		{ "cleaner",		"qWalkToXY",		22, 22								},
		{ "cleaner",		"qWait",			800									},
		{ "cleaner",		"qAnimateWait",		"CLAP", 1							},
		{ "cleaner",		"qAnimate",			"IDLE", 0							},	
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_1", 0) getObject("rest4_tree_lights_on"):setVisible(true) getObject("rest4_tree_glow"):setVisible(true) getObject("rest4_tree_glow"):setAlpha(0.15) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_2", 0) getObject("rest4_tree_glow"):setAlpha(0.3) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_3", 0) getObject("rest4_tree_glow"):setAlpha(0.45) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_4", 0) getObject("rest4_tree_glow"):setAlpha(0.6) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_5", 0) getObject("rest4_tree_glow"):setAlpha(0.75) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_6", 0) getObject("rest4_tree_glow"):setAlpha(0.9) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_7", 0) getObject("rest4_tree_glow"):setAlpha(1.0) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_on"):animate("EVENT_TREE_LIGHTS_8", 0) end },
		{ "emily",			"qWait",			300									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_top"):animate("EVENT_TREE_PIEK_ON", 0) end },
		{ "emily",			"qWait",			300									},
				
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_8"				},
		{ "emily",			"qSetAppearance",	"HAPPY"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_9"				},
						
		{ "scene", 			"qFinishMovie" 											},
		{ "pm", 			"qAllPeopleWalkOut" 									},
	}

	self.dayLost = 
	{		
		{ "cleaner",		"qWalkToXY",		22, 22								},
		{ "emily",			"qWalkToXY",		18, 22								},

		{ "emily",			"qSetAppearance",	"ROLL_EYES"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_10"				},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_11"				},
		{ "emily",			"qSetAppearance",	"FLIRT"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY8_12"				},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY8_13"				},

		{ "cleaner",		"qSetAppearance",	""									},
		{ "emily",			"qSetAppearance",	""									},
			
		{ "cleaner",		"qWalkToXY",		31, 25								},
		{ "emily",			"qWalkToXY",		34, 25								},
		
		{ "cleaner",		"qAnimate",			"WORK", -1							},				
		{ "emily",			"qAnimate",			"FIX", -1							},
		
		{ "emily",			"qWait",			200									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_lights_off"):setVisible(true) end },
		{ "emily",			"qWait",			800									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_balls_blue"):setVisible(true) end },
		{ "emily",			"qWait",			800									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_balls_green"):setVisible(true) end },
		{ "emily",			"qWait",			800									},
		{ "scene",			"qCallback",		self, function(c) getObject("rest4_tree_balls_gold"):setVisible(true) end },

		{ "cleaner",		"qAnimate",			"IDLE", 0							},				
		{ "emily",			"qAnimate",			"IDLE", 0							},

		{ "",				"qSequence", 	self.dayEnd								},
	}


end

function day8:onLevelInited()
	qSequence(self.sequenceStart)
end

function day8:onDayBegin()

	getObject("rest4_tree"):setOverheadY(60)
	getObject("rest4_tree"):createOverhead("INGAME_ARROW")
	--getObject("rest4_tree").pb:setVisible(true)

end

function day8:onDayEnd()
	-- prevent walking out
	autoAllPeopleWalkOut = false

	getObject("rest4_tree"):removeOverhead()
	scene:setShowTopBar(false)
	scene:qStartMovie(2)
	if (event.completed) then
		qSequence(self.dayEnd)
	else
		qSequence(self.dayLost)
	end
end

function day8:onNotify(notification)
end

function day8:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = christmasCleaner("INGAME_PERSON_FRANCOIS_WINTER")
		result:setType(class)
		result:animate("IDLE", 0)
		result.clean = true
	end
	
	return result
end

-- set day
day = day8()

class 'christmasCleaner' (d2cleaner)

christmasCleaner.tree = nil
christmasCleaner.ladder = nil

function christmasCleaner:__init(baseName) 
	super(baseName)
end

function christmasCleaner:onCreate()
	d2cleaner.onCreate(self)
end

function christmasCleaner:createTree()
	self.tree = createSprite()
	self.tree:setX(23)
	self.tree:setY(-137)
	self.tree:setDefaultSection(player:getCurrentResourceSection())
	self.tree:animate("EVENT_TREE_SIDE", 0)
	self:addChild(self.tree)
	self:setAppearance("TREE")
end

function christmasCleaner:createLadder()
	self.ladder = createSprite()
	self.ladder:setX(-180)
	self.ladder:setY(-133)
	self.ladder:setDefaultSection(player:getCurrentResourceSection())
	self.ladder:animate("EVENT_LADDER_SIDE", 0)
	self:addChild(self.ladder)
	self:setAppearance("LADDER")
end

function christmasCleaner:removeTree()
	self.tree:setObsolete(true)
end

function christmasCleaner:removeLadder()
	self.ladder:setObsolete(true)
end
