include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Wood"
}

-- day class
class 'day7' (interface)

day7.numObjectsFound = 0

function day7:__init() super()
end

function day7:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false	
	
	-- persons
	mo = pm:createPerson("npc")
	mo:setBaseName("INGAME_PERSON_MO_BROKEN")
	mo:setDefaultSection("characters")	
	mo:setPosition(entryNode)
	
	cleaner:setPosition(entryNode)
	cleaner:setVisible(false)
	
	emily:setPosition(entryNode)
	
	-- event
	event.timeUntilEnterMin = 0
	event.timeUntilEnterMax = 1
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = true
	event.numItems = 12
	event.highlightX = 35
	event.highlightY = 12
	
	-- sequences
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			3							},	
		{ "",				"parallel"											},
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "cleaner",		"qWait",				300							},
		{ "cleaner",		"qSetVisible",			true						},		
		{ "cleaner",		"qWalkToNode",			cleaner:getHomeNode()		},
		{ "",				"sequential",										},		
		{ "mo",				"qWalkToXY",			15, 29						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_0"		},
		{ "mo",				"qSay",					"RESTAURANT4_DAY7_1"		},		
		{ "mo",				"qSetAppearance",		"SAD"						},
		{ "mo",				"qSay",					"RESTAURANT4_DAY7_2"		},
		{ "mo",				"qSay",					"RESTAURANT4_DAY7_4"		},
		{ "emily",			"qSetAppearance",		"FLIRT"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_5"		},
		{ "mo",				"qSetAppearance",		""							},
		{ "emily",			"qSetAppearance",		""							},
		{ "mo",				"qWalkToNode",			exitNode					},
		{ "mo",				"qDestroy",				"mo"						},
		{ "scene",			"qNotify",				"ho_arrived"				},		
		{ "scene",			"qNotify",				"show bar"					},		
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qStartGame" 										},			
	}	
	
	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "emily",			"qSetAppearance",		"CURIOUS"					},
		{ "emily",			"qSay",					"RESTAURANT0_DAY5_21"		},
		{ "cleaner",		"qWalkToXY",			16, 32						},
		{ "cleaner",		"qSetAppearance",		"SAD"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY7_20"		},
		{ "emily",			"qSetAppearance",		"SAD"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_21"		},
		{ "emily",			"qSetAppearance",		"NEUTRAL"					},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_22"		},
		{ "cleaner",		"qSetAppearance",		"HAPPY"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY7_23"		},
		{ "emily",			"qSetAppearance",		"LAUGH"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_25"		},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qFinishGame" 										},				
	}	
	
	self.foundObject11 = 
	{
		{ "scene",			"qStartMovie",			2							},	
		{ "emily",			"qSetAppearance",		"HAPPY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY7_11"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}	

end

function day7:onLevelInited()
	qSequence(self.sequenceStart)
end

function day7:onDayBegin()
end

function day7:onDayEnd()
	autoAllPeopleWalkOut = false
	qSequence(self.sequenceEnd)
end

function day7:onNotify(notification)
	if (notification == "hiddenObject click") then
		if (self["foundObject" .. self.numObjectsFound] ~= nil) then
			qSequence(self["foundObject" .. self.numObjectsFound])
		end
		self.numObjectsFound = self.numObjectsFound + 1
	end
end

-- set day
day = day7()