include("scripts/events/spiderwebevent.lua")

-- set event
event = spiderwebevent()
event.itemsProps = 
{
    {type="rest4_puddle_ice_3", anchorY=180, image="OBJECT_PUDDLE_ICE", x=21, y=12, hidden = true},
    {type="rest4_puddle_ice_4", anchorY=60, image="OBJECT_PUDDLE_ICE", x=13, y=24, hidden = true},
    {type="rest4_puddle_ice_1", anchorY=60, image="OBJECT_PUDDLE_ICE", x=31, y=13, hidden = true},
    {type="rest4_puddle_ice_2", anchorY=60, image="OBJECT_PUDDLE_ICE", x=33, y=23, hidden = true},
}
event.pixelsToClean = 2400

-- day class
class 'day6' (interface)

day6.areas = {}
day6.areaIdx = nil
day6.slipChance = 50
day6.slip = false
day6.fallCount = 0

function day6:__init() super()
end

function day6:onLevelGlobals()

	event.eventBarImage = "OBJECT_PUDDLE_BAR"
	event.highlightX = 33
	event.highlightY = 23
	event.timeUntilEnterMin = 60000							-- minimum time the person waits outside
	event.timeUntilEnterMax = 70000							-- maximum time the person waits outside
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.hintId = "HINT_SLIPPERY_ICE"
	event.cleanSound = "SOUND_CLEAN_LOOP2"

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	waterHose = getObject("rest4_water_hose")
	waterHoseStill = getObject("rest4_water_hose_still")
	waterHoseStill:setAcceptingTasks(true)
	waterSpot1 = event.items[1]
	waterSpot1:animate("OBJECT_PUDDLE_WATER_ANIM", 0)
	waterSpot2 = event.items[2]
	waterSpot2:animate("OBJECT_PUDDLE_WATER", 0)
	waterSpot3 = event.items[3]
	waterSpot3:animate("OBJECT_PUDDLE_WATER", 0)
	waterSpot4 = event.items[4]
	waterSpot4:animate("OBJECT_PUDDLE_WATER", 0)
	
	-- areas
	for i, water in ipairs(event.itemsProps) do
		assert(water.x)
		assert(water.y)
		local x = water.x + 1
		local y = water.y
		local w = 3
		local h = 3
		local area = {x, y, x+w, y+h}
		table.insert(self.areas, area)		
	end
	
	-- sequences
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			3							},
		{ "cleaner",		"qWalkToXY",			16, 17						},
		{ "cleaner",		"qSetAppearance",		"THINK"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY6_0"		},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "cleaner",		"qWalkToXY",			10, 12						},
		{ "cleaner",		"qAnimateWait",			"WORK", 2					},
		{ "cleaner",		"qAnimate",				"IDLE", 0					},
		{ "waterHoseStill",	"qAnimate",				"OBJECT_HOSE_SPRAY", -1 	},
		{ "waterHoseStill",	"qWait",				500							},
		{ "waterSpot1",		"qSetVisible",			true						},
		{ "waterSpot1",		"qAnimateWait",			"OBJECT_PUDDLE_WATER_ANIM", 1, false, -1, true },
--		{ "waterSpot1",		"qAnimate",				"OBJECT_PUDDLE_WATER", 0	},
		{ "waterHoseStill",	"qWait",				500							},
		{ "waterSpot2",		"qSetVisible",			true						},
--		{ "waterSpot2",		"qAnimateWait",			"OBJECT_PUDDLE_WATER_ANIM", 1, false, -1, true },
		{ "waterSpot2",		"qAnimate",				"OBJECT_PUDDLE_WATER", 0	},
		{ "waterHoseStill",	"qWait",				500							},
		{ "waterSpot3",		"qSetVisible",			true						},
--		{ "waterSpot3",		"qAnimateWait",			"OBJECT_PUDDLE_WATER_ANIM", 1, false, -1, true },
		{ "waterSpot3",		"qAnimate",				"OBJECT_PUDDLE_WATER", 0	},
		{ "waterHoseStill",	"qWait",				500							},
		{ "waterSpot4",		"qSetVisible",			true						},
--		{ "waterSpot4",		"qAnimateWait",			"OBJECT_PUDDLE_WATER_ANIM", 1, false, -1, true },				
		{ "waterSpot4",		"qAnimate",				"OBJECT_PUDDLE_WATER", 0	},
		{ "waterHoseStill",	"qWait",				500							},
		{ "cleaner",		"qAnimateWait",			"WORK", 2					},
		{ "cleaner",		"qAnimate",				"IDLE", 0					},
		{ "waterHoseStill",	"qAnimate",				"OBJECT_HOSE_STILL", 0 		},
		{ "cleaner",		"qWalkToXY",			16, 17						},
		{ "cleaner",		"qSetAppearance",		"SHOCKED"					},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY6_1"		},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "emily",			"qWalkToXY",			20, 17						},
		{ "emily",			"qSetAppearance",		"SHOCK"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_2"		},
		{ "cleaner",		"qSetAppearance",		"BLUSH"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY6_3"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_4"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_5"		},
		{ "",				"parallel"											},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "cleaner",		"qWalkToNode",			cleaner:getHomeNode()		},	
		{ "",				"sequential"										},		
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qStartGame" 										},
		{ "scene",			"qNotify",				"show bar"					},
		{ "",				"parallel"											},			
	}	
	
	self.sequenceFall0 =
	{
		{ "emily",			"qSetDirection",		1							},
		{ "emily",			"qSetBalloonY",			30							},
		{ "emily",			"qAnimateWait",			"FALL", 1, false, -1, true	},
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qSetAppearance",		"ANGRY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_30"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_31"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSetBalloonY",			0							},
		{ "scene",			"qFinishMovie" 										},
	}
	
	self.sequenceFallRandom0 =
	{
		{ "emily",			"qSetDirection",		1							},
		{ "emily",			"qSetBalloonY",			30							},
		{ "emily",			"qAnimateWait",			"FALL", 1, false, -1, true	},
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qSetAppearance",		"ANGRY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_40"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSetBalloonY",			0							},
		{ "scene",			"qFinishMovie" 										},
	}
	
	self.sequenceFallRandom1 =
	{
		{ "emily",			"qSetDirection",		1							},
		{ "emily",			"qSetBalloonY",			30							},
		{ "emily",			"qAnimateWait",			"FALL", 1, false, -1, true	},
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qSetAppearance",		"ANGRY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_41"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSetBalloonY",			0							},
		{ "scene",			"qFinishMovie" 										},
	}
	
	self.sequenceFallRandom2 =
	{
		{ "emily",			"qSetDirection",		1							},
		{ "emily",			"qSetBalloonY",			30							},
		{ "emily",			"qAnimateWait",			"FALL", 1, false, -1, true	},
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qSetAppearance",		"ANGRY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_42"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSetBalloonY",			0							},
		{ "scene",			"qFinishMovie" 										},
	}		
	
	event.sequenceDone = 
	{
		{ "scene",			"qStartMovie",			1							},	
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "cleaner",		"qWalkToXY",			16, 32						},
		{ "emily",			"qAnimateWait",			"JUMP", 1, true, 8			},
		{ "emily",			"qAnimate",				"IDLE", 0					},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_20"		},
		{ "cleaner",		"qSetAppearance",		"BLUSH"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY6_21"		},
		{ "emily",			"qSetAppearance",		"LAUGH"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY6_22"		},
		{ "",				"parallel"											},
		{ "emily",			"qSetAppearance",		""							},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "",				"sequential"										},
		{ "scene",			"qFinishMovie" 										},
	}	
	
end

function day6:onLevelInited()
	qSequence(self.sequenceStart)
end

function day6:onDayBegin()
end

function day6:onDayEnd()
end

function day6:onTick(time)

	if (self.slip) then
		emily:finishTask()
		self.slip = false
		
		if (self["sequenceFall" .. self.fallCount] ~= nil) then
			qInsertSequence(self["sequenceFall" .. self.fallCount])
		else
			local r = getRandom(3)
			assert(self["sequenceFallRandom" .. r])
			qInsertSequence(self["sequenceFallRandom" .. r])
		end

		self.fallCount = self.fallCount + 1
	end

end

function day6:onLockToNode(actor, node)

	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end	

	if (actor:getType() == "emily") then
		local x = actor:getPosition():getGridX()
		local y = actor:getPosition():getGridY()
		
		local idx = nil
		for i, area in ipairs(self.areas) do
			if (event.items[i]:isVisible()) then
				if (math.contains(area, x, y)) then
					idx = i
					break
				end
			end
		end	
		
		if (idx ~= nil) then
			if (self.areaIdx == nil) then
				-- emily enters area
				self.areaIdx = idx
				
				-- she might slip!
				local r = getRandom(100)
				if (r < self.slipChance) then
					-- emily slips!
					self.slip = true
				end				
			end
		else
			self.areaIdx = nil
			self.slip = false
		end
	end

end

-- set day
day = day6()