-- day class
class 'day5' (interface)

day5.sequenceStart = nil
day5.danceTimes = {50000, 50000, 50000, 50000, 50000}
day5.danceMoves =
{
	{1, 2},
	{2, 3},
	{3, 4},
	{2, 4},
	{3, 4, 5},
}
day5.danceSteps = nil
day5.scoreGotOne = 25
day5.scoreGotAll = 100

day5.timer = 0
day5.indexDance = 0
day5.indexMove = 0
day5.clicked = {}
day5.right = 0
day5.dayEnded = false

function day5:__init() super()

	local choices =
	{
		"STEP",
		"TWIRL",
		"DIP",
	}
	local choicesCount =
	{
		0,
		0,
		0,
	}
	local picked =
	{
	}
	
	for i = 1,6 do
		local random = getRandom(table.getn(choicesCount)) + 1
		while (choicesCount[random] >= 3) do
			random = getRandom(table.getn(choicesCount)) + 1
			
		end
		
		table.insert(picked, choices[random])	
		choicesCount[random] = choicesCount[random] + 1
		-- cout(choices[random] .. "\n")
	end
	
	self.danceSteps =
	{
		{ picked[1], picked[2] },
		{ picked[1], picked[2], picked[3] },
		{ picked[1], picked[2], picked[3], picked[4] },
		{ picked[1], picked[2], picked[3], picked[4], picked[5] },
		{ picked[1], picked[2], picked[3], picked[4], picked[5], picked[6] },
	}

end

function day5:onLevelGlobals()

	if (self.danceSteps == nil) then
		return
		
	end

	angela = pm:createPerson("npc")
	angela:setBaseName("INGAME_PERSON_ANGELA_WINTER")
	angela:setDefaultSection("characters")
	angela:setPosition(grid:getNode(27, 0))
	angela:setVisible(false)

	restaurant.doSkaters = false
	autoStartGame = false
	autoAllPeopleWalkIn = false

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",				2							},
		{ "cleaner",		"qWalkToXY",				37, 24						},
		{ "emily",			"qWalkToXY",				34, 24						},
		{ "cleaner",		"qSetAppearance",			"SKATE_HOLD"				},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_0"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_1"		},
		{ "cleaner",		"qSetAppearance",			""							},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_2"		},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_3"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_4"		},
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_5"		},	
		{ "emily",			"qSetAppearance",			"ROLL_EYES"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_6"		},
		{ "cleaner",		"qSetAppearance",			""							},
		{ "emily",			"qSetAppearance",			""							},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},		
		{ "scene",			"qNotify",					"next dance"				},
		--{ "",				"parallel"												},			
	}

	self.sequenceAngela =
	{
		--{ "",				"sequential"											},			
		{ "angela",			"qSetVisible",				true						},
		{ "angela",			"qWalkToXY",				37, 24						},
		{ "emily",			"qWalkToXY",				34, 24						},
		{ "angela",			"qSetAppearance",			"HAPPY"						},
		{ "angela",			"qSay",						"RESTAURANT4_DAY5_15"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_16"		},
		{ "emily",			"qSetAppearance",			""							},

		{ "angela",			"qWalkToXY",				27, 0						},
		{ "angela",			"qDestroy"												},
		{ "angela",			"qSetAppearance",			""							},
		{ "angela",			"qSetAppearance",			""							},
		--{ "",				"parallel"												},			
	}
	
	self.sequenceWin =
	{
		--{ "",				"sequential"											},			
		{ "cleaner",		"qSetAppearance",			"HAPPY_SKATE"				},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_21"		},	
		{ "emily",			"qSetAppearance",			"LAUGH_SKATE"				},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_22"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_23"		},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_24"		},
		{ "cleaner",		"qSetAppearance",			"SKATE"						},
		{ "emily",			"qSetAppearance",			"SKATE"						},
		--{ "",				"parallel"												},			
	}
	
	self.sequenceAfterDance1 = 
	{
		--{ "",				"sequential"											},			
		{ "emily",			"qSetAppearance",			"LAUGH_SKATE"				},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_7"		},	
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_8"		},	
		{ "emily",			"qSetAppearance",			"SKATE"						},
		--{ "",				"parallel"												},			
	}

	self.sequenceAfterDance2 = 
	{
		--{ "",				"sequential"											},			
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_9"		},	
		{ "emily",			"qSetAppearance",			"LAUGH_SKATE"				},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_10"		},	
		{ "emily",			"qSetAppearance",			"SKATE"						},
		--{ "",				"parallel"												},			
	}

	self.sequenceAfterDance3 = 
	{
		--{ "",				"sequential"											},			
		{ "emily",			"qSetAppearance",			"LAUGH_SKATE"				},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_11"		},			
		{ "cleaner",		"qSetAppearance",			"HAPPY_SKATE"				},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_12"		},			
		{ "cleaner",		"qSetAppearance",			"SKATE"						},
		{ "emily",			"qSetAppearance",			"SKATE"						},
		--{ "",				"parallel"												},			
	}

	self.sequenceAfterDance4 = 
	{
		--{ "",				"sequential"											},			
		{ "cleaner",		"qSetAppearance",			"HAPPY_SKATE"				},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_13"		},			
		{ "emily",			"qSetAppearance",			"LAUGH_SKATE"				},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_14"		},			
		{ "cleaner",		"qSetAppearance",			"SKATE"						},
		{ "emily",			"qSetAppearance",			"SKATE"						},
		--{ "",				"parallel"												},			
	}
	
	self.sequenceDance =
	{
		--{ "",				"sequential"											},			
		{ "scene",			"qStartMovie",				true, 2						},
		{ "cleaner",		"qWalkToXY",				6, 26						},
		{ "cleaner",		"qSetAppearance",			"SKATE"						},
		{ "cleaner",		"qWalkToXY",				9, 21						},
		{ "emily",			"qWalkToXY",				6, 26						},
		{ "emily",			"qSetAppearance",			"SKATE"						},
		{ "emily",			"qWalkToXY",				4, 21						},
		{ "cleaner",		"qNotify",					"arrived"					},
		{ "cleaner",		"qButtonAction",			"new", "DIP", -110, 20		},
		{ "cleaner",		"qButtonAction",			"popin", "DIP"				},
		{ "cleaner",		"qWait",					500							},
		{ "cleaner",		"qButtonAction",			"new", "TWIRL", -70, 20		},
		{ "cleaner",		"qButtonAction",			"popin", "TWIRL"			},
		{ "cleaner",		"qWait",					500							},
		{ "cleaner",		"qButtonAction",			"new", "STEP", -30, 20		},
		{ "cleaner",		"qButtonAction",			"popin", "STEP"				},		
		{ "cleaner",		"qWait",					1000						},
		{ "cleaner",		"qNotify",					"next move"					},	
		--{ "",				"parallel"												},			
	}
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(table.getn(self.danceTimes))
	eventBar:setProgress(0)	
	eventBar:setSubjectImage("EVENT_SKATE_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))	

end

function day5:onLevelInited()
	qSequence(self.sequenceStart)
end

function day5:onDayBegin()
	eventBar:animateToActive()
	eventBar:raiseCurtain()
	self.dayEnded = false
end

function day5:onDayEnd()
	--autoAllPeopleWalkOut = false
	self.dayEnded = true
	--qSequence(self.sequenceDance)
	--cleaner:qNotify("next move")
end

function day5:onNotify(notification)

	if (notification == "next dance") then
		self:gotoNextDance()	
	
	elseif (notification == "next move") then
		self:gotoNextMove()

	elseif (notification == "enable buttons") then
		cleaner:buttonAction("enable", "DIP")
		cleaner:buttonAction("enable", "TWIRL")
		cleaner:buttonAction("enable", "STEP")
	
	elseif (notification == "disable buttons") then
		cleaner:buttonAction("disable", "DIP")
		cleaner:buttonAction("disable", "TWIRL")
		cleaner:buttonAction("disable", "STEP")	
	
	elseif (notification == "delete buttons") then
		cleaner:buttonAction("popout", "DIP")
		cleaner:buttonAction("popout", "TWIRL")
		cleaner:buttonAction("popout", "STEP")
	
	elseif (notification == "inc score") then
		incScore(self.scoreGotOne, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, 0)	
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
	
	elseif (notification == "inc score bonus") then
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
	
	elseif (notification == "arrived") then
	end

end

function day5:onTick(time)

	if (scene:isPlayingMovie()) then
		return
	end
	
	if (scene:isStartingMovie()) then
		return
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
		
			--if (emily:hasTasksToDo() or cleaner:hasTasksToDo() or chicken:hasTasksToDo()) then
				--self.timer = 1
				--return
			--end
--
			qSequence(self.sequenceDance)		
		end	
	end

end

function day5:gotoNextDance()

	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	
	if (self.danceTimes[self.indexDance]) then
		self.timer = self.danceTimes[self.indexDance]
	
	else
		eventBar:animateToDeactive()	
		self:endDanceAnim()
		scene:qFinishMovie()
	end

end

function day5:gotoNextMove()

	self.indexMove = self.indexMove + 1
	self.clicked = {}
	
	cout("day5:gotoNextMove() - indexDance = " .. self.indexDance .. " and indexMove = " .. self.indexMove .. "\n")
	
	if (self.danceMoves[self.indexDance][self.indexMove]) then
		-- francois shows next move
		for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do
			cleaner:qPlaySound("SOUND_MOVES_" .. value)
			cleaner:qButtonAction("highlight", value)
			cleaner:qButtonAction("pop", value)
			cleaner:qAnimateWait(value, 1, false, -1, true)
			cleaner:qWait(500)
			
		end
		
		cleaner:qAnimate("IDLE", 0)
		cleaner:qNotify("enable buttons")		
	
	else
		-- we did all moves correct
		
		-- eventbar
		self.right = self.right + 1
		eventBar:setProgress(self.right)		
		
		if (self.indexDance == table.getn(self.danceTimes)) then
			-- we did the final dance right: win + bonus
			cleaner:qNotify("inc score bonus")
			cleaner:qNotify("delete buttons")
			cleaner:qWait(1000)

			qSequence(self.sequenceWin)
			scene:qNotify("next dance")	
		
		else
			-- there's dances left
			qSequence(self["sequenceAfterDance" .. self.indexDance])
			cleaner:qNotify("delete buttons")
			cleaner:qWait(500)
			self:endDanceAnim()
			scene:qNotify("next dance")		
			scene:qFinishMovie()
			--parallel()
		
		end
	end

end

function day5:endDanceAnim()
	cleaner:qWalkToXY(6, 26)
	cleaner:qSetAppearance("")
	cleaner:qWalkToXY(10, 26)
	emily:qWalkToXY(6, 26)
	emily:qSetAppearance("")
	
	if (self.indexDance == 3) then
		qSequence(self.sequenceAngela)
	end
end

function day5:onClickButton(button)

	table.insert(self.clicked, button)
	
	for index, value in ipairs(self.clicked) do
		if (self.clicked[index] ~= self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]][index]) then
			-- clicked wrong
			self:onNotify("disable buttons")

            emily:qPlaySound("SOUND_EVENT_BAD")
         	
			emily:qAnimateWait(button, 1, false, -1, true)
			emily:qAnimate("IDLE", 0)
			emily:qWait(250)
			emily:qNotify("delete buttons")
			cleaner:qAnimateWait("SHAKENO", 3, 12)

			self:endDanceAnim()
			-- there could be a sequence lose over here

			scene:qFinishMovie()
			scene:qNotify("next dance")

			return			
		end	
	end
	
	-- clicked right
	emily:qPlaySound("SOUND_MOVES_" .. button)
	emily:qAnimateWait(button, 1, false, -1, true)
	emily:qWait(250)
	
	if (table.getn(self.clicked) == table.getn(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]])) then
		-- all good
		-- immediate effect
		self:onNotify("disable buttons")
		
		-- queue next
		emily:qAnimate("IDLE", 0)
		emily:qNotify("inc score")		
		emily:qWait(250)		
		emily:qNotify("next move")
	
	end
end

-- set day
day = day5()
