-- set no skaters during the snowstorm
skaterCountMax = 0

-- emily location in the barn
emilyBarnX = 10
emilyBarnY = 12

-- barn
class 'barn' (D2Object)

function barn:__init() super()
end

function barn:onCreate()
	D2Object.onCreate(self)
	self:animate(self:getBaseName(), 0)
	self:createHighlight()	
	self:setOverheadX(-50)
	self:setOverheadY(80)
end

function barn:onPlace()
	D2Object.onPlace(self)
end

function barn:onClick()
	self:clearOverhead()
	emily:qWalkToXY(emilyBarnX, emilyBarnY)
end

-- day class
class 'day4' (interface)

day4.colorStartA = 1
day4.colorStartR = 1
day4.colorStartG = 1
day4.colorStartB = 1
day4.colorFinishA = 1
day4.colorFinishR = 0.4
day4.colorFinishG = 0.4
day4.colorFinishB = 1
day4.timeUntilBlue = 50 * 1000	-- time to go from fully warm to fully cold
day4.timeUntilCold = 50 * 1000	-- time emily has to be fully cold until she starts walking slower
day4.timeUntilWarm = 8 * 1000	-- time to go from fully cold to fully warm
day4.walkTimePerNodeDefault = 0	-- see onLevelInited()
day4.walkTimePerNodeCold = 0
day4.cold = false
day4.blueLevel = 1				-- one based
day4.blueLevels = 10
day4.blueLevelTime = day4.timeUntilBlue / day4.blueLevels
day4.warmLevelTime = day4.timeUntilWarm / day4.blueLevels
day4.timerInside = 0
day4.timerOutside = 0
day4.timerCold = 0
day4.stormSound = "SOUND_SNOWSTORM_LOOP"

function day4:__init() super()
end

function day4:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false	
	
	-- sequences
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			3							},
		{ "emily",			"qWalkToXY",			19, 17						},
		{ "cleaner",		"qWalkToXY",			15, 17						},
		{ "emily",			"qSetAppearance",		"SUSPICIOUS"				},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_0"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_1"		},
		{ "cleaner",		"qSetAppearance",		"REFUSE"					},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY4_2"		},
		{ "",				"parallel"											},
		{ "cleaner",		"qWalkToNode",			cleaner:getHomeNode()		},
		{ "emily",			"qWalkToXY",			emilyBarnX, emilyBarnY		},
		{ "",				"sequential"										},
		{ "emily",			"qSetAppearance",		"LAUGH"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_3"		},
		{ "cleaner",		"qSetAppearance",		"HAPPY"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY4_4"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "cleaner",		"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										},
	}	
	
	self.sequenceCold = 
	{
		{ "scene",			"qStartMovie",			3							},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qAnimate",				"COLD", -1					},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_10"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_11"		},
		{ "emily",			"qSetAppearance",		"SQUINTED"					},
		{ "emily",			"qAnimate",				"IDLE", 0					},
		{ "scene",			"qFinishMovie" 										},		
		{ "barn",			"qCreateOverhead",		"INGAME_ARROW"				},
		{ "",				"parallel"											},			
	}	
	
	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",			3							},
		{ "cleaner",		"qWalkToXY",			15, 17						},
		{ "emily",			"qWalkToXY",			19, 17						},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qAnimate",				"COLD", -1					},
		{ "cleaner",		"qSetAppearance",		"THINK"						},
		{ "cleaner",		"qSay",					"RESTAURANT4_DAY4_20"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_21"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY4_22"		},
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qFinishGame" 										},		
	}		

end

function day4:onLevelInited()
	self.timerOutside = self.blueLevelTime
	self.timerInside  = self.warmLevelTime
	self.walkTimePerNodeDefault = emily:getWalkTimePerNode()
	self.walkTimePerNodeCold = self.walkTimePerNodeDefault * 2.5
	
	-- initialize snow storm
	self.snowStorm = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_STORM") 
	self.snowStorm:play()
	self.snowStorm:addInitialTime(10000)
	scene:startSnowStormOverlay()
	emily:playSound(day.stormSound, true)
	
	-- initialize event bar
	--eventBar:setTotalShowed(false)
	--eventBar:setProgressShowed(false)
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(9)
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("EVENT_BAR_FREEZING", player:getCurrentResourceSection())
	
	-- appearances
	emily:setAppearance("SQUINTED")
	cleaner:setAppearance("REFUSE")
	
	-- sequence
	qSequence(self.sequenceStart)
end

function day4:onDayBegin()
	eventBar:animateToActive()
end

function day4:onDayEnd()
	-- finish snow storm
	self.snowStorm:setEmitterEnabled(false)
	scene:finishSnowStormOverlay()
	emily:stopSound(day.stormSound)
	
	-- sequence
	autoAllPeopleWalkOut = false
	qSequence(self.sequenceEnd)
end

function day4:onNotify(notification) 
end

function day4:onTick(time)

	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	local inside = false
	if (emily:getPosition():getGridX() == emilyBarnX) then
		if (emily:getPosition():getGridY() == emilyBarnY) then
			inside = true
		end
	end
	
	local updateColor = false
	
	if (inside) then
		-- get warmer
		if (self.timerInside > 0) then
			self.timerInside = self.timerInside - time
			if (self.timerInside <= 0) then
				if (self.blueLevel > 1) then
					self.blueLevel = self.blueLevel - 1
					cout("emily got warmer: " .. self.blueLevel .. "\n")
					updateColor = true
					self.cold = false
					eventBar:lowerCurtain()
				end
				if (self.blueLevel > 1) then
					self.timerInside = self.warmLevelTime
				end
			end
		else
			assert(self.blueLevel == 1)
		end
		
		-- reset outside timer
		self.timerOutside = self.blueLevelTime
		self.timerCold = self.timeUntilCold
	
	else
		-- get colder
		if (self.blueLevel == self.blueLevels) then
			if (self.timerCold > 0) then
				self.timerCold = self.timerCold - time
				if (self.timerCold <= 0) then
					cout("emily got cold\n")
					self.cold = true
					eventBar:raiseCurtain()
				end
			end
			
		end
	
		-- get bluer
		if (self.timerOutside > 0) then
			self.timerOutside = self.timerOutside - time
			if (self.timerOutside <= 0) then
				if (self.blueLevel < self.blueLevels) then
					self.blueLevel = self.blueLevel + 1
					cout("emily got blue-er: " .. self.blueLevel .. "\n")					
					updateColor = true
				end
				if (self.blueLevel < self.blueLevels) then
					self.timerOutside = self.blueLevelTime
				end
				if (self.blueLevel == self.blueLevels) then
					self.timerCold = self.timeUntilCold
				end
			end		
		end	
		
		-- reset inside timer
		self.timerInside = self.warmLevelTime
	end
	
	if (updateColor) then
		assert(self.blueLevel >= 1)
		assert(self.blueLevel <= self.blueLevels)
		
		local colorA = self.colorStartA - ((self.colorStartA - self.colorFinishA) / self.blueLevels) * (self.blueLevel-1)
		local colorR = self.colorStartR - ((self.colorStartR - self.colorFinishR) / self.blueLevels) * (self.blueLevel-1)
		local colorG = self.colorStartG - ((self.colorStartG - self.colorFinishG) / self.blueLevels) * (self.blueLevel-1)
		local colorB = self.colorStartB - ((self.colorStartB - self.colorFinishB) / self.blueLevels) * (self.blueLevel-1)
		emily:setColor(colorA, colorR, colorG, colorB)
		emily:setAlpha(1)
		
		if (self.blueLevel <= 1 * (self.blueLevels / 5)) then
			emily:setAppearance("")
		elseif (self.blueLevel <= 2 * (self.blueLevels / 5)) then
			emily:setAppearance("COLD")
		elseif (self.blueLevel <= 3 * (self.blueLevels / 5)) then
			emily:setAppearance("COLD_A")
		elseif (self.blueLevel <= 4 * (self.blueLevels / 5)) then
			emily:setAppearance("COLD_B")
		elseif (self.blueLevel <= 5 * (self.blueLevels / 5)) then
			emily:setAppearance("COLD_C")
		end	
		
		eventBar:setProgress(self.blueLevel - 1)	
	
	end
	
	if (self.cold) then
		emily:setWalkTimePerNode(self.walkTimePerNodeCold)
		-- play cold sequence once
		if (self.sequenceCold) then
			qSequence(self.sequenceCold)
			self.sequenceCold = nil
		end			
	else
		emily:setWalkTimePerNode(self.walkTimePerNodeDefault)
	end

end

function day4:createObject(desc)

	local result = nil
	
	if (desc:getObjectId() == "rest4_barn") then
		result = barn()
		result:setType(desc:getType())
		result:setVisible(true)
		barn = result
	end
	
	return result
	
end

-- set day
day = day4()
