include("scripts/events/candle.lua")

-- day class
class 'day3' (interface)

day3.candles = {}
day3.candleCounter = 0

day3.candleLitTime = 160 * 1000
day3.candleFadeTime = 20 * 1000
day3.candleTimeToLightFromFade = 3 * 1000
day3.candleTimeToLightFromDead = 2 * 1000
day3.candleLitAllDayScore = 300

function day3:__init() super()
end

function day3:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false	
	
	-- persons
	mo = pm:createPerson("npc")
	mo:setBaseName("INGAME_PERSON_MO_BROKEN")
	mo:setDefaultSection("characters")	
	mo:setPosition(grid:getNode(38, 16))
	mo:animate("IDLE", 0)
	
	cleaner:setPosition(entryNode)

	-- sequences
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "",				"parallel"											},
		{ "emily",			"qWalkToXY",			35, 16						},
		{ "cleaner",		"qWait",				200							},
		{ "cleaner",		"qWalkToXY",			27, 13						},
		{ "",				"sequential"										},
		{ "emily",			"qSetAppearance",		"CONFUSED"					},
		{ "emily",			"qSay",					"RESTAURANT4_DAY3_20"		},
		{ "mo",				"qSay",					"RESTAURANT4_DAY3_0"		},
		{ "mo",				"qSay",					"RESTAURANT4_DAY3_1"		},
		{ "emily",			"qSetAppearance",		"HAPPY"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY3_2"		},
		{ "mo",				"qSetAppearance",		"HAPPY"						},
		{ "mo",				"qSay",					"RESTAURANT4_DAY3_3"		},
		{ "mo",				"qSay",					"RESTAURANT4_DAY3_21"		},
		{ "emily",			"qSay",					"RESTAURANT4_DAY3_4"		},
		{ "mo",				"qSetAppearance",		"BLUSH"						},
		{ "mo",				"qSay",					"RESTAURANT4_DAY3_5"		},
		{ "mo",				"qWalkToNode",			exitNode					},
		{ "mo",				"qDestroy",				"mo"						},
		{ "",				"parallel"											},
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "cleaner",		"qWalkToNode",			cleaner:getHomeNode()		},
		{ "",				"sequential"										},
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qStartGame" 										},
	}
	
	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",			2							},
		{ "emily",			"qWalkToNode",			grid:getCounterNode()		},
		{ "cust",			"qWalkToXY",			16, 29						},
		{ "cust",			"qSetAppearance",		"HAPPY"						},
		{ "cust",			"qSay",					"RESTAURANT4_DAY3_15"		},
		{ "cust",			"qSay",					"RESTAURANT4_DAY3_16"		},
		{ "emily",			"qSetAppearance",		"LAUGH"						},
		{ "emily",			"qSay",					"RESTAURANT4_DAY3_17"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "cust",			"qSay",					"RESTAURANT4_DAY3_18"		},
		{ "cust",			"qNotify",				"pop score"					},
		{ "cust",			"qWalkToNode",			exitNode					},
		{ "cust",			"qDestroy",				"cust"						},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}

end

function day3:onLevelInited()

	-- snow
	self.snowFine = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_FINE") 
	self.snowFine:play()
	self.snowFine:addInitialTime(15000)
	
	self.snowNormal = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_NORMAL") 
	self.snowNormal:play()
	self.snowNormal:addInitialTime(15000)

	-- lit candles
	for i, candle in pairs(self.candles) do
		candle:setFlameState("alight")
	end
	qSequence(self.sequenceStart)
	
end

function day3:onDayBegin()
	for i, candle in pairs(self.candles) do
		candle.timerSuspended = false
	end
end

function day3:onNotify(notification)
end

function day3:onTick(time)
end

function day3:createObject(desc)

	local result = nil
	
	if (desc:getObjectId() == "rest4_brazier") then
		result = candle()
		result:setType(desc:getType())
		result:setVisible(true)
		result.canFade = true
		result.workAnim = "WORK"
		result.timerSuspended = false
		result.timeAlight = self.candleLitTime
		result.timeToFade = self.candleFadeTime
		result.timeToLightFromFade = self.candleTimeToLightFromFade
		result.timeToLightFromDead = self.candleTimeToLightFromDead
		
		self.candleCounter = self.candleCounter + 1
		self.candles[self.candleCounter] = result
		self.candles[self.candleCounter].burnFrameTime = 8
		self.candles[self.candleCounter]:setFlameState("alight")
	end
	
	return result
	
end

function day3:onDayEnd()

	local allLit = true
	for i, candle in pairs(self.candles) do
		if (not candle:isLit()) then
			allLit = false
			break
		end
	end
	
	if (allLit) then
		autoAllPeopleWalkOut = false
	
		local baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_MALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_FEMALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_MALE_WINTER_ELDERLY",		
		}				
	
		cust = pm:createPerson("npc")
		cust:setBaseName(baseNames[getRandom(#baseNames) + 1])
		cust:setDefaultSection("customers")	
		cust:setPosition(entryNode)
		
		qSequence(self.sequenceEnd)
		
	end

end

function day3:onNotify(notification)

	if (notification == "pop score") then
		incScore(self.candleLitAllDayScore, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, 0, "BONUS")	
	end

end

-- set day
day = day3()