-- day class
class 'day2' (interface)

function day2:__init() super()
end

function day2:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	kid = pm:createPerson("npc")
	kid:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_CHILD")
	kid:setDefaultSection("customers")
	kid:setPosition(grid:getNode(32, 26))
	kid:animate("IDLE", 0)
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(grid:getCleanerNode())

	self.sequenceBegin = 	-- sequence when day begins
	{	
		{ "scene",			"qStartMovie",		2								},
		{ "entertainer",	"qWalkToXY",		26, 25							},
		{ "kid",			"qSetAppearance",	"HAPPY"							},
		{ "kid",			"qSay",				"RESTAURANT4_DAY2_60"			},
		{ "entertainer",	"qSay",				"RESTAURANT4_DAY2_61"			},
		{ "entertainer",	"qSay",				"RESTAURANT4_DAY2_62"			},
		{ "entertainer",	"qSay",				"RESTAURANT4_DAY2_63"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_64"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "kid",			"qSay",				"RESTAURANT4_DAY2_65"			},
		{ "kid",			"qWalkToXY",		33, 0							},
		{ "kid",			"qDestroy"											},
		{ "entertainer",	"qWalkToNode",		grid:getEntertainerNode()		},
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
	}

	-- Antonio
	antonio = pm:createPerson("story_character")
    antonio:setBaseName("INGAME_PERSON_ANTONIO")
    antonio:setPosition(grid:getNode(27, 0))
    antonio:initTimer(40000, 60000)
	antonio.destX = 34
	antonio.destY = 24
	antonio.talkPositionX = 31
	antonio.talkPositionY = 24  
    antonio.sequence =
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_3"			},				
		{ "emily",			"qSetAppearance",	"HAPPY"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_4"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_5"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_51"			},				
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_6"			},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_7"			},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_8"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_9"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_10"			},				
		{ "emily",			"qSetAppearance",	"CONFUSED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_11"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_12"			},				
		{ "antonio",		"qSay",				"RESTAURANT4_DAY2_121"			},				
		{ "emily",			"qSetAppearance",	"SAD"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_13"			},				
		{ "antonio",		"qSetAppearance",	"PROUD"							},						
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_131"			},
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
	
    antonio.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "antonio",		"qSetAppearance",	""								},					
		{ "antonio",		"qWalkToXY",		27, 0							},
		{ "antonio",		"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}

	-- Angela
	angela = pm:createPerson("story_character")
    angela:setBaseName("INGAME_PERSON_ANGELA_WINTER")
    angela:setPosition(grid:getNode(27, 0))
    angela:initTimer(40000, 60000)
	angela.destX = 34
	angela.destY = 24
	angela.talkPositionX = 31
	angela.talkPositionY = 24     
    angela.sequence =
	{	
		{ "scene",			"qStartMovie",		2								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_14"			},						
		{ "angela",			"qSetAppearance",	"SMIRK"							},				
		{ "angela",			"qSay",				"RESTAURANT4_DAY2_15"			},				
		{ "emily",			"qSetAppearance",	"CURIOUS"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_16"			},						
		{ "angela",			"qSetAppearance",	"ENTHUSIASTIC"					},				
		{ "angela",			"qSay",				"RESTAURANT4_DAY2_17"			},				
		{ "angela",			"qSetAppearance",	"SMIRK"							},				
		{ "angela",			"qSay",				"RESTAURANT4_DAY2_18"			},				
		{ "emily",			"qSetAppearance",	"SMIRK"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_19"			},								
		{ "angela",			"qSetAppearance",	"LAUGH"							},				
		{ "angela",			"qSay",				"RESTAURANT4_DAY2_20"			},						
		{ "emily",			"qSetAppearance",	""								},				
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    angela.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "angela",			"qSetAppearance",	""								},					
		{ "angela",			"qWalkToXY",		27, 0							},
		{ "angela",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}
	
	-- Edward
	edward = pm:createPerson("story_character")
    edward:setBaseName("INGAME_PERSON_EDWARD")
    edward:setPosition(grid:getNode(27, 0))
    edward:initTimer(40000, 60000)
	edward.destX = 34
	edward.destY = 24
	edward.talkPositionX = 31
	edward.talkPositionY = 24     
    edward.sequence =
	{	
		{ "scene",			"qStartMovie",		1								},
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_21"			},				
		{ "emily",			"qSetAppearance",	"SAD"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_22"			},				
		{ "emily",			"qSetAppearance",	"CONFUSED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_23"			},				
		{ "edward",			"qSetAppearance",	"LAUGH"							},				
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_24"			},				
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_25"			},				
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_26"			},				
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_27"			},				
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_271"			},				
		{ "emily",			"qSetAppearance",	""								},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_28"			},						
		{ "edward",			"qSay",				"RESTAURANT4_DAY2_281"			},						
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    edward.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "edward",			"qSetAppearance",	""								},					
		{ "edward",			"qWalkToXY",		27, 0							},
		{ "edward",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}	

	-- Evelyn
	evelyn = pm:createPerson("story_character")
    evelyn:setBaseName("INGAME_PERSON_EVELYN")
    evelyn:setPosition(grid:getNode(27, 0))
    evelyn:initTimer(40000, 60000)
	evelyn.destX = 34
	evelyn.destY = 24
	evelyn.talkPositionX = 31
	evelyn.talkPositionY = 24     
    evelyn.sequence =
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "evelyn",			"qSetAppearance",	"ANGRY_POSED"					},				
		{ "evelyn",			"qSay",				"RESTAURANT4_DAY2_29"			},					
		{ "evelyn",			"qSay",				"RESTAURANT4_DAY2_291"			},				
		{ "emily",			"qSetAppearance",	"NOT_AMUSED"					},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_30"			},				
		{ "emily",			"qSetAppearance",	"SAD"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_301"			},				
		{ "evelyn",			"qSay",				"RESTAURANT4_DAY2_31"			},				
		{ "evelyn",			"qSetAppearance",	"SAD"							},				
		{ "evelyn",			"qSay",				"RESTAURANT4_DAY2_311"			},				
		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_312"			},				
		{ "evelyn",			"qSetAppearance",	""								},				
		{ "evelyn",			"qWalkToXY",		29, 15							},
		{ "evelyn",			"qSay",				"RESTAURANT4_DAY2_32"			},				
		{ "evelyn",			"qWalkToXY",		29, 0							},
		{ "emily",			"qSetAppearance",	"LAUGH"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_33"			},						
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    evelyn.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "evelyn",			"qSetAppearance",	""								},					
		{ "evelyn",			"qWalkToXY",		27, 0							},
		{ "evelyn",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}		
	
	antonio:setActive()
	antonio:setNextCharacter(angela)
	angela:setNextCharacter(edward)
	edward:setNextCharacter(evelyn)
		
	self.sequenceStart = 
	{	
		{ "scene",			"qStartMovie",		2								},
		{ "emily",			"qWalkToXY",		23, 22							},
		{ "emily",			"qSetAppearance",	"HAPPY"							},				
		{ "cleaner",		"qWalkToXY",		26, 22							},
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
		{ "emily",			"qSetAppearance",	""								},				
		{ "",				"parallel"											},			
	}

	self.sequenceFinish = 
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "cleaner",		"qWalkToXY",		26, 22							},				
		{ "emily",			"qWalkToXY",		23, 22							},
		{ "emily",			"qSetAppearance",	"CONFUSED"						},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_34"			},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_35"			},		
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY2_36"			},
		{ "emily",			"qSetAppearance",	"SAD"							},				
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY2_37"			},		
		{ "emily",			"qSetAppearance",	"FLIRT"							},				
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_38"			},		
		{ "cleaner",		"qWalkToXY",		27, 0							},				
		{ "emily",			"qWalkToXY",		27, 0							},	
		{ "scene", 			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}
			
end

function day2:onLevelInited()
	qSequence(self.sequenceBegin)
end

function day2:onDayEnd()
	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)
end

-- set day
day = day2()