include("scripts/events/clickevent.lua")

-- set event
event = clickEvent()
event.itemsProps = 
{
    {type="rest4_head",		anchorY=-64,  image="OBJECT_FROZEN_HEAD",   x=36, y=16},
    {type="rest4_arm_l",	anchorY=-48,  image="OBJECT_FROZEN_ARM_R",  x=35, y=19},
    {type="rest4_arm_r",	anchorY=-80,  image="OBJECT_FROZEN_ARM_L",  x=38, y=16},
    {type="rest4_middle",	anchorY=-48,  image="OBJECT_FROZEN_MIDDLE", x=38, y=19},
    {type="rest4_leg_l",	anchorY=0,	  image="OBJECT_FROZEN_LEG_R",  x=39, y=21},
    {type="rest4_leg_r",	anchorY=-32,  image="OBJECT_FROZEN_LEG_L",  x=40, y=20},
}

-- day class
class 'day1' (interface)


function day1:__init() super()
end

function day1:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	event.eventBarImage = "OBJECT_FROZEN_BAR"
	event.timeUntilEnterMin = 500							-- minimum time the person waits outside
	event.timeUntilEnterMax = 1000							-- maximum time the person waits outside
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.clicksNeeded = 25									-- number of clicks to break the ice
	--event.soundClick = ""
	event.sequenceStart	= 									-- text when event starts
	{
		{ "scene",			"qNotify",			"show bar"							}
	}	
	event.highlightX = 38
	event.highlightY = 16
	
	event.sequenceDone = 
	{
		{ "scene",			"qCallback",		self, function(self) cleaner:setShadowVisible(true) cleaner.active = true end },						
		{ "cleaner",		"qSetPosition",		grid:getNode(39, 24)				},						
		{ "scene",			"qStartMovie",		1									},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qWalkToXY",		39, 25								},
		{ "emily",			"qWalkToXY",		36, 25								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_11"				},		
		{ "emily",			"qSetAppearance",	"LAUGH"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_12"				},		
		{ "cleaner",		"qSetAppearance",	""									},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_13"				},		
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_14"				},		
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_15"				},		
		{ "emily",			"qSetAppearance",	"HAPPY"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_16"				},			
		{ "scene",			"qCallback",		self, function(self) cleaner:setReturnHome(true) end },								
		{ "scene", 			"qFinishMovie" 											},
		{ "emily",			"qSetAppearance",	""									},
		{ "",				"parallel"												},			
	}
	
	cleaner:setReturnHome(false)
	self:setFranciousAlpha(0)	
	getObject("rsst4_snow_angel"):setAlpha(0)	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",		2									},
		
		{ "emily",			"qWalkToNode",		grid:getCounterNode()				},		
		{ "cleaner",		"qWalkToXY",		39, 24								},
		{ "cleaner",		"qSetAppearance",	"HAPPY"								},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_0"				},		
		{ "cleaner",		"qCallback",		cleaner, function(c) c:setShadowVisible(false) end },				
		{ "cleaner",		"qSetAppearance",	"FROZEN"							},
		{ "cleaner",		"qAnimateWait",		"SNOW_ANGEL", 1						},		
		{ "cleaner",		"qCallback",		self, function(s) getObject("rsst4_snow_angel"):setAlpha(0.33) end },						
		{ "cleaner",		"qAnimateWait",		"SNOW_ANGEL", 1						},		
		{ "cleaner",		"qCallback",		self, function(s) getObject("rsst4_snow_angel"):setAlpha(0.66) self:setFranciousAlpha(0.25) end },						
		{ "cleaner",		"qAnimateWait",		"SNOW_ANGEL", 1						},			
		{ "cleaner",		"qCallback",		self, function(self) getObject("rsst4_snow_angel"):setAlpha(1) self:setFranciousAlpha(0.4) end },						
		{ "cleaner",		"qAnimate",			"IDLE", 0							},		
		{ "emily",			"qSetAppearance",	"LAUGH"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_1"				},		
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_2"				},		
		{ "emily",			"qSetAppearance",	"CURIOUS"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_3"				},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_4"				},
		{ "emily",			"qSetAppearance",	"LAUGH"								},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_41"				},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY1_42"				},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_5"				},
		{ "cleaner",		"qCallback",		self, function(self) self:setFranciousAlpha(0.65) end },						
		{ "emily",			"qWalkToXY",		39, 25								},
		{ "emily",			"qSetAppearance",	""									},
		{ "emily",			"qAnimateWait",		"FIX", 4							},		
		{ "emily",			"qAnimate",			"IDLE", 0							},		
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_6"				},
		{ "cleaner",		"qCallback",		self, function(self) self:setFranciousAlpha(0.9) end },						
		{ "scene", 			"qFinishMovie" 											},
		{ "cleaner",		"qCallback",		self, function(self) self:setFranciousAlpha(1.0) cleaner.active = false end },						
		{ "scene", 			"qStartGame" 											},		
		{ "",				"parallel"												},			
	}

	self.sequenceEnd = 
	{		
		{ "scene", 			"qStartMovie",		1									},

		{ "",				"sequential"											},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_20"				},
		{ "emily",			"qSay",				"RESTAURANT4_DAY1_21"				},

		{ "emily",			"qWalkToXY",		39, 25								},
		{ "emily",			"qAnimateWait",		"FIX", 1							},		
		{ "emily",			"qCallback",		self, function(self) self:setFranciousAlpha(0.75) end },						
		{ "emily",			"qAnimateWait",		"FIX", 1							},		
		{ "emily",			"qCallback",		self, function(self) self:setFranciousAlpha(0.5) end },						
		{ "emily",			"qAnimateWait",		"FIX", 1							},		
		{ "emily",			"qCallback",		self, function(self) self:setFranciousAlpha(0.25) end },						
		{ "emily",			"qAnimateWait",		"FIX", 1							},		
		{ "emily",			"qCallback",		self, function(self) self:setFranciousAlpha(0.0) end },						

		{"",				"qSequence",		event.sequenceDone					},
		
		{ "scene", 			"qFinishGame" 											},		
	}

end

function day1:onLevelInited()

	qSequence(self.sequenceStart)

end

function day1:setFranciousAlpha(alpha)
	getObject("rest4_head"):setAlpha(alpha)
	getObject("rest4_arm_l"):setAlpha(alpha)
	getObject("rest4_arm_r"):setAlpha(alpha)
	getObject("rest4_middle"):setAlpha(alpha)
	getObject("rest4_leg_l"):setAlpha(alpha)
	getObject("rest4_leg_r"):setAlpha(alpha)
end

function day1:onDayBegin()
	local p = cleaner
	hm:openHint(getHintIndex("HINT_BREAK_ICE"), p:getScreenX(), p:getScreenY() - (p:getHeight() / 2))
end

function day1:onDayEnd()
	
	if (not event.completed) then
		autoAllPeopleWalkOut = false
		qSequence(self.sequenceEnd)
	end
end

function day1:createPerson(class)
	local result = nil
	
	if (class == "cleaner") then
		result = frozenCleaner("INGAME_PERSON_FRANCOIS_WINTER")
		result:setType(class)
		result:animate("IDLE", 0)
		result.clean = true
	end
	
	return result
end

function day1:onNotify(notification)

	if (notification == "active cleaner") then
		cleaner:setShadowVisible(true) 
		cleaner.active = true
	elseif (notification == "click object done") then
		cleaner:qSayTimed("RESTAURANT4_DAY1_" .. math.random(7, 10), 3000)
	end

end


-- set day
day = day1()

class 'frozenCleaner' (d2cleaner)

frozenCleaner.active = true

function frozenCleaner:__init(baseName) 
	super(baseName)
end

function frozenCleaner:onCreate()
	d2cleaner.onCreate(self)
end

function frozenCleaner:acceptTask(task)
	if (self.active) then
		return d2cleaner.acceptTask(self, task)
	end	
	
	return task:getType() == "MessageTask"
end
