include("scripts/events/spiderwebevent.lua")

-- set event
event = spiderwebevent()
event.itemsProps = 
{
    {type="rest4_dirty_spot_1", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=0, y=16},
    {type="rest4_dirty_spot_2", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=6, y=14},
    {type="rest4_dirty_spot_3", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=5, y=18},
    {type="rest4_dirty_spot_4", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=1, y=23},
    {type="rest4_dirty_spot_5", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=6, y=21},
    {type="rest4_dirty_spot_5", anchorY=160, image="EVENT_OPEN_ICE_SPOT", x=4, y=29},
}
event.pixelsToClean = 1600

-- set no skaters for the first day
skaterCountMax = 0

-- day class
class 'day0' (interface)


function day0:__init() super()
end

function day0:onLevelGlobals()
    -- the event
	event.eventBarImage = "OBJECT_CLEANING_CLOTH_BAR"
	event.highlightX = 6
	event.highlightY = 21
	event.timeUntilEnterMin = 5000							-- minimum time the person waits outside
	event.timeUntilEnterMax = 10000							-- maximum time the person waits outside
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.sequenceStart	= 									-- text when event starts
	{
		{ "scene",			"qNotify",			"show bar"					},
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "scene",			"qStartMovie",		2							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_14"		},
		{ "scene",			"qFinishMovie" 									},
	}	
	event.hintId = ""
	event.cleanSound = "SOUND_CLEAN_LOOP2"

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	mo = pm:createPerson("npc")
	mo:setBaseName("INGAME_PERSON_MO_BROKEN")
	mo:setDefaultSection("characters")
	mo:setPosition(grid:getNode(27, 0))
	
	self.startSequence = 
	{
		{ "scene",			"qStartMovie",		2							},
		
		{ "mo",				"qWalkToXY",		36, 25						},
		{ "emily",			"qWalkToXY",		32, 25						},		
		{ "mo",				"qSay",				"RESTAURANT4_DAY0_0"		},
		{ "emily",			"qSetAppearance",	"CURIOUS"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_1"		},
		{ "mo",				"qSetAppearance",	"SAD"						},
		{ "mo",				"qSay",				"RESTAURANT4_DAY0_2"		},
		{ "emily",			"qSetAppearance",	"DISAPPROVE"				},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_3"		},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_31"		},
		{ "mo",				"qSetAppearance",	""							},
		{ "mo",				"qSay",				"RESTAURANT4_DAY0_4"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_5"		},
		{ "mo",				"qSetAppearance",	"HAPPY"						},
		{ "mo",				"qSay",				"RESTAURANT4_DAY0_51"		},
		{ "mo",				"qSetAppearance",	""							},
		{ "mo",				"qSay",				"RESTAURANT4_DAY0_52"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_53"		},
		{ "mo",				"qWalkToXY",		27, 0						},
		{ "mo",				"qDestroy"										},
		
		{ "cleaner",		"qWalkToXY",		36, 25						},
		{ "cleaner",		"qSetAppearance",	"THINK"						},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY0_6"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	"FLIRT"						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_7"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_8"		},
		{ "cleaner",		"qSetAppearance",	"HAPPY"						},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY0_9"		},
		{ "emily",			"qSetAppearance",	"CURIOUS"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_10"		},
		{ "emily",			"qSetAppearance",	""							},
		
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
	}

	self.dayEndSequence = 
	{
		{ "scene",			"qStartMovie",		3							},
	
		{ "cleaner",		"qWalkToXY",		36, 25						},
		{ "emily",			"qWalkToXY",		32, 25						},		

		{ "emily",			"qSay",				"RESTAURANT4_DAY0_15"		},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY0_16"		},
		{ "emily",			"qSetAppearance",	"CURIOUS"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_17"		},
		{ "cleaner",		"qSetAppearance",	"SHOCKED"					},
		{ "cleaner",		"qSay",				"RESTAURANT4_DAY0_18"		},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_19"		},
		{ "emily",			"qSetAppearance",	"LAUGH"						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY0_20"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	""							},
						

		{ "scene",			"qFinishMovie" 									},
	--	{ "scene",			"qFinishGame" 									},
	}

end

function day0:onLevelInited()
	qSequence(self.startSequence)
end

function day0:onDayEnd()
	--autoAllPeopleWalkOut = false
	qSequence(self.dayEndSequence)
end

-- set day
day = day0()