include("scripts/products/regularproduct.lua")
include("scripts/products/rest4_baseovenproduct.lua")
include("scripts/products/rest4_ovenproduct.lua")
include("scripts/products/pearproduct.lua")
include("scripts/products/fruitproduct.lua")
include("scripts/products/treefruitproduct.lua")
include("scripts/appliances/stockappliance.lua")
include("scripts/appliances/fishholeappliance.lua")
include("scripts/appliances/pearappliance.lua")
include("scripts/appliances/redirectappliance.lua")
include("scripts/appliances/fruittreeappliance.lua")
include("scripts/persons/fakecustomer.lua")
include("scripts/persons/skater.lua")
include("scripts/persons/chicken.lua")

-- entry node
-- npc's and such will be spawned at this location
entryX = 34
entryY = 0
entryNode = nil

-- exit node
exitX = 32
exitY = 0
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = entryX
movieY = entryY
movieNode = nil

chicken = nil

-- restaurant class
class 'restaurant4' (interface)

restaurant4.cowState = "WAITING"
restaurant4.cowTimer = 2000
restaurant4.skaterTimer = 0
restaurant4.doSkaters = true
restaurant4.timeUntilFirstSkaterMin = 5000
restaurant4.timeUntilFirstSkaterMax = 10000
restaurant4.timeUntilCheckSkaterMin = 15000
restaurant4.timeUntilCheckSkaterMax = 30000

function restaurant4:__init() super()
end

function restaurant4:onLevelInited()
	if (player:hasUpgradeByIdx(4, 0)) then
		pm:createPerson("goose")
	end		
	
	local fishingStool = getAppliance("rest4_fishing_stool")
	if (fishingStool) then
		fishingStool.target = getAppliance("rest4_fish_hole")	
	end
	
	self.skaterTimer = getRandomRange(self.timeUntilFirstSkaterMin, self.timeUntilFirstSkaterMax)
end

function restaurant4:onNotify(notification)

	if (notification == "trigger injury") then
		skaterInjure = skaterInjure + 1	
	end

end

function restaurant4:createObject(desc)

	local result = nil

	if (desc:getObjectId() == "rest4_chocolate") then
		result = pearappliance()
		result:setType(desc:getType())
		result:setOverheadY(38)
		
		result.toSturDuration = 80000
		result.toDirtyDuration = 8000
		result.sturDuration = 1000
		result.cleanDuration = 2000
		
		result.productName = "CHOCO"
		result.stirAnim = "ANIM_CHOC_STIRR"
		result.spillAnim = "ANIM_CHOC_SPILL"
		result.overheadAnimation = "INGAME_GLUHWEIN_STIR"
		result.hintID = ""
		return result
	elseif (desc:getObjectId() == "rest4_mistletoe_white") then
		result = fruitTreeAppliance()
		result:createHighlight()
		result:setType(desc:getType())
		result:setMaxFruitAmount(3)
		result:setFruitProductBaseName("MISTLETOE_WHITE_")
		return result
	elseif (desc:getObjectId() == "rest4_mistletoe_red") then
		result = fruitTreeAppliance()
		result:createHighlight()
		result:setType(desc:getType())
		result:setMaxFruitAmount(3)
		result:setFruitProductBaseName("MISTLETOE_RED_")
		return result
	elseif (desc:getObjectId() == "rest4_fish_hole") then
		result = fishholeAppliance()
		result:setType(desc:getType())
		result.productFillLimit = 1
		result.productFillAnim = "WORK_LEFT"
		result.productFillTime = 2000
		result.productFillMethod = "random"
		result.products = {"RED_FISH", "BLUE_FISH"}
		return result
	elseif (desc:getObjectId() == "rest4_fishing_stool") then
		result = redirectAppliance()
	end
	
	return result

end

function restaurant4:createProduct(base)

	local bubbleCookieX = 544
	local bubbleCookieY = 446
	local bubbleCookieS = true
	
	if (type(base) == "string")	then
		if (base == "CHOCO") then
			p = pearProduct(base)
			p.applianceName = "rest4_chocolate"
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_POUR_FLUID")
			p:setBubbleX(714)
			p:setBubbleY(544)
			p:setBubbleSmall(false)			
			return p	
		elseif (base == "BREAD") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_SLICE_FRENCH_BREAD")
			p:setWorkOffsetX(3)
			return p
		elseif (base == "CANDY") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(-2)
			return p
		elseif (base == "NOUGAT") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(1)
			return p
		elseif (base == "MARS") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(-2)
			return p
		elseif (base == "CREAM") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			p:setWorkOffsetX(1)
			return p		
		elseif (base == "WATERBOTTLE") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_PLASTIC_WATER")
			p:setWorkOffsetX(1)
			return p	
		elseif (base == "BANDAGE") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("FIX")
			p:setWorkSound("SOUND_PICKUP_FIRSTAID")
			p:setWorkOffsetX(-6)
			return p											
		elseif (base == "BLUE_FISH") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			p:setWorkOffsetX(-2)
			p:setStock(2)
			p:setMaxStock(6)				
			return p
		elseif (base == "RED_FISH") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			p:setWorkOffsetX(1)
			p:setStock(2)
			p:setMaxStock(6)			
			return p
		elseif (base == "DOUGH_TREECUTTER_READY") then
			p = regularProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GETCOOKIE")
			p:setStock(4)
			p:setMaxStock(4)
			p:setWorkOffsetX(-2)
			return p
		elseif (base == "DOUGH_ANGELCUTTER_READY") then
			p = regularProduct(base)
 			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GETCOOKIE")
			p:setStock(4)
			p:setMaxStock(4)	
			p:setWorkOffsetX(2)		
			return p
		elseif (base == "MISTLETOE_WHITE") then
			p = fruitProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("FIX")
			p:setWorkSound("SOUND_PICK_TEA_GARDEN")
			p:setStock(2)
			p:setMaxStock(12)
			p:setWorkOffsetX(-2)
			return p
		elseif (base == "MISTLETOE_RED") then
			p = fruitProduct(base)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(0)
			p:setWorkTime(800)
			p:setWorkAnimation("FIX")
			p:setWorkSound("SOUND_PICK_TEA_GARDEN")
			p:setStock(2)
			p:setMaxStock(12)
			p:setWorkOffsetX(2)
			return p
		elseif (string.find(base, "MISTLETOE_WHITE_")) then
			p = treeFruitProduct(base)
			p:setBasketProductName("MISTLETOE_WHITE")
			p:setAnchorPointType(CENTER)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK")
			return p
		elseif (string.find(base, "MISTLETOE_RED_")) then
			p = treeFruitProduct(base)
			p:setBasketProductName("MISTLETOE_RED")
			p:setAnchorPointType(CENTER)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK")
			return p
		elseif (base == "DOUGH") then
			p = rest4_baseOvenProduct(base)
			p:setBubbleX(bubbleCookieX)
			p:setBubbleY(bubbleCookieY)
			p:setBubbleSmall(bubbleCookieS)
			p:setWorkOffsetX(-5)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_ROLL_DOUGH")
			return p
		elseif (base == "TREECUTTER") then
			p = rest4_baseOvenProduct(base)
			p:setBubbleX(bubbleCookieX)
			p:setBubbleY(bubbleCookieY)
			p:setBubbleSmall(bubbleCookieS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(0)
			return p

		elseif (base == "ANGELCUTTER") then
			p = rest4_baseOvenProduct(base)
			p:setBubbleX(bubbleCookieX)
			p:setBubbleY(bubbleCookieY)
			p:setBubbleSmall(bubbleCookieS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(2)
			return p			
			
		elseif (base == "DOUGH_ANGELCUTTER" or base == "DOUGH_TREECUTTER") then
			p = rest4_ovenProduct(base)
			p:setBubbleTarget("rest4_oven")
			return p
			
		end
	
	elseif (type(base) == "userdata") then
		-- attempting to create a copy!

		if (string.find(base:getBase(), "MISTLETOE_WHITE_")) or (string.find(base:getBase(), "MISTLETOE_RED_")) then
			p = treeFruitProduct(base)
			return p
			
		elseif (base:getBase() == "DOUGH_ANGELCUTTER" or base:getBase() == "DOUGH_TREECUTTER") then
			p = rest4_ovenProduct(base)
			p:setBubbleTarget("rest4_oven")
			return p
		
		end

	end	
	
	return nil
	
end

function restaurant4:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_FRANCOIS_WINTER")
		result:setType(class)
		result:animate("IDLE", 0)
		result.clean = true
	elseif (class == "skater") then
		if (not self.doSkaters) then
			return nil
		end
		
		local baseNames =
		{
			"INGAME_CUSTOMER_MALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_MALE_WINTER_FARMER",
			"INGAME_CUSTOMER_FEMALE_WINTER_FARMER",	
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",				
		}
		local random = getRandom(table.getn(baseNames)) + 1
		result = skater(baseNames[random])
		result:setType(class)
		result:animate("IDLE", 0)
	elseif (class == "goose") then
		result = chickenPerson("INGAME_PERSON_GOOSE")
		result:setType(class)
		result:setShadowY(-20)
		result:animate("IDLE", 0)
		chicken = result
	end

	return result

end	

function restaurant4:onDayBegin()
end

function restaurant4:onDayEnd()
end

function restaurant4:onTick(time)

	if (skaterSoundPlaying) then
		if (skaterCountBusy == 0) then
			cout("(skater) stopping skate sound\n")
			emily:stopSound("SOUND_ICESKATER_LOOP")
			skaterSoundPlaying = false
		end
	else
		if (skaterCountBusy > 0) then
			cout("(skater) starting skate sound\n")
			emily:playSound("SOUND_ICESKATER_LOOP", true)
			skaterSoundPlaying = true
		end	
	end

	if (self.cowTimer > 0) then
		self.cowTimer = self.cowTimer - time
		if (self.cowTimer <= 0) then
			local cow = getObject("rest4_cow_front")
			local base = "DECO_COW_"
		
			if (self.cowState == "LICKING" or self.cowState == "MOOING") then
				-- back to idle
				self.cowState = "WAITING"
				self.cowTimer = getRandomRange(3000, 6000)
				cow:animate(base .. "IDLE", 0)
				
			elseif (self.cowState == "WAITING") then
				-- animation
				if (getRandom(2) == 0) then
					-- moo
					self.cowState = "MOOING"
					self.cowTimer = getRandomRange(5000, 10000)
					cow:animate(base .. "MOOING", 1, 6)
					cow:playSound("SOUND_COW_MOO")
				else
					-- lick
					self.cowState = "LICKING"
					self.cowTimer = getRandomRange(5000, 10000)				
					cow:animate(base .. "LICKING", 1, 6)
				end
			end
		end
	end	
	
	if (scene:isClosed()) then
		return
	end

	if (scene:isPlayingMovie()) then
		return
	end
	
	if (scene:isStartingMovie()) then
		return
	end

	if (self.doSkaters and self.skaterTimer > 0) then
		self.skaterTimer = self.skaterTimer - time
		if (self.skaterTimer <= 0) then
			if (skaterCount < skaterCountMax) then
				pm:createPerson("skater")
			end
			self.skaterTimer = getRandomRange(self.timeUntilCheckSkaterMin, self.timeUntilCheckSkaterMax)
		end
	end
	
end

-- set restaurant
restaurant = restaurant4()