-- set event

-- day class
class 'day9' (interface)

day9.timer = 90000
day9.state = "event not started"

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false	

	entertainer:setPosition(grid:getNode(0, 5))	
	cleaner:setPosition(grid:getNode(0, 7))
	emily:setPosition(grid:getNode(5, 20))
	emily:setAppearance("SAD")

    paul = pm:createPerson("npc")
    paul:setBaseName("INGAME_PERSON_PAUL_WINTER")
    paul:setDefaultSection("characters")
    paul:setPosition(grid:getNode(0, 7))
    paul:setVisible(false)
    paul:setAppearance("SAD")
	
	self.startSequence = 
	{
		{ "scene",			"qStartMovie",			1						},

		{ "cleaner",		"qWalkToXY",		8, 20						},
		{ "cleaner",		"qSetAppearance",	"SURPRISED"					},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY9_0"		},
		{ "emily",			"qSay",				"RESTAURANT3_DAY9_1"		},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY9_2"		},
		{ "emily",			"qSetAppearance",	"CONFUSED"					},
		{ "emily",			"qSay",				"RESTAURANT3_DAY9_3"		},
		{ "cleaner",		"qSetAppearance",	"SHOCKED"					},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY9_4"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	"CONFUSED"					},
		{ "emily",			"qSay",				"RESTAURANT3_DAY9_5"		},
		{ "cleaner",		"qSetAppearance",	"HAPPY"						},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY9_6"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY9_7"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "cleaner",		"qAnimate",			"SHRUG", 1					},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY9_40"		},
		{ "cleaner",		"qAnimate",			"IDLE", 0					},
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()		},
		
		{ "scene",			"qFinishMovie" 									},		
		{ "scene", 			"qStartGame" 									},
	}
	
	self.startEvent = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "cleaner",		"qSetAppearance",		"SHOES"						},		
		{ "cleaner",		"qWalkToXY",			8, 20						},
		{ "emily",			"qWalkToXY",			5, 20						},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY9_8"		},
		{ "cleaner",		"qSetAppearance",		""							},				
		{ "emily",			"qSetBaseName",			"INGAME_PERSON_EMILY_BOOTS"	},
		{ "emily",			"qSetAppearance",		"FLIRT"						},				
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_9"		},
		{ "cleaner",		"qSetAppearance",		"HAPPY"						},		
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY9_10"		},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_11"		},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY9_12"		},
		{ "emily",			"qSetAppearance",		"LAUGH"						},				
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_13"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}
	
	self.dayEndSequence = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "cleaner",		"qWalkToXY",			10, 12						},
		{ "emily",			"qWalkToXY",			5, 20						},	
		{ "paul",			"qSetVisible",			true						},	
		{ "paul",			"qWalkToXY",			8, 20						},	
		{ "emily",			"qSetAppearance",		"SHOCK"						},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_18"		},		
		{ "cleaner",		"qSetAppearance",		"ANGRY"						},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY9_19"		},		
		{ "cleaner",		"qSetAppearance",		""							},
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_20"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_21"		},		
		{ "paul",			"qSetAppearance",		"SAD"						},
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_22"		},
		{ "cleaner",		"qSetAppearance",		"THINK"						},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY9_23"		},		
		{ "cleaner",		"qSetAppearance",		""							},
		{ "emily",			"qSetAppearance",		"ROLL_EYES"					},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_24"		},		
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_25"		},
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_26"		},
		{ "emily",			"qSetAppearance",		"SAD"						},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_27"		},
		{ "paul",			"qSetAppearance",		"SAD"						},
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_28"		},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_29"		},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_30"		},
		{ "paul",			"qSay",					"RESTAURANT3_DAY9_31"		},
		{ "emily",			"qSetAppearance",		"SAD"						},
		{ "emily",			"qSay",					"RESTAURANT3_DAY9_32"		},
		{ "",				"parallel"											},
		{ "emily",			"qWalkToNode",			grid:getNode(0, 5)			},
		{ "cleaner",		"qWalkToNode",			grid:getNode(0, 5)			},
		{ "",				"sequential"										},
		{ "scene",			"qFinishMovie" 										},		
		{ "scene", 			"qFinishGame" 										},
	}
		
	qSequence(self.startSequence)
end

function day9:onLevelInited()
	
end

function day9:onNotify(notification)
	
end

function day9:onDayBegin()
	
end

function day9:onDayEnd()
	qSequence(self.dayEndSequence)	
	autoAllPeopleWalkOut = false
end

function day9:onTick(time)
	
	if (not scene:isStartingMovie() and not scene:isPlayingMovie()) then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				if (self.state == "event not started") then
					self.state = "event started"
					self.timer = 0
					qSequence(self.startEvent)
					pm:setSnowSpeedMultiplier(0.9)

				end
			end
		end
	end
	
end

function day9:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_FRANCOIS_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true
	end
	
	return result
end	

-- set day
day = day9()
