include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Spider"
}

-- day class
class 'day8' (interface)

function day8:__init() super()
end

day8.numObjecsFound = 0

function day8:onLevelGlobals()

	entertainer:setPosition(grid:getNode(0, 5))	
	cleaner:setPosition(grid:getNode(0, 5))
	emily:setPosition(grid:getNode(0, 5))


	autoStartGame = false
	autoAllPeopleWalkIn = false	

	event.timeUntilEnterMin = 1
	event.timeUntilEnterMax = 2
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = true
	event.numItems = 10
	event.highlightX = 33
	event.highlightY = 13

	cleaner:setPosition(grid:getNode(8, 20))

	self.sequenceStart = 
	{
		{ "scene",		"qStartMovie",			1							},
		
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY8_0"			},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY8_1"			},
		{ "emily",		"qSetAppearance",	"CURIOUS"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY8_2"			},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY8_3"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY8_4"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY8_5"			},
		{ "cleaner",	"qSetAppearance",	"LAUGH"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY8_6"			},		
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY8_7"			},		
			
		{ "scene",		"qNotify",			"ho_arrived"					},		
		{ "scene",		"qNotify",			"show bar"						},
		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "scene",		"qFinishMovie" 										},		
		{ "scene",		"qStartGame" 										},		
	}

	self.foundObject0 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_8"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_9"		},	
		{ "scene",			"qFinishMovie" 										},		
	}
	
	self.foundObject1 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_10"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject2 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_11"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject3 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_12"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject4 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_13"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject5 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_14"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject6 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_15"		},
		{ "emily",			"qSetAppearance",		"LAUGH"						},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_16"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject7 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_17"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.foundObject8 = 
	{
		{ "scene",			"qStartMovie",			1							},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_18"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "scene",			"qFinishMovie" 										},		
	}

	self.dayEndSequence = 
	{
		{ "scene",			"qStartMovie",			1							},
		
		{ "cleaner",		"qWalkToXY",			5, 20						},
		{ "emily",			"qWalkToXY",			8, 20						},
		{ "emily",			"qSetAppearance",		"CONFUSED"					},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_19"		},
		{ "emily",			"qSetAppearance",		""							},
		{ "cleaner",		"qSetAppearance",		"LAUGH"						},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY8_20"		},
		{ "emily",			"qSetAppearance",		""							},
		
		{ "cleaner",		"qAnimateWait",			"PROPOSE", 1, false, -1, true },
		{ "cleaner",		"qSetAppearance",		"PROPOSE"					  },	
		{ "emily",			"qSetAppearance",		"SHOCK"						},
		{ "emily",			"qWait",				500							},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY8_22"		},
		{ "cleaner",		"qSay",					"RESTAURANT3_DAY8_23"		},
		{ "emily",			"qSay",					"RESTAURANT2_DAY9_1"		},
		{ "emily",			"qSetAppearance",		"OFFENDED"					},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_24"		},
		{ "emily",			"qSetAppearance",		"SAD"						},		
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_25"		},
		{ "cleaner",		"qSetAppearance",		"SAD"						},	
		{ "cleaner",		"qWalkToXY",			0, 7						},
		{ "emily",			"qSetAppearance",		"SHOCK"						},
		{ "emily",			"qSay",					"RESTAURANT3_DAY8_26"		},
		{ "scene",			"qFinishMovie" 										},		
		{ "scene",			"qFinishGame" 										},		
	}
	
	qSequence(self.sequenceStart)
end

function day8:onDayBegin()
end

function day8:onDayEnd()
	autoAllPeopleWalkOut = false
	qSequence(self.dayEndSequence)
end

function day8:onNotify(notification)
	if (notification == "hiddenObject click") then
		cout("foundObject" .. self.numObjecsFound .. "\n")
		qSequence(self["foundObject" .. self.numObjecsFound])
		self.numObjecsFound = self.numObjecsFound + 1
	end
end


function day8:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set day
day = day8()