
-- set event

-- day class
class 'day7' (interface)

day7.state = "not active"
day7.timer = 19000 -- duration before question 1

function day7:__init() super()
end

function day7:onLevelGlobals()
	
	entertainer:setPosition(grid:getNode(0, 5))	
	cleaner:setPosition(grid:getNode(0, 5))
	emily:setPosition(grid:getNode(0, 5))

	autoStartGame = false

    richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD_WINTER")
    richard:setDefaultSection("characters")
    richard:setPosition(grid:getNode(0, 7))

	emily:setPosition(grid:getNode(5, 20))
    
	self.sequenceStart = 
	{
		{ "scene",		"qStartMovie",			1							},
		
		{ "cleaner",	"qWalkToXY",		10, 8							},		
		{ "richard",	"qWalkToXY",		8, 20							},
		{ "richard",	"qSetAppearance",	"SORRY"							},
		{ "richard",	"qSay",				"RESTAURANT3_DAY7_0"			},
		{ "emily",		"qSetAppearance",	"SHOCK"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_1"			},
		{ "richard",	"qSay",				"RESTAURANT3_DAY7_2"			},
		{ "emily",		"qSetAppearance",	"CURIOUS"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_3"			},
		{ "richard",	"qSay",				"RESTAURANT3_DAY7_4"			},
		{ "richard",	"qSetAppearance",	"SERIOUS"						},
		{ "richard",	"qSay",				"RESTAURANT3_DAY7_5"			},
		{ "richard",	"qWalkToXY",		0, 7							},	
		{ "richard",	"qDestroy"											},
		{ "cleaner",	"qWalkToXY",		8, 20							},
		{ "cleaner",	"qSetAppearance",	"CONFUSED"						},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_6"			},
		{ "emily",		"qSetAppearance",	"CONFUSED"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_7"			},
		{ "cleaner",	"qSetAppearance",	"SAD"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_8"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_9"			},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_10"			},
		{ "cleaner",	"qWalkToNode",		grid:getCleanerNode()			},
		
		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "scene",		"qFinishMovie" 										},		
		{ "scene",		"qStartGame" 										},		
	}    

    self.sequenceQ1 = 
	{
		{ "scene",		"qStartMovie",			2							},
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "cleaner",	"qWalkToXY",		8, 20							},		
		{ "cleaner",	"qSetAppearance",	"ROLLEYES"						},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_11"			},
		{ "emily",		"qSetAppearance",	"FLIRT"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_12"			},
		{ "cleaner",	"qSayYesNo",		"RESTAURANT3_DAY7_13"			},	
	}

    self.sequenceQ2 = 
	{
		{ "scene",		"qStartMovie",			2							},
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "cleaner",	"qWalkToXY",		8, 20							},		
		{ "cleaner",	"qSetAppearance",	"ROLLEYES"						},
		{ "cleaner",	"qSayYesNo",		"RESTAURANT3_DAY7_16"			},

	}

    self.sequenceQ3 = 
	{
		{ "scene",		"qStartMovie",			2							},
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "cleaner",	"qWalkToXY",		8, 20							},		
		{ "cleaner",	"qSetAppearance",	"ROLLEYES"						},
		{ "cleaner",	"qSayYesNo",		"RESTAURANT3_DAY7_19"			},

	}
    
    self.endDaySequence = 
	{
		{ "scene",		"qStartMovie",			1							},
		
		{ "cleaner",	"qSetAppearance",	"ROLLEYES"						},
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "cleaner",	"qWalkToXY",		8, 20							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_22"			},
		{ "emily",		"qSetAppearance",	"CONFUSED"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_23"			},
		{ "cleaner",	"qSetAppearance",	"CONFUSED"						},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY7_24"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_25"			},
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY7_26"			},
		{ "cleaner",	"qSetAppearance",	""								},
		
		{ "scene",		"qFinishMovie" 										},		
	}    

    
    qSequence(self.sequenceStart)
end


function day7:onClickMessage(text, result)
	local sequence = nil

	if (text == "RESTAURANT3_DAY7_13") then
		choose("dontWorkTogether", result)
	
		if (result == "yes") then
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_14"					},						
			}
		else
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_15"					},						
			}
		end

	elseif (text == "RESTAURANT3_DAY7_16") then
		choose("commitmentImportant", result)
	
		if (result == "yes") then
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_17"					},						
			}
		else
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_18"					},						
			}
		end
	elseif (text == "RESTAURANT3_DAY7_19") then
		choose("commitmentOverFreedom", result)
	
		if (result == "yes") then
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_20"					},						
			}
		else
			sequence = 
			{		
				{ "emily",			"qSay",	"RESTAURANT3_DAY7_21"					},						
			}
		end
	end
	
	if (sequence ~= nil) then
		local endSequence = 
		{
			{ "emily",			"qSetAppearance",	""								},						
			{ "cleaner",		"qSetAppearance",	""								},						
			{ "scene", 			"qFinishMovie" 										},
		}
		insert()
		qSequence(sequence)	
		qSequence(endSequence)			
		append()
	end
end

function day7:onDayBegin()
	self.state = "question1"
end

function day7:onDayEnd()
    qSequence(self.endDaySequence)
end

function day7:onTick(time)

	if (self.state ~= "not active" and
	 not scene:isStartingMovie() and 
	 not scene:isPlayingMovie()) then
		
		self.timer = self.timer - time
		if (self.timer <= 0) then
			if (self.state == "question1") then
				self.state = "question2"
				self.timer = 40000 -- duration from question 1 to question 2
				qSequence(self.sequenceQ1)
			elseif (self.state == "question2") then
				self.state = "question3"
				self.timer = 40000 -- duration from question 2 to question 3
				qSequence(self.sequenceQ2)		
			elseif (self.state == "question3") then
				self.state = "not active"
				qSequence(self.sequenceQ3)					
			end
		end	 
	 end
end



function day7:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true
	end
	
	return result
end	

-- set the day
day = day7()
