include("scripts/events/brokenObjectEvent.lua")

-- set event
event = brokenObjectEvent()

event.targetId = "rest3_flag"
event.nrTargets = 5
event.manual = false
event.alwaysShowBar = false

-- day class
class 'day6' (interface)

day6.halfWayTimer = 220000
day6.state = "not started"
day6.specialSkiHill = nil


function day6:__init() super()
end

function day6:onLevelGlobals()

	createDummyObject("specialSkiHill", 26, 0)

	entertainer:setPosition(grid:getNode(0, 5))	
	emily:setPosition(grid:getNode(0, 5))

	autoStartGame = false

	cleaner:setPosition(grid:getNode(5, 20))
	
	event.animFix = "FIX"
	event.soundFix = "SOUND_STICKING_FLAG_IN"
	event.overheadX = 3
	event.overheadY = 100
	event.pbY = 20
	event.timeUntilFixed = 1000 * 10
	event.scoreGotAll = 100
	event.score = 50
	event.sequenceWinAfterSwap = 
	{
		{ "scene",		"qStartMovie",			2							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_13"			},
		{ "emily",		"qNotify",			"flags done"					},
		{ "scene",		"qFinishMovie" 										},			
	}	
	
    mo = pm:createPerson("npc")
    mo:setBaseName("INGAME_PERSON_MO_BROKEN")
    mo:setDefaultSection("characters")
    mo:setPosition(grid:getNode(0, 5))

    elvis = pm:createPerson("npc")
    elvis:setBaseName("INGAME_PERSON_ELVIS")
    elvis:setDefaultSection("characters")
    elvis:setPosition(grid:getNode(0, 5))

	self.sequenceStart = 
	{
		{ "scene",		"qStartMovie",			2							},
		
		{ "emily",		"qWalkToXY",		8, 20							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_0"			},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_1"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_2"			},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_3"			},
		{ "elvis",		"qWalkToXY",		11, 12							},
		{ "mo",			"qWalkToXY",		7, 12							},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "emily",		"qSetAppearance",	"CONFUSED"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_5"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_7"			},
		{ "emily",		"qSetAppearance",	"SHOCK"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_8"			},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_9"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_10"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_11"			},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_12"			},

		{ "mo",			"qWalkToXY",		0, 5							},
		{ "mo",			"qSetVisible",		false							},
	
		{ "elvis",		"qSay",				"RESTAURANT4_DAY1_41"			},
		{ "elvis",		"qSetAppearance",	"HAPPY"							},
		{ "elvis",		"qSay",				"RESTAURANT3_DAY6_20"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_21"			},
		{ "elvis",		"qSetAppearance",	"SAD"							},
		{ "elvis",		"qSay",				"RESTAURANT3_DAY6_22"			},	
		{ "elvis",		"qWalkToXY",		0, 5							},
		{ "elvis",		"qSetVisible",		false							},

		{ "cleaner",	"qSetAppearance",	""								},
		{ "emily",		"qSetAppearance",	""								},
		{ "scene",		"qFinishMovie" 										},			
		{ "scene",		"qStartGame" 										},			
	}
	
    sp1 = pm:createPerson("npc")
    sp1:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_REGULAR")
    sp1:setDefaultSection("customers")
    sp1:setPosition(grid:getNode(0, 5))
    sp1:setVisible(false)

    sp2 = pm:createPerson("npc")
    sp2:setBaseName("INGAME_CUSTOMER_MALE_WINTER_YUPPIES")
    sp2:setDefaultSection("customers")
    sp2:setPosition(grid:getNode(0, 5))
    sp2:setVisible(false)
	
    sp3 = pm:createPerson("npc")
    sp3:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_DESIGNER")
    sp3:setDefaultSection("customers")
    sp3:setPosition(grid:getNode(0, 5))
    sp3:setVisible(false)

    sp4 = pm:createPerson("npc")
    sp4:setBaseName("INGAME_CUSTOMER_MALE_WINTER_BIGGIES")
    sp4:setDefaultSection("customers")
    sp4:setPosition(grid:getNode(0, 5))
    sp4:setVisible(false)
	
	self.wonPrepareContest = 
	{
		{ "scene",		"qStartMovie",			3							},
	}
	
	self.lostPrepareContest = 
	{
		{ "scene",		"qStartMovie",			3							},
		{ "emily",		"qWalkToXY",		20, 20							},
		{ "emily",		"qSetAppearance",	"PANIC"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_30"			},
		{ "cleaner",	"qWalkToXY",		16, 19							},
		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_31"			},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()			},
			
		-- TODO cleaner place flags!
	}

	self.startContest = 
	{
		{ "sp1",		"qSetVisible",		true							},
		{ "sp2",		"qSetVisible",		true							},
		{ "sp3",		"qSetVisible",		true							},
		{ "sp4",		"qSetVisible",		true							},		
		{ "",			"parallel"											},		
		{ "sp1",		"qWalkToXY",		20, 24							},
		{ "sp3",		"qWait",			1000							},
		{ "sp3",		"qWalkToXY",		32, 28							},
		{ "sp2",		"qWait",			2000							},
		{ "sp2",		"qWalkToXY",		19, 32							},
		{ "sp4",		"qWait",			3000							},
		{ "sp4",		"qWalkToXY",		18, 12							},

		{ "",			"sequential"										},		
		{ "emily",		"qWalkToXY",		32, 20							},
		{ "cleaner",	"qWalkToXY",		32, 12							},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_135"			},
		{ "cleaner",	"qSetAppearance",	""								},

		{ "sp4",		"qNotify",			"start contest"					},
	}

	self.endContestWon = 
	{		
		{ "scene",		"qFadeToBlack"										},
		{ "scene",		"qFadeOutBlack"										},
		
		{ "elvis",		"qSetVisible",		true							},
		{ "mo",			"qSetVisible",		true							},
		{ "elvis",		"qWalkToXY",		41, 15							},
		{ "mo",			"qWalkToXY",		32, 15							},
		{ "cleaner",	"qWalkToXY",		38, 15							},

		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "mo",			"qSetAppearance",	"SAD"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_14"			},
		{ "elvis",		"qAnimateWait",		"ENTERTAIN", 2					},
		{ "elvis",		"qAnimate",			"IDLE", 0						},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "cleaner",	"qAnimateWait",		"GIVE_MEDAL", 1					},
		{ "elvis",		"qSetAppearance",	"MEDAL"							},
		{ "cleaner",	"qAnimate",			"IDLE", 0						},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY6_15"			},
		{ "elvis",		"qSay",				"RESTAURANT3_DAY6_16"			},
		{ "emily",		"qWalkToXY",		35, 15							},
		{ "emily",		"qSetAppearance",	"CURIOUS"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_17"			},
		{ "mo",			"qSetAppearance",	"LAUGH"							},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_175"			},
		{ "mo",			"qSetAppearance",	""								},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_18"			},
		{ "mo",			"qSetAppearance",	"LAUGH"							},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_19"			},
		{ "emily",		"qAnimateWait",		"LAUGH", 1						},
		{ "",			"sequential"										},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qFinishGame" 										},
	}

	self.endContestLost = 
	{
		{ "scene",		"qFadeToBlack"										},
		{ "scene",		"qFadeOutBlack"										},
		{ "elvis",		"qSetVisible",		true							},
		{ "mo",			"qSetVisible",		true							},
		{ "elvis",		"qWalkToXY",		38, 15							},
		{ "mo",			"qWalkToXY",		32, 15							},
		{ "cleaner",	"qWalkToXY",		41, 15							},
		{ "emily",		"qWalkToXY",		35, 15							},
	
		{ "emily",		"qSetAppearance",	"CURIOUS"						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY6_32"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "mo",			"qSetAppearance",	"HAPPY"							},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_33"			},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_34"			},
		{ "mo",			"qSetAppearance",	""								},
		{ "mo",			"qSay",				"RESTAURANT3_DAY6_35"			},

		{ "",			"sequential"										},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qFinishGame" 										},
	}
		
	qSequence(self.sequenceStart)
end

function day6:onLevelInited()
	restaurant.skiHill.active = false
end

function day6:onDayBegin()
	self.state = "started"
	
	assert(#(event.brokenObjects) == event.nrTargets)
	event.brokenObjects[3]:createScreenOverhead("INGAME_ARROW")
end

function day6:onDayEnd()
	autoAllPeopleWalkOut = false
	restaurant.skiHill.active = false
	if (event.completed) then
		qSequence(self.wonPrepareContest)
	else
		qSequence(self.lostPrepareContest)
	
		for index, value in ipairs(event.brokenObjects) do
			-- init object
			value:removeOverhead()
			if (value.state == "broken") then
				cleaner:qWalkToNode(value:getWorkNode())
				cleaner:qAnimateWait("FIX", 2)
				cleaner:qCallback(value, function(obj) obj.state = "fixed" obj:fix() end)
			end			
		end		
		cleaner:qWalkToXY(32, 12)
	end
	qSequence(self.startContest)
end

function day6:onTick(time)
	if (self.state == "started" and
	 not scene:isStartingMovie() and 
	 not scene:isPlayingMovie()) then
		self.halfWayTimer = self.halfWayTimer - time
		if (self.halfWayTimer <= 0) then
			self.state = "halfway"
		end
	end
end

function day6:onNotify(notification)
	if (notification == "flags done") then
		if (self.state == "started") then
			self.state = "practice"
			restaurant.skiHill.characters = {}
			restaurant.skiHill.characters = {"INGAME_PERSON_MO_SKI", "INGAME_PERSON_ELVIS_SKI"}	
			restaurant.skiHill.active = true
		end		
	elseif (notification == "start contest") then
		if (self.state == "practice") then
			self.specialSkiHill.characters = {"INGAME_PERSON_ELVIS_SKI",		
								"INGAME_PERSON_MO_SKI", 
								"INGAME_PERSON_REGULAR_FEMALE_SKI", 
								"INGAME_PERSON_YUPPIES_MALE_SKI"}
		else
			self.specialSkiHill.characters = {"INGAME_PERSON_REGULAR_FEMALE_SKI", 
								"INGAME_PERSON_YUPPIES_MALE_SKI", 
								"INGAME_PERSON_ELVIS_SKI",
								"INGAME_PERSON_MO_SKI"}
		end	
		self.specialSkiHill.active = true
	elseif (notification == "contest done") then
		if (self.state == "practice") then
			cout("qSequence(self.endContestWon)\n")
			qSequence(self.endContestWon)
		else
			cout("qSequence(self.endContestLost)\n")
			qSequence(self.endContestLost)
		end
	end

end

function day6:createObject(desc)
	if (desc:getType() == "specialSkiHill") then
		result = specialSkiHill()
		result:setType(desc:getType())
		self.specialSkiHill = result
		return result
	end
	return nil
end

function day6:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set day
day = day6()

class 'specialSkiHill' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
specialSkiHill.timer = 1000
specialSkiHill.active = false
specialSkiHill.characterIdx = 1
specialSkiHill.characters = {}

function specialSkiHill:__init() super()
end

function specialSkiHill:onCreate()
end

function specialSkiHill:onTick(time)
	if (self.active == false) then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer <= 0) then
	
		if (self.characterIdx > 4) then
			self.active = false
			emily:qNotify("contest done")
			return
		end
	
		self.timer = math.random(1500, 3000)
		if (self.characterIdx == 4) then self.timer = 6000 end
		
		local skiPerson = createSprite()
		skiPerson:setDefaultSection("characters")
		skiPerson:animate(self.characters[self.characterIdx], -1, 10)
		skiPerson:setX(-47)
		skiPerson:setY(-200)
		skiPerson:addLocationAnimation(-47, 600, math.random(4000, 4500), true, 0)
		self:addChild(skiPerson)			
		self.characterIdx = self.characterIdx + 1
	end
end
