include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day5' (interface)

day5.numPackages = 0
day5.midDayTimer = 100000
day5.dayEndSequence = nil

function day5:__init() super()
end

function day5:onLevelGlobals()
	autoStartGame = false
	autoAllPeopleWalkIn = false

	entertainer:setPosition(grid:getNode(0, 5))	
	emily:setPosition(grid:getNode(0, 5))
    cleaner:setPosition(grid:getNode(0, 5))
		
	paul = pm:createPerson("npc")
    paul:setBaseName("INGAME_PERSON_PAUL")
    paul:setPosition(grid:getNode(0, 5))

	evelyn = pm:createPerson("npc")
    evelyn:setBaseName("INGAME_PERSON_EVELYN")
    evelyn:setPosition(grid:getNode(0, 5))

	self.sequenceStart = 
	{
		{ "scene",		"qStartMovie",			2							},
		
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "emily",		"qWait",			1000							},
		{ "paul",		"qWalkToXY",		8, 20							},
		
		{ "emily",		"qSetAppearance",	"HAPPY"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_0"			},
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_1"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_2"			},
		{ "paul",		"qSetAppearance",	"HAPPY"							},
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_3"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_4"			},
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_5"			},
		{ "paul",		"qSetAppearance",	""								},
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_6"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_7"			},
		{ "paul",		"qSetAppearance",	"ROLLEYES"						},
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_8"			},
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_9"			},
		
		{ "paul",		"qSetAppearance",	""								},
		{ "paul",		"qWalkToXY",		0, 5							},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qWait",			1000							},
		{ "cleaner",	"qWalkToXY",		8, 20							},
		{ "emily",		"qSetAppearance",	"HAPPY"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_10"			},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_11"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_12"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_13"			},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_14"			},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()			},

		{ "scene",		"qFinishMovie" 										},		
		{ "scene",		"qStartGame" 										},		
	}


	self.dayMidSequence = 
	{
		{ "scene",		"qStartMovie",			2							},

		{ "evelyn",		"qWalkToXY",		38, 14							},
		{ "emily",		"qWalkToXY",		34, 14							},
		{ "evelyn",		"qSay",				"RESTAURANT3_DAY5_24"			},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_25"			},
		{ "evelyn",		"qSetAppearance",	"HAPPY"							},
		{ "evelyn",		"qSay",				"RESTAURANT3_DAY5_26"			},
		{ "emily",		"qSetAppearance",	"HAPPY"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_27"			},
		{ "evelyn",		"qWalkToXY",		0, 5							},
		{ "evelyn",		"qDestroy"											},
		{ "emily",		"qSetAppearance",	""								},
		
		{ "scene",		"qFinishMovie" 										},		
	}
	
	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 20000
	event.timeUntilEnterMax = 35000
	event.timeUntilAngry = 7000
	event.timeUntilLeave = 4000
	event.numPackages = 6
	event.entryX = 0
	event.entryY = 5
	event.waitX = 38
	event.waitY = 14
	event.workX = 34
	event.workY = 14
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.autoTransfer = true

	self.firstPackage = 
	{
		{ "scene",		"qStartMovie",			2							},
		{ "person",		"qAnimate",			"IDLE", 0						},
		
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_15"			},
		{ "person",		"qSay",				"RESTAURANT3_DAY5_16"			},
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_17"			},
		{ "person",		"qSay",				"RESTAURANT3_DAY5_18"			},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_19"			},	
		
		{ "scene",		"qFinishMovie" 										},		
	}

	qSequence(self.sequenceStart)
end

function day5:onLevelInited()
end

function day5:onDayBegin()
end

function day5:onDayEnd()
	autoAllPeopleWalkOut = false

	local dayEndSequence = 
	{
		{ "scene",		"qStartMovie",			3							},
		
		{ "emily",		"qWalkToXY",		5, 20							},
		{ "cleaner",	"qWalkToXY",		8, 20							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_28"			},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},	
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_29"			},
		{ "emily",		"qSetAppearance",	"CURIOUS"						},	
		{ "emily",		"qSay",				"RESTAURANT3_DAY5_30"			},
		{ "cleaner",	"qSetAppearance",	"THINK"							},	
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_31"			},

		{ "",			"parallel"											},		
		{ "cleaner",	"qWalkToXY",		38,	13							},
		{ "paul",		"qWait",			1100							},
		{ "paul",		"qWalkToXY",		35,	13							},
		{ "paul",		"qSetAppearance",	"ANGRY"							},	
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_32"			},	
		
		{ "",			"sequential"										},		
		{ "cleaner",	"qSetAppearance",	"SHOCKED"						},	
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_33"			},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY5_34"			},
		{ "paul",		"qSetAppearance",	"LAUGH"							},	
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_35"			},	
		{ "paul",		"qSetAppearance",	"HAPPY"							},	
		{ "paul",		"qSay",				"RESTAURANT3_DAY5_36"			},	

		{ "cleaner",	"qSetAppearance",	""								},	
		{ "paul",		"qSetAppearance",	""								},	
		{ "emily",		"qSetAppearance",	""								},			
		{ "",			"parallel"											},		
		{ "emily",		"qWalkToXY",		0, 5							},
		{ "cleaner",	"qWalkToXY",		0, 5							},
		{ "entertainer","qWalkToXY",		0, 5							},
		{ "paul",		"qWalkToXY",		0, 5							},
			
		{ "",			"sequential"										},	
		{ "scene",		"qFinishMovie" 										},		
		{ "scene",		"qFinishGame" 										},		
	}
	qSequence(dayEndSequence)
end

function day5:onNotify(notification)
	if (notification == "before package delivered") then
		self.numPackages = self.numPackages + 1
		
		if (self.numPackages == 1) then
			qSequence(self.firstPackage)
--		elseif (event.person.handed == 3) then
--			qSequence(self.reminder1Package)	
--		elseif (event.person.handed == 5) then
--			qSequence(self.reminder2Package)		
		end
	end
end

function day5:onTick(time)
	
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	if (self.midDayTimer <= 0) then
		if (event.person.state == "wait to enter" and self.dayMidSequence) then
			qInsertSequence(self.dayMidSequence)
			self.dayMidSequence = nil
		end
		return
	end
	self.midDayTimer = self.midDayTimer - time
end

function day5:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_FRANCOIS_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set day
day = day5()