include("scripts/events/ordertableevent.lua")

-- set event
event = orderTableEvent()

-- day class
class 'day4' (interface)

day4.table1 = nil
day4.shouldOrder = true

day4.contestant1 = nil -- Arty Farty
day4.contestant2 = nil -- Biggie
day4.contestant3 = nil -- Elvis
day4.contestant4 = nil -- Betty

day4.state = "not active"
day4.timer = 15 * 1000			-- Time before Paul makes his compliment

function day4:__init() super()
end

function day4:onLevelGlobals()
	autoStartGame = false
	autoAllPeopleWalkIn = false

	entertainer:setPosition(grid:getNode(0, 5))	
	emily:setPosition(grid:getNode(38, 14))
	cleaner:setPosition(grid:getNode(0, 5))
	
	-- set tables
	self.table1 = om:getTable(0)
	self.table1:setReserved(true)

	-- create contestants
	self.contestant1 = pm:createPerson("fakecustomer")
	self.contestant1:setPosition(grid:getNode(0,5))
	self.contestant1.state = "READ"
	self.contestant1.timer = 1
	self.contestant1:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_REGULAR")
	self.contestant1:setVisible(false)
	
	self.contestant2 = pm:createPerson("fakecustomer")
	self.contestant2:setPosition(grid:getNode(0,5))
	self.contestant2.state = "READ"
	self.contestant2.timer = 1
	self.contestant1:setBaseName("INGAME_CUSTOMER_MALE_WINTER_REGULAR")
	self.contestant2:setVisible(false)
	
	self.contestant3 = pm:createPerson("fakecustomer")
	self.contestant3:setPosition(grid:getNode(0,5))
	self.contestant3.state = "READ"
	self.contestant3.timer = 1
	self.contestant3:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_YUPPIES")
	self.contestant3:setVisible(false)
	
	self.contestant4 = pm:createPerson("fakecustomer")
	self.contestant4:setPosition(grid:getNode(0,5))
	self.contestant4.state = "READ"
	self.contestant4.timer = 1
	self.contestant4:setBaseName("INGAME_CUSTOMER_MALE_WINTER_YUPPIES")
	self.contestant4:setVisible(false)
	
	event.pool =
	{
		"COKE",
		"BRATWURST_READY",
		"GLUHWEIN",
		"FRIES_RED_SAUCE",
		"FRIES_WHITE_SAUCE",
		"QUICHE",
		"CORN",
		"PAPRIKA",
		"BREAD",
	}
	
	event.chances =
	{ 	
		10, 
		10,
		10,
		10, 
		10,
		10,
		10,
		10,
		10,
	}
	
	event.timeUntilEnterMin = 5000
	event.timeUntilEnterMax = 5001		
	event.timeUntilNextOrder = 25000					-- interval at which the orders come
	event.timeUntilEnd = 480000							-- time allowed to make all products
	event.timeTransfer = 400							-- time it takes to transfer the order	
	event.numProductsPerOrder = 2						-- number of products ordered each order
	event.numOrders = 10									-- total number of orders
	event.score = 40
	event.maxBalloonSize = 12
	event.maxBalloonWidth = 3
	event.table = self.table1
	event.orderOffsetY = 70
	event.subjectImage = "OBJECT_SHOUT_MAKE_BAR"

	-- the sequences
	event.sequenceStart =
	{
		{ "scene",				"qNotify",			"start"						},	
		{ "",					"parallel"										},		
		{"contestant2",			"qSetVisible",		true						},
		{"contestant2",			"qSitAt",			self.table1, 1				},
		{"contestant3",			"qSetVisible",		true						},
		{"contestant3",			"qWait",			1000						},
		{"contestant3",			"qSitAt",			self.table1, 3				},
		
		{ "scene",				"qNotify",			"start ordering"			},
	}		
	
	event.sequenceWin = 
	{
		{ "scene",			"qStartMovie",			2							},

		{ "emily",			"qSetAppearance",	"HAPPY"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_14"			},
		{ "emily",			"qSetAppearance",	""								},

		{ "scene",			"qFinishMovie" 										},			
		{ "",				"qSequence",		"sequenceExit" 					},	
		{ "",				"parallel"											},			
	}

	event.sequenceLose = 
	{		
		{ "",				"qSequence",		"sequenceExit" 					},
		{ "",				"parallel"											},			
	}

	event.sequenceExit = 
	{		
		{ "",				"parallel"											},		
		{"contestant1",		"qWalkToXY",		0, 5							},
		{"contestant2",		"qWait",			1000							},
		{"contestant2",		"qWalkToXY",		0, 5							},
		{"contestant3",		"qWait",			1000							},
		{"contestant3",		"qWalkToXY",		0, 5							},
		{"contestant4",		"qWait",			1000							},
		{"contestant4",		"qWalkToXY",		0, 5							},
		{ "scene",			"qNotify",			"all left"						},
	}
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			2							},

		{ "contestant1",	"qSetVisible",		true							},
		{ "contestant4",	"qSetVisible",		true							},		
		
		{ "",				"parallel"											},		
		{ "contestant1",	"qWalkToXY",		35, 14							},
		{ "contestant4",	"qWait",			1000							},
		{ "contestant4",	"qWalkToXY",		32, 14							},
		
		{ "",				"sequential"										},		
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_0"			},
		{ "contestant1",	"qSay",				"RESTAURANT3_DAY4_1"			},
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_2"			},
		{ "contestant4",	"qSay",				"RESTAURANT3_DAY4_3"			},
		
		{ "emily",			"qSetAppearance",	"HAPPY"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_4"			},
		{ "contestant1",	"qSay",				"RESTAURANT3_DAY4_5"			},
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_6"			},
		{ "contestant4",	"qSay",				"RESTAURANT3_DAY4_7"			},
		
		{ "",				"parallel"											},		
		{ "contestant1",	"qSitAt",			self.table1, 0					},
		{ "contestant4",	"qSitAt",			self.table1, 2					},
		{ "emily",			"qWalkToXY",		5, 20							},
					
		{ "",				"sequential"										},		
		{ "emily",			"qSetAppearance",	""								},		
		{ "scene",			"qFinishMovie" 										},			
		{ "scene",			"qStartGame" 										},			
	}

	self.paul1 =
	{
		{ "scene",			"qStartMovie",			1							},

		{ "emily",			"qWalkToXY",		5, 20							},
		{ "cleaner",		"qWalkToXY",		8, 20							},	
		
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY4_8"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY4_9"			},

		{ "cleaner",		"qSetAppearance",	""								},
		{ "emily",			"qSetAppearance",	""								},	
		--HUG
		
		{ "emily",			"qWalkToXY",		6, 20							},
		{ "emily",			"qSetVisible",		false							},
		{ "cleaner",		"qSetAppearance",	"HUG", 							},
		{ "cleaner",		"qWait",			750								},
		{ "cleaner",		"qSetAppearance",	"", 							},
		{ "emily",			"qSetVisible",		true							},
		{ "emily",			"qWalkToXY",		5, 20							},
				
		--HUG
		{ "scene",			"qFinishMovie" 										},				
	}

	qSequence(self.sequenceStart)
end

function day4:onDayBegin()
	event.active = true
	self.state = "paul1"
end

function day4:onNotify(notification)

	if (notification == "start ordering") then
		for i = 1,4  do    
			self["contestant" .. i].state = "ORDER"
		
		end
		
	elseif (notification == "start eating") then
		for i = 1,4  do    
			if (getRandom(2) == 0) then	self["contestant" .. i].state = "DRINK"
			else						self["contestant" .. i].state = "EAT"
			end
		
		end
		
	elseif (notification == "stop eating") then
		for i = 1,4  do    
			self["contestant" .. i].state = "ORDER"
		
		end		
		
	elseif (notification == "stop ordering") then
		self.shouldOrder = false
	
	elseif (notification == "all left") then
		self.table1:setReserved(false)	
	
	end

end

function day4:onTick(time)

	-- the group customers have to do other stuff
	if (not event.completed and event.started and self.shouldOrder) then
		for i = 1,4  do    
			local contestant = self["contestant" .. i]
			if (contestant and contestant:isSitting()) then
				if (contestant.state == "READ") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
						
						end
					end			
				
				elseif (contestant.state == "ORDER") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
						end
					end				
				
				elseif (contestant.state == "DRINK" or contestant.state == "EAT") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
							if (getRandom(2) == 0) then	contestant.state = "DRINK"
							else						contestant.state = "EAT"
							end					
						
						end
					end
				
				end
			end
		end
	end
	
	if (scene:isStartingMovie() or scene:isPlayingMovie() or self.state == "not active") then
		return
	end

	self.timer = self.timer - time
	if (self.timer <= 0) then
		if (self.state == "paul1") then
			qInsertSequence(self.paul1)
			self.state = "not active"
		end		
	end
end

function day4:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set the day
day = day4()
