-- Level design: Search for "TWEAK VALUE" in this file.

-- day class
class 'day3' (interface)

function day3:__init() super()
end

function day3:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	entertainer:setPosition(grid:getNode(0, 5))	
	emily:setPosition(grid:getNode(0, 5))
	cleaner:setPosition(grid:getNode(0, 5))
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",			2							},
		
		{ "emily",			"qWalkToXY",		5, 20							},
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_0"			},
		{ "emily",			"qSetAppearance",	"SHOCK"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_1"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_2"			},

		{ "cleaner",		"qWalkToXY",		8, 20							},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY3_3"			},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_4"			},
		
		{ "cleaner",		"qSetAppearance",	""								},		
		{ "emily",			"qSetAppearance",	""								},		
		{ "scene",			"qFinishMovie" 										},			
		{ "scene",			"qStartGame" 										},			
	}
	
	-- tashi
	tashi = pm:createPerson("story_character")
    tashi:setBaseName("INGAME_PERSON_TASHI")
    tashi:setPosition(grid:getNode(0, 5))
    tashi:initTimer(40000, 40001)				-- TWEAK VALUE: min and max time this person comes walking in.
	tashi.destX = 38
	tashi.destY = 14
	tashi.talkPositionX = 34
	tashi.talkPositionY = 14    
    tashi.sequence =
	{	
		{ "scene",			"qStartMovie",			2							},

		{ "emily",			"qSetAppearance",	"BLUSH"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_5"			},
		{ "tashi",			"qSetAppearance",	"SUSPICIOUS"					},
		{ "tashi",			"qSay",				"RESTAURANT3_DAY3_51"			},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_52"			},
		{ "tashi",			"qSetAppearance",	"HAPPY"							},
		{ "tashi",			"qSay",				"RESTAURANT3_DAY3_6"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_7"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "tashi", 			"qAnimateWait", 	"LAUGH", 3						},
		{ "tashi", 			"qAnimate", 		"IDLE", 0						},
		{ "tashi",			"qSetAppearance",	"HAPPY"							},
		{ "tashi",			"qSay",				"RESTAURANT3_DAY3_8"			},
		{ "tashi",			"qSetAppearance",	""								},
		{ "tashi",			"qSay",				"RESTAURANT3_DAY3_81"			},
		{ "tashi",			"qWalkToXY",		0, 5							},
		{ "tashi", 			"qSetVisible", 		false							},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_82"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "emily",			"qWait",			200								},
		{ "scene", 			"qFinishMovie" 										},
	}
    tashi.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "tashi",			"qSetAppearance",	""								},					
		{ "tashi",			"qWalkToXY",		0, 0							},
		{ "tashi",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}	

	-- edward
	edward = pm:createPerson("story_character")
    edward:setBaseName("INGAME_PERSON_EDWARD_WINTER")
    edward:setPosition(grid:getNode(0, 5))
    edward:initTimer(40000, 40001)				-- TWEAK VALUE: min and max time this person comes walking in.
	edward.destX = 38
	edward.destY = 14
	edward.talkPositionX = 34
	edward.talkPositionY = 14    
    edward.sequence =
	{	
		{ "scene",			"qStartMovie",			1							},

		{ "emily",			"qSetAppearance",	"NEUTRAL"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_9"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "edward",			"qSay",				"RESTAURANT3_DAY3_10"			},
		{ "emily",			"qSetAppearance",	"NEUTRAL"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_11"			},
		{ "edward",			"qAnimateWait",		"FACEPALM", 1					},
		{ "edward",			"qAnimate",			"IDLE", 0						},
		{ "edward",			"qSetAppearance",	"FACEPALM"						},
		{ "edward",			"qWait",			1000							},
		{ "edward",			"qSetAppearance",	""								},
		{ "edward",			"qSay",				"RESTAURANT3_DAY3_12"			},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_13"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "edward",			"qSetAppearance",	"LAUGH"							},
		{ "edward",			"qSay",				"RESTAURANT3_DAY3_14"			},
		{ "edward",			"qSay",				"RESTAURANT3_DAY3_15"			},
		{ "emily",			"qSetAppearance",	"CONFUSED"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_16"			},
		{ "edward",			"qSay",				"RESTAURANT3_DAY3_17"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "emily",			"qWait",			200								},
		{ "scene", 			"qFinishMovie" 										},
	}
    edward.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "edward",			"qSetAppearance",	""								},					
		{ "edward",			"qWalkToXY",		0, 0							},
		{ "edward",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}	

	-- evelyn
	evelyn = pm:createPerson("story_character")
    evelyn:setBaseName("INGAME_PERSON_EVELYN_WINTER")
    evelyn:setPosition(grid:getNode(0, 5))
    evelyn:initTimer(40000, 40001)				-- TWEAK VALUE: min and max time this person comes walking in.
	evelyn.destX = 38
	evelyn.destY = 14
	evelyn.talkPositionX = 34
	evelyn.talkPositionY = 14    
    evelyn.sequence =
	{	
		{ "scene",			"qStartMovie",			2							},
		{ "emily",			"qSetAppearance",	"ROLL_EYES"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_18"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "evelyn",			"qSay",				"RESTAURANT3_DAY3_19"			},						
		{ "emily",			"qSetAppearance",	"NEUTRAL"						},				
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_20"			},				
		{ "evelyn",			"qSay",				"RESTAURANT3_DAY3_21"			},
		{ "evelyn",			"qSay",				"RESTAURANT3_DAY3_215"			},

		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    evelyn.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "evelyn",			"qSetAppearance",	""								},					
		{ "evelyn",			"qWalkToXY",		0, 0							},
		{ "evelyn",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}		

	-- angela
	angela = pm:createPerson("story_character")
    angela:setBaseName("INGAME_PERSON_ANGELA_WINTER")
    angela:setPosition(grid:getNode(0, 5))
    angela:initTimer(40000, 40001)				-- TWEAK VALUE: min and max time this person comes walking in.
    angela.optional = false
	angela.destX = 38
	angela.destY = 14
	angela.talkPositionX = 34
	angela.talkPositionY = 14    
    angela.sequence =
	{	
		{ "scene",			"qStartMovie",			1							},

		{ "angela",			"qSay",				"RESTAURANT3_DAY3_22"			},						
		{ "emily",			"qSetAppearance",	"NEUTRAL"						},				
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_23"			},				
		{ "angela",			"qSetAppearance",	"CONFUSED"						},					
		{ "angela",			"qSay",				"RESTAURANT3_DAY3_24"			},						
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_25"			},				
		{ "angela",			"qSetAppearance",	"LAUGH"							},					
		{ "angela",			"qSay",				"RESTAURANT3_DAY3_26"			},						
		{ "emily",			"qSetAppearance",	"CONFUSED"						},					
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_27"			},				
		{ "angela",			"qSetAppearance",	"SMIRK"							},
		{ "angela",			"qSay",				"RESTAURANT3_DAY3_28"			},						
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "angela",			"qSetAppearance",	""								},
		{ "emily",			"qSay",				"RESTAURANT3_DAY3_29"			},						

		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    angela.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "angela",			"qSetAppearance",	""								},					
		{ "angela",			"qWalkToXY",		0, 0							},
		{ "angela",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}		

	
	tashi:setActive()
	tashi:setNextCharacter(edward)
	edward:setNextCharacter(evelyn)
	evelyn:setNextCharacter(angela)
	

	
	qSequence(self.sequenceStart)
end

function day3:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set the day
day = day3()
