include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Spider"
}

-- day class
class 'day2' (interface)

day2.timer = 4000
day2.state = "not active"
day2.highlight = nil
day2.paulWalkTimePerNode = 35		-- Influences Paul's walking speed. Higher value means a slower Paul.
day2.flower = nil

function day2:__init() super()
end

function day2:onLevelGlobals()
	entertainer:setPosition(grid:getNode(0, 5))	
	emily:setPosition(grid:getNode(0, 5))
	cleaner:setPosition(grid:getNode(0, 5))

	-- set event configuration
	event.baseName = "INGAME_CUSTOMER_MALE_WINTER_REGULAR"
	event.baseSection = "customers"
	event.entryX = 0
	event.entryY = 5
	event.highlightX = 42
	event.highlightY = 14
	event.timeUntilEnterMin = self.timer
	event.timeUntilEnterMax = self.timer + 2
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = false
	event.eventBarImage = "OBJECT_HIDDEN_1_BAR"

end

function day2:onLevelInited()
    
    self.flower = getObject("rest3_flower")
    self.flower:setVisible(true)
    self.flower:setAcceptingTasks(true)
    
	event.sequenceStart	= 								-- text when event starts
	{
		{ "scene",			"qStartMovie",		1								},
		{ "cleaner",		"qWalkToXY", 		13, 12							},				
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_01"			},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_02"			},
		{ "cleaner",		"qWalkToXY",		26, 18							},	
		{ "scene",			"qCallback",		self, function(self) restaurant.skiHill:doSkiPerson(1500, 200) end },
		{ "cleaner",		"qWait",			400								},	
		{ "cleaner",		"qAnimate",			"TAKE_CARD", 1					},
		{ "flower",			"qSetVisible",		false							},
		{ "cleaner",		"qSayTimed",		"RESTAURANT3_DAY2_1", 900		},	
		{ "cleaner",		"qSetAppearance",	""								},			
		{ "", 				"parallel"											},
		{ "cleaner",		"qAnimate",			"WIPE_CRASHED_ROLL", -1			},
		{ "cleaner",		"qCallback",		self, function(self) self.state = "rolling" end },
		{ "scene",			"qNotify",			"show objects"					},			
		{ "emily",			"qSetAppearance", 	"PANIC"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_2", 			},
		{ "emily",			"qWalkToXY",		20, 34							},	
		{ "emily",			"qSetVisible",		false							},	
		{ "", 				"sequential"										},
		{ "emily",			"qWait",			1000							},				
		{ "cleaner",		"qCallback",		self, function(self) self.state = "not active" end },
		
		{ "scene",			"qFadeToBlack" 										},
		{ "emily",			"qSetVisible",		true							},	
		{ "cleaner",		"qAnimate",			"IDLE", 0						},
		{ "cleaner",		"qWait",			2000							},
		{ "emily",			"qSetPosition",		grid:getNode(0, 5)				},
		{ "cleaner",		"qSetPosition",		grid:getNode(0, 5)				},						
		{ "cleaner",		"qSetAppearance",	"SAD"							},
		{ "emily",			"qSetAppearance", 	"NEUTRAL"						},
		{ "scene",			"qFadeOutBlack"										},
		
		{ "", 				"parallel"											},
		{ "cleaner",		"qWalkToXY",		37, 14							},
		{ "emily",			"qWait",			250								},
		{ "emily",			"qWalkToXY",		40, 14							},
		{ "", 				"sequential"										},
		{ "cleaner",		"qAnimateWait",		"WIPE_SNOWBALL", 2, 6			},
		{ "cleaner",		"qAnimate",			"IDLE", 0						},
		
		{ "emily",			"qSetAppearance", 	""								},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_3"			},
		{ "cleaner",		"qSetAppearance", 	"LAUGH"							},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_4"			},
		{ "cleaner",		"qSetAppearance", 	""								},
		{ "emily",			"qSetAppearance", 	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_5"			},
		{ "emily",			"qSetAppearance", 	""								},
		{ "cleaner",		"qSetAppearance", 	"BLUSH"							},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_6"			},
		
		{ "person",			"qSetVisible",		true							},
		{ "person",			"qWalkToXY",		34, 14							},
		{ "person",			"qAnimate",			"SCRATCH", -1					},
		{ "person",			"qSetAppearance", 	"ASHAMED"						},
		{ "person",			"qSay",				"RESTAURANT3_DAY2_7"			},
		{ "person",			"qAnimate",			"IDLE", 0						},
		{ "cleaner",		"qSetAppearance", 	"ROLLEYES"						},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_8"			},
		{ "cleaner",		"qSetAppearance", 	""								},
		{ "person",			"qSay",				"RESTAURANT3_DAY2_9"			},
		{ "person",			"qSay",				"RESTAURANT3_DAY2_95"			},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_10"			},
		
		{ "person",			"qWalkToXY",		0, 5							},
		{ "person",			"qSetAppearance", 	""								},
		{ "person",			"qSetVisible",		false							},						
		{ "emily",			"qWalkToCounter",									},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qNotify",			"show bar"						},
		{ "cleaner",		"qSetWalkTimePerNode",	self.paulWalkTimePerNode	},
		{ "",				"parallel"											},			
	}
	
	event.sequenceDone = 
	{	
		{ "",				"sequential"										},
		{ "scene",			"qStartMovie",			2							},

		{ "emily",			"qWalkToXY",		35, 14							},
		{ "emily",			"qSetAppearance", 	"HAPPY"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_11"			},
		{ "emily",			"qSetAppearance", 	"OFFENDED"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_12"			},
		{ "emily",			"qSetAppearance", 	""								},
		{ "scene",			"qFinishMovie" 										},
		{ "cleaner",		"qSetWalkTimePerNode",	self.paulWalkTimePerNode	},
		{ "",				"parallel"											},				
	}
	
	self.dayEndSequence = 
	{
		{ "scene",			"qStartMovie",			1							},
		
		{ "cleaner",		"qWalkToXY",		37, 14							},
		{ "emily",			"qWalkToXY",		34, 14							},
		{ "emily",			"qSetAppearance",	"CONSTRAINED_LAUGH"				},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_13"			},
		{ "cleaner",		"qSetAppearance",	"ROLLEYES"						},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_14"			},
		{ "cleaner",		"qSetAppearance",	""								},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_15"			},
		{ "cleaner",		"qSetAppearance",	"ROLLEYES"						},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_16"			},
		{ "emily",			"qWalkToXY",		35, 14							},
		{ "cleaner",		"qSetAppearance",	"BLUSH"							},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_17"			},
		{ "emily",			"qSetVisible",		false							},
		{ "cleaner",		"qAnimate",			"WIPE_BANDAGE", -1, 3			},
		{ "cleaner",		"qWait",			1500							},
		{ "cleaner",		"qSetAppearance",	"BANDAGE"						},
		{ "cleaner",		"qAnimate",			"IDLE", 0						},
		{ "emily",			"qSetVisible",		true							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_18"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_19"			},
		{ "cleaner",		"qSetAppearance",	"BANDAGE_BLUSH"					},
		{ "emily",			"qSetAppearance",	"BLUSH"							},
		{ "emily",			"qWait",			1500							},
		{ "emily",			"qSetVisible",		false							},
		{ "cleaner",		"qAnimateWait",		"KISS", 1, 1					},
		{ "cleaner",		"qSetAppearance",	"BANDAGE_WORRIED"				},
		{ "cleaner",		"qAnimate",			"IDLE", 0						},
		{ "emily",			"qSetAppearance",	"SURPRISED"						},
		{ "emily",			"qSetVisible",		true							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_22"			},
		{ "cleaner",		"qSetAppearance",	"BANDAGE_WORRIED"				},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_23"			},
		{ "emily",			"qSetAppearance",	"FLIRT"							},
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_24"			},
		{ "emily",			"qSetVisible",		false							},
		{ "cleaner",		"qAnimateWait",		"KISS", 1, 8					},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}
	
	cleaner:setWalkTimePerNode(200)
end

function day2:onDayBegin()
	self.state = "active"	

end

function day2:onDayEnd()
	autoAllPeopleWalkOut = false	
	qSequence(self.dayEndSequence)		
end

function day2:onTick(time)

	if (self.state == "not active") then
		return
	end

	if (self.state == "rolling") then
		cleaner:setY(cleaner:getY() + (200 / (1000/time)))		
		return
	end

	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
	
	self.timer = self.timer - time	
	if (self.timer <= 3000) then
		restaurant.skiHill.active = false
	end
end

function day2:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

function day2:onNotify(notification)
	if (notification == "show objects") then
		local numObjects = event:getNumberOfObjects()
		if (numObjects > 0) then
			insert()
			local objectAdded = 1
			for i = 1, numObjects do
				local object = event:getObjectAtIndex(i)
				
				if (object ~= nil) then
					object:qWait(objectAdded * 150)
					object:qSetVisible(true)
					object:qSetClickable(true)
					
					if (object:getPosition():getGridX() == event.highlightX) then
						if (object:getPosition():getGridY() == event.highlightY) then
							self.highlight = object
						end
					end		
					
					objectAdded = objectAdded + 1
				end
			end
			append()	
		end
	elseif (notification == "show bar") then
		if (self.highlight) then
			self.highlight:createScreenOverhead("INGAME_ARROW")	
		end
	end
end



-- set day
day = day2()
