include("scripts/events/meltingsnowevent.lua")

-- set event
event = meltingsnowevent()
event.itemsProps = 
{
    {type="badSpot1", anchorY=0, image="OBJECT_BAD_SPOT", x=21, y=15},
    {type="badSpot2", anchorY=0, image="OBJECT_BAD_SPOT", x=29, y=0},
    {type="badSpot3", anchorY=0, image="OBJECT_BAD_SPOT", x=1, y=11},
    {type="badSpot4", anchorY=20, image="OBJECT_BAD_SPOT", x=13, y=24},
    {type="badSpot5", anchorY=0, image="OBJECT_BAD_SPOT", x=48, y=18},
    {type="badSpot6", anchorY=0, image="OBJECT_BAD_SPOT", x=20, y=32},
}
event.pixelsToClean = 600

-- day class
class 'day1' (interface)

function day1:__init() super()
end

function day1:onLevelGlobals()

	entertainer:setPosition(grid:getNode(0, 5))	

	event.eventBarImage = "OBJECT_SNOW_BAR"
	event.entryX = 0									    -- position person enters from
	event.entryY = 2
	event.highlightX = 21
	event.highlightY = 15
	event.timeUntilEnterMin = 50000							-- minimum time the person waits outside
	event.timeUntilEnterMax = 52000							-- maximum time the person waits outside
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.sequenceStart	= 									-- text when event starts
	{
		{ "scene",		"qNotify",			"show bar"					}
	}
	
	event.sequenceDone	= 									
	{
		{ "scene",		"qStartMovie",			3							},
		{ "emily",		"qWalkToXY",			21, 19						},
		{ "emily",		"qAnimate", 			"JUMP", 1					},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY1_8"		},
		{ "emily",		"qAnimate", 			"IDLE", 0					},
		{ "scene",		"qFinishMovie" 										},
	}
end

function day1:onLevelInited()
	autoStartGame = false
	autoAllPeopleWalkIn = false

	cleaner:setPosition(grid:getNode(0, 0))
	emily:setPosition(grid:getNode(0,0))
	
	local sequenceStart	= 									
	{
		{ "scene",		"qStartMovie",			3							},
		{ "cleaner",	"qWalkToXY",			8, 14						},
		{ "emily",		"qWalkToXY",			4, 14						},
		{ "cleaner", 	"qSetAppearance",		"HAPPY"					 	},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY1_0"		},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY1_1"		},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY1_2"		},	
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY1_3"		},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY1_4"		},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY1_5"		},
		{ "cleaner", 	"qSetAppearance",		"SURPRISED"					},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY1_6"		},
		{ "cleaner", 	"qSetAppearance",		""							},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY1_7"		},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qStartGame" 										},
		{ "scene",		"qNotify",				"show bar"					},
		{ "",			"parallel"											},					
	}	

	-- play completed sequence
	qSequence(sequenceStart)

end

function day1:onNotify(notification)

end

function day1:onDayEnd()

end

function day1:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result
end	

-- set day
day = day1()