-- Leveldesigner(s): Search for "(TWEAKERSTUFF)" in this file to tweak Paul's sobbing.

-- day class
class 'day0' (interface)

function day0:__init() super()
end

function day0:onLevelGlobals()
end

day0.paulIdle = ""				-- Whatever Sebastiaan means with "Paul Idle" appearance
day0.paulNormal = ""			-- Whatever Sebastiaan means with "Paul Normal" appearance

function day0:onLevelInited()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	entertainer:setVisible(false)
	entertainer:setPosition(grid:getNode(0, 0))

	angela = pm:createPerson("npc")
	angela:setBaseName("INGAME_PERSON_ANGELA")
	angela:setDefaultSection("characters")
	angela:setPosition(grid:getNode(33, 16))
	angela:onCreate()
	angela:setAppearance("SAD")
	
	cleaner:setPosition(grid:getNode(36, 16))
	
	emily:setPosition(grid:getNode(0,0))
	
	local sequenceStart	=
	{
		{ "cleaner", 	"qSetAppearance",		"SAD"						},
		{ "angela",		"qSetAppearance",		"SAD"			   			},
		{ "scene",		"qStartMovie",			1							},
		{ "angela", 	"qSay",					"RESTAURANT3_DAY0_00"		},
		{ "emily",		"qWalkToXY",			38, 14						},
		{ "cleaner", 	"qSetAppearance",		"SURPRISED"					},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_0"		},
		{ "angela",		"qSay",			   		"RESTAURANT3_DAY0_1"		},
		{ "cleaner", 	"qSetAppearance",		"SAD"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_2"		},
		{ "angela",		"qSay",			    	"RESTAURANT3_DAY0_3"		},
		{ "cleaner", 	"qSetAppearance",		"SORRY"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_4"		},
		{ "angela", 	"qSetAppearance",		"ANGRY"						},
		{ "angela", 	"qSay",					"RESTAURANT3_DAY0_41"		},
		{ "emily", 		"qSetAppearance",		"SHOCK"						},
		{ "emily",		"qSay",			   		"RESTAURANT3_DAY0_5"		},
		{ "angela", 	"qSetAppearance",		"SAD"						},
		{ "angela",		"qWalkToXY",			0,0							},
		{ "emily", 		"qSetAppearance",		"NEUTRAL"					},
		{ "cleaner", 	"qSetAppearance",		"SAD"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_6"		},
		{ "emily", 		"qSetAppearance",		"SAD"						},
		{ "emily",		"qSay",			   		"RESTAURANT3_DAY0_7"		},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_8"		},
		{ "cleaner",	"qSay",			    	"RESTAURANT3_DAY0_9"		},
		{ "emily", 		"qSetAppearance",		"NEUTRAL"					},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_10"		},
		{ "emily", 		"qSetAppearance",		""							},
		{ "cleaner", 	"qSetAppearance",		self.paulIdle				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_101"		},
		{ "entertainer","qSetVisible", 			true						},
		{ "entertainer","qWalkToXY",			32,11						},
		{ "entertainer","qSay",					"RESTAURANT3_DAY0_102"		},
		{ "entertainer","qWalkToNode",			grid:getEntertainerNode()	},
		{ "emily", 		"qSetAppearance",		"CONFUSED"					},
		{ "emily",		"qSay",					"RESTAURANT3_DAY0_103"		},
		{ "emily",	 	"qSay",					"RESTAURANT3_DAY0_104"		},
		{ "emily", 		"qSetAppearance",		""							},
		{ "cleaner", 	"qSetAppearance",		"LAUGH"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_105"		},
		{ "cleaner", 	"qSetAppearance",		"HAPPY"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_106"		},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_107"		},
		{ "emily", 		"qSetAppearance",		"CONFUSED"					},
		{ "emily",	 	"qSay",					"RESTAURANT3_DAY0_108"		},
		{ "emily", 		"qSetAppearance",		""							},
		{ "cleaner", 	"qSetAppearance",		"LAUGH"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_109"		},
		{ "cleaner", 	"qSetAppearance",		""							},
		
		{ "angela",		"qSetVisible",			false						},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qStartGame" 										}
	}	

	-- play completed sequence
	qSequence(sequenceStart)


end

function day0:onDayBegin()
	cleaner.started = true
end

function day0:onDayEnd()
	autoAllPeopleWalkOut = false

	cleaner.completed = true
	local sequenceEnd	= 									
	{
		{ "scene",		"qStartMovie" ,			2							},
		{ "emily",		"qWalkToXY",				   	11, 13				},
		{ "cleaner",	"qWalkToXY",				 	 8, 13				},
		{ "cleaner", 	"qSetAppearance",		self.paulNormal				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_24"		},
		{ "cleaner", 	"qSetAppearance",		self.paulIdle				},
		{ "emily", 		"qSetAppearance",		"LAUGH"						},
		{ "emily",		"qSay",			   		"RESTAURANT3_DAY0_25"		},
		{ "cleaner", 	"qSetAppearance",		"HAPPY"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_26"		},
		{ "emily", 		"qSetAppearance",		"FLIRT"						},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_27"		},
		{ "emily", 		"qSetAppearance",		""							},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qFinishGame" 										}
	}	

	-- play completed sequence
	qSequence(sequenceEnd)

end

function day0:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		result = paulCleaner("INGAME_PERSON_PAUL_WINTER")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true
	end
	
	return result
end	

-- set day
day = day0()

class 'paulCleaner' (d2cleaner)

paulCleaner.SeqC1 = 
{
		{ "scene",		"qStartMovie",			1							},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_11"		},
		{ "cleaner", 	"qAnimate",							"IDLE" ,0		},
		{ "emily", 		"qSetAppearance",						"NEUTRAL"	},
		{ "cleaner", 	"qSetAppearance",		day.paulIdle				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_12"		},
		{ "emily", 		"qSetAppearance",						""			},
		{ "scene",		"qFinishMovie" 										}
		
}

paulCleaner.SeqC2 = 
{
		{ "scene",		"qStartMovie",			1							},
		{ "emily", 		"qSetAppearance",						"FLIRT"		},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_13"		},
		{ "cleaner", 	"qAnimate",							"IDLE" ,0		},	
		{ "cleaner", 	"qSetAppearance",		day.paulIdle				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_14"		},
		{ "emily", 		"qSetAppearance",						""			},
		{ "scene",		"qFinishMovie" 										}
}

paulCleaner.SeqC3 = 
{
		{ "scene",		"qStartMovie",			1							},
		{ "emily", 		"qSetAppearance",		"NEUTRAL"					},
		{ "cleaner", 	"qAnimate",				"IDLE" ,0					},
		{ "cleaner", 	"qSetAppearance",		day.paulIdle				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_15"		},
		{ "emily", 		"qSetAppearance",		"FLIRT"						},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_16"		},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_17"		},
		{ "emily", 		"qSetAppearance",						""			},
		{ "cleaner", 	"qSetAppearance",		"HAPPY"						},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_18"		},
		{ "cleaner", 	"qSetAppearance",		day.paulIdle				},
		{ "scene",		"qFinishMovie" 										} 
}

paulCleaner.SeqC4 = 
{
		{ "scene",		"qStartMovie",			1							},
		{ "emily", 		"qSetAppearance",		"HAPPY"						},
		{ "cleaner", 	"qAnimate",				"IDLE" ,0					},
		{ "cleaner", 	"qSetAppearance",		"SAD"						},
		{ "emily",	 	"qSay",					"RESTAURANT3_DAY0_19"		},
		{ "cleaner", 	"qSetAppearance",		"HAPPY"						},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY0_20"		},
		{ "emily", 		"qSetAppearance",		"NEUTRAL"					},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_21"		},
		{ "cleaner",	"qSetAppearance",		"SURPRISED"					},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_22"		}, 
		{ "cleaner",	"qSetAppearance",		""							},
		{ "emily", 		"qSetAppearance",		"HAPPY"						},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_23"		},
		{ "cleaner",	"qSetAppearance",		day.paulNormal				},
		{ "cleaner", 	"qSay",					"RESTAURANT3_DAY0_231"		},
		{ "emily",		"qSetAppearance",		"FLIRT"						},
		{ "emily", 		"qSay",					"RESTAURANT3_DAY0_232"		},
		{ "emily",		"qSetAppearance",		""							},
		{ "cleaner", 	"qSetAppearance",		day.paulIdle				},
		{ "scene",		"qFinishMovie" 										}
}

-- (TWEAKERSTUFF) - configuration variables for YOU:
paulCleaner.cryTimerMin = 53000				-- MIN time he isn't crying before he starts again.
paulCleaner.cryTimerMax = 25000				-- MAX time he isn't crying before he starts again.
paulCleaner.cryTimeOut 	= 15000				-- time he remains crying without comfort

-- Stuff for the programmin' people:

paulCleaner.cryTimer = 0					-- time till he cries again(is set on levelinit)

paulCleaner.crying = false
paulCleaner.isClicked = false
paulCleaner.isBeingComforted = false
paulCleaner.timesCried = 0
paulCleaner.timesComforted = 0

paulCleaner.started = false
paulCleaner.completed = false
paulCleaner.waitTimeSuspended = false

function paulCleaner:__init(baseName) 
	self.cryTimer = getRandomRange(self.cryTimerMin, self.cryTimerMax)
	super(baseName)
end

function paulCleaner:onCreate()
	d2cleaner.onCreate(self)
end

function paulCleaner:onClick()
	d2cleaner.onClick(self)
	if(self.isClicked == false and self.crying == true) then
		self.isClicked = true
		self.waitTimeSuspended = true
		emily:qWorkOn(self)
		self:clearOverhead()
		self:setSelected(true)
	end
end

function paulCleaner:onWorkStart(task)

	cout("paulCleaner:onWorkStart(task)\n")

	-- disable selection
	self:setSelected(false)
	-- disable highlight so we can't click the mailman anymore
	self:removeHighlight()
	
	task:setDuration(0)--immediately start comforting paul
	
	return true
end

function paulCleaner:acceptTask(task)

	if (self.crying) then
		return D2Person.acceptTask(self, task)
	end
	
	return d2cleaner.acceptTask(self, task)

end

function paulCleaner:onWorkComplete(task)
	if(self.timesComforted == 0) then
		qInsertSequence(self.SeqC1)
	elseif (self.timesComforted == 1) then
		qInsertSequence(self.SeqC2)	
	elseif (self.timesComforted == 2) then
		qInsertSequence(self.SeqC3)	
	elseif (self.timesComforted == 3) then
		qInsertSequence(self.SeqC4)	
	end
	
	incScore(50, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 0);
	
	self.cryTimeOut = 0
	self.timesComforted = self.timesComforted + 1
	self.isClicked = false
	self.waitTimeSuspended = false
	
	if(self.timesComforted > 3) then
		incScore(100, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS");
	end
end

function paulCleaner:onTick(time)

	if(self.started == false or self.completed == true or cleaner.isBeingComforted == true or (scene:isStartingMovie() or scene:isPlayingMovie())) then
		return
	end
	
	if(self.timesCried > 3) then
		self.completed = true
		return
	end
	if (self.crying == true) then
		self.cryTimeOut = self.cryTimeOut - time
		if ((self.cryTimeOut < 0) and (not self.waitTimeSuspended)) then	-- Emily didn't comfort me! Buhu! let's go back to work...
			self:clearOverhead()
			self:removeHighlight()
			self:animate("IDLE", 0)
			self.cryTimer = getRandomRange(self.cryTimerMin, self.cryTimerMax)
			self.timesCried = self.timesCried + 1
			self.crying = false
			self:setReturnHome(true)
		end
	else
		self.cryTimer = self.cryTimer - time
		if (self.cryTimer < 0) then				-- Let's bring the tears! Maybe it impresses the lady...
--			NO NO NO NO
--			THIS IS SO BAD
--			Paul might be cleaning a table at this point!, the table selection will never be set to false
--			and the table becomes unusable!!!
--			self:finishTask()
			self:qWalkToXY(36,14)
			self:qAnimate("WIPE_CRY", -1)
			if (self.timesCried == 0) then
				self:qCreateOverhead("INGAME_ARROW")
			end
			self.cryTimeOut = 10000
			self.crying = true
			self:createHighlight()
			self:setReturnHome(false)
		end
	end
end

function paulCleaner:getWorkNode()
 
	return grid:getNode(38, 14)
  
end
