include("scripts/products/regularproduct.lua")
include("scripts/appliances/stockappliance.lua")
include("scripts/appliances/pearappliance.lua")
include("scripts/products/grillproduct.lua")
include("scripts/products/pearProduct.lua")

-- entry node
-- npc's and such will be spawned at this location
entryX = 6
entryY = 0
entryNode = nil

-- exit node
exitX = 40
exitY = 0
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 7
movieY = 4
movieNode = nil

-- restaurant class
class 'restaurant3' (interface)

restaurant3.fondueScore			= 50
restaurant3.fondueScoreBonus	= 10

restaurant3.skiHill = nil
restaurant3.skiLift = nil
restaurant3.iceSprites = List.new()
restaurant3.iceSprites.progress = 0
restaurant3.iceSprites.targetProgress = 0
restaurant3.iceSprites.state = 0
restaurant3.iceSprites.lerpVal = math.random(3, 10) / 10

function restaurant3:__init() super()
end

function restaurant3:onLevelGlobals()
	createDummyObject("skiHill", 26, 0)
	createDummyObject("skiLift", 49, 34)
end

function restaurant3:onLevelInited()

	if (um:hasUpgrade("DECO_RUG_UPGRADE") ~= 1) then
		getObject("rest3_footsteps"):setVisible(false)
	end

	om:getCounter():setYPos(-85)
end

function restaurant3:onTaskComplete(actorType, taskType, p0, p1)
	-- DELV-353 
	-- only emily, otherwise a cleaner could fill the bucket!
	if (actorType == "emily") then 
		if (taskType == "TableTask" and p0:getType() == "Table4") then
			if (tray:hasProduct("FONDUE_FULL") and p0:isBucketFilled() == false) then

				-- increase score and pop a floater
				incScore(self.fondueScore, p0:getScreenX(), p0:getScreenY(), 0)

				if (p0:getOrder() and p0:getOrder():hasProduct("FONDUE_FULL")) then
					tray:distributeProducts(p0:getOrder())				
					if (p0:getOrder():isCompleted()) then
						-- fill the order with new products
						p0:getCustomerGroup():createNextOrder()
					end
					p0:getOrder():draw()
				else
					-- increase score and pop a floater
					incScore(self.fondueScoreBonus, p0:getScreenX(), p0:getScreenY(), scoreBonusFloaterDelay, "BONUS")					
					tray:takeProduct("FONDUE_FULL")			
				end
				p0:setTableTopImage("TABLE_4_FULL")
				p0:setBucketFilled(true)
				p0:playSound("SOUND_GRAB_FONDUE_SET")
			end
		end
	end
end

function restaurant3:onCustomerGroupStateChange(customerGroup, prevState, newState)
	--walking to table
	local cTable = customerGroup:getTable()
	if (cTable ~= nil and cTable:getType() == "Table4") then
		if (prevState == GROUP_STATE_TABLE_WALKING_TO_TABLE and cTable:isBucketFilled() == false) then			
			if (cTable:getOrder() ~= nil) then
				cTable:getOrder():clear()
				cTable:getOrder():addProduct("FONDUE_FULL")
			end
		elseif (prevState == GROUP_STATE_TABLE_LOOKING_FOR_QUEUE_TO_PAY) then
			cTable:setTableTopImage("TABLE_4")
			cTable:setBucketFilled(false)	
			hm:openHint(getHintIndex("HINT_FONDUE_REFILL"), cTable:getScreenX() - 10, cTable:getScreenY() - 100)
			hm:placeArrow(getArrowIndex("ARROW_FONDUE_REFILL"), getProduct("FONDUE_FULL"), 33, 20)
		end
	end
end

function restaurant3:onDayBegin()
end
	
function restaurant3:createObject(desc)

	if (desc:getObjectId() == "rest3_gluhwein") then
		result = pearappliance()
		result:setType(desc:getType())
		result:setOverheadY(33)
		
		result.toSturDuration = 80000
		result.toDirtyDuration = 8000
		result.sturDuration = 1000
		result.cleanDuration = 2000
		
		result.productName = "GLUHWEIN"
		result.stirAnim = "PROD_ANIM_GLUHWEIN_ROTATE"
		result.spillAnim = "PROD_ANIM_GLUHWEIN_SPILL"
		result.overheadAnimation = "INGAME_GLUHWEIN_STIR"
		result.hintID = ""
		return result
	elseif (desc:getObjectId() == "rest3_board") then
		result = stockAppliance()
		result:setType(desc:getType())
		result.productFillSound = "SOUND_MORTALPESSLE"
		result.products = {"CORN", "PAPRIKA", "BREAD"}
		return result
	elseif (desc:getType() == "skiHill") then
		result = skiHill()
		result:setType(desc:getType())
		restaurant3.skiHill = result
		return result
	elseif (desc:getType() == "skiLift") then
		result = skiLift()
		result:setType(desc:getType())
		restaurant3.skiLift = result
		return result		
	elseif (desc:getObjectId() == "rest3_ice_light_top_upgrade") then
		if (um:hasUpgrade("DECO_ICE_LIGHTS_BACKGROUND_UPGRADE") ~= 1) then
			result = iceLightUpgrade()
			result:setType(desc:getType())
			List.push_back(self.iceSprites, result:addSprite(17, -85)):setAlpha(0)
			List.push_back(self.iceSprites, result:addSprite(168, -83)):setAlpha(0)
					
			return result		
		end
	elseif (desc:getObjectId() == "rest3_ice_light_bottom_upgrade") then
		if (um:hasUpgrade("DECO_ICE_LIGHTS_BACKGROUND_UPGRADE") ~= 1) then
			result = iceLightUpgrade()
			result:setType(desc:getType())
			
			List.push_back(self.iceSprites, result:addSprite(-18, -93)):setAlpha(0)
			List.push_back(self.iceSprites, result:addSprite(32, -93)):setAlpha(0)		
			List.push_back(self.iceSprites, result:addSprite(223, -100)):setAlpha(0)
			
			return result		
		end
	end

	return nil
end


function restaurant3:createProduct(base)
	bubbleWaffleX = 44
	bubbleWaffleY = 386
	bubbleWaffleS = true
	
	if (type(base) == "string")	then
		if (base == "COKE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_PICKDRINKANDPOPCAP")
			return p

		elseif (base == "BOOTS") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_SKIBOOT")
			p:setWorkOffsetX(0)
			return p

		elseif (base == "SKI_GLASSES") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_SKIBOOT")
			p:setWorkOffsetX(0)
			return p

		elseif (base == "FRIES") then
			p = regularProduct(base)
			p:setBubbleX(bubbleWaffleX)
			p:setBubbleY(bubbleWaffleY)
			p:setBubbleSmall(bubbleWaffleS)
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(-7)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_LEFT")
			p:setWorkSound("SOUND_FRIES")
			return p
			
		elseif (base == "RED_SAUCE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleWaffleX)
			p:setBubbleY(bubbleWaffleY)
			p:setBubbleSmall(bubbleWaffleS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_LEFT")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(-5)
			return p

		elseif (base == "WHITE_SAUCE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleWaffleX)
			p:setBubbleY(bubbleWaffleY)
			p:setBubbleSmall(bubbleWaffleS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_LEFT")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			p:setWorkOffsetX(0)
			p:setWorkOffsetY(-3)
			return p
			
		elseif (base == "QUICHE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_LEFT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(-7)
			p:setWorkOffsetY(-1)
			return p
										
		elseif (base == "FONDUE_FULL") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_FONDUE_SET")
			p:setWorkOffsetX(2)
			return p

		elseif (base == "CORN") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_CHICKEN_CORN")
			p:setWorkOffsetX(-6)		
			p:setStock(3)
			p:setMaxStock(3)
			return p

		elseif (base == "PAPRIKA") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(-4)		
			p:setStock(3)
			p:setMaxStock(3)
			return p

		elseif (base == "BREAD") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_SLICE_FRENCH_BREAD")
			p:setWorkOffsetX(-1)		
			p:setStock(3)
			p:setMaxStock(3)
			return p
					
		elseif (base == "GLUHWEIN") then
			p = pearProduct(base)
			p.applianceName = "rest3_gluhwein"
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_POUR_HOTWINE")
			return p			

		elseif (base == "BRATWURST") then
			p = grillProduct(base)
			p:setWorkTime(500)  
			p.appliance = "rest3_grill"
			p.workAnimation = "WORK_BACK"
			p:setWorkSound("SOUND_PICKUP_HOTDOG")
			p.burnOffsetY = 20
			return p		
		
		elseif (base == "SCHNITZEL") then
			p = grillProduct(base)
			p:setWorkTime(500)  
			p.appliance = "rest3_grill"
			p.workAnimation = "WORK_BACK"
			p:setWorkSound("SOUND_PICKUP_HOTDOG")
			p.burnOffsetY = 24
			return p								
		end
	elseif (type(base) == "userdata") then
		-- attempting to create a copy!
		if (base:getBase() == "BRATWURST" or base:getBase() == "SCHNITZEL") then
			p = grillProduct(base)
			return p			
		end	
	end

	return nil		
end

function restaurant3:onTick(time)	

	if (um:hasUpgrade("DECO_ICE_LIGHTS_BACKGROUND_UPGRADE") == 1) then
		return
	end
	
	local imageName = ""
	while (self.iceSprites.progress >= self.iceSprites.targetProgress) do
		self.iceSprites.state = self.iceSprites.state + 1
		self.iceSprites.state = self.iceSprites.state % 2

		self.iceSprites.progress = self.iceSprites.progress - self.iceSprites.targetProgress
		
		if (self.iceSprites.state == 0) then
				self.iceSprites.targetProgress = math.random(800, 2000)												
		elseif (self.iceSprites.state == 1) then				
				self.iceSprites.targetProgress = math.random(800, 2000)
				imageName = self:getRandomIceImageName()
				self.iceSprites.lerpVal = math.random(3, 10) / 10
		end
	end

	local alpha = 0
	if (self.iceSprites.state == 0) then
		alpha = math.lerp(self.iceSprites.lerpVal, 0, self.iceSprites.progress / self.iceSprites.targetProgress);
	elseif (self.iceSprites.state == 1) then
		alpha = math.lerp(0, self.iceSprites.lerpVal, self.iceSprites.progress / self.iceSprites.targetProgress);
	end
	
	self.iceSprites.progress = self.iceSprites.progress + time

	for index, sprite in ipairs(self.iceSprites) do
		if (imageName ~= "") then
			sprite:animate(imageName, 0)
		end
		sprite:setAlpha(alpha)
	end	
end

function restaurant3:getRandomIceImageName()
	
	local r = getRandomRange(0, 5)
	if (r == 0) then
		return "DECO_ICE_LIGHT_BLUE_UPGRADE"
	elseif (r == 1) then
		return "DECO_ICE_LIGHT_GREEN_UPGRADE"
	elseif (r == 2) then
		return "DECO_ICE_LIGHT_PURPLE_UPGRADE"
	elseif (r == 3) then
		return "DECO_ICE_LIGHT_RED_UPGRADE"
	else
		return "DECO_ICE_LIGHT_YELLOW_UPGRADE"
	end
	
	cout("Wrong id: getRandomIceImageName")
	return ""	
end

function restaurant3:onNotify(notification)
	if (notification == "CustomerGroupAboutToEnter") then
		self.skiLift:DoLift()
	end
end

-- set restaurant
restaurant = restaurant3()

class 'skiHill' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
skiHill.timer = 6000
skiHill.active = true
skiHill.characters = {"INGAME_PERSON_REGULAR_FEMALE_SKI", 
					"INGAME_PERSON_REGULAR_MALE_SKI", 
					"INGAME_PERSON_CHILD_FEMALE_SKI", 
					"INGAME_PERSON_CHILD_MALE_SKI",
					"INGAME_PERSON_YUPPIES_FEMALE_SKI",
					"INGAME_PERSON_YUPPIES_MALE_SKI"}
skiHill.trackX = -47 -- if you change this, change restaurant_3_day6.lua as well!


function skiHill:__init() super()
end

function skiHill:onCreate()
end

function skiHill:getRandomCharacter()
	local r = math.random(table.getn(self.characters))
	return self.characters[r]
end

function skiHill:onTick(time)
	if (self.active == false) then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer <= 0) then
		local skiPerson = createSprite()
		local skiTime = math.random(3000, 6000)
		skiPerson:setDefaultSection("characters")
		skiPerson:animate(self:getRandomCharacter(), -1, 10)
		skiPerson:setX(self.trackX)
		skiPerson:setY(-200)
		skiPerson:addSoundAnimation("SOUND_SKIER_DOWN_SLOPE", false)
		skiPerson:addLocationAnimation(self.trackX, 600, skiTime, true, 0)
		self:addChild(skiPerson)			
		
		self.timer = math.random(9000, 18000)
	end
end

function skiHill:doSkiPerson(duration, yPos)
	local skiPerson = createSprite()
	skiPerson:setDefaultSection("characters")
	skiPerson:animate("INGAME_PERSON_REGULAR_MALE_SKI", -1, 10)
	skiPerson:setX(self.trackX)
	skiPerson:setY(-200)
	skiPerson:addSoundAnimation("SOUND_SKIER_DOWN_SLOPE", false)
	skiPerson:addLocationAnimation(self.trackX, yPos, duration, true, 0)
	self:addChild(skiPerson)			
end

class 'skiLift' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
skiLift.cable = nil
skiLift.mainNode = nil
skiLift.object = ""

function skiLift:__init() super()
end

function skiLift:onCreate()
	self.mainNode = createSprite()
	self:addChild(self.mainNode)

	self.cable = createSprite()
	self.cable:setDefaultSection(player:getCurrentResourceSection())
	self.cable:animate("DECO_SKI_LIFT_CABLE", 0)
	self.cable:setX(1)
	self.cable:setY(-530)
	self:addChild(self.cable)
	
end

function skiLift:onTick(time)
	self.mainNode:setSuspended(scene:isPlayingMovie() or scene:isStartingMovie())
end

function skiLift:DoLift()

	local liftNode = createSprite()
	liftNode:addSoundAnimation("SOUND_SKI_GONDOLA_ARRIVES", false)
	liftNode:addLocationAnimation(0, -530, 4000, false, 3) -- ease out
	liftNode:addLocationAnimation(0, -530, 1500, false, 0) -- delay
	liftNode:addSoundAnimation("SOUND_SKI_GONDOLA_DEPARTS", false)
	liftNode:addLocationAnimation(0, -900, 2000, true, 2) -- ease in
	self.mainNode:addChild(liftNode)

	local skiLift = createSprite()
	skiLift:setDefaultSection(player:getCurrentResourceSection())
	skiLift:animate("DECO_SKI_LIFT", 0)
	skiLift:setX(-47)
	skiLift:setY(47)
	liftNode:addChild(skiLift)

	local wheels = createSprite()
	wheels:setDefaultSection(player:getCurrentResourceSection())
	wheels:animate("DECO_SKI_LIFT_WEELS", 0)
	wheels:setX(30)
	wheels:setY(-34)
	skiLift:addChild(wheels)
end


class 'iceLightUpgrade' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
iceLightUpgrade.sprites = List.new()

function iceLightUpgrade:__init() super()
end

function iceLightUpgrade:addSprite(x, y)
	local sprite = createSprite()
	sprite:setDefaultSection(player:getCurrentResourceSection())
	sprite:animate("DECO_ICE_LIGHT_BLUE_UPGRADE", 0)
	sprite:setX(x)
	sprite:setY(y)
	sprite:setAlpha(1)
	self:addChild(sprite)
	--sprite:setBlendMode(BLENDMODE_ADDITIVE)
	List.push_back(self.sprites, sprite)
	return sprite
end

function iceLightUpgrade:onCreate()
end

function iceLightUpgrade:onTick(time)
	
end
