
class 'day9' (interface)

day9.richardEntered = false
day9.richardEntering = false
day9.richardEnterTime = 40000

day9.richardLeft = false
day9.richardLeaveTime = 40000
day9.richardLeaving = false
day9.closed = false

day9.elevator = nil

day9.oldDoKeyCustomers = false

function day9:__init() super()
end

function day9:onLevelGlobals()
	-- First sort out the day's event
	--self:initEvent()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- Now the intro story bizzle
	local introSequence =
	{
		{ "scene",		"qStartMovie",			1							},	
		{ "emily",		"qSetPosition",			movieNode					},
		{ "cleaner",	"qSetPosition",			movieNode					},
		{ "emily",		"qSetAppearance",		"NEUTRAL"					},
		{ "emily",		"qWalkToXY",			25, 19						},
		{ "cleaner",	"qWalkToXY",			29, 19						},
		{ "emily",		"qAnimateWait",			"LOOKAROUND", 1, 7			},
		{ "emily",		"qWait",				500							},
		{ "emily",		"qSayTimed",			"RESTAURANT2_DAY9_0", 1500	},
		{ "emily",		"qSetAppearance",		"SAD"						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_25"		},	
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_26"		},	
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_27"		},	
		{ "emily",		"qSetAppearance",		"CRYING"					},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_28"		},	
		{ "emily",		"qWalkToNode",			grid:getCounterNode()		},
		{ "",			"sequential"										},
		{ "emily",		"qSetAppearance",		""							},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qStartGame" 										},
	}
	
	qSequence(introSequence)

	-- setup Ricky
	self:initRichard()
    richard:setPosition(grid:getNode(49, 4))
    
end

function day9:initRichard()
	
	richard = pm:createPerson("elevatorCustomer")
	richard:setDefaultSection("characters")
	richard:setBaseName("INGAME_PERSON_RICHARD")
	richard:setAppearance("SORRY")
	richard.doKey = false
	
end

function day9:onTick(time)
	
	if (self.richardEntering or
		self.richardLeaving) then
		
		return	
	end
	
	if (self.richardEntered == false and self.closed == false) then
		self.richardEnterTime = self.richardEnterTime - time
		if (self.richardEnterTime <= 0) then
			self.elevator = getAppliance("rest2_elevator")
			if (self.elevator and
				not self.elevator:isBusy() and
				self.elevator.customerArriving == nil and
				self.elevator.customerLeaving == nil and
				not self.elevator:hasCustomersWaiting()) then
			
				self.oldDoKeyCustomers = self.elevator.doKeyCustomers
				self.elevator.doKeyCustomers = false
				self.elevator.activeKeyCustomer = true
				
				self.richardEntered = true
				self.richardEntering = true
				
				richard:setKeyName("KEY_3")
				richard:qWalkToXY(23, 19)
				richard:qSetAppearance("SORRY")
				richard:qSayTimed("RESTAURANT2_DAY9_1", 1500)
				richard:qWalkToXY(1, 12)
				richard:qNotify("richard at lift")
				
			end
		 end
	elseif (not self.richardLeft) then
		self.richardLeaveTime = self.richardLeaveTime - time
		if (self.richardLeaveTime <= 0) then
			if (self.elevator and
				not self.elevator:isBusy() and
				self.elevator.customerArriving == nil and
				self.elevator.customerLeaving == nil and
				not self.elevator:hasCustomersWaiting()) then
			
				self.oldDoKeyCustomers = self.elevator.doKeyCustomers
				self.elevator.doKeyCustomers = false
				self.elevator.activeKeyCustomer = true
				
				self.richardLeft = true
				self.richardLeaving = true
						
				self:initRichard()
				
				self.elevator.customerLeaving = richard
				richard:setKeyName("KEY_3")
				richard:setPosition(grid:getNode(self.elevator.inLiftGridX, self.elevator.inLiftGridY))
				richard:setVisible(false)

				self.elevator:addFloorRequest(richard, richard:getRequestedFloor(), 0)
			end
		 end
	end
end

function day9:onNotify(notification)

	if (notification == "richard at lift") then
		if (self.elevator) then
			
			self.elevator.customerArriving = richard
			self.elevator:addFloorRequest(richard, 0, 3)
			self.elevator.doKeyCustomers = self.oldDoKeyCustomers
		end
	elseif (notification == "onCustomerArrivingExit") then
	
		--if (self.closed) then
			--self.richardLeaving = true
			--self.richardEntering = true
			--return
		--end

		self.richardEntering = false

		self.richardLeft = false
		self.richardLeaving = false
		self.richardLeaveTime = 12000

	elseif (notification == "onCustomerLeavingExit") then

		richard:qWalkToXY(23, 19)
		richard:qSetAppearance("SORRY")
		richard:qSayTimed("RESTAURANT2_DAY9_1", 1500)
		richard:qWalkToNode(exitNode)
		
		self.elevator.doKeyCustomers = self.oldDoKeyCustomers
		self.elevator:clearCustomerLeaving()
		
		self.richardLeaving = false
		self.richardEntered = false
		self.richardEntering = false
		self.richardEnterTime = 35000

		--if (self.closed) then
			--self.richardLeaving = true
			--self.richardEntering = true
		--end
--
	elseif (notification == "restaurant closed") then
	
		self.closed = true
	
	end

end

function day9:onDayEnd()
	
	-- setup Ricky
	autoAllPeopleWalkOut = false
	self:initRichard()
    richard:setPosition(grid:getNode(49, 4))
	
	-- Now the outro meuk
	local outroSequence =
	{
		{ "scene",		"qStartMovie",			1							},	
		{ "cleaner",	"qWalkToNode",			exitNode					},
		{ "richard",	"qWalkToXY",			26, 19						},
		{ "richard",	"qSetAppearance",		"SORRY"						},
		{ "emily",		"qWalkToXY",			22, 19						},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_2"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_3"		},
		{ "emily",		"qSetAppearance",		"SAD"						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_4"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_5"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_6"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_7"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_8"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_9"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_10"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_11"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_12"		},
		{ "richard",	"qSetAppearance",		"THINKING"					},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_13"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_14"		},
		{ "emily",		"qSetAppearance",		"PANIC"						},
		{ "emily",		"qWait",				1000						},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_15"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_16"		},
		{ "richard",	"qSetAppearance",		"WORRIED"					},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_17"		},
		{ "emily",		"qSetAppearance",		""							},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_18"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_19"		},
		{ "richard",	"qSetAppearance",		"SORRY"						},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_20"		},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_21"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_22"		},
		{ "emily",		"qSetAppearance",		"SAD"						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_1"		},
		{ "richard",	"qSay",					"RESTAURANT2_DAY9_24"		},
		
		{ "emily",		"qWalkToNode",			exitNode					},
		{ "richard",	"qWalkToNode",			exitNode					},
		--{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}
	
	qSequence(outroSequence)
end

function day9:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set the day
day = day9()