-- day class
class 'day8' (interface)

function day8:__init() super()
end

day8.questionIndex = 0
day8.timer = 0
day8.timeInterval = 30 * 1000
day8.timeUntilNext = { day8.timeInterval, day8.timeInterval, day8.timeInterval, day8.timeInterval, day8.timeInterval, day8.timeInterval }
day8.timePerProduct = 16 * 1000
day8.products = 
{ 
	{ "ROAST", "CHAMPAGNE" }, 
	{ "CHAMPAGNE", "ASPARAGUS" },
	{ "ASPARAGUS", "COFFEE" }, 
}

day8.ludwig = nil
day8.order = nil
day8.interviewTable = nil
day8.state = "idle"
day8.timerpb = 0
day8.timerpbSuspended = false
day8.scorePerOrder = 50
-------------------------------------------------------------------------------
-- The various sequences
day8.sequenceEnter = {}
-- Answer sequences
day8.q1Yes	= {}
day8.q1No	= {}
day8.q2Yes	= {}
day8.q2No	= {}
day8.q3Yes	= {}
day8.q3No	= {}

function day8:onLevelGlobals()

	-- Ricky
	richard = pm:createPerson("npc")
	richard:setDefaultSection("characters")
	richard:setBaseName("INGAME_PERSON_RICHARD")
	
	-- Ludo
	self.ludwig = pm:createPerson("npc")
	self.ludwig:setDefaultSection("characters")
	self.ludwig:setBaseName("INGAME_PERSON_LUDWIG")

	self.order = createOrder()
	self.order:setX(-50)
	self.order:setY(-30)		
	self.order:setAnchorPointType(BOTTOMCENTER)
	self.order:setPivotPointType(BOTTOMCENTER)
	self.order:setVisible(false)
	self.ludwig:addChild(self.order)
	
	self.interviewTable = om:getTable(1)
	self.interviewTable:setReserved(true)
	self.interviewTable:setOverheadY(self.interviewTable:getOverheadY() - 75)

	richard:setPosition(grid:getNode(30, 6))
	self.ludwig:setPosition(grid:getNode(30, 2))
	
end

function day8:onLevelInited()

	autoStartGame = false
	autoAllPeopleWalkIn = false	

	local intro = 
	{
		{ "scene",			"qStartMovie",		3							},	
		{ "ludwig",			"qSetAppearance",	"CRITIC"					},
		{ "", 				"parallel"										},
		
		{ "richard",		"qWalkToXY",		40, 12						},
		{ "ludwig",			"qWait",			500							},
		{ "ludwig",			"qWalkToXY",		37, 12						},
		
		{ "", 				"sequential"									},
		{ "richard",		"qWait",			1000						},
		{ "", 				"parallel"										},
		
		{ "richard",		"qWalkToXY",		25, 12						},
		{ "ludwig",			"qWait",			500							},
		{ "ludwig",			"qWalkToXY",		29, 12						},
		
		{ "", 				"sequential"									},
		{ "richard",		"qWait",			1000						},
		{ "", 				"parallel"										},
		
		{ "richard",		"qWalkToXY",		25, 27						},
		{ "ludwig",			"qWait",			500							},
		{ "ludwig",			"qWalkToXY",		29, 27						},
		
		{ "", 				"sequential"									},
		{ "richard",		"qWait",			1000						},
		{ "", 				"parallel"										},
		
		{ "richard",		"qWalkToXY",		17, 22						},
		{ "ludwig",			"qWait",			500							},
		{ "ludwig",			"qWalkToXY",		21, 22						},
		
		{ "",				"sequential"									},
		
		{ "emily",			"qSetPosition",		movieNode					},
		{ "emily",			"qWalkToXY",		25, 22						},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_0"		},
		{ "ludwig",			"qSetAppearance",	"SURPRISED"					},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_1"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "richard",		"qSetAppearance",	"SURPRISED"					},
		{ "richard",		"qSay",				"RESTAURANT2_DAY8_2"		},
		{ "ludwig",			"qSetAppearance",	"ANGRY"						},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_3"		},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_4"		},
		{ "richard",		"qSetAppearance",	"WORRIED"					},
		{ "richard",		"qSay",				"RESTAURANT2_DAY8_5"		},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_6"		},
		{ "ludwig",			"qSetAppearance",	""							},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_7"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_8"		},
		{ "richard",		"qSetAppearance",	"SORRY"						},
		{ "richard",		"qSay",				"RESTAURANT2_DAY8_9"		},
		{ "emily",			"qSetAppearance",	"OFFENDED"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_10"		},
		{ "ludwig",			"qSetAppearance",	"ANGRY"						},
		{ "ludwig",			"qSay",				"RESTAURANT2_DAY8_11"		},
		{ "ludwig",			"qWalkToNode",		exitNode					},
		{ "ludwig",			"qSetAppearance",	""							},
		{ "richard",		"qWalkToXY",		21, 22						},
		{ "richard",		"qSetAppearance",	"SERIOUS"					},
		{ "richard",		"qSay",				"RESTAURANT2_DAY8_12"		},
		{ "richard",		"qWalkToNode",		exitNode					},
		
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},			
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},			
	}

	qSequence(intro)

	self:setupSequences()
end

function day8:onDayBegin()
	-- Time before Dicky and Ludo reappear
	self.timer = 100 * 1000
end

function day8:onNotify(notification)
	if (notification == "next question") then
		self:gotoNextQuestion()
	elseif (notification == "question finished") then
		self:onQuestionAnswered()
	end
end

function day8:gotoNextQuestion()
	self.questionIndex = self.questionIndex + 1
	
	if (self.questionIndex == 1) then
		self.state = "interviewing"
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(table.getn(self.timeUntilNext))
		eventBar:setProgress(0)				
		eventBar:setDescriptionText(getText("EVENTBAR"))
		eventBar:setSubjectImage("INTERVIEW_BAR", player:getCurrentResourceSection())		
		eventBar:animateToActive()
		
	end
	
	if (self.questionIndex > table.getn(self.timeUntilNext)) then
		
		self.state = "leaving"
		eventBar:animateToDeactive()	
		self.ludwig:clearOverhead()

	else
		self.state = "interviewing"
		eventBar:lowerCurtain()
		
		self.timer = self.timeUntilNext[self.questionIndex]
			
	end
	
end

function day8:onClickTable(table)

	if (self.state == "interviewing") then
		if (table:isReserved()) then
			if (self.timerpb > 0) then
				self.timerpbSuspended = true
		
			end	
		end
	end

end

function day8:onTaskComplete(actorType, taskType, p0, p1)

	if (self.state == "interviewing") then
		if (taskType == "TableTask") then
			if (p0:isReserved()) then
				-- the table is reserved
				-- it's the table where the interviewer is sitting on
				if (self.timerpb > 0) then
					local n = tray:distributeProducts(self.order)
					if (n > 0) then
						self.order:draw()
						if (self.order:isCompleted()) then
							incScore(self.scorePerOrder, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)		
							self.order:setVisible(false)
							self.timerpb = 0
							self.timerpbSuspended = false
							self.ludwig:setAppearance("IDLE")
							eventBar:setProgress(self.questionIndex)
							
							insert()
							emily:qNotify("next question")
							append()

						end				
					else
						self.timerpbSuspended = false

					end
				end
			end
		end
	end

end

function day8:setupQuestion()
	scene:qStartMovie(true, 3)
	eventBar:raiseCurtain()
	self.ludwig:setAppearance("TALK")
end

function day8:onQuestionAnswered()
	scene:qFinishMovie()
	self.ludwig:qNotify("next question")
	self.ludwig:setAppearance("IDLE")
	parallel()	
end

function day8:onClickMessage(text, result)
	
	local progress = false
	if (text == "RESTAURANT2_DAY8_30") then
		choose("loveRichard", result)
		
		if (result == "yes") then
			insert()
			qSequence(self.q1Yes)
			append()
			
		elseif (result == "no") then
			insert()
			qSequence(self.q1No)
			append()
			
		end
		progress = true
		
	elseif (text == "RESTAURANT2_DAY8_41") then
		choose("prenuptual", result)
	
		if (result == "yes") then
			insert()
			qSequence(self.q2Yes)
			append()
			
		elseif (result == "no") then
			insert()
			qSequence(self.q2No)
			append()
			
		end
		progress = true
		
	elseif (text == "RESTAURANT2_DAY8_51") then
		choose("sorry", result)
	
		if (result == "lie") then
			insert()
			qSequence(self.q3Yes)
			qSequence(self.q3No)
			append()
			
		elseif (result == "no") then
			insert()
			qSequence(self.q3No)
			append()			
	
		end
		progress = true
	end
	
	if (progress) then
		eventBar:setProgress(self.questionIndex)
	end
			
end

function day8:onOrderPlaced()
	self.order:setVisible(true)
	self.order:setScaleX(0)
	self.order:setScaleY(0)					
	self.order:popIn()
	self.timerpb = self.timePerProduct
	self.timerpbSuspended = false
	self.ludwig:setAppearance("WAVE")
	self.ludwig:playSound("SOUND_EVENT_ATTENTION")
end

function day8:onTick(time)

	--cout("TICK.  State is: '" .. self.state .. "' and timer is: " .. self.timer .. "\n")
	if (self.state == "idle") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				qSequence(self.sequenceEnter)
				self.state = "enter"
						
			end	
		end

	elseif (self.state == "enter") then
		-- do nothing

	elseif (self.state == "interviewing") then
	
		if (self.timerpb > 0) then
			if (self.timerpbSuspended == false) then
				self.timerpb = self.timerpb - time
				if (self.timerpb <= 0) then
					self.order:setVisible(false)
					self.timerpb = 0			
					self.timerpbSuspended = false
					
					eventBar:setProgress(self.questionIndex)
				
					insert()
					emily:qNotify("next question")
					append()				
								
				end		
			end
		end
	
		if (self.timer > 0) then
			self.timer = self.timer - time
			
			if ((self.questionIndex == 1) or (self.questionIndex == 3) or (self.questionIndex == 5)) then
    			if (self.timer + time > 3000) then
    			    if (self.timer <= 3000) then
    			       self.interviewTable:createOverhead("INGAME_THINK_ICON")
    			        
    			    end			
    			end
    			
    			if (self.timer + time > 650) then
    			    if (self.timer <= 650) then
    			        self.interviewTable:clearOverhead()
    			    
    			    end
                end
            end
			
			if (self.timer <= 0) then
				--cout("Timer run out.  Index is: " .. self.questionIndex .."\n")
				if (self.questionIndex == 1) then
					eventBar:raiseCurtain()
					self.order:clear()
					
					for index, value in ipairs(self.products[1]) do
						self.order:addProduct(value)
					end
					self:onOrderPlaced()
				
				elseif (self.questionIndex == 2) then
					self:setupQuestion()
					self.ludwig:qSayYesNo("RESTAURANT2_DAY8_30")
					--self:askQuestion("RESTAURANT2_DAY8_30")
				
				elseif (self.questionIndex == 3) then
					eventBar:raiseCurtain()
					self.order:clear()
					for index, value in ipairs(self.products[2]) do
						self.order:addProduct(value)
					end
					self:onOrderPlaced()
				
				elseif (self.questionIndex == 4) then
					self:setupQuestion()
					self.ludwig:qSay("RESTAURANT2_DAY8_40")
					self.ludwig:qSayYesNo("RESTAURANT2_DAY8_41")
					--self:askQuestion("RESTAURANT2_DAY4_33")
				
				elseif (self.questionIndex == 5) then
					eventBar:raiseCurtain()
					self.order:clear()
					for index, value in ipairs(self.products[3]) do
						self.order:addProduct(value)
					end
					self:onOrderPlaced()
				
				elseif (self.questionIndex == 6) then
					self:setupQuestion()
					self.ludwig:qSay("RESTAURANT2_DAY8_50")
					self.ludwig:qSayLieNo("RESTAURANT2_DAY8_51")
					--self:askQuestion("RESTAURANT2_DAY4_36")
				
				else
					warn("day4:onTick - invalid state")				
				
				end			
			end
		end	
	
	elseif (self.state == "leaving") then
		-- do nothing

	end

end

function day8:setupSequences()
	self.sequenceEnter = 
	{
		{ "scene",		"qStartMovie",			3						},	
		{ "ludwig",		"qSetPosition",			movieNode				},
		{ "richard",	"qSetPosition",			movieNode				},
		{ "richard",	"qWalkToXY",			25, 22					},
		{ "richard",	"qSetAppearance",		"SORRY"					},
		{ "",			"parallel"										},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_20"	},
		{ "emily",		"qWalkToXY",			22, 22					},
		{ "",			"sequential"									},
		{ "emily",		"qSetAppearance",		"OFFENDED"				},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_21"	},
		{ "richard",	"qSetAppearance",		"WORRIED"				},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_22"	},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_23"	},
		{ "",			"parallel"										},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_24"	},
		{ "ludwig",		"qWalkToXY",			28, 22					},
		{ "",			"sequential"									},
		{ "emily",		"qSetAppearance",		""						},
		{ "richard",	"qSetAppearance",		"ROLLEYES"				},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_25"	},
		{ "richard",	"qSetAppearance",		"WORRIED"				},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_26"	},
		{ "",			"parallel"										},
		{ "ludwig",		"qSitAt",				om:getTable(1), 3		},
		{ "richard",	"qSitAt",				om:getTable(1), 2		},
		{ "",			"sequential"									},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",				"next question"			},
		{ "",			"parallel"										},					
	}

	-- Answer sequences
	self.q1Yes =
	{
		{ "emily",		"qSetAppearance",		""						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_31"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_32"	},
		{ "scene",		"qNotify",				"question finished"		},
	}

	self.q1No=
	{
		{ "emily",		"qSetAppearance",		"OFFENDED"				},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_33"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_34"	},
		{ "emily",		"qSetAppearance",		""						},
		{ "scene",		"qNotify",				"question finished"		},
	}

	self.q2Yes =
	{
		{ "emily",		"qSetAppearance",		""						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_42"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_43"	},
		{ "richard",	"qSetAppearance",		"SERIOUS"				},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_44"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_45"	},
		{ "richard",	"qSetAppearance",		""						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_46"	},
		{ "scene",		"qNotify",				"question finished"		},
	}

	self.q2No=
	{
		{ "emily",		"qSetAppearance",		"OFFENDED"				},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_47"	},
		{ "emily",		"qSetAppearance",		""						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_48"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_49"	},
		{ "emily",		"qSetAppearance",		"OFFENDED"				},
		{ "emily",		"qWait",				1000					},
		{ "emily",		"qWalkToNode",			grid:getCounterNode()	},
		{ "emily",		"qSetAppearance",		""						},
		{ "scene",		"qNotify",				"question finished"		},
	}

	self.q3Yes =
	{
		{ "emily",		"qSetAppearance",		""						},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_52"	},
		{ "ludwig",		"qSetAppearance",		"HAPPY"					},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_53"	},
		{ "emily",		"qSetAppearance",		"CONFUSED"				},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_54"	},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_55"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_56"	},
	}

	self.q3No=
	{
		{ "emily",		"qSetAppearance",		"OFFENDED"				},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_57"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_58"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_59"	},
		{ "ludwig",		"qSetAppearance",		"OFFENDED"				},
		{ "ludwig",		"qSay",					"RESTAURANT2_DAY8_60"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY8_61"	},
		{ "",			"parallel"										},
		{ "ludwig",		"qWalkToNode",			exitNode				},
		{ "richard",	"qWait",				1000					},
		{ "",			"sequential"									},
		{ "richard",	"qSetAppearance",		"SORRY"					},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_62"	},
		{ "richard",	"qSay",					"RESTAURANT2_DAY8_63"	},
		{ "",			"parallel"										},
		{ "richard",	"qWalkToNode",			exitNode				},
		{ "richard",	"qWait",				1000					},
		{ "",			"sequential"									},
		{ "emily",		"qSetAppearance",		""						},
		{ "scene",		"qNotify",				"question finished"		},
	}

end

function day8:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c
	end	
	return nil
end

-- set day
day = day8()
