
-- day class
class 'day7' (interface)

day7.distanceToWalk = 1000	-- textual number (gui / dialogs)
day7.nodesTotal = 4025		-- internal number 
day7.sequenceStart = nil
day7.sequenceWin = nil
day7.sequenceFinish = nil
day7.nodesLeft = 0
day7.started = false
day7.completed = false
day7.score = 100

day7.sequenceWin = {}
day7.sequenceFinish = {}

function day7:__init() super()
end

function day7:onLevelInited()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	self.nodesLeft = self.nodesTotal
	
	evelyn = pm:createPerson("story_character")
    evelyn:setBaseName("INGAME_PERSON_EVELYN")
    evelyn:setVisible(true)
    evelyn:setPosition(movieNode)
    
    emily:setPosition(grid:getCounterNode())
    local startSequence =
    {
		{ "scene",			"qStartMovie",		2						},	
		{ "evelyn",			"qSetAppearance",	"HAPPY"					},
		{ "evelyn",			"qWalkToXY",		26, 24					},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_0"	},
		{ "emily",			"qWalkToXY",		22, 24					},
		{ "emily",			"qSetAppearance",	"SUSPICIOUS"			},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_1"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_2"	},
		{ "emily",			"qSetAppearance",	"SURPRISED"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_3"	},
		{ "evelyn",			"qSetAppearance",	""						},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_4"	},
		{ "emily",			"qSetAppearance",	"SAD"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_5"	},
		{ "evelyn",			"qSetAppearance",	"HAPPY"					},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_6"	},
		{ "emily",			"qSetAppearance",	"CONFUSED"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_7"	},
		{ "evelyn",			"qSetAppearance",	""						},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_8"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_9"	},
		{ "emily",			"qAnimateWait",		"LAUGH", 1, 10			},
		{ "emily",			"qAnimate",			"LAUGH", 0,				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_10"	},
		{ "evelyn",			"qWalkToXY",		26, 16					},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_11"	},
		{ "emily",			"qAnimate",			"IDLE", 0,				},
		{ "emily",			"qSetAppearance",	"HAPPY"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_12"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_13"	},
		{ "emily",			"qSetAppearance",	"BLUSH"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_14"	},
		
		{ "",				"parallel"									},
		{ "evelyn",			"qWalkToXY",		49, 2					},
		{ "emily",			"qWait",			500						},
		{ "emily",			"qSetAppearance",	""						},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()	},
		{ "",				"sequential"								},
		{ "scene",			"qFinishMovie"								},
		{ "scene", 			"qStartGame" 								},
    }
    
    qSequence(startSequence)
    
    -- Win sequence (when distance walked)
    self.sequenceWin =
    {
		{ "emily",			"qAnimateWait",		"JUMP", 1,	10			},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_20"	},
    }
    
    -- End sequence (at end of day)
    self.sequenceFinish =
    {
		{ "scene",			"qStartMovie",		1						},	
		{ "evelyn",			"qSetAppearance",	"HAPPY"					},
		{ "evelyn",			"qWalkToXY",		26, 24					},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_30"	},
		{ "emily",			"qWalkToXY",		22, 24					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_31"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_32"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_33"	},
		{ "",				"parallel"									},
		{ "emily",			"qSetAppearance",	"THINKING"				},
		{ "evelyn",			"qWalkToXY",		26, 18					},
		{ "",				"sequential"								},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_34"	},
		{ "evelyn",			"qSetAppearance",	""						},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_35"	},
		{ "emily",			"qSetAppearance",	"NEUTRAL"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_36"	},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_37"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_38"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_39"	},
		{ "evelyn",			"qSetAppearance",	"STOIC"					},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_40"	},
		{ "emily",			"qSay",				"RESTAURANT2_DAY7_41"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_42"	},
		{ "evelyn",			"qSay",				"RESTAURANT2_DAY7_43"	},
		{ "",				"parallel"									},
		{ "evelyn",			"qWalkToNode",		exitNode				},
		{ "emily",			"qSetAppearance",	""						},
		{ "emily",			"qWalkToNode",		exitNode				},
		{ "",				"sequential"								},
		{ "scene",			"qFinishMovie"								},
		{ "scene",			"qFinishGame"								},
    }
	
end

function day7:onDayBegin()

	eventBar:setSubjectImage("OBJECT_PANDA_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(self.distanceToWalk)
	eventBar:setProgress(0)	
	eventBar:animateToActive()
	eventBar:raiseCurtain()
	self.started = true
	
end

function day7:onDayEnd()

	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)

end

function day7:onLockToNode(actor, node)

	if (self.started and not self.completed) then
		if (actor:getType() == "emily") then
			self.nodesLeft = self.nodesLeft - 1
			
			local progress = 1 - (self.nodesLeft / self.nodesTotal)
			eventBar:setProgress(progress * self.distanceToWalk)
			
			if (self.nodesLeft == 0) then
				eventBar:animateToDeactive()
				emily:playSound("SOUND_EVENT_COMPLETE_ALL")
				incScore(self.score, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
				qInsertSequence(self.sequenceWin)
				self.completed = true
			
			end	
		end
	end
	
end

function day7:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day7()
