include("scripts/events/spiderwebevent.lua")

-- set event
event = spiderwebevent()
event.itemsProps = 
{
	{type="coffeePuddle", anchorY=16, image="OBJECT_COFFEE_SPILL_BACK", x=13, y=10, hidden=true, pixelsToClean=600},
	-- Walking down
    {type="footstep1", anchorY=8, image="FOOTPRINT_DOWN_R", x=16, y=12, hidden=true, pixelsToClean=200},
    {type="footstep2", anchorY=8, image="FOOTPRINT_DOWN_L",	x=16, y=15, hidden=true, pixelsToClean=200},
    {type="footstep3", anchorY=8, image="FOOTPRINT_DOWN_R",	x=16, y=18, hidden=true, pixelsToClean=200},
    
    -- Walking right
    {type="footstep10", anchorY=8, image="FOOTPRINT_R_L",	x=18, y=19, hidden=true, pixelsToClean=200},
    {type="footstep11", anchorY=8, image="FOOTPRINT_R_R",	x=21, y=19, hidden=true, pixelsToClean=200},
    {type="footstep12", anchorY=8, image="FOOTPRINT_R_L",	x=24, y=19, hidden=true, pixelsToClean=200},
    
    -- Walking up
    {type="footstep20", anchorY=8, image="FOOTPRINT_UP_R",	x=26, y=17, hidden=true, pixelsToClean=200},
    {type="footstep21", anchorY=8, image="FOOTPRINT_UP_L",	x=26, y=14, hidden=true, pixelsToClean=200},
}

-- day class
class 'day6' (interface)

day6.coffeeMachine = nil

day6.coffeePuddle = nil
day6.puddleBaseX = -56
day6.puddleBaseY = -18

day6.footprintsVisible = false
day6.footprintCount = 1
day6.footprintStepSize = 3

day6.emilyArrived = {}

function day6:__init() super()
end

function day6:onLevelGlobals()
	event.baseName = nil                   
	event.eventBarImage = "OBJECT_CLEANING_CLOTH_BAR"
	event.entryX = 0
	event.entryY = 0
	event.highlightX = 17
	event.highlightY = 15
	event.timeUntilEnterMin = 0
	event.timeUntilEnterMax = 1
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.sequenceStart	= nil
	event.sequenceDone = nil
	event.hintId = "HINT_FOOTSTEPS_CLEANING"
	event.cleanSound = "SOUND_CLEAN_CARPET_LOOP"
end

function day6:onDayBegin()
	scene:qNotify("show bar")
	self.coffeePuddle:setVisible(false)
	self:showEventObject("coffeePuddle")
end

function day6:onLevelInited()
	
	self.coffeeMachine = getAppliance("rest2_coffee_machine")
	self.coffeePuddle = createSprite()
	self.coffeePuddle:setDefaultSection(player:getCurrentResourceSection())
	self.coffeePuddle:animate("OBJECT_COFFEE_SPILL_BACK", 0)
	self.coffeePuddle:setX(self.puddleBaseX)
	self.coffeePuddle:setY(self.puddleBaseY)
	self.coffeePuddle:setVisible(false)
	self.coffeeMachine:addChild(self.coffeePuddle)
	
	autoStartGame = false
	autoAllPeopleWalkIn = false	

	francois = pm:createPerson("francois")
	francois:setPosition(grid:getNode(16, 12))
	francois:setAppearance("BACK")
	
	local elevator = getAppliance("rest2_elevator")
	emily:setPosition(grid:getNode(elevator.inLiftGridX, elevator.inLiftGridY))
	emily:setVisible(false)
	
	local sequenceStart = 
	{
		{ "scene",			"qStartMovie",		2							},	
		{ "francois",		"qAnimateWait",		"KICK_COFFEE", 1, 16		},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_0"		},
		{ "francois",		"qAnimateWait",		"KICK_COFFEE", 1, 16		},
		{ "emily",			"qNotify",			"animate_spill"				},
		{ "francois",		"qAnimate",			"IDLE", 0					},
		{ "francois",		"qSetAppearance",	"IDLE"						},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_1"		},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_2"		},
		{ "francois",		"qWalkToXY",		16, 19						},
		{ "francois",		"qWalkToXY",		22, 19						},
		{ "francois",		"qAnimateWait",		"LOOK_AROUND", 1, 16		},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_3"		},
		{ "francois",		"qAnimate",			"IDLE", 0					},
		{ "francois",		"qWalkToXY",		26, 19						},
		{ "francois",		"qWalkToXY",		26, 12						},
		--{ "francois",		"qWalkToNode",		movieNode					},
		{ "francois",		"qNotify",			"frank_left"				},
	}
	
	self.emilyArrived = 
	{
		{ "emily",			"qSetVisible",		true						},
		{ "emily",			"qWalkToXY",		22, 18						},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_4"		},
		{ "emily",			"qSetAppearance",	"DISAPPROVE"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_5"		},
		{ "emily",			"qSetAppearance",	""							},
		
		{ "francois",		"qWalkToXY",		26, 18						},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_6"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_7"		},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_8"		},
		{ "emily",			"qSetAppearance",	"SUSPICIOUS"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_9"		},
		{ "francois",		"qSetAppearance",	"BLUSH"						},
		{ "francois",		"qSay",				"RESTAURANT2_DAY6_10"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "francois",		"qSetAppearance",	""							},
		
		{ "francois",		"qWalkToNode",		exitNode					},
		{ "francois",		"qDestroy",										},
		{ "scene",			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									},
		{ "emily",			"qSetAppearance",	""							},
		{ "",				"parallel"										},			
	}
	event.sequenceDone = 
	{
		{ "scene",			"qStartMovie",		2							},	
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_20"		},
		{ "emily",			"qSetAppearance",	"THINKING"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_21"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "scene",			"qFinishMovie" 									},		
	}
	qSequence(sequenceStart)

	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",		3								},	
		{ "elvis",			"qWalkToXY",				24, 22					},
		{ "emily",			"qWalkToXY",				20, 22					},
		{ "emily",			"qSay",						"RESTAURANT2_DAY6_30"	},	
		{ "elvis",			"qSay",						"RESTAURANT2_DAY6_31"	},
		{ "elvis",			"qSay",						"RESTAURANT2_DAY6_32"	},
		{ "emily",			"qSay",						"RESTAURANT2_DAY6_33"	},	
		{ "elvis",			"qSetAppearance",			"SAD"					},	
		{ "elvis",			"qSay",						"RESTAURANT2_DAY6_34"	},
		{ "elvis",			"qSay",						"RESTAURANT2_DAY6_35"	},				
		{ "elvis",			"qWalkToXY",				44, 3					},
		{ "elvis",			"qSetVisible",				false					},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										}
	}	

end

function day6:onDayEnd()
	autoAllPeopleWalkOut = false
    elvis = pm:createPerson("npc")
    elvis:setBaseName("INGAME_PERSON_ELVIS")
    elvis:setDefaultSection("characters")
    elvis:setPosition(grid:getNode(44, 3))
	qSequence(self.sequenceEnd)
end

function day6:onNotify(notification)

	if (notification == "object cleaned") then
		self:onObjectCleaned(event.objectToClean)
		
	elseif (notification == "animate_spill") then
		self:animateCoffeeSpill()
		
	elseif (notification == "start_spill") then
		self:setCoffeeCupVisible(false)
		self.coffeeMachine:animate("OBJECT_COFFEE_MACHINE_SPILL",	1, false, 8, true)
	
	elseif (notification == "animate_puddle") then
		self.coffeePuddle:setVisible(true)
		self.coffeePuddle:animate("OBJECT_COFFEE_SPILL_ANIM", 1, false, 8, true)
		
	elseif (notification == "end_spill") then
		self:setCoffeeCupVisible(true)
		self.coffeeMachine:animate("OBJECT_COFFEE_MACHINE_DIRTY", 0)
		self.coffeePuddle:animate("OBJECT_COFFEE_SPILL_BACK", 0)
		
	elseif (notification == "frank_left") then
		self.footprintsVisible = true
		
		local elevator = getAppliance("rest2_elevator")
		elevator.customerLeaving = emily
		elevator:addFloorRequest(emily, 1, 0)
		elevator.activeKeyCustomer = true
		
	elseif (notification == "onCustomerLeavingExit") then
		local elevator = getAppliance("rest2_elevator")
		elevator:clearCustomerLeaving()
		elevator.activeKeyCustomer = false
		elevator.customerLeaving = nil
		
		qInsertSequence(self.emilyArrived)
		
	end
end

function day6:onObjectCleaned(object)
	if (object ~= nil and object:getObjectIdName() == "coffeePuddle") then
		self.coffeeMachine:animate("APP_COFFEE_MACHINE", 0)
	end
end

function day6:animateCoffeeSpill()
	
	local spillSequence =
	{
		{ "francois",			"qNotify",			"start_spill"										},
		{ "francois",			"qWait",			1000												},
		{ "francois",			"qNotify",			"animate_puddle"									},
		{ "francois",			"qWait",			500													},
		{ "francois",			"qNotify",			"end_spill"											},
	}
	qInsertSequence(spillSequence)
end

function day6:setCoffeeCupVisible(visible)
	local cup = self.coffeeMachine:getProduct("COFFEE")
	cup:setVisible(visible)
end

function day6:resetCoffeeSpill()
	self:setCoffeeCupVisible(true)
	self.coffeeMachine:animate("OBJECT_COFFEE_MACHINE", 0)
	self.coffeePuddle:setVisible(false)
end

function day6:onLockToNode(actor, node)
	
	if (not event.started and not self.footprintsVisible) then
		if (actor:getType() == "francois") then
			self.footprintCount = self.footprintCount + 1
			local footprintIndex = self.footprintCount % self.footprintStepSize
			if (footprintIndex == 0) then
				local nrFootprints = table.getn(event.itemsProps)
				footprintIndex = self.footprintCount / self.footprintStepSize
				footprintIndex = footprintIndex + 1 -- Skip the first entry...
				
				if (footprintIndex <= nrFootprints) then
					self:showEventObject(event.itemsProps[footprintIndex].type)
				end
			end
		end
	end
end

function day6:showEventObject(type)
	local object = getObject(type)
	if (object) then
		object:setVisible(true)
	--else
	--	cout("Cannot find object: " .. type .. "\n")
	end
end

function day6:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day6()
