include("scripts/events/brokenObjectEvent.lua")

-- set event
event = brokenObjectEvent()

event.targetId = "rest2_doormat"
event.nrTargets = 2
event.manual = true

-- day class
class 'day5' (interface)

day5.timer = 12000
day5.index = 1

function day5:__init() super()

end

function day5:onLevelGlobals()
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setPosition(grid:getNode(49, 3))

	event.animFix = "CLEAN_GROUND"
	event.soundFix = "SOUND_CLEAN_LOOP2"
	event.overheadY = 33
	event.pbY = 150
	event.timeUntilFixed = 1000 * 30
	event.scoreGotAll = 100
	event.score = 50
	event.sequenceStart = 
	{	
		{ "scene",		"qStartMovie",		1								},	
		{ "",			"sequential"										},
		{ "emily",		"qWalkToXY",		22, 22							},
		{ "cleaner",	"qWalkToXY",		25, 22							},
		
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_0"		},
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_1"		},
		{ "cleaner",	"qSetAppearance",	"HAPPY"							},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_2"		},
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_3"		},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_4"		},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_5"		},
		{ "cleaner",	"qSetAppearance",	"THINKING"						},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_6"		},
		{ "emily",		"qSetAppearance",	"LAUGH"							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_7"		},	

		{ "emily",		"qSetAppearance",	""								},
		{ "cleaner",	"qSetAppearance",	""								},
		{ "cleaner",	"qWalkToNode",		grid:getCleanerNode()			},
		{ "scene",		"qFinishMovie" 										},		
		{ "scene",		"qStartGame" 										},
	}
	
	self.sequenceObject1 = 
	{
		{ "scene",		"qStartMovie",		3							},	
		
		{ "richard",	"qWalkToXY",		23, 14						},
		{ "emily",		"qWalkToXY",		26, 14						},

		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_8"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_9"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_10"	},	
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_11"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_12"	},	
			
		{ "richard",	"qWalkToXY",		47, 3						},
		{ "scene",		"qFinishMovie" 									},		
	}

	self.sequenceObject2 = 
	{
		{ "scene",		"qStartMovie",		3							},	

		{ "richard",	"qWalkToXY",		14, 19						},
		{ "emily",		"qWalkToXY",		17, 19						},

		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_13"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_14"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_15"	},	
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_16"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_17"	},	
			
		{ "richard",	"qWalkToXY",		47, 3						},
		{ "scene",		"qFinishMovie" 									},		
	}

	self.sequenceObject3 = 
	{
		{ "scene",		"qStartMovie",		1							},	

		{ "richard",	"qWalkToXY",		4, 12						},
		{ "emily",		"qWalkToXY",		7, 12						},

		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_18"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_19"	},	
		{ "emily",		"qSetAppearance",	"CONFUSED"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_21"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_20"	},	
		{ "emily",		"qSetAppearance",	"OFFENDED"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_21"	},	
		{ "richard",	"qSetAppearance",	"SURPRISED"					},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_22"	},	
		{ "emily",		"qSetAppearance",	"SAD"						},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_23"	},	
		{ "richard",	"qSetAppearance",	"SORRY"						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_24"	},	
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_25"	},	
		{ "richard",	"qSetAppearance",	""							},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_26"	},	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_27"	},	
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_28"	},			
		{ "richard",	"qAnimateWait",		"LAUGH", 2					},
		{ "richard",	"qAnimate",			"IDLE", 0					},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY5_29"	},	
		{ "emily",		"qSetAppearance",	"OFFENDED"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_30"	},	
					
		{ "richard",	"qWalkToXY",		47, 3						},
		{ "richard",	"qDestroy"										},
		{ "scene",		"qFinishMovie" 									},		
		{ "emily",		"qSetAppearance",	""							},
		{ "",			"parallel"										},			
	}
	
end

function day5:onDayEnd()
	if (event.completed == false) then
		autoAllPeopleWalkOut = false
		qSequence(self.sequenceObject3)
		scene:qFinishGame()
	end
end

function day5:onTick(time)
	if (scene:isStartingMovie() or 
		scene:isPlayingMovie() or
		self.active) then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer <= 0) then		
		qSequence(self["sequenceObject" .. self.index])	
		self.active = true	
		if (self.index <= table.getn(event.brokenObjects)) then
			scene:qCallback(event.brokenObjects[self.index], function(s) s.pb:setVisible(true) s:createHighlight() end)		
			self.index = self.index + 1
			self.timer = 5000
		end
	end
end

function day5:onNotify(notification)
	if (notification == "swap1" or notification == "swap2") then
		self.active = false
	end
end

function day5:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day5()
