include("scripts/events/npcchaseevent.lua")

-- set event
event = npcChaseEvent()

-- day class
class 'day4' (interface)

day4.angela = nil

function day4:__init() super()
end

function day4:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	emily:setPosition(grid:getNode(25, 23))
	emily:animate("KISS_RICHARD", 0)

    richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setDefaultSection("characters")
    richard:setAppearance("IDLE")
    richard:animate("IDLE", 0)
    richard:setPosition(grid:getNode(23, 23))
    richard:setVisible(false)

    tmpAngela = pm:createPerson("npc")
    tmpAngela:setBaseName("INGAME_PERSON_ANGELA")
    tmpAngela:setDefaultSection("characters")
    tmpAngela:setAppearance("IDLE")
    tmpAngela:animate("IDLE", 0)
    tmpAngela:setPosition(grid:getNode(43, 3))

	self.angela = pm:createPerson("chaseAngela")
    self.angela.coordinates = 
	{
		{ 27, 13,  27, 13, "" },
		{ 42, 31, 42, 31, "" },
		{ 21, 14, 21, 14, "" },		
		{ 1, 12, 1, 12, "" },
		{ 27, 18, 27, 18, "" },
		{ 3, 23, 3, 23, "" },
		{ 47, 18, 47, 18, "" },
		{ 11, 31, 11, 31, "" },
		{ 25, 14, 25, 14, "" },
	}
	
	self.angela.arrivalAnim = "IDLE"
	self.angela.visibleWhenCaught = true
	
	event:addChaseNpc(self.angela)
	
	event.timeUntilEnterMin = 0
	event.timeUntilEnterMax = 1
	
	event.scoreGotOne = 25
	event.scoreGotAll = 150
	event.actionDuration = 0
	event.timerReturn = 1000 * 10
	--event.caughtSounds = {"SOUND_GIRL_GIGGLE0", "SOUND_GIRL_GIGGLE1"}
	
	event.shoutText = { "TEXT_RESTAURANT2_DAY4_12", "TEXT_RESTAURANT2_DAY4_13", "TEXT_RESTAURANT2_DAY4_14", "TEXT_RESTAURANT2_DAY4_15" }
	self.angela:setPosition(grid:getNode(25, 16))
	self.angela:setVisible(false)
	
	event.sequenceWin = 
	{
		{ "scene",		"qStartMovie",		2							},	

		{ "emily",		"qWalkToXY",		28, 14						},

    	{ "emily",		"qSetAppearance",	"HAPPY"						},  	
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY4_8"	},

    	{ "angela",		"qSetAppearance",	"SMIRK"						},  	
		{ "angela",		"qSay",				"TEXT_RESTAURANT2_DAY4_9"	},
    	{ "angela",		"qSetAppearance",	""							},  	
		{ "angela",		"qWalkToXY",		43, 3						},
		{ "angela",		"qDestroy"										},  		
  	
    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "scene",		"qFinishMovie" 									},
	}
	
	event.sequenceLose = 
	{
		{ "scene",		"qStartMovie",		2							},	

    	{ "angela",		"qSetAppearance",	"SMIRK"						},  	
		{ "angela",		"qSay",				"TEXT_RESTAURANT2_DAY4_10"	},
    	{ "angela",		"qSetAppearance",	""						},  	

		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY4_11"	},

		{ "angela",		"qWalkToXY",		43, 3						},
		{ "angela",		"qDestroy"										},  		

    	{ "scene",		"qFinishMovie" 									},
	}	
	
	self.sequenceDayStart = 
	{
		{ "scene",		"qStartMovie",		3							},	

		{ "tmpAngela",	"qWalkToXY",		25, 16						},
		{ "tmpAngela",	"qAnimateWait",		"PICTURE_FRONT", 1			},
		{ "tmpAngela",	"qAnimate",			"IDLE", 0					},    
	    { "emily",		"qAnimate",			"IDLE", 0					},
    	{ "richard",	"qSetVisible",		true						},
    	{ "emily",		"qSetAppearance",	"SHOCK"						},  	
		{ "tmpAngela",	"qSay",				"TEXT_RESTAURANT2_DAY4_0"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY4_1"	},
		{ "tmpAngela",	"qSay",				"TEXT_RESTAURANT2_DAY4_2"	},
    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "richard",	"qSetAppearance",	"ROLLEYES"					},  	
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY4_3"	},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY4_4"	},
		{ "richard",	"qWalkToXY",		43, 3						},
		{ "richard",	"qDestroy"										},
		{ "tmpAngela",	"qSay",				"TEXT_RESTAURANT2_DAY4_5"	},
		{ "emily",		"qWalkToXY",		22, 16						},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY4_6"	},
		{ "tmpAngela",	"qSay",				"TEXT_RESTAURANT2_DAY4_7"	},

    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qStartGame" 									},
    	{ "scene",		"qNotify",			"chase start"				},    	   	
		{ "tmpAngela",	"qDestroy"										},	
		{ "",			"parallel"										},			
		
	}

	qSequence(self.sequenceDayStart)
end

function day4:onDayBegin()

end

function day4:createPerson(class)

	if (class == "chaseAngela") then
		local result = chaseNpc("INGAME_PERSON_ANGELA")
		result:setType(class)
		result:setDefaultSection("characters")		
		return result
	elseif (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	
	return nil
end

-- set day
day = day4()