include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day3' (interface)

-- local dummy mailman for the intro sequence
day3.dummyPostman = nil

function day3:__init() super()
end

function day3:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	 
	emily:setPosition(grid:getCounterNode())
	 
    richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setDefaultSection("characters")
    richard:setAppearance("IDLE")
    richard:animate("IDLE", 0)
    richard:setPosition(grid:getNode(30, 18))
	richard:setAppearance("PHONE_ANGRY")

    edward = pm:createPerson("npc")
    edward:setBaseName("INGAME_PERSON_EDWARD")
    edward:setDefaultSection("characters")
    edward:setAppearance("IDLE")
    edward:animate("IDLE", 0)
    edward:setPosition(grid:getNode(24, 18))
    
	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 30000
	event.timeUntilEnterMax = 45000
	event.timeUntilAngry = 8000
	event.timeUntilLeave = 4000
	event.numPackages = 7
	event.entryX = entryX
	event.entryY = entryY
	event.waitX = 26
	event.waitY = 15
	event.workX = 22
	event.workY = 15
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie",		3							},	
		
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_0"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_1"	},
		{ "richard",		"qSetAppearance",	"SERIOUS"					},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_2"	},
		{ "emily",			"qSetAppearance",	"SAD"						},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_3"	},
		{ "richard",		"qSetAppearance",	"THINKING"					},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_4"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_5"	},
		{ "emily",			"qSetAppearance",	""							},
		{ "richard",		"qSetAppearance",	"SERIOUS"					},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_6"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_7"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_8"	},
		{ "richard",		"qWalkToXY",		40, 3						},
		{ "richard",		"qSetVisible",		false						},
		{ "emily",			"qSetAppearance",	"OFFENDED"					},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_9"	},
		{ "edward",			"qSay",				"TEXT_RESTAURANT2_DAY3_10"	},		
		{ "emily",			"qSetAppearance",	"SAD"						},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_11"	},
		{ "edward",			"qSay",				"TEXT_RESTAURANT2_DAY3_12"	},		
		{ "edward",			"qSay",				"TEXT_RESTAURANT2_DAY3_13"	},		
		{ "edward",			"qSay",				"TEXT_RESTAURANT2_DAY3_14"	},		
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_15"	},		
		{ "edward",			"qSay",				"TEXT_RESTAURANT2_DAY3_16"	},		
		{ "edward",			"qWalkToXY",		40, 3						},		
		{ "edward",			"qDestroy"										},		
		
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
	}

	event.sequenceComplete = 
	{
		{ "",				"sequential"									},
		{ "scene",			"qStartMovie",		1							},	
		
		{ "emily",			"qAnimateWait",		"JUMP", 1					},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_17"	},
		{ "emily",			"qSetAppearance",	""							},

		{ "scene",			"qFinishMovie" 									},
	}
	
	table1 = om:getTable(1)
	self.sequenceDayEnd = 
	{
		{ "scene",			"qStartMovie",		1							},	

		{ "emily",			"qWalkTo",			table1						},
		{ "emily",			"qAnimate",			"CLEAN", -1					},
		{ "richard",		"qSetVisible",		true						},
		{ "richard",		"qWalkToXY",		30, 20						},	
		{ "richard",		"qSetAppearance",	"SORRY"						},		
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_21"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_18"	},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qWalkToXY",		27, 20						},	
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_19"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_20"	},
		{ "richard",		"qSetAppearance",	"WORRIED"					},		
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_21"	},
		{ "richard",		"qSetAppearance",	"SERIOUS"					},		
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_22"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_23"	},
		{ "richard",		"qSetAppearance",	"HAPPY"						},		
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_24"	},
		{ "emily",			"qSetAppearance",	"LAUGH"						},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT2_DAY3_25"	},
		{ "richard",		"qSetAppearance",	"SMUG"						},		
		{ "richard",		"qSay",				"TEXT_RESTAURANT2_DAY3_26"	},

		{ "",				"parallel"										},
		{ "emily",			"qSetAppearance",	""							},		
		{ "richard",		"qSetAppearance",	""							},		
		{ "richard",		"qWalkToXY",		43, 3						},	
		{ "emily",			"qWait",			500							},	
		{ "emily",			"qWalkToXY",		43, 3						},	

		{ "",				"sequential"									},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}
end

function day3:onLevelInited()
end

function day3:onDayEnd()

	autoAllPeopleWalkOut = false
		
	-- play completed sequence
	qSequence(self.sequenceDayEnd)
end

function day3:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day3()
