-- day class
class 'day2' (interface)

function day2:__init() super()
end

day2.eventActive = false
day2.elevator = nil
day2.sparks = nil
day2.startTimer = 5000
day2.startEventTimer = 50000
day2.startSequence = {}

function day2:onLevelInited()
	--pm:setDoCleaner(false)
	--cleaner:setPosition(grid:getNode(5, 12))
	--cleaner:setVisible(false)

	self.elevator = getAppliance("rest2_elevator")
	self.elevator:checkNodes()
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(100)
	eventBar:setProgress(0)	
	eventBar:setSubjectImage("OBJECT_ELEVATOR_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))
		
	richard = pm:createPerson("npc")
	richard:setBaseName("INGAME_PERSON_RICHARD")
	richard:setDefaultSection("characters")
	richard:setPosition(inLiftNode)
	richard:setVisible(false)
	richard:setBalloonY(richard:getBalloonY() - 200)
	richard.doKey = false	

	mo = pm:createPerson("npc")
	mo:setBaseName("INGAME_PERSON_MO_BROKEN")
	mo:setDefaultSection("characters")
	mo:setPosition(grid:getNode(40, 3))
	mo:setVisible(false)

	self.startSequence = 
	{
    	{ "scene",		"qStartMovie",		3													},	
    	{ "",			"sequential" 															},	
		{ "richard",	"qWait",			1000												},
		{ "richard",	"qCallback",		self, function(self) self.sparks:setObsolete(true) self.sparks=nil end						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY2_0"							},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY2_1"							},
		{ "emily",		"qSetAppearance",	"PANIC"												},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_2"							},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY2_3"							},
		{ "emily",		"qWait",			500													},
		{ "emily",		"qSetAppearance",	"MOBILE_PANIC"										},
		{ "emily",		"qWait",			1500												},
    	{ "scene",		"qFadeToBlack" 															},
    	{ "scene",		"qWait",			1500												},
		{ "emily",		"qSetAppearance",	""													},
    	{ "scene",		"qFadeOutBlack" 														},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_4"							},
    	{ "scene",		"qFinishMovie" 															},
	}
	
	self.startEventSequence = 
	{
    	{ "scene",		"qStartMovie",		3													},	
    	{ "mo",			"qSetVisible",		true												},
    	
    	{ "",			"parallel" 																},	
    	{ "mo",			"qWalkToXY",		22, 13												},
    	{ "emily",		"qWalkToXY",		25, 13												},
		
    	{ "",			"sequential" 															},	
		{ "emily",		"qSetAppearance",	"SHOCK"												},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_5"							},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_6"							},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_7"							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_8"							},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_9"							},
		{ "emily",		"qSetAppearance",	"CONFUSED"											},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_10"							},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_11"							},
		{ "emily",		"qSetAppearance",	""													},
    	{ "mo",			"qWalkToXY",		1, 13												},
	    
		{ "richard",	"qCallback",		self, function(self) 
			self.elevator.pb:setVisible(true) 
			self.elevator:createHighlight() 
			if (um:hasUpgrade("APP_ELEVATOR_DOOR_R") ~= 1) then
				self.elevator:getHighlight():setImage("APP_ELEVATOR_FRONT_HL_UPGRADE")
			else
				self.elevator:getHighlight():setImage("APP_ELEVATOR_FRONT_HL")
			end
			eventBar:animateToActive() eventBar:raiseCurtain() end },
    	{ "scene",		"qFinishMovie" 															},
	}	

	self.preWonSequence = 
	{
    	{ "scene",		"qCallback",		self, function(self) cleaner = pm:createCleaner() cleaner:setVisible(false) qSequence(self.wonSequence) end }  
    }


	self.wonSequence = 
	{
    	{ "scene",		"qStartMovie",		1													},	
    	{ "richard",	"qWalkToXY",		5, 12												},    	
		{ "richard",	"qDestroy"																},
		{ "cleaner",	"qSetPosition",		grid:getNode(5, 12)									},				
		{ "cleaner",	"qSetVisible",		true												},		
    	{ "emily",		"qWalkToXY",		7, 12												},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY2_12"							},
		{ "emily",		"qSetAppearance",	"BLUSH"												},
		{ "emily",		"qWait",			1500												},
		{ "emily",		"qSetAppearance",	""													},
    	{ "cleaner",	"qSetVisible",		false												},
	    { "emily",		"qAnimate",			"HUG_RICHARD", 0									},
	    { "emily",		"qWait",			2000												},
	    { "emily",		"qAnimate",			"IDLE", 0											},
    	{ "cleaner",	"qSetVisible",		true												},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_13"							},
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_14"							},
    	{ "mo",			"qWalkToXY",		43, 3												},
		{ "mo",			"qDestroy"																},		
    	{ "scene",		"qFinishMovie" 															},
	}

	self.lostSequenceStart = 
	{
    	{ "scene",		"qStartMovie",		2												},	
    	{ "mo",			"qWalkToXY",		5, 12											},
    	{ "mo",			"qAnimateWait",		"PUNCH", 1										},
    	{ "mo",			"qAnimateWait",		"IDLE", 0										},
    	{ "mo",			"qWalkToXY",		1, 13											},
    	{ "scene",		"qCallback",		self, function(self) self.eventActive = false self.elevator.pause = false end	},   	
	}

	self.lostSequenceEnd =
	{
		{ "mo",			"qSay",				"TEXT_RESTAURANT2_DAY2_15"						},
		{ "richard",	"qSetAppearance",	"HAPPY"											},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY2_16"						},
    	{ "richard",	"qWalkToXY",		5, 13											},
    	{ "emily",		"qWalkToXY",		8, 13											},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY2_17"						},
		{ "richard",	"qSetAppearance",	"SMUG"											},
		{ "richard",	"qSay",				"TEXT_RESTAURANT2_DAY2_18"						},
    	{ "scene",		"qFinishMovie" 														},
		{ "scene",		"qFinishGame" 														},   	
	}	
end

function day2:onDayBegin()
end

function day2:onDayEnd()
	if (self.eventActive) then
		autoAllPeopleWalkOut = false
		self.elevator.pb:setVisible(false)
		qSequence(self.lostSequenceStart)
	end
end

function day2:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	if (self.eventActive == false) then
		if (self.startTimer <= 0 or self.elevator.activeKeyCustomer == true or scene:isClosed()) then
			return
		end
		
		self.startTimer = self.startTimer - time
		if (self.startTimer <= 0) then
			self.elevator.customerLeaving = richard
			self.elevator:addFloorRequest(richard, 3, 0)
			self.elevator.activeKeyCustomer = true
			self.eventActive = true
		end
	
	elseif (self.elevator.pause == false and self.elevator.floorDelta < 0 and self.elevator.cabin:getY() > -160) then
		self.elevator.pause = true
		
		-- create sparks
		self.sparks = createSprite()		
		self.sparks:setDefaultSection(player:getCurrentResourceSection())
		self.sparks:setX(4)
		self.sparks:setY(76)
		self.elevator.doorR:addChild(self.sparks)
		self.sparks:animate("ANIM_BROKEN_ELEVATOR", -1, 25)
						
		self.elevator.doorL:createHighlight()
		self.elevator.doorR:createHighlight()
							
	    qSequence(self.startSequence)
	elseif (self.startEventTimer > 0) then
	
		self.startEventTimer = self.startEventTimer	- time
		if (self.startEventTimer <= 0) then
			qSequence(self.startEventSequence)	
		end		
	end			
end

function day2:onNotify(notification)
	if (notification == "onCustomerLeavingExit") then
		self.elevator:clearCustomerLeaving()
		self.elevator.activeKeyCustomer = false
		self.elevator.customerLeaving = nil
		self.eventActive = false	
		richard:setBalloonY(richard:getBalloonY() + 200)
		richard:setAppearance("HAPPY")
		richard:animate("IDLE", 0)
		
		if (dayEnded) then
		    qSequence(self.lostSequenceEnd)
		 else
		    qSequence(self.preWonSequence)
		 end
	end
end

function day2:createObject(desc)

	if (desc:getObjectId() == "rest2_elevator") then
		result = specialElevator()
		
		result.shaftInfo.imageName = "APP_ELEVATOR_BACK"
		result.shaftInfo.baseX = -98
		result.shaftInfo.baseY = -134
		
		result.cabinInfo.imageName = "APP_ELEVATOR_CABIN"
		result.cabinInfo.baseX = -101
		result.cabinInfo.baseY = -143
		
		result.fakeCustomerInfo.imageName = "INGAME_CUSTOMER_MALE_REGULAR_IDLE"
		result.fakeCustomerInfo.baseX = -60
		result.fakeCustomerInfo.baseY = -132
		
		result.doorInfo.imageNameL = "APP_ELEVATOR_DOOR_L"
		result.doorInfo.imageNameR = "APP_ELEVATOR_DOOR_R"
		if (um:hasUpgrade("APP_ELEVATOR_DOOR_R") ~= 1) then
			result.doorInfo.imageNameR = "APP_ELEVATOR_DOOR_UPGRADE_R"
		end
		if (um:hasUpgrade("APP_ELEVATOR_DOOR_L") ~= 1) then
			result.doorInfo.imageNameL = "APP_ELEVATOR_DOOR_UPGRADE_L"
		end
				
		result.doorInfo.baseLX = -81
		result.doorInfo.baseLY = -126
		result.doorInfo.baseRX = -32
		result.doorInfo.baseRY = -124
		
		result.exteriorInfo.imageName = "APP_ELEVATOR_FRONT"
		result.exteriorInfo.baseX = -112
		result.exteriorInfo.baseY = -160
		
		result.indicatorInfo.imageName = "APP_ELEVATOR_POINTER"
		result.indicatorInfo.baseX = -24
		result.indicatorInfo.baseY = -127
		
		result:initAppearance()
		result:setType(desc:getType())
		
		restaurant.elevator = result
		return result
	end
	
	return nil
end

function day2:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		cout("cleaner\n")
		local c = d2cleaner("INGAME_PERSON_RICHARD")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day2()

-- a broken object
class 'specialElevator' (elevator)

specialElevator.event = nil
specialElevator.fixDuration = 1000 * 60
specialElevator.timer = specialElevator.fixDuration
specialElevator.eventState = "broken"
specialElevator.pb = nil
specialElevator.index = -1

function specialElevator:__init() super()
end

function specialElevator:onCreate()
	Appliance.onCreate(self)
	self:updatePointerPosition(0)

	-- initialize progress bar
	self.pb = createDefaultFillProgressBar();
	self.pb:setProgress(0)	
	self.pb:setY(20)
	self.pb:setX(-20)
	self.pb:setVisible(false)
	self:addChild(self.pb)
end

function specialElevator:getWorkNode()
	return grid:getNode(5, 11)
end

function specialElevator:onClick()
	cout("specialElevator:onClick()" .. self.eventState .. "\n")

	if (self.eventState == "broken") then
		self:playSound("SOUND_OBJECT_CLICK")
		cout("specialElevator:onClick()\n")
		if (self:isSelected() == false) then
			self:setSelected(true)
			self:clearOverhead()			
			emily:qWorkOn(self)
		
		end
	end
	
end

function specialElevator:onWorkStart(task)

	self:setSelected(false)
	
	emily:animate("FIX", -1)
	emily:playSound("SOUND_FIXTABLE_LOOP", true)
	
	--
	return (self.eventState == "broken")

end

function specialElevator:onWorkUpdate(task, time)

	self.timer = self.timer - time
	if (self.timer <= 0) then
	
		self.timer = 0
		self.eventState = "fixed"	
		self.pb:setVisible(false)
		self:removeHighlight()
		
		self.pause = false
		day.eventActive = false
		eventBar:animateToDeactive()

		return true	
	end
	
	self.pb:setProgress((self.fixDuration - self.timer) / self.fixDuration)
	eventBar:setProgress((self.fixDuration - self.timer) / self.fixDuration * 100)
	
	return emily:hasTasksToDo()
end

function specialElevator:onWorkComplete(task)

	emily:stopSound("SOUND_FIXTABLE_LOOP")

end
