include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"BoyHat",
	"FemaleHat",
	"Glove1",
	"Glove2",
}

-- day class
class 'day1' (interface)


function day1:__init() super()
end

function day1:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(grid:getCleanerNode())
	
	mom = pm:createPerson("npc")
	mom:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_REGULAR")
	mom:setDefaultSection("customers")
	mom:setPosition(grid:getNode(44, 2))	
	mom:setAppearance("VARIATION")
	mom.sequenceThanks = 
	{	
		{ "mom",		"qSayTimed",        "RESTAURANT2_DAY1_7", 2500	 },		
	}
	event.itemsList["FemaleHat"].person = mom

	dad = pm:createPerson("npc")
	dad:setBaseName("INGAME_CUSTOMER_MALE_WINTER_REGULAR")
	dad:setDefaultSection("customers")
	dad:setPosition(grid:getNode(43, 3))	
	dad:setAppearance("VARIATION")
	dad.sequenceThanks = 
	{	
		{ "",			"sequential"									},
		{ "dad",		"qSayTimed",        "RESTAURANT2_DAY1_6", 2500	},		
	}
	event.itemsList["Glove1"].person = dad

	boy = pm:createPerson("npc")
	boy:setBaseName("INGAME_CUSTOMER_MALE_WINTER_CHILD")
	boy:setDefaultSection("customers")
	boy:setPosition(grid:getNode(44, 3))	
	boy:setAppearance("VARIATION")
	boy.sequenceThanks = 
	{
		{ "boy",		"qSayTimed",        "RESTAURANT2_DAY1_8", 2500  },		
	}
	event.itemsList["BoyHat"].person = boy
	
	event.highlightX = 31
	event.highlightY = 12
	event.timeUntilEnterMin = 1000 * 80
	event.timeUntilEnterMax = 1000 * 100
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = false
	
	self.sequenceBegin = 	-- sequence when day begins
	{	
		{ "scene",			"qStartMovie",		2								},	
		{ "entertainer",	"qWalkToXY",		22, 25							},
		{ "emily",			"qSetAppearance",	"CONFUSED"						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY1_20"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY1_21"			},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY1_22"			},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY1_23"			},
		{ "emily",			"qSetAppearance",	"LAUGH"							},
		{ "emily",			"qSay",				"RESTAURANT2_DAY1_24"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "emily",			"qSay",				"RESTAURANT2_DAY1_25"			},
		{ "entertainer",	"qSetAppearance",	"ANNOYED"						},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY1_26"			},
		{ "emily",			"qSetAppearance",	"CURIOUS"						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY1_27"			},
		{ "entertainer",	"qSetAppearance",	""								},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY1_28"			},
		{ "emily",			"qSetAppearance",	"LAUGH"							},
		{ "emily",			"qSay",				"RESTAURANT2_DAY1_29"			},
		{ "emily",			"qSetAppearance",	""								},
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
	}
	
	event.sequenceStart	= 								-- text when event starts
	{	
		{ "",			"sequential"									},		
		{ "scene",		"qStartMovie",		2							},	

		{ "",			"parallel"										},
		{ "mom", 		"qWalkToXY",		30, 14				 		},
		{ "dad", 		"qWalkToXY",		33, 14				 		},
		{ "boy", 		"qWalkToXY",		36, 14				 		},				

		{ "",			"sequential"									},				
		{ "dad",		"qSay",		        "RESTAURANT2_DAY1_0"	    },
		{ "mom",		"qSay",		        "RESTAURANT2_DAY1_1"	    },
		{ "boy",		"qSay",		        "RESTAURANT2_DAY1_2"	    },
		{ "dad",		"qSay",		        "RESTAURANT2_DAY1_3"	    },
		{ "emily",		"qSay",		        "RESTAURANT2_DAY1_4"	    },
		{ "dad",		"qSay",		        "RESTAURANT2_DAY1_5"	    },		

    	{ "cleaner",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSay",		        "RESTAURANT2_DAY1_13"	    },		
    	{ "emily",		"qSetAppearance",	"ROLLEYES"					},
		{ "emily",		"qSay",		        "RESTAURANT2_DAY1_14"	    },						

    	{ "cleaner",	"qSetAppearance",	""							},
    	{ "emily",		"qSetAppearance",	""							},
				
		{ "",			"sequential"									},		
		{ "scene",		"qFinishMovie" 									},				
		{ "scene",		"qNotify",			"ho_arrived"				},		
		{ "scene",		"qNotify",			"show bar"					},
		{ "",			"parallel"										},			
	}
	
	event.sequenceDone =
	{
		{ "",			"sequential"									},		
		{ "scene",		"qStartMovie",		2							},	

		{ "dad",		"qSay",		        "RESTAURANT2_DAY1_9"	    },		
		{ "cleaner",	"qSay",		        "RESTAURANT2_DAY1_15"	    },				
		{ "emily",		"qSay",		        "RESTAURANT2_DAY1_10"	    },

		{ "",			"parallel"										},
		{ "mom", 		"qWalkToXY",		49, 3				 		},
		{ "dad", 		"qWalkToXY",		49, 3				 		},
		{ "boy", 		"qWalkToXY",		49, 3				 		},				

		{ "mom", 		"qDestroy"										},				
		{ "dad", 		"qDestroy"										},				
		{ "boy", 		"qDestroy"										},				

		{ "",			"sequential"									},		
		{ "scene",		"qFinishMovie" 									},				
	}
	
	event.sequenceFail = 
	{
		{ "",			"sequential"									},		
		{ "scene",		"qStartMovie",		2							},	

		{ "emily",		"qSay",		        "RESTAURANT2_DAY1_11"	    },		
		{ "dad",		"qSay",		        "RESTAURANT2_DAY1_12"	    },

		{ "",			"parallel"										},
		{ "mom", 		"qWalkToXY",		49, 3				 		},
		{ "dad", 		"qWalkToXY",		49, 3				 		},
		{ "boy", 		"qWalkToXY",		49, 3				 		},				

		{ "mom", 		"qDestroy"										},				
		{ "dad", 		"qDestroy"										},				
		{ "boy", 		"qDestroy"										},				

		{ "",			"sequential"									},		
		{ "scene",		"qFinishMovie" 									},				
	}
	
end

function day1:onNotify(notification)

end

function day1:onLevelInited()
	qSequence(self.sequenceBegin)
end

function day1:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_RICHARD")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day1()
