-- set event

-- day class
class 'day0' (interface)

day0.startEnd = nil

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	getAppliance("rest2_fireplace"):setState("OUT")
	
	-- emily    
    emily:setPosition(movieNode)
    
    -- show the movie bar non-animated
	scene:showBars(false)
	scene:showDark(false)
	
    --cleaner:setAppearance("IDLE")
    cleaner:setPosition(grid:getNode(22, 21))
    --cleaner:animate("IDLE", 0)
	
	sitTable = om:getTable(0)	
	  
	-- start movie sequence
	local startSequence =
    {
    	{ "scene",		"qStartMovie",		1							},
    	{ "",			"sequential" 									},
    	{ "emily",		"qWalkToXY",		29, 22						},
    	{ "emily",		"qSetAppearance",	"CONFUSED"					},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_0"		},    	
    	{ "cleaner",	"qAnimateWait",		"CLAP", 1					},
    	{ "cleaner",	"qAnimate",			"IDLE", 0					},
    	{ "scene",		"qFadeOutBlack" 								},
    	{ "cleaner",	"qSetAppearance",	"HAPPY"						},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_1"		},
    	{ "emily",		"qSetAppearance",	"SURPRISED"					},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_2"		},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "cleaner",	"qSetAppearance",	""							},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_3"		},
    	{ "emily",		"qSetAppearance",	"LAUGH"						},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_4"		},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_5"		},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_6"		},
    	{ "cleaner",	"qWalkToXY",		41, 12						},
    	{ "cleaner",	"qPlaySound",		"SOUND_LOG_ON_FIRE"			},
    	{ "cleaner",	"qAnimateWait",		"FIREWOOD", 1				},
   	   	{ "cleaner",	"qCallback", self,	function(self) getAppliance("rest2_fireplace"):setLocked() end },
    	{ "cleaner",	"qSitAt",			sitTable, 0					},
    	{ "emily",		"qSitAt",			sitTable, 1					},
   	   	{ "emily",		"qCallback", sitTable,	function(t) t:setPlateState(0) end },
    	{ "emily",		"qWait",			3000						},    	
    	{ "emily",		"qSetAppearance",	""							},
    	{ "emily",		"qSay2Choice",		"REST_Q1", "BUTTON_KISS_CLOUD", "BUTTON_HALO_CLOUD" },
	}    	

	self.q1_lips =   
	{  
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_7"		},
    	{ "emily",		"qSetAppearance",	"FLIRT"						},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_8"		},
    	{ "cleaner",	"qSetAppearance",	"SORRY"						},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_9"		},
    	{ "cleaner",	"qSetAppearance",	"ROLLEYES"					},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_10"		},
    	{ "emily",		"qSetAppearance",	"FLIRT"						},
    	{ "emily",		"qSayTimed",		"RESTAURANT2_DAY0_11", 2000	},   	
    	{ "emily",		"qSetAppearance",	""							},   	
    	{ "cleaner",	"qSetAppearance",	""							},
	}

	self.q1_helo =   
	{
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_12"		},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_13"		},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_14"		},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_15"		},
    	{ "emily",		"qSetAppearance",	""							},   			
	}

	self.q1_end =   
	{
	    { "emily",		"qAnimate",			"EAT", -1					},
	    { "cleaner",	"qAnimate",			"EAT", -1					},
	    { "cleaner",	"qWait",			2000						},    
	    { "emily",		"qAnimate",			"IDLE", 0					},
	    { "cleaner",	"qAnimate",			"IDLE", 0					},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_16"		},		
    	{ "emily",		"qSay2Choice",		"REST_Q2", "BUTTON_KISS_CLOUD", "BUTTON_HALO_CLOUD" },
	}

	self.q2_lips =   
	{  
    	{ "emily",		"qSetAppearance",	"FLIRT"						},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_17"		},
    	{ "cleaner",	"qSetAppearance",	"BLUSH"						},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_18"		},		
	}

	self.q2_helo =   
	{
    	{ "emily",		"qSay",				"RESTAURANT2_DAY0_19"		},
    	{ "cleaner",	"qSetAppearance",	"BLUSH"						},
    	{ "cleaner",	"qSay",				"RESTAURANT2_DAY0_20"		},		
	}

	self.q2_end =   
	{
    	{ "cleaner",	"qSetAppearance",	""							},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_21"	},			    
    	{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_22"	},			    
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_23"	},			    
    	{ "cleaner",	"qSayTimed",		"TEXT_RESTAURANT2_DAY0_24", 1000	},			    
    	{ "scene",		"qFadeToBlack" 									},
	    { "emily",		"qAnimate",			"SIT_LAUGH", -1				},
	    { "cleaner",	"qAnimate",			"SIT_LAUGH", -1				},
    	{ "scene",		"qWait", 			1000						},
    	{ "scene",		"qFadeOutBlack" 								},
    	{ "scene",		"qWait", 			1000						},
	    { "emily",		"qAnimate",			"IDLE", 0					},
	    { "cleaner",	"qAnimate",			"IDLE", 0					},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_25"	},    	
    				     	
		{ "",			"parallel"										},
    	{ "emily",		"qWalkToXY",		28, 16						},
    	{ "cleaner",	"qWalkToXY",		26, 16						},  	   
    	
    	{ "",			"sequential" 									},
    	{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_26"	},			        	
    	{ "emily",		"qSay2Choice",		"REST_Q3", "BUTTON_KISS_CLOUD", "BUTTON_HALO_CLOUD" },
	}

	self.q3_lips =   
	{
    	{ "emily",		"qSetAppearance",	"FLIRT"						},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_27"	},			    
    	{ "emily",		"qWait",			1000						},			    
	}  

	self.q3_helo =   
	{
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_27"	},			    
    	{ "emily",		"qWait",			2000						},			    
    	{ "cleaner",	"qSetAppearance",	"SMUG"						},
    	{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_28"	},			    
    	{ "emily",		"qSetAppearance",	"SURPRISED"					},
    	{ "emily",		"qWait",			1000						},			    
	}

	self.q3_end =   
	{
    	{ "emily",		"qSetAppearance",	""							},
    	{ "cleaner",	"qSetAppearance",	""							},
	
    	-- kiss    	
    	{ "cleaner",	"qSetVisible",		false						},
	    { "emily",		"qAnimate",			"KISS_RICHARD", 0			},
	    { "emily",		"qWait",			2000						},
	    { "emily",		"qAnimate",			"IDLE", 0					},
    	{ "cleaner",	"qSetVisible",		true						},
    	   	
    	{ "emily",		"qSetAppearance",	"BLUSH"						},
    	{ "emily",		"qWait",			500							},			    
    	{ "emily",		"qSayTimed",		"TEXT_RESTAURANT2_DAY0_11", 1000 },			    
    	{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_29"	},			    
    	{ "cleaner",	"qSetAppearance",	"BLUSH"						},    	
    	{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_30"	},
    	
    	{ "scene",		"qFadeToBlack" 									},   	
    	{ "cleaner",	"qSetPosition",		grid:getNode(22, 20)		},    	
    	{ "emily",		"qSetPosition",		grid:getNode(25, 20)		},    	
    	{ "scene",		"qWait",			700							},			    
    	{ "emily",		"qSetAppearance",	""							},
    	{ "cleaner",	"qSetAppearance",	""							},    	
   	   	{ "emily",		"qCallback", sitTable,	function(t) t:setPlateState(1) getAppliance("rest2_fireplace").working = false end },
    	{ "scene",		"qFinishMovie" 									},
    	
    	{ "scene",		"qFadeOutBlack" 								},
    	{ "scene",		"qStartGame" 									},
		{ "",			"parallel"										},			
    }
    
    qSequence(startSequence)

end

function day0:onDayBegin()
	local beginSequence = 
	{
    	{ "scene",		"qStartMovie",		1													},
    	{ "",			"sequential" 															},

		{ "emily",		"qSetAppearance",	"HAPPY"												},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_31"							},
		
    	{ "cleaner",	"qSetVisible",		false												},
	    { "emily",		"qAnimate",			"HUG_RICHARD", 0									},
	    { "emily",		"qWait",			2000												},
	    { "emily",		"qAnimate",			"IDLE", 0											},
    	{ "cleaner",	"qSetVisible",		true												},

    	{ "cleaner",	"qSetAppearance",	"SMUG"												},  	
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_32"							},
    	{ "cleaner",	"qSetAppearance",	"ROLLEYES"											},  	
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY0_33"							},

    	{ "cleaner",	"qSetAppearance",	""													},  	
		
		{ "emily",		"qSetAppearance",	"LAUGH"												},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY0_34"							},
		
		{ "emily",		"qSetAppearance",	""													},
    	{ "scene",		"qFinishMovie" 															},
	}
    qSequence(beginSequence)
	getAppliance("rest2_fireplace"):setLocked()
end


function day0:onDayEnd()
		autoAllPeopleWalkOut = false
		sequential()
		emily:qWalkToXY(45, 3)
		scene:qFinishGame()
end

function day0:onClickMessage(text, result)
	if (text == "REST_Q1") then
		if (result == "yes") then
		    qSequence(self.q1_lips)
		else
		    qSequence(self.q1_helo)
		end	
	    qSequence(self.q1_end)		
	elseif (text == "REST_Q2") then
		if (result == "yes") then
		    qSequence(self.q2_lips)
		else
		    qSequence(self.q2_helo)
		end
		qSequence(self.q2_end)		
	elseif (text == "REST_Q3") then
		if (result == "yes") then
		    qSequence(self.q3_lips)
		else
		    qSequence(self.q3_helo)
		end
		qSequence(self.q3_end)		
	end	
end

function day0:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	elseif (class == "cleaner") then
		cout("cleaner\n")
		c = d2cleaner("INGAME_PERSON_RICHARD")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
	return nil
end

-- set day
day = day0()